unit keys;

INTERFACE


type
	Ttecla=(ESCAPE,UNO,DOS,TRES,CUATRO,CINCO,SEIS,SIETE,OCHO,NUEVE,
					CERO,INTERROGANTE,ADMIRACION,BORRAR,TAB,Q,W,E,R,T,Y,U,I,O,P,
					ABRE_CORCHETE,CIERRA_CORCHETE,RETURN,CONTROL,A,S,D,F,G,H,J,K,L,
					ENYE,ABRE_LLAVE,INVERTIDA,LEFT_SHIFT,CIERRA_LLAVE,Z,X,C,V,B,N,M,
					COMA,PUNTO,GUION,RIGHT_SHIFT,ASTERISCO,ALT,ESPACIO,BLOQ_MAY,F1,F2,
					F3,F4,F5,F6,F7,F8,F9,F10,BLOQ_NUM,BLOQ_DESP,INICIO,ARRIBA,
					RETROCESO_PAGINA,MENOS,IZQUIERDA,CINCO_NUM,DERECHA,MAS,FIN,ABAJO,
					AVANCE_PAGINA,INSERT,SUPR,NULA_84,NULA_85,MAYOR_MENOR,F11,F12,NULA);

const
	inkeys:Ttecla=NULA;              {TECLA ACTIVA EN CUALQUIER MOMENTO}

var
	inkey:array[Ttecla] of boolean;

procedure init;
{inhibe el teclado, pero se puede leer a traves del ARRAY
booleano INKEYS[Ttecla]}

procedure done;
{habilita el teclado}

procedure ClearInput;
{borrar el buffer del teclado, en modo NORMAL}

procedure SpeedKey(num,tiempo:byte);
{cambia la tasa de repeticin NUM y el tiempo de espera del teclado TIEMPO
en modo NORMAL}

function PulsaTecla:Ttecla;
{Espera a una pulsacin de tecla y la devuelve}

IMPLEMENTATION

const
	INT_TECLADO=9;

	key:boolean=FALSE;

var
	SalirDOS,VecIntTec:pointer;

procedure detecta;ASSEMBLER;
ASM
	PUSHF
	PUSH		AX
	PUSH		BX
	PUSH		DS

	MOV			AX,SEG @DATA
	MOV			DS,AX

	IN			AL,$60
	DB			$0F,$B6,$D8			{MOVZX BX,AL}
	DB			$0F,$BA,$E0,$07	{BT AX,7}
	JC			@SOLTADA

	MOV			BYTE(inkey-1[BX]),TRUE
	DEC			AL
	MOV			inkeys,AL
	JMP			@SIGUE

@SOLTADA:
	MOV			BYTE(inkey-129[BX]),FALSE
	MOV			inkeys,NULA

@SIGUE:
	IN			AL,$61
	MOV			AH,AL
	OR			AL,$80
	OUT			$61,AL
	MOV     AL,AH
	OUT			$61,AL              {resetea teclado}

	CLI
	MOV			AL,$20
	OUT			$20,AL							{EOI}
	STI

	POP			DS									{Fin interrucin}
	POP			BX
	POP			AX
	POPF
	IRET
END;

procedure GetIntVec(numero:byte;var direccion:pointer);
var
	dir:pointer;

begin
	ASM
		MOV			AH,$35
		MOV			AL,numero
		INT			$21

		MOV			WORD(dir),BX
		MOV			WORD(dir+2),ES
	END;
	direccion:=dir;
end;

procedure SetIntVec(numero:byte;direccion:pointer);ASSEMBLER;
ASM
	PUSH		DS
	MOV			AH,$25
	MOV			AL,numero
	LDS			DX,direccion
	INT			$21
	POP			DS
END;

procedure ClearInput;ASSEMBLER;
ASM
	MOV			AX,$0C02
	INT			$21
END;

procedure init;
begin
	 key:=TRUE;
	 GetIntVec(INT_TECLADO,VecIntTec);
	 SetIntVec(INT_TECLADO,@detecta);
end;

procedure done;
begin
	 if key then
		begin
			SetIntVec(INT_TECLADO,VecIntTec);
			key:=FALSE;
		end;
end;

procedure SpeedKey(num,tiempo:byte);ASSEMBLER;
ASM
	MOV			BL,num
	MOV			BH,tiempo
	MOV			AX,$305
	INT			$16
END;

function PulsaTecla:Ttecla;
begin
	while inkeys<NULA do;
	while inkeys=NULA do;

	PulsaTecla:=inkeys;
end;

begin
	FillChar(inkey,SizeOf(inkey),0);
	SalirDOS:=ExitProc;
end.