unit files;

INTERFACE

type
	ModoLectura=(RO,WO,RW);
	ModoComparticion=(COMPATIBILIDAD_TOTAL,TODO_DENEGADO,ESCRITURA_DENEGADA,
										LECTURA_DENEGADA,NADA_DENEGADO);

	Tfile=record
		nombre:array[0..80] of char;
		handle:word;
	end;

function open(var f:Tfile;nombre:string;ml:ModoLectura):integer;
function ReWrite(var f:Tfile;nombre:string):integer;
function close(f:Tfile):integer;
function read(f:Tfile;var buffer;bytes:word;var leidos:word):integer;
function write(f:Tfile;var buffer;bytes:word;var escritos:word):integer;
function seek(f:Tfile;desplazamiento:LongInt):integer;
function FilePos(f:Tfile):LongInt;
function erase(f:Tfile):integer;
function rename(f:Tfile;nuevo:string):integer;
function FileSize(f:Tfile):LongInt;
function EOF(f:Tfile):boolean;
function search(f:Tfile;s:string;longitud:byte):string;

IMPLEMENTATION

uses strings;

var
	handle:word;
	name:array[0..80] of char;
	error:integer;

function open(var f:Tfile;nombre:string;ml:ModoLectura):integer;
const
	valores:array[0..4] of byte=(0,8,$10,$1a,$22);

var
	at:byte;

begin
	StrPCopy(name,nombre);
	StrCopy(f.nombre,name);

	at:=$80+ord(ml);		{BIT 7 a 1 = handle no se hereda :-? }

	ASM
		MOV			error,0

		LEA			DX,name
		MOV			AH,$3d
		MOV			AL,at
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			handle,AX
	END;

	f.handle:=handle;
	open:=error;
end;

function ReWrite(var f:Tfile;nombre:string):integer;
begin
	StrPCopy(name,nombre);
	StrCopy(f.nombre,name);

	ASM
		MOV			error,0

		MOV			AH,$3c
		XOR			CX,CX
		LEA			DX,name
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			handle,AX
	END;

	f.handle:=handle;
	ReWrite:=error;
end;

function close(f:Tfile):integer;
begin
	handle:=f.handle;

	ASM
		MOV			error,0

		MOV			AH,$3e
		MOV			BX,handle
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
	END;

	close:=error;
end;

function read(f:Tfile;var buffer;bytes:word;var leidos:word):integer;
var
	n:word;

begin
	handle:=f.handle;

	ASM
		PUSH		DS

		MOV			error,0

		MOV			AH,$3F
		MOV			BX,handle
		MOV			CX,bytes
		LDS			DX,buffer
		INT			$21

		POP			DS
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			n,AX
	END;

	leidos:=n;
	read:=error;
end;

function write(f:Tfile;var buffer;bytes:word;var escritos:word):integer;
var
	n:word;

begin
	handle:=f.handle;

	ASM
		PUSH		DS

		MOV			error,0

		MOV			AH,$40
		MOV			BX,handle
		MOV			CX,bytes
		LDS			DX,buffer
		INT			$21

		POP			DS
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			n,AX
	END;

	escritos:=n;
	write:=error;
end;

function seek(f:Tfile;desplazamiento:LongInt):integer;
begin
	StrPCopy(name,f.nombre);
	handle:=f.handle;

	ASM
		MOV			error,0

		MOV			AH,$42
		XOR			AL,AL
		MOV			BX,handle
		MOV			CX,WORD(desplazamiento+2)
		MOV			DX,WORD(desplazamiento)
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
	END;

	seek:=error;
end;

function FilePos(f:Tfile):LongInt;
var
	d:LongInt;

begin
	StrPCopy(name,f.nombre);
	handle:=f.handle;

	ASM
		MOV			error,0

		MOV			AH,$42
		MOV			AL,1
		MOV			BX,handle
		XOR			CX,CX
		MOV			DX,CX
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			WORD(d),AX
		MOV			WORD(d+2),DX
	END;

	FilePos:=d;
end;

function erase(f:Tfile):integer;
begin
	StrPCopy(name,f.nombre);

	ASM
		MOV			error,0

		MOV			AH,$41
		LEA			DX,name
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
	END;

	erase:=error;
end;

function ReName(f:Tfile;nuevo:string):integer;
var
	n:array[0..80] of char;
	error:integer;

begin
	StrPCopy(name,f.nombre);
	StrPCopy(n,nuevo);

	ASM
		MOV			error,0

		MOV			AH,$56
		LEA			DX,name
		MOV			BX,SS
		MOV			ES,BX
		LEA			DI,n
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
	END;

	ReName:=error;
end;

function FileSize(f:Tfile):LongInt;
var
	d,e:LongInt;

begin
	StrPCopy(name,f.nombre);
	handle:=f.handle;
	e:=FilePos(f);

	ASM
		MOV			error,0

		MOV			AH,$42
		MOV			AL,2
		MOV			BX,handle
		XOR			CX,CX
		MOV			DX,CX
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			WORD(d),AX
		MOV			WORD(d+2),DX
	END;

	seek(f,e);
	FileSize:=d;
end;

function EOF(f:Tfile):boolean;
begin
	EOF:=FilePos(f)>=FileSize(f);
end;

function search(f:Tfile;s:string;longitud:byte):string;
var
	linea:string;
	leidos:word;

begin
	repeat
		read(f,linea,longitud,leidos);
	until (pos(s,linea)>0) or (EOF(f));
end;

end.