unit colors;

INTERFACE

uses global;

const
	blanco:RGB=(rojo:63;verde:63;azul:63);
	negro:RGB=(rojo:0;verde:0;azul:0);
	amarillo:RGB=(rojo:63;verde:63;azul:0);
	rosa:RGB=(rojo:63;verde:0;azul:63);
	rojo:RGB=(rojo:63;verde:0;azul:0);
	azul:RGB=(rojo:0;verde:0;azul:63);
	verde:RGB=(rojo:0;verde:63;azul:0);
	cyan:RGB=(rojo:0;verde:63;azul:63);

var
	PaletaBlanca,PaletaNegra:Tpaleta;

procedure border(color:byte);
{cambia el color del borde en cualquier modo}

procedure ink(numero,color:byte);
{cambia el color de una pluma NUMERO por otra COLOR}

procedure InkRGB(numero:byte;var colores:RGB);
{cambia la intensidad RGB de del color}

procedure GetRGB(numero:byte;var colores:RGB);
{devuelve la intensidad RGB del color}

procedure DifuminaColor(desde,hasta:byte;var color:RGB);
{difumina los colores hasta color}

procedure DifuminaPaleta(desde,hasta,steps:integer;var nueva:Tpaleta);
{difumina los colores actuales hasta cambiarlos a nueva}

procedure InkAllBlue(desde,hasta:byte);
{difumina los colores actuales hasta cambiarlos a azules}

procedure InkAllGreen(desde,hasta:byte);
{difumina los colores actuales hasta cambiarlos a verdes}

procedure InkAllRed(desde,hasta:byte);
{difumina los colores actuales hasta cambiarlos a rojos}

procedure InkAllOrange(desde,hasta:byte);
{difumina los colores actuales hasta cambiarlos a naranjas}

procedure InkAllGray(desde,hasta:byte);
{difumina los colores actuales hasta cambiarlos a grises}

procedure InkAllRGB(desde,hasta:integer;var nueva:Tpaleta);
{cambia la intensidad RGB de Tpaleta desde PRIMERO A ULTIMO en
VALORES es un puntero a una tabla de 3 bytes de cada color en RGB}

procedure GetAllRGB(desde,hasta:integer;var nueva:Tpaleta);
{Devuelve la intensidad RGB de Tpaleta desde PRIMERO A ULTIMO en
VALORES es un puntero a una tabla de 3 bytes de cada color en RGB}

procedure MakeGrayScale(desde,hasta:byte);
{Hace una escala de grises}

procedure UnidifuminaPaleta(desde,hasta,paso:integer;var nueva:Tpaleta);
{difumina los colores actuales hasta cambiarlos a la nueva paleta,
con el nmero de pasos especificado}

function Unipaleta:boolean;
{Se llama despus del anterior procedimiento, si TRUE, el difuminado termin}

IMPLEMENTATION

uses syncro;

var
	de,ha,pa:integer;
	pal,vieja:Tpaleta;

function PorCiento(num:longint;tanto:byte):integer;
begin
	PorCiento:=(tanto*num) div 100;
end;

procedure border(color:byte);ASSEMBLER;
ASM
	MOV		DX,$3C0
	MOV		AX,49
	OUT		DX,AL

	MOV		AL,color
	OUT		DX,AL
END;

procedure ink(numero,color:byte);
var
	valor:RGB;

begin
	GetRGB(color,valor);
	InkRGB(numero,valor);
end;

procedure InkRGB(numero:byte;var colores:RGB);ASSEMBLER;
ASM
	PUSH		DS

	LDS			SI,colores
	MOV			DX,$3C8
	MOV			AL,numero
	OUT			DX,AL
	INC			DX

	OUTSB
	OUTSB
	MOV			AL,[SI]
	OUT			DX,AL

	POP			DS
END;

procedure GetRGB(numero:byte;var colores:RGB);ASSEMBLER;
ASM
	LES			DI,colores

	MOV			DX,$3C7
	MOV			AL,numero
	OUT			DX,AL
	INC			DX
	INC			DX

	INSB
	INSB
	IN			AL,DX
	MOV			ES:[DI],AL
end;

procedure DifuminaColor(desde,hasta:byte;var color:RGB);
var
	nueva:Tpaleta;
	n:byte;

begin
	for n:=desde to hasta do nueva[n]:=color;

	DifuminaPaleta(desde,hasta,64,nueva);
end;

procedure DifuminaPaleta(desde,hasta,steps:integer;var nueva:Tpaleta);
var
	vieja,WorkPalette:Tpaleta;
	CrossFade,counter:word;
	t:LongInt;

begin
	GetAllRGB(desde,hasta,vieja);

	if steps<0 then steps:=0;
	if steps>64 then steps:=64;

	for CrossFade:=0 to 64 do
		begin
			for counter:=desde to hasta do
				begin
					WorkPalette[counter].rojo:=
						((vieja[counter].rojo*(64-CrossFade))+
						 (nueva[counter].rojo*CrossFade)) div 64;

					WorkPalette[counter].verde:=
						((vieja[counter].verde*(64-CrossFade))+
						 (nueva[counter].verde*CrossFade)) div 64;

					WorkPalette[counter].azul:=
						((vieja[counter].azul*(64-CrossFade))+
						 (nueva[counter].azul*CrossFade)) div 64;
			End;

		 if not music then
			begin
				frame;
				InkAllRGB(desde,hasta,WorkPalette);
			end else
				begin
					t:=frames;
					while frames=t do;
					SetColors(desde,hasta,WorkPalette);
				end;
		end;

	if music then StopColors;
end;

procedure InkAllBlue(desde,hasta:byte);
var
	colores:Tpaleta;
	n:integer;

begin
	GetAllRGB(desde,hasta,colores);

	for n:=desde to hasta do
		begin
			colores[n].rojo:=PorCiento(colores[n].rojo,30);
			colores[n].verde:=PorCiento(colores[n].verde,11);
			colores[n].azul:=PorCiento(colores[n].azul,59);
		end;

	InkAllRGB(desde,hasta,colores);
end;

procedure InkAllGreen(desde,hasta:byte);
var
	colores:Tpaleta;
	n:integer;

begin
	GetAllRGB(desde,hasta,colores);

	for n:=desde to hasta do
		begin
			colores[n].rojo:=PorCiento(colores[n].rojo,30);
			colores[n].verde:=PorCiento(colores[n].verde,59);
			colores[n].azul:=PorCiento(colores[n].azul,11);
		end;

	InkAllRGB(desde,hasta,colores);
end;

procedure InkAllRed(desde,hasta:byte);
var
	colores:Tpaleta;
	n:integer;

begin
	GetAllRGB(desde,hasta,colores);

	for n:=desde to hasta do
		begin
			colores[n].rojo:=PorCiento(colores[n].rojo,59);
			colores[n].verde:=PorCiento(colores[n].verde,11);
			colores[n].azul:=PorCiento(colores[n].azul,30);
		end;

	InkAllRGB(desde,hasta,colores);
end;

procedure InkAllOrange(desde,hasta:byte);
var
	colores:Tpaleta;
	n:integer;

begin
	GetAllRGB(desde,hasta,colores);

	for n:=desde to hasta do
		begin
			colores[n].rojo:=PorCiento(colores[n].rojo,59);
			colores[n].verde:=PorCiento(colores[n].verde,30);
			colores[n].azul:=PorCiento(colores[n].azul,11);
		end;

	InkAllRGB(desde,hasta,colores);
end;

procedure InkAllGray(desde,hasta:byte);
var
	colores:Tpaleta;
	n:integer;
	d:byte;

begin
	GetAllRGB(desde,hasta,colores);

	for n:=desde to hasta do
		begin
			d:=PorCiento(colores[n].rojo,30)+PorCiento(colores[n].verde,11)+
				 PorCiento(colores[n].azul,59);

			colores[n].rojo:=d;
			colores[n].verde:=d;
			colores[n].azul:=d;
		end;

	InkAllRGB(desde,hasta,colores);
end;

procedure InkAllRGB(desde,hasta:integer;var nueva:Tpaleta);ASSEMBLER;
ASM
	PUSH		DS

	LDS			SI,nueva
	MOV			DX,$3C8

	MOV			AX,desde
	OUT			DX,AL
	INC			DX

	MOV			CX,hasta
	SUB			CX,AX
	INC			CX

	MOV			BX,AX		{*3}
	ADD			AX,AX
	ADD			AX,BX
	ADD			SI,AX

	MOV			BX,CX
	ADD			CX,CX
	ADD			CX,BX		{*3}

	REP			OUTSB

	POP			DS
END;

procedure GetAllRGB(desde,hasta:integer;var nueva:Tpaleta);ASSEMBLER;
ASM
	LES			DI,nueva

	MOV			DX,$3C7

	MOV			AX,desde
	OUT			DX,AL
	INC			DX
	INC			DX

	MOV			CX,hasta
	SUB			CX,AX
	INC			CX

	MOV			BX,AX     {*3}
	ADD			AX,AX
	ADD			AX,BX
	ADD			DI,AX

	MOV			BX,CX
	ADD			CX,CX
	ADD			CX,BX			{*3}

	REP			INSB
END;

procedure MakeGrayScale(desde,hasta:byte);
var
	colores:Tpaleta;
	m,n:integer;
	nueva:RGB;

begin
	m:=0;

	for n:=desde to hasta do
		begin
{			dec(nueva.rojo);}
			with nueva do
				begin
					rojo:=m;verde:=m;azul:=m;
				end;
			colores[n]:=nueva;
			if n mod 4=0 then inc(m);
		end;

	InkAllRGB(desde,hasta,colores);
end;

procedure UnidifuminaPaleta(desde,hasta,paso:integer;var nueva:Tpaleta);

procedure SpeedMove(var origen,destino;longitud:word);ASSEMBLER;
ASM
	PUSH		DS
	LDS			SI,origen
	LES     DI,destino
	MOV			CX,longitud

	SHR			CX,1
	REP			MOVSW

	POP			DS
END;

begin
	de:=desde;ha:=hasta;pa:=paso;

	SpeedMove(nueva,pal,SizeOf(pal));
	if pa>64 then pa:=64;
	GetAllRGB(de,ha,vieja);
end;

function UniPaleta:boolean;
var
	i:byte;
	s:ShortInt;
	p1,p2:^RGB;

begin
	unipaleta:=FALSE;
	if pa<1 then exit;

	for i:=de to ha do
		begin
		end;

	InkAllRGB(de,ha,vieja);
	dec(pa);
	unipaleta:=TRUE;
end;

begin
	FillChar(PaletaBlanca,SizeOf(PaletaBlanca),63);
	FillChar(PaletaNegra,SizeOf(PaletaNegra),0);
end.