{$I BOBS3D.RGB}

const
	B_ANCHO=13;B_ALTO=11;
	B_TOTAL=250;

type
	Txyz=record
		x,y,z:LongInt;
	end;

var
	bobs:array[0..B_TOTAL] of Txyz;
	AnteriorBobs:pointer;

{$L BOLA.OBJ}
procedure bola;EXTERNAL;

const
	grafico:^byte=@bola;

procedure pinta;ASSEMBLER;		{DI=x, BX=y, AH=numero}
ASM
	PUSH		DS

	ADD			BX,BX
	ADD			DI,WORD(MultBy320[BX])

	LDS			SI,grafico

	MOV			CH,B_ANCHO
	MOV			BL,B_ALTO

	MOV			DX,320-B_ANCHO

@BUCLE:
	MOV			CL,CH

@PINTA:
	LODSB
	TEST		AL,AL
	JZ			@CERO

	CMP			BYTE(ES:[DI]),AH
	JB			@UNO

	INC			BYTE(ES:[DI])
	JMP			@CERO

@UNO:
	MOV			BYTE(ES:[DI]),AH

@CERO:
	INC			DI
	DEC			CL
	JNZ			@PINTA

	ADD			DI,DX
	DEC			BL
	JNZ			@BUCLE

	POP			DS
END;

procedure PintaBobs3D;ASSEMBLER;
ASM
	MOV			ES,Mode13.vRAM

	MOV			CX,B_TOTAL
	LEA			SI,bobs

@BUCLE:
	DB			$66;MOV				AX,WORD(Txyz[SI].x)
	DB			$66;MOV				WORD(v1.x),AX
	DB			$66;MOV				WORD(v2.x),AX

	DB			$66;MOV				AX,WORD(Txyz[SI].y)
	DB			$66;MOV				WORD(v1.y),AX
	DB			$66;MOV				WORD(v2.y),AX

	DB			$66;MOV				AX,WORD(Txyz[SI].z)
	DB			$66;MOV				WORD(v1.z),AX
	DB			$66;MOV				WORD(v2.z),AX

	PUSH		CX
	PUSH		SI

	PUSH		DS
	PUSH		OFFSET[v1]
	CALL		Calculos3D

	PUSH		DS
	PUSH		OFFSET[v2]
	CALL		Calculos3D

	MOV			DI,v1.sx
	MOV			BX,v1.sy
	MOV			AH,128
	CALL		pinta

	MOV			DI,v2.sx
	MOV			BX,v2.sy
	MOV			AH,164
	CALL		pinta

	POP			SI
	POP			CX

	ADD			SI,12
	DEC			CX
	JNZ			@BUCLE
END;

procedure MueveBobs;INTERRUPT;
begin
	ASM
		PUSHF
		CALL		AnteriorBobs
	END;

	inc(n);
end;

procedure _Bobs3D;
begin
	PaginaVisible:=0;
	CambiaPaginaVisible:=FALSE;

	Mode13.init(global.COPIA);
	SetScreenSyncro(sync[X200]);

	for n:=0 to B_TOTAL do with bobs[n] do
		begin
			x:=round(n*cos(n*pi/180)) div 2;
			y:=round(n*sin(n*pi/180)) div 2;
			z:=(x*y) div 100;
		end;

	v1.AnguloDeriva:=random(360);
	v1.AnguloCaida:=random(360);
	v1.AnguloBalanza:=random(360);
	v1.mx:=-100;v1.my:=0;v1.mz:=1000;

	v2.AnguloDeriva:=random(360);
	v2.AnguloCaida:=random(360);
	v2.AnguloBalanza:=random(360);
	v2.mx:=100;v2.my:=0;v2.mz:=1000;

	Mode13.LoadPCX('BOBS3D.PCX',vRAM2,c);
	move(ColorBobs[1],c[128],127*3);
	InkAllRGB(0,255,c);

	GetIntVec(8,AnteriorBobs);
	SetIntVec(8,@MueveBobs);

	n:=0;
	repeat
		vector.rotacion(v1);
		vector.rotacion(v2);

		PintaBobs3D;

		if GetSemaphore(3)=1 then SetColors(0,255,PaletaBlanca)
			else SetColors(0,255,c);

		inc(v1.AnguloBalanza);
		if v1.AnguloBalanza>360 then v1.AnguloBalanza:=0;

		inc(v1.AnguloCaida,2);
		if v1.AnguloCaida>360-2 then v1.AnguloCaida:=0;

		inc(v1.AnguloDeriva,4);
		if v1.AnguloDeriva>360-4 then v1.AnguloDeriva:=0;


		dec(v2.AnguloBalanza);
		if v2.AnguloBalanza<0 then v2.AnguloBalanza:=360;

		dec(v2.AnguloCaida,2);
		if v2.AnguloCaida<2 then v2.AnguloCaida:=360;

		dec(v2.AnguloDeriva,4);
		if v2.AnguloDeriva<4 then v2.AnguloDeriva:=360;

		Mode13.anima;
	until n>1000;
	StopColors;

	SetIntVec(8,AnteriorBobs);
end;