unit AnimaX;

INTERFACE

uses global;

const
	INACTIVO=-1;

type
	Tsprite=record
		x,y,n:integer;
	end;

{$I SPRITES.DAT}

function LoadAllSprites:boolean;
{Inicializa y carga la base de sprites}

procedure DisposeAllSprites;
{Acaba y libera la memoria de los sprites}

function LoadSprite(n:integer):boolean;
{Carga el sprite N}

procedure DisposeSprite(n:integer);
{Libera la memoria ocupada por el sprite N}

procedure PintaSpriteMask(var s:Tsprite);
{Pinta el sprite N con mscara (sin pintar los 0) en XY y pgina activa}

procedure PintaSpriteMaskFondo(var s:Tsprite);
{Pinta el sprite N con mscara (sin pintar los 0) en XY y pgina fondo}

procedure PintaSprite(var s:Tsprite);
{Pinta el sprite N sin mscara en XY y pgina activa}

procedure PintaSpriteFondo(var s:Tsprite);
{Pinta el sprite N sin mscara en XY y pgina fondo}

function choque(var s1,s2:Tsprite):boolean;
{Si el sprite N1 en X1Y1 y el sprite N2 en X2Y2, han chocado, TRUE}

IMPLEMENTATION

uses
	ModeX,
{$IFDEF _megafich_}
	megafich;
{$ELSE}
	files;
{$ENDIF}

var
	nada:integer;	{?}
	IncY1,IncY2,dimensiones:word;
	IncAlto,PlanosRestantes:byte;

function LoadAllSprites:boolean;
var
	m,l,d:word;
	f:Tfile;
	p:^byte;

begin
	LoadAllSprites:=FALSE;

	if open(f,'SPRITES.BIN',RO)>0 then
		begin
			close(f);
			exit;
		end;

	for m:=1 to high(dim) do with dim[m] do
		begin
			l:=ancho*alto;
			GetMem(PunteroSprite,l);
			read(f,PunteroSprite^,l,d);
		end;

	LoadAllSprites:=TRUE;
end;

procedure DisposeAllSprites;
var
	n:integer;

begin
	for n:=1 to high(dim) do DisposeSprite(n);
end;

function LoadSprite(n:integer):boolean;
var
	p:^byte;
	a:LongInt;
	b:integer;
	d,l:word;
	f:Tfile;

begin
	LoadSprite:=FALSE;
	if open(f,'SPRITES.BIN',RO)>0 then
		begin
			close(f);
			exit;
		end;

	a:=0;
	for b:=1 to n-1 do with dim[b] do
		begin
			l:=ancho*alto;
			inc(a,l);
		end;

	with dim[n] do
		begin
			l:=ancho*alto;
			GetMem(PunteroSprite,l);
			seek(f,a);
			read(f,PunteroSprite^,l,d);
		end;

	LoadSprite:=TRUE;
	close(f);
end;

procedure DisposeSprite(n:integer);
var
	p:^byte;

begin
	with dim[n] do
		begin
			p:=PunteroSprite;
			if p<>NIL then FreeMem(p,ancho*alto);
		end;
end;

procedure PintaSpriteMask(var s:Tsprite);ASSEMBLER;
ASM
	PUSH		DS
	PUSH		BP

	LES			DI,s
	MOV			AX,ES:Tsprite[DI].n
	CMP			AX,INACTIVO
	JZ			@SALIR

	LEA			SI,dim
	SHL			AX,3
	ADD			SI,AX

	MOV			AX,DS
	DW			MOV_GS_AX

	MOV			IncAlto,0
	MOV			IncY1,0
	MOV			IncY2,0

	MOV			DX,region.yul
	MOV			BX,ES:Tsprite[DI].y
	MOV			AX,BX
	ADD			AX,WORD(Tdim[SI].alto)
	CMP			AX,DX						{if y+alto<region.yul then goto fin}
	JLE			@SALIR

	CMP			BX,DX   				{if y<region.yul then...}
	JGE			@SIGUE_Y1
	MOV			AX,DX           {y:=region.yul;}
	SUB			AX,BX
	MOV			IncAlto,AL      {...dec(alto,abs(region.yul-y);}

	MOV			CX,WORD(Tdim[SI].ancho)
	SHR			CX,2
	IMUL		CX              {...inc(IncY1,abs(region.yul-y)*ancho);}
	MOV			IncY1,AX
	MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
	MOV			DX,region.ylr
	CMP			BX,DX   				{if y>region.ylr then goto fin}
	JGE			@SALIR

	MOV			AX,BX
	ADD			AX,WORD(Tdim[SI].alto)
	CMP			AX,DX   							{if y+alto>region.ylr then...}
	JL			@SIGUE_Y2
	SUB			AX,DX
	MOV			IncAlto,AL      			{dec(alto,(y+alto)-region.ylr}

	MOV			CX,WORD(Tdim[SI].ancho)
	SHR			CX,2
	IMUL		CX              			{inc(IncDir,region.ylr-(y+alto))*ancho}
	MOV			IncY2,AX

@SIGUE_Y2:
	MOV			AX,ES:Tsprite[DI].x
	PUSH		AX                    {Guardo x}
	SHR			AX,2             	 		{x=x/4}
	ADD			BX,BX
	ADD			AX,WORD(MultBy80[BX]) {y=y*80}
	LES     DI,vRAM
	ADD			DI,AX             		{DI=x+y}

	MOV			BX,WORD(Tdim[SI].ancho)
	SHR			BX,2                  {ancho=ancho/4}
	MOV			BP,80
	SUB			BP,BX									{paso=320-ancho}
	MOV			WORD(@CAMBIA+2),BP

	MOV			BH,BYTE(Tdim[SI].alto)
	SUB			BH,IncAlto
	MOV			dimensiones,BX        {BX=ancho y alto}
	MOV			PlanosRestantes,4

	LDS			SI,DWORD(Tdim[SI].PunteroSprite)

	POP			CX                    {Recupero x}
	AND			CL,3
	MOV			AH,$11
	SHL			AH,CL         				{AH=plano actual}

	MOV			DX,SC_INDEX
	MOV			AL,GC_READ_MAP
	OUT			DX,AL
	INC			DX

@PLANO:
	DB			GS;ADD			SI,IncY1
	PUSH		DI

	MOV			AL,AH
	OUT			DX,AL

	DB			GS;MOV			BH,BYTE(dimensiones+1)	{MOV BH,alto}

@Y:
	MOV			CL,BL				{CL=ancho/4}

@X:
	LODSB
	TEST		AL,AL
	JZ			@CERO
	MOV			ES:[DI],AL

@CERO:
	INC			DI
	DEC			CL
	JNZ			@X

@CAMBIA:
	ADD			DI,65535		{65535, cambia con BP}
	DEC			BH
	JNZ			@Y

	POP			DI          {Recupera direccin inicial de escritura}
	ROL			AH,1
	ADC			DI,0				{Si el plano actual es el 4, pasamos a los
											4 puntos del plano siguiente}
	DB			GS;ADD			SI,IncY2
	DB			GS;DEC			PlanosRestantes
	JNZ			@PLANO

@SALIR:
	POP			BP
	POP			DS
END;

procedure PintaSpriteMaskFondo(var s:Tsprite);
var
	guarda:pointer;

begin
	guarda:=vRAM;
	vRAM:=ptr($a000,desplazamiento[PAGINA_FONDO]);
	PintaSpriteMask(s);
	vRAM:=guarda;
end;

procedure PintaSprite(var s:Tsprite);ASSEMBLER;
ASM
	PUSH		DS
	PUSH		BP

	LES			DI,s
	MOV			AX,ES:Tsprite[DI].n
	CMP			AX,INACTIVO
	JZ			@SALIR

	LEA			SI,dim
	SHL			AX,3
	ADD			SI,AX

	MOV			AX,DS
	DW			MOV_GS_AX

	MOV			IncAlto,0
	MOV			IncY1,0
	MOV			IncY2,0

	MOV			DX,region.yul
	MOV			BX,ES:Tsprite[DI].y
	MOV			AX,BX
	ADD			AX,WORD(Tdim[SI].alto)
	CMP			AX,DX						{if y+alto<region.yul then goto fin}
	JLE			@SALIR

	CMP			BX,DX   				{if y<region.yul then...}
	JGE			@SIGUE_Y1
	MOV			AX,DX           {y:=region.yul;}
	SUB			AX,BX
	MOV			IncAlto,AL      {...dec(alto,abs(region.yul-y);}

	MOV			CX,WORD(Tdim[SI].ancho)
	SHR			CX,2
	IMUL		CX              {...inc(IncY1,abs(region.yul-y)*ancho);}
	MOV			IncY1,AX
	MOV			BX,region.yul		{...y:=region.yul}

@SIGUE_Y1:
	MOV			DX,region.ylr
	CMP			BX,DX   				{if y>region.ylr then goto fin}
	JGE			@SALIR

	MOV			AX,BX
	ADD			AX,WORD(Tdim[SI].alto)
	CMP			AX,DX   				{if y+alto>region.ylr then...}
	JL			@SIGUE_Y2
	SUB			AX,DX
	MOV			IncAlto,AL      {dec(alto,(y+alto)-region.ylr}

	MOV			CX,WORD(Tdim[SI].ancho)
	SHR			CX,2
	IMUL		CX              {inc(IncDir,region.ylr-(y+alto))*ancho}
	MOV			IncY2,AX

@SIGUE_Y2:
	MOV			AX,ES:Tsprite[DI].x
	PUSH		AX										{Guardo x}
	SHR			AX,2             	 		{x=x/4}
	ADD			BX,BX
	ADD			AX,WORD(MultBy80[BX]) {y=y*80}

	LES     DI,vRAM
	ADD			DI,AX             		{DI=x+y}

	MOV			BX,WORD(Tdim[SI].ancho)
	SHR			BX,2                  {ancho=ancho/4}
	MOV			BP,80
	SUB			BP,BX									{paso=320-ancho}
	MOV			WORD(@CAMBIA+2),BP

	MOV			BH,BYTE(Tdim[SI].alto)
	SUB			BH,IncAlto
	MOV			dimensiones,BX        {BX=ancho y alto}
	MOV			PlanosRestantes,4

	LDS			SI,DWORD(Tdim[SI].PunteroSprite)

	POP			CX                    {Recupero x}
	AND			CL,3
	MOV			AH,$11
	SHL			AH,CL         				{AH=plano actual}

	MOV			DX,SC_INDEX
	MOV			AL,GC_READ_MAP
	OUT			DX,AL
	INC			DX

@PLANO:
	DB			GS;ADD			SI,IncY1
	PUSH		DI

	MOV			AL,AH
	OUT			DX,AL

	DB			GS;MOV			BH,BYTE(dimensiones+1)	{MOV BH,alto}

@Y:
	DB			$F,$B6,$CB	{CX=ancho/4		[MOVZX CX,BL]}
	REP			MOVSB

@CAMBIA:
	ADD			DI,65535		{65535, cambia con BP}
	DEC			BH
	JNZ			@Y

	POP			DI                    {Recupera direccin inicial de escritura}
	ROL			AH,1
	ADC			DI,0									{Si el plano actual es el 4, pasamos a los
																{4 puntos del plano siguiente}
	DB			GS;ADD			SI,IncY2
	DB			GS;DEC			PlanosRestantes
	JNZ			@PLANO

@SALIR:
	POP			BP
	POP			DS
END;

procedure PintaSpriteFondo(var s:Tsprite);
var
	guarda:pointer;

begin
	guarda:=vRAM;
	vRAM:=ptr($a000,desplazamiento[PAGINA_FONDO]);
	PintaSprite(s);
	vRAM:=guarda;
end;

function choque(var s1,s2:Tsprite):boolean;ASSEMBLER;
var
	x1,y1:integer;
	x1_ancho1,y1_alto1:integer;

ASM
	MOV				BL,FALSE

	LES				DI,s1
	MOV				AX,ES:Tsprite[DI].n	{if n1=INACTIVO then exit}
	CMP				AX,INACTIVO
	JZ				@FIN

	LEA				SI,dim
	SHL				AX,3
	ADD				SI,AX

	MOV				BX,Tdim[SI].ancho
	MOV				CX,Tdim[SI].alto

	MOV				AX,ES:Tsprite[DI].x
	MOV       x1,AX
	ADD				AX,BX
	MOV				x1_ancho1,AX

	MOV				AX,ES:Tsprite[DI].y
	MOV       y1,AX
	ADD				AX,CX
	MOV       y1_alto1,AX

	LES				DI,s2
	MOV				AX,ES:Tsprite[DI].n	{if n2=INACTIVO then exit}
	CMP				AX,INACTIVO
	JZ				@FIN

	LEA				SI,dim
	SHL				AX,3
	ADD				SI,AX

	MOV				BX,Tdim[SI].ancho
	MOV				CX,Tdim[SI].alto

	MOV				AX,ES:Tsprite[DI].x
	MOV				SI,AX
	ADD				SI,BX

	MOV				DX,ES:Tsprite[DI].y
	MOV				DI,DX
	ADD				DI,CX

	CMP				x1_ancho1,AX
	JLE				@FIN

	CMP				SI,x1
	JLE				@FIN

	CMP      	y1_alto1,DX
	JLE				@FIN

	CMP				DI,y1
	JLE				@FIN

	MOV				BL,TRUE

{	choque:=(x1+ancho1>x2) and (x2+ancho2>x1) and
					(y1+alto1>y2) and (y2+alto2>y1);}

@FIN:
	MOV				AL,BL
END;

end.