{                                                                         }
{ This routine is dedicated to Lord Crom, because he asked me for a fast  }
{ keyboard routine for LISSA. Then I made this little example for all     }
{ coders. Feel free to use it. I only want you to give me credit.         }
{                                                                         }
{                  Creada por AtaSoft Enero 1994.                         }
{                      Lords Crom & Mitra.                                }
{                        Madrid (Spain)                                   }

Program LeeDocs;

{$M 16000,0,0}

uses dos,Crt,atas;

const
Contact: Array[1..20] of string =(
'                               ڿ             ڿ              ',
'      ¿ Ŀ Ŀ Ŀ ڿ   Ŀ             Ŀ  Ĵ ',
'                 ¿                     ¿',
'                              ',
'            ',
'                     ',
' ۱   Contact with Spanish Lords   ',
'                                                                             ',
' If you want to contact with us our adresses are:                            ',
'                                                                             ',
'    Standard mail:           Bit Informatica.                              ',
'                            Ref: Spanish Lords.                          ',
'                             C/Mayor 26 2A                            ',
'                            Alcala de Henares                          ',
'                                 28801                                 ',
'                               (M a d r i d)                             ',
'                                  S P A I N                                ',
'                                                                             ',
'    InterNet mail:  Mase08@Islero.Cedex.es                                   ',
'  ');


var

  DocArray  : Array [1..16000] of byte;
  DocToMem  : Array [1..32000] of byte;
  NumPages  : Byte;

  cnt       : byte;
  YPos      : Integer;   { X,Y positions of the screen. }
  ContExec  : Boolean;   { True if executing. False when ESC is pressed. }
  ScrDirec  : Byte;      {  Where is the screen going ? }
  OldProc   : Procedure; { Here goes the normal interrupt 9. }

Procedure ClrScr; assembler;

ASM
   mov  ah,0Fh
   int  10h
   mov  ah,00
   int  10h
END;

Procedure PutDocLikeMem;

  Const
    LastLine : String [80] =
    '  SPANISH LORDS               '+#24#25+'- Up / Down     Esc- Quit         Enero 1994    ';
    LastLineColor : Array [1..80] of Byte = (
    $70,$70,$74,$74,$74,$7E,$7E,$7E,$7E,$7E,$7E,$7E,$74,$74,$74,$70,$70,$70,$70,$70,$70,$70,
    $70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,
    $70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,
    $70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70,$70);

  var
     CntAux     : Byte;
     CntPag     : Byte;
     CntColChar : Byte;
     CntFilChar : Byte;
     CntArray   : Word;
     CntMem     : Word;
begin
  CntPag:=1;
  CntArray:=1;
  CntMem:=1;
  Repeat
    CntFilChar:=1;
    If CntPag<>1 then
      begin
         DocToMem [CntMem]:=DocArray[CntArray-1];
         Inc(CntMem);
         DocToMem [CntMem]:=$0A;
         Inc(CntMem);
      end;
    Repeat
      CntColChar:=1;
      Repeat
        Case DocArray [CntArray] of
                26 : Begin
                       NumPages:=CntPag;
                       DocToMem [CntMem]:= 00;
                       Inc(CntMem);
                       DocToMem [CntMem]:=$0F;
                       Inc(CntMem);
                     end;
                $D : ;
                $A : Begin
                       For CntAux:=CntColchar to 80 do
                         Begin
                           DocToMem [CntMem]:= 00;
                           Inc(CntMem);
                           DocToMem [CntMem]:=$0F;
                           Inc(CntMem);
                         End;
                       CntColChar:=79;
                       If (CntFilChar=1) and (CntPag=1) then
                         Begin
                           DocToMem [CntMem]:= 00;
                           Inc(CntMem);
                           DocToMem [CntMem]:=$0F;
                           Inc(CntMem);
                         End;
                     End;
          219..223 : Begin
                       DocToMem [CntMem]:=DocArray[CntArray];
                       Inc(CntMem);
                       DocToMem [CntMem]:=$0A;
                       Inc(CntMem);
                     End;
          176..178,196 : Begin
                       DocToMem [CntMem]:=DocArray[CntArray];
                       Inc(CntMem);
                       DocToMem [CntMem]:=$02;
                       Inc(CntMem);
                     End
          else begin
                 DocToMem [CntMem]:=DocArray[CntArray];
                 Inc (CntMem);
                 DocToMem [CntMem]:=$0F;
                 Inc (CntMem);
               end;
        end;
        Inc (CntColChar);
        Inc (CntArray);
      Until CntColChar=81;
      Inc (CntFilChar);
    Until CntFilChar>24;
    Dec(CntMem,2);
    For CntAux:=1 to 80 do
      Begin
        DocToMem [CntMem]:=Ord(LastLine[CntAux]);
        Inc(CntMem);
        DocToMem [CntMem]:=LastLineColor [CntAux];
        Inc(CntMem);
      End;
    Inc(CntPag);
  Until CntPag=8;
End;
Procedure ReadDoc (DocName:String);

  Var
    DocFile : File;
    Aux     : Word;

  Begin
    Assign (DocFile,DocName);
    Reset  (DocFile,16000);
    BlockRead (DocFile,DocArray,1,Aux);
    PutDocLikeMem;
  End;


Procedure PutScr;Assembler;

  ASM
    push  es
    push  di
    push  ds
    push  si
    pusha

    mov ax,Seg DocToMem
    mov ds,ax
    mov si,offset DocToMem

    mov ax,$B800
    mov es,ax
    xor di,di

    mov cx,16000
    @bucle:
      lodsw
      stosw
      loop @bucle


    popa
    pop  si
    pop  ds
    pop  di
    pop  es
  End;

Procedure ClearBuffer; assembler;

ASM
   push  es

   cli                   { Deactivate interrupts. }

   xor  ax,ax            { AX := 0 }
   mov  es,ax            { ES := 0 }
   mov  al,es:[$41A]     { AL := Keyboard buffer begin. }
   mov  es:[$41C],al     { Keyboard buffer tail := Keyboard buffer begin. }

   sti                   { Enable interrupts. }

   pop  es
END;


{$S-,W-,F+}
procedure Teclado; interrupt;
begin
  If Port[$60]= 1 then ContExec:=False; { ESCAPE      }
  If Port[$60]=72 then ScrDirec:=1;     { UP ARROW    }
  If Port[$60]=80 then ScrDirec:=4;     { DOWN ARROW  }
  If Port[$60]=$E1 then Port[$60]:=0;   { PAUSE       }
  If PortW[$60]=$48 then ScrDirec:=1;

  inline ($9C); { PUSHF }
  OldProc; { Execute old interrupt. }
  ClearBuffer; { Clean keyboard buffer. }
end;
{$F-,S+}

{ BPR is the number of bytes that each row occupies in video memory. }

Procedure SetBegin(X,Y,BPR:Word); assembler;

asm
   push  si
   push  di

   mov   ax,40h     { Segment 40h }
   mov   es,ax
   mov   cl,es:49h  { Port 49h = Video BIOS data area }

   mov   ax,X       { AX := X coordinate. }
   mov   bx,Y       { BX := Y coordinate. }

   cmp   cl,7       { Jump if graphics mode. }
   ja    @l01

   je    @l02       { Jump if monocrome text. }

   test  byte ptr es:89h,1 { If there's 1 in port 89h , we have a VGA }
   jnz   @l02       { Jump if VGA present }

   jmp   @l03

@L01:
   mov   cx,8       { CL := 8 pixels by byte. }
                    { CH := 0(Line sweep preselection. }
   div   cl         { AH := bit displacement in byte. }
                    { AL := Byte displacement in pixels row. }
   mov   cl,ah      { CL := Horizontal pixel panoramic. }
   xor   ah,ah
   xchg  ax,bx      { AX := Y }
                    { BX := Byte displacement in pixels row. }
   mov   dx,BPR     { DX := Chars row shown }
   mul   dx         { AX := Byte displacement in row begin. }
   jmp   @L05

@L02:
   mov   cx,9       { CL := 9 pixels by byte. }
   div   cl         { AH := bit displacement in byte. }
                    { AL := byte displacement in pixels row. }
   dec   ah         { AH := -1, 0-7 }
   jns   @l04       { Jump if AL = 0-7 }
   mov   ah,8       { AH := 8 }
   jmp   @L04

@L03:
   mov   cx,8       { CL := 8 pixels by byte. }
   div   cl         { AH := bit displacement in byte. }
                    { AL := byte displacement in pixels row. }


@L04:
   mov   cl,ah      { Horizontal pixel panoramic value. }
   xor   ah,ah
   xchg  ax,bx      { AX := Y }
                    { BX := byte displacement in row. }
   div   byte ptr es:85h  { AL := Char`s row }
                    { AH := Sweep line in characters matrix. }
   xchg  ah,ch      { AX := Char`s row. }
                    { CH := Sweep line. }
   mov   dx,BPR     { DX := chars row shown }
   mul   dx         { AX := Byte displacement in char`s row. }
   shr   ax,1       { AX := Word displacement in char`s row. }

{ Here the operations end. Now, this is the routine that really do all. }
{ Assembler registers must have these valours :                         }
{  AX : Char`s row displacement.                                        }
{  BX : Byte displacement in the row.                                   }
{  CH : Line sweep preselection                                         }
{  CL : Horizontal pixel panoramic                                      }

@L05:
   add   bx,ax
   mov   dx,es:63h { Puerto 63h = E/S del CRTC }
   add   dl,6      { Puerto del estado de video }

@L20:              { Wait for vertical retrace. }
   in    al,dx

   test  al,8
   jz    @L20

@L21:              { Wait until vertical retrace ends. }
   in    al,dx
   test  al,8
   jnz   @L21

   cli             { Stop interrupts. }
   sub   dl,6      { DX := 3B4H or 3D4H. }

   mov   ah,bh     { AH := High value for begin direction. }
   mov   al,0ch    { AL := Register to modify. }
   out   dx,ax
   mov   ah,bl     { AH := Low  value for begin direction. }
   inc   al        { AL := Register to modify. }
   out   dx,ax
   sti             { Enable interrupts. }

   add   dl,6      { DX := Video status port. }

@L22:              { Wait for vertical retrace. }
   in    al,dx
   test  al,8
   jz    @l22

   cli             { Stop interrupts. }

   sub   dl,6      { DX := 3B4h or 3D4H }
   mov   ah,ch     { AH := Value for line sweep preselection register. }
   mov   al,8      { AL := Register to change. }
   out   dx,ax
   mov   dl,0c0h   { Atributes controller port. }
   mov   al,13h OR 20h { Horizontal pixel panoramic register. }
   out   dx,al
   mov   al,cl     { Horizontal pixel panoramic value. }
   out   dx,al

   sti             { Enable interrupts. }

end;

Procedure PutContact;

begin
 { Clean screen and write 'SPANISH LORDS'. }
  ClrScr;
  For Cnt:=1 to 20 do
    begin
       For YPos:=1 to 80 do
         begin
            Case ord(Contact[Cnt,YPos]) of
              176..178:TextColor(Green);
              219..223:TextColor(LightGreen);
              else TextColor(White);
            end;
            Write(Contact[Cnt,YPos]);
         end;
    end;
    Asm
      mov ax,$B800
      mov es,ax
      mov di,1

      mov bl,20
    @CincoLineas :

      mov al,12
      mov cx,0021
    @Rojo1 :
      stosb
      inc di
      loop @Rojo1

      mov al,14
      mov cx,0038
    @Amarillo :
      stosb
      inc di
      loop @Amarillo

      mov al,12
      mov cx,0021
    @Rojo2 :
      stosb
      inc di
      loop @Rojo2

      dec bl
      jnz @CincoLineas
    End;
end;

Begin
 { Clean the screen. }
  Clrscr;
 { Put the screen in the next video page. }
  If ParamCount=0 then ReadDoc('CONTACT.DOC')
                  else if FileExists(ParamStr(1)) then ReadDoc(ParamStr(1))
                                                  else begin
                                                          PutContact;
                                                          Halt(1);
                                                       end;
  PutScr;
 { Save the old keyboard interrupt and put mine. }
  GetIntVec($9,@OldProc);
  SetIntVec($9,@Teclado);
 { Put in variables their initial values. }
  ContExec:=True;
  ScrDirec:=0;
  YPos:=0;
 { Execute until ESC pressed. }
  Repeat
      Case ScrDirec of
           1 : begin
                  If YPos<>0
                     then begin
                             Cnt:=0;
                             Repeat
                                Dec(Ypos,4);
                                SetBegin(0,YPos,160);
                                Inc(Cnt);
                             until cnt=100;
                             ScrDirec:=0;
                          end;
               end;
           4 : begin
                  If YPos<>NumPages*400-400
                     then begin
                             Cnt:=0;
                             Repeat
                                Inc(Ypos,4);
                                SetBegin(0,YPos,160);
                                Inc(Cnt);
                             until cnt=100;
                             ScrDirec:=0;
                          end;
               end;
      end;
  Until not ContExec;
 { Put the sreen in the correct position. }
  SetBegin(0,0,640);
 { Put the old keyboard interrupt }
  SetIntVec($9,@OldProc);
  ClrScr;
  PutContact;
End.