{       A little program what draw balls, in lissajous forms.             }
{                                                                         }
{               Created by Spanish Lords Enero 1994.                      }
{                    Lords   Crom  &  Mitra.                              }
{                       Alcala de Henares                                 }
{                         M a d r i d                                     }
{                           (Spain)                                       }

PROGRAM Lissajous;

{$M 3000,0,255360}

USES
  Crt,Dos,Misc,Esferas;


VAR
  Tecla     : Char;
  Retardo   : Byte;
  Code      : Integer;

  TipoEsfera: Byte;

  Continue  : Boolean;
  NextPart  : Boolean;
  Direction : Byte;
  Old       : Procedure;

{ Fill a rectangle with a color.}

Procedure FillRectangle (X1,Y1,X2,Y2:Word;Color:Byte);
  Var
    Ancho : Word;
    Alto  : Byte;

  Begin
    Ancho:=X2-X1;
    Alto :=Y2-Y1;

    Asm
      mov ax,$a000 { Video memory.}
      mov es,ax
                   { Calculating Offset of X1,Y1.}
      mov bx,x1
      mov dx,y1

      xchg dh,dl

      mov di,dx
      shr di,1
      shr di,1
      add di,dx
      add di,bx
                   { Ok }
      mov dl,Alto  { Drawing lines for fill an area.}
      mov al,color

    @Columna :
      mov cx,Ancho
    @VerticalLine :
      stosb
      loop @VerticalLine

      mov cx,320
      sub cx,Ancho
      add di,cx

      dec dl
      jnz @Columna

    End;
  End;

{ Clear keyboard buffer. }
Procedure ClearBuffer; assembler;

ASM
   cli                   { Deactivate interrupts. }

   xor  ax,ax            { AX := 0 }
   mov  es,ax            { ES := 0 }
   mov  al,es:[$41A]     { AL := Keyboard buffer begin. }
   mov  es:[$41C],al     { Keyboard buffer tail := Keyboard buffer begin. }

   sti                   { Enable interrupts. }
END;

{ New keyboard interrupt. Simply but effective.}
{$S-,W-,F+}
procedure Teclado; interrupt;
begin
  If Port[$60]= 1                     then Continue:=False; { ESCAPE      }
  If Port[$60]=72                     then Direction:=1;    { UP ARROW    }
  If Port[$60]=75                     then Direction:=2;    { LEFT ARROW  }
  If Port[$60]=77                     then Direction:=3;    { RIGHT ARROW }
  If Port[$60]=80                     then Direction:=4;    { DOWN ARROW  }
  If (Port[$60]=27) or (Port[$60]=78) then Direction:=5;    { + KEY       }
  If (Port[$60]=53) or (Port[$60]=74) then Direction:=6;    { - KEY       }
  If (Port[$60]=28)                   then NextPart:=True;  {   ENTER     }
  If  Port[$60]=$E1                   then Port[$60]:=0;    {   PAUSE     }
  inline ($9C); { PUSHF }
  Old;
  ClearBuffer;
end;
{$F-,S+}
{                                                                         }
{ If we add two armonics moves with perpendicular directions we'll have   }
{ a curve called lissanjous curve. Then:                                  }
{         x = A1 sen (w1t + Desf1)                                        }
{         y = A2 sen (w2t + Desf2)                                        }
{                                                                         }
PROCEDURE Curvas;

  Var
  { We are going to draw 60 balls (max).                                  }
  {                                                                       }
  {   StPuntos:Circular queque where I'll put x,y coordinates of the balls}
  {   NumBolas:Number of balls that we are using (max 60)                 }
  {   PBola1  :Init of queque.                                            }
  {   PBolaFin:End of queque.                                             }

    StPuntos : Array [1..60,1..2] of Integer;
    NumBolas : Byte;
    PBola1   : Byte;
    PBolaFin : Byte;

    CoorX    : Integer;
    CoorY    : Integer;

  { Counters for work with two curves.                                   }
  {                                                                      }
  { Cnt      : Un Contador.                                              }
  { CntAng   : Determina el numero de grados que incremento en cada paso.}
  { CntA1    : Valor de la amplitud de la primera curva.                 }
  { CntA2    : Valor de la amplitud de la segunda curva.                 }
  { Cntw1    : Valor de la pulsacion de la primera curva.                }
  { Cntw2    : Valor de la pulsacin de la segunda curva.                }
  { CntDesf1 : Valor del desfase de la primera curva.                    }
  { CntDesf2 : Valor del desfase de la segunda curva.                    }
  { CntIniX  : Coordenada x donde empiezo a dibujar la curva.            }
  { CntIniY  : Coordenada y donde empiezo a dibujar la curva.            }
  { CntColor : Valor del color de la esfera.                             }

    Cnt      : Integer;
    CntAng   : Integer;
    CntA1    : Integer;
    CntA2    : Integer;
    Cntw1    : Integer;
    Cntw2    : Integer;
    CntDesf1 : Integer;
    CntDesf2 : Integer;
    CntIniX  : Integer;
    CntIniY  : Integer;
    CntColor : Byte;


    ValA1    : Real;
    ValA2    : Real;
    Valw1    : Real;
    Valw2    : Real;
    ValDesf1 : Real;
    ValDesf2 : Real;
    Cntt     : Real;


  { Well, this is really slow, you can make a SinCos table and work with it }
  { Lissa don't use it. You must understand this is only a proof. Sorry.    }
  { VAR X,Y  get x,y coordinates.                                           }

  Procedure Valores(VAR X,Y:Integer;A1,A2,w1,w2,Desf1,Desf2,t:Real);

    Const
      PI = 3.141592654;
    Var
      Wt     : Real;
      WtD    : Real;
      AngRad : Real;
      Aux    : Real;
    Begin
      Wt     := W1*t;
      AngRad := (Desf1*PI)/180;
      WtD    := Wt+AngRad;
      AngRad := (WtD*PI)/180;
      Aux    := A1*(SIN (AngRad));
      X      := CntIniX+Trunc (Aux);

      Wt     := W2*t;
      AngRad := (Desf2*PI)/180;
      WtD    := Wt+AngRad;
      AngRad := (WtD*PI)/180;
      Aux    := A2*(SIN (AngRad));
      Y      := CntIniY+Trunc (Aux);
    End;

  { Fill queque the first time.                             }
  Procedure FillArray;

    Var
      Cnt    : Integer;
      CntIni : Integer;
      CntFin : Integer;

    Begin
      PBola1   := 1;
      PBolaFin := 0;

      For Cnt:=1 to NumBolas do
        Begin
          Valores (StPuntos[Cnt,1],StPuntos[Cnt,2],ValA1,ValA2,Valw1,Valw2,
                   ValDesf1,ValDesf2,Cntt);
          Cntt:=Cntt+CntAng;
          Inc (PBolaFin);
        end;
    end;

  { Bring up pointers PBola1 (init) and PBolaFin (end).}
  Procedure ActualizaP;
    Begin
      If PBola1   = NumBolas then PBola1:=1
                             else Inc(PBola1);
      If PBolaFin = NumBolas then PBolaFin:=1
                             else Inc (PBolaFin);
    end;



  { Erase final ball get a new ball and draw all balls.       }
  Procedure ActCurva;
    Var
      CntBola : Byte;
      AuxP1   : Byte;
      AuxP2   : Byte;

    Begin
        Valores  (CoorX,CoorY,ValA1,ValA2,Valw1,Valw2,ValDesf1,ValDesf2,Cntt);
        Case TipoEsfera of
          1 : Esfera1 (StPuntos[PBola1,1],StPuntos[PBola1,2],CntColor,False);
          2 : Esfera2 (StPuntos[PBola1,1],StPuntos[PBola1,2],CntColor,False);
          3 : Esfera3 (StPuntos[PBola1,1],StPuntos[PBola1,2],0,26,4,False);
          4 : Esfera4 (StPuntos[PBola1,1],StPuntos[PBola1,2],0,5,False);
          5 : Esfera5 (StPuntos[PBola1,1],StPuntos[PBola1,2],False);
          6 : Esfera6 (StPuntos[PBola1,1],StPuntos[PBola1,2],False);
        end;

        ActualizaP;

        StPuntos [PBolaFin,1] := CoorX;
        StPuntos [PBolaFin,2] := CoorY;

        CntBola :=PBola1;
        If CntBola =1 then CntBola :=NumBolas
                  else Dec (CntBola);
        Repeat
          If CntBola = NumBolas then CntBola:=1
                                else Inc(CntBola);
          Case TipoEsfera of
            1 : Esfera1 (StPuntos[CntBola,1],StPuntos[CntBola,2],CntColor,True);
            2 : Esfera2 (StPuntos[CntBola,1],StPuntos[CntBola,2],CntColor,True);
            3 : Esfera3 (StPuntos[CntBola,1],StPuntos[CntBola,2],0,26,4,True);
            4 : Esfera4 (StPuntos[CntBola,1],StPuntos[CntBola,2],0,5,True);
            5 : Esfera5 (StPuntos[CntBola,1],StPuntos[CntBola,2],True);
            6 : Esfera6 (StPuntos[CntBola,1],StPuntos[CntBola,2],True);
          end;
        Until CntBola=PBolaFin;
    end;
  { Draw a curve with actually parameters.}
  Procedure UnaCurva;
    Begin
      Repeat
        ActCurva;
        Delay (Retardo);
        If  Cntt<=360 then Cntt := Cntt+CntAng
                      else Cntt := CntAng;
        Case Direction of
          5 : If Retardo<100 then Inc (Retardo); { + Key. }
          6 : If Retardo>  0 then Dec (Retardo); { - Key. }
          7 : NextPart:=True;                    { ENTER  }
        end;
        Direction := $FF;
      Until (Cntt>=360) or (not Continue) or (NextPart);
    end;

    { Design of each part, colors, angles, kind of ball...}
    {-- PARTE I ------------------------------------------}
    Procedure DisParteI;
      Begin
        ReadPcx($A000,'ATAS.PCX');
        SetText (2,1,1,1,1);
        GrWrite ( 40,180, 96,'Bah esto es fcil.');
        GrWrite (180,180,102,'(Bah this is easy).');
        ActPantalla;

        NextPart  :=False;
        TipoEsfera:=   1;

        CntColor  :=  48;
        NumBolas  :=  60;
        CntAng    :=   1;
        ValA1     :=  10;
        ValA2     :=  10;

        Valw1     :=   5;
        Valw2     :=   6;

        ValDesf1  :=   0;
        ValDesf2  :=  90;

        Cntt      :=   0;

        CntIniX   := 160;
        CntIniY   := 100;

        FillArray;

        CntA1:=10;
        Repeat
          ValA1:=CntA1;
          ValA2:=CntA1;
          UnaCurva;
          Inc (CntA1,10);
          Inc (CntColor,16);
        Until (CntA1>=80) or (not continue) or (NextPart);
        Inc(CntColor,16);
        Repeat
          ValA1:=CntA1;
          ValA2:=CntA1;
          UnaCurva;
          Dec (CntA1,10);
          Dec (CntColor,16);
        Until (CntA1<=10) or (not continue) or (NextPart);
      End;
    {-- PARTE II ---------------------------------------}
    Procedure DisParteII;
      Begin
        Cls;
        ReadPcx ($A000,'ATAS1.PCX');
        GrWrite (70,175, 96,'Oh,oh esto no es tan fcil.');
        GrWrite (40,185,102,'(Oh,oh this isn`t as easy as it looks).');
        ActPantalla;

        NextPart  :=False;
        TipoEsfera:=   2;

        CntColor  :=   0;
        NumBolas  :=  10;
        CntAng    :=   2;

        ValA1     :=  80;
        ValA2     :=  80;

        Valw1     :=   1;
        Valw2     :=   6;

        ValDesf1  :=   0;
        ValDesf2  :=  90;

        Cntt      :=   0;

        CntIniX   := 160;
        CntIniY   := 100;

        FillArray;

        Cntw1:=1;
        Repeat
          Valw1:=Cntw1;
          UnaCurva;
          Inc (Cntw1);
        Until (Cntw1=6) or (not continue) or (NextPart);

        Repeat
          Valw2:=Cntw1;
          UnaCurva;
          Dec (Cntw1);
        Until (Cntw1=1) or (not continue) or (NextPart);
      End;
    {-- PARTE III --------------------------------------}
    Procedure DisParteIII;
      Begin
        Cls;
        ReadPcx ($A000,'ATAS2.PCX');
        GrWrite ( 40,5, 96,'Te gusta?');
        GrWrite (150,5,102,'(Do you like it?).');
        ActPantalla;

        NextPart  :=False;
        TipoEsfera:=   3;

        ActColEsf :=   5;
        NumBolas  :=  30;
        CntAng    :=   1;

        ValA1     :=  80;
        ValA2     :=  80;

        Valw1     :=  11;
        Valw2     :=   6;

        ValDesf1  :=   0;
        ValDesf2  :=  90;

        Cntt      :=   0;

        CntIniX   := 160;
        CntIniY   := 100;

        FillArray;
        FillColors;


        CntDesf1:=1;
        Repeat
          UnaCurva;
          Inc (CntDesf1);
        Until (CntDesf1=5) or (not continue) or (NextPart);
      End;
    {-- PARTE IV ----------------------------------------}
    Procedure DisParteIV;
      Begin
        Cls;
        ReadPcx ($A000,'ATAS3.PCX');
        GrWrite ( 10,185, 96,'Guauu, mira el cristal.');
        GrWrite (150,185,102,'(Guauu, look the glass).');
        ActPantalla;

        NextPart  :=False;
        TipoEsfera:=   3;

        ActColEsf :=   9;
        NumBolas  :=  30;
        CntAng    :=   1;

        ValA1     :=  10;
        ValA2     :=  10;

        Valw1     :=  11;
        Valw2     :=   6;

        ValDesf1  :=   0;
        ValDesf2  :=  90;

        Cntt      :=   0;

        CntIniX   := 160;
        CntIniY   := 100;

        FillArray;
        FillColors;


        CntA1:=10;
        Repeat
          ValA1:=CntA1;
          ValA2:=CntA1;
          UnaCurva;
          Inc (CntA1,10);
        Until (CntA1>=80) or (not continue) or (NextPart);
        Repeat
          ValA1:=CntA1;
          ValA2:=CntA1;
          UnaCurva;
          Dec (CntA1,10);
        Until (CntA1<=10) or (not continue) or (NextPart);
      End;
    {-- PARTE V -----------------------------------------}
    Procedure DisParteV;
      Begin
        Cls;
        ReadPcx($A000,'ATAS4.PCX');
        ActPantalla;

        NextPart  :=False;
        TipoEsfera:=   4;

        ActColEsf :=   0;
        NumBolas  :=  20;
        CntAng    :=   2;

        ValA1     :=  80;
        ValA2     :=  80;

        Valw1     :=   8;
        Valw2     :=   2;

        ValDesf1  :=   0;
        ValDesf2  :=  90;

        Cntt      :=   0;

        CntIniX   := 100;
        CntIniY   := 100;

        FillArray;
        FillColors;

        Repeat
          UnaCurva;
          Inc (CntIniX,10);
        Until (CntIniX>=230) or (not continue) or (NextPart);
        Repeat
          UnaCurva;
          Dec (CntIniX,10);
        Until (CntIniX<=100) or (not continue) or (NextPart);

      End;
    {-- PARTE VI ----------------------------------------}
    Procedure DisParteVI;

      Var
        CntLine : Byte;

      Begin
        Cls;
        PutDpPalette;
        SetText (1,1,1,1,1);
        GrWrite (80, 0,55,'Lissa  by ');
        GrWrite (80,20,71,' Spanish');
        GrWrite (80,40,55,'  Lords');
        SetText (2,1,1,1,1);
        Grwrite ( 90,80,122,'Coded by');
        GrWrite (145,80,120,'Crom');
        GrWrite (175,80,121,'&');
        GrWrite (185,80,120,'Mitra');

        GrWrite (90,110, 99,'a new group of demos?');
        GrWrite (40,120,101,'soon you can see LOCURA, our first demo');
        GrWrite (50,130,103,'but first we need some music routines');
        GrWrite (90,140,105,'have you any routines?');
        GrWrite (50,150,103,'do you want to work with Spanish Lords?');
        GrWrite (60,160,101,'yes?, !!!!  READ DOCs !!!! BE QUICK');
        GrWrite (90,170, 99,'we hope you like LISSA.');



        ActPantalla;
        NextPart  :=False;
        TipoEsfera:=   5;

        ActColEsf :=   0;
        NumBolas  :=  20;
        CntAng    :=   2;

        ValA1     :=  80;
        ValA2     :=  80;

        Valw1     :=   2;
        Valw2     :=   8;

        ValDesf1  :=   0;
        ValDesf2  :=  90;

        Cntt      :=   0;

        CntIniX   := 100;
        CntIniY   := 100;

        FillArray;

        Repeat
          UnaCurva;
          Inc (CntIniX,10);
        Until (CntIniX>=230) or (not continue) or (NextPart);
        Repeat
          UnaCurva;
          Dec (CntIniX,10);
        Until (CntIniX<=100) or (not continue) or (NextPart);

      End;
    {-- PARTE VII ---------------------------------------}
    Procedure DisParteVII;

      Var
        CntLine : Byte;

      Begin
        Cls;
        PutDpPalette;
        SetText (1,1,1,1,1);
        GrWrite (80, 0,55,'Lissa  by ');
        GrWrite (80,20,71,' Spanish');
        GrWrite (80,40,55,'  Lords');
        SetText (2,1,1,1,1);
        Grwrite ( 90,80,122,'Coded by');
        GrWrite (145,80,120,'Crom');
        GrWrite (175,80,121,'&');
        GrWrite (185,80,120,'Mitra');

        GrWrite (99,100,161,'ok,ok we know it');
        GrWrite (40,110,163,'our code can be better, we are working on it');
        GrWrite (50,120,165,'Greetings to Jare, the Faker, Avalancha');
        GrWrite (60,130,167,'and all groups of demos in the world.');
        GrWrite (40,140,165,'Do you know that Assembly Coders do it better?');
        GrWrite (50,150,163,'no?, SomeBody (hungarian notation) said me.');
        SetText (1,1,1,1,1);
        GrWrite (90,165,161,'Bye,Bye.');

        ActPantalla;
        NextPart  :=False;
        TipoEsfera:=   6;

        ActColEsf :=   0;
        NumBolas  :=  10;
        CntAng    :=   4;

        ValA1     :=  70;
        ValA2     :=  70;

        Valw1     :=   3;
        Valw2     :=   6;

        ValDesf1  :=   0;
        ValDesf2  :=  90;

        Cntt      :=   0;

        CntIniX   := 100;
        CntIniY   := 100;

        FillArray;

        Repeat
          UnaCurva;
          Inc (CntIniX,10);
        Until (CntIniX>=230) or (not continue) or (NextPart);
        Repeat
          UnaCurva;
          Dec (CntIniX,10);
        Until (CntIniX<=100) or (not continue) or (NextPart);

      End;
    {-- FINAL -------------------------------------------}
    Procedure DisFinal;

      Var
        CntLine : Byte;

      Begin

        RestRectangle (0,0,319,199);

        FillRectangle (80,0,220,35,0);
        GrWrite   (80,20,71,' Spanish');
        ActPantalla;
        CntLine:=0;
        Repeat
          GrWrite (80,CntLine,55,'Lissa  by');
          Delay (Retardo);
          RestRectangle (80,CntLine,220,CntLine+35);
          Inc(CntLine,5);
        Until CntLine>=199;
        FillRectangle (90,20,220,55,0);
        GrWrite   (80,40,55,'  Lords');
        ActPantalla;
        CntLine:=20;
        Repeat
          GrWrite (80,CntLine,71,' Spanish');
          Delay (Retardo);
          RestRectangle (80,CntLine,220,CntLine+35);
          Inc(CntLine,5);
        Until CntLine>=199;
        FillRectangle (90,40,220,65,0);
        ActPantalla;
        CntLine:=40;
        Repeat
          GrWrite (80,CntLine,55,'  Lords');
          Delay (Retardo);
          RestRectangle (80,CntLine,220,CntLine+35);
          Inc(CntLine,5);
        Until CntLine>=199;
      End;

{----------------------------------------------------------------------------}
  Begin
{                                                                 }
{ Variamos el diseo de las curvas para conseguir bonitos efectos.}
{                                                                 }
    Cnt:=1;
    Repeat
      Case Cnt of
        1 : DisParteI;
        2 : DisParteII;
        3 : DisParteIII;
        4 : DisParteIV;
        5 : DisParteV;
        6 : DisParteVI;
        7 : DisParteVII;
        8 : DisFinal;
        9 : Continue:=False;
      end;
      Inc (Cnt)
    Until not Continue;
  end;
{----------------------------------------------------------------------------}
{ This is very simply but...}
{-----------------------}
{ Write   Spanish Lords.}
{-----------------------}
Procedure WriteSpanishLords;
  Begin
    WriteLn;
    WriteLn;
    WriteLn;
    WriteLn;
    WriteLn;
    WriteLn;
    WriteLn('                               ڿ       ڿ           ');
    WriteLn('            ¿ĿĿĿڿ Ŀ      ĿĴ');
    WriteLn('                  ¿          ¿');
    WriteLn('            ٳ        ');
    WriteLn('                 ');
    WriteLn;

    Asm
      mov ax,$B800
      mov es,ax
      mov di,961

      mov bl,05
    @CincoLineas :

      mov al,12
      mov cx,0025
    @Rojo1 :
      stosb
      inc di
      loop @Rojo1

      mov al,14
      mov cx,0026
    @Amarillo :
      stosb
      inc di
      loop @Amarillo

      mov al,12
      mov cx,0029
    @Rojo2 :
      stosb
      inc di
      loop @Rojo2

      dec bl
      jnz @CincoLineas
    End;
  End;

{------------------------}
{ First screen.          }
{------------------------}
Procedure Principio;

  Begin
    Cls;

    WriteSpanishlords;

    WriteLn;
    WriteLn;
    WriteLn;
    writeLn;
    WriteLn('            Keys: ESC   key  quit LISSA.');
    WriteLn('                  +,-   keys more minus delay.');
    WriteLn('                  ENTER key  next part.');
    WriteLn;
    WriteLn('            IMPORTANT:  LISSA itsn`t a demo, it will be a part of one.');
    WriteLn('                        You aren`t very demanding.');
    WriteLn;
    WriteLn('            Coded by Crom & Mitra. (The blamers of it.)');
    Asm
      mov ax,$B800
      mov es,ax
      mov di,2561

      mov bl,06
    @SeisLineas :

      mov al,15
      mov cx,0023
    @HiBlanco :
      stosb
      inc di
      loop @HiBlanco

      mov al,10
      mov cx,0057
    @LiVerde :
      stosb
      inc di
      loop @LiVerde

      dec bl
      jnz @SeisLineas

      mov di,3681
      mov al,09
      mov cx,0021
    @LiAzul :
      stosb
      inc di
      loop @LiAzul
      mov al,11
      stosb
      inc di
      stosb
      inc di
      stosb
      inc di
      stosb
      inc di
      stosb
      inc di
      mov al,03
      stosb
      inc di
      stosb
      inc di
      mov al,11
      stosb
      inc di
      stosb
      inc di
      stosb
      inc di
      stosb
      inc di
      stosb
      inc di
      stosb
      inc di
      stosb
      inc di
      mov cx,20
      mov al,06
    @Marron :
      stosb
      inc di
      loop @Marron
    End;

    Repeat until (not Continue) or (NextPart);
    Continue:=True;
    NextPart:=False;

  End;
{------------------------}
{ Final screen.          }
{------------------------}
Procedure Final;

  Begin
    WriteSpanishLords;
    WriteLn('                    We hope you like it. See you soon.');
  End;

BEGIN
  If ParamCount=0 then Retardo:=0
                  else begin
                          Val (ParamStr(1),Retardo,Code);
                          If Code<>0 then Retardo:=10;
                          If Retardo>100 then retardo:=100;
                       end;

{ Get keyboard interrupt and put my keyboard interrupt.}
  GetIntVec($9,@Old);
  SetIntVec($9,@Teclado);
{ Play until ESC.}
  Continue:=True;
  NextPart:=False;
{ The first.}
  Principio;
  LoadFont  (1,'TRIP');
  LoadFont  (2,'LITT');

  McgaOn;
{ Main}
  Curvas;
  Delay (1000);
  McgaOff;
  Final;

{ Restore keyboard interrupt(9).}
  SetIntVec($9,@Old);
END.