{$A+}
UNIT Esferas2;
{
{ Put balls in differents sizes and colours.                              }
{                                                                         }
{ IMPORTANT : If you want to see the correct colors in your balls you must}
{             use Deluxe Paint palette, in MISC there is a procedure      }
{             called PutDpPalette.                                        }
{                                                                         }
{               Created by Spanish Lords Enero 1994.                      }
{                    Lords   Crom  &  Mitra.                              }
{                       Alcala de Henares                                 }
{                         M a d r i d                                     }
{                           (Spain)                                       }

INTERFACE

VAR
{ This is a buffer of video memory.}
  PANTALLA : Pointer;
  PSeg     : Word;
{ Esfera3 and Esfera4 color}
  ActColEsf: Byte;

{ The balls are                                                          }
{     ESFERA1 : 7x7 ball. It takes 249 diferent colors.                  }
{     ESFERA2 : 17x17 ball.  .                                           }
{     ESFERA3 : 11x11 ball. It goes under all except the background and  }
{               a color where it will be dark.                           }
{     ESFERA4 : 11x11 ball. The part of the ball which has something     }
{               under, will be dark.                                     }
{     ESFERA5 : 17x17 ball. It makes Zoom x2 of the background.          }
{     ESFERA6 : 31x31 ball. It makes Zoom x3 of the background.          }


{ This procedure takes all the VRAM ant put it into PANTALLA. }
PROCEDURE ACTPANTALLA;
{ This procedure transfer a part of PANTALLA to VRAM. }
PROCEDURE RESTRECTANGLE (X1,Y1,X2,Y2:Word);
PROCEDURE ESFERA1 (X,Y:Word;Color:Byte;On:Boolean);
PROCEDURE ESFERA2 (X,Y:Word;Color:Byte;On:Boolean);
{ This procedure is used to fill the color table for balls 3 and 4. }
PROCEDURE FILLCOLORS;
PROCEDURE ESFERA3 (X,Y:Word;Fondo,Gris,Oscuridad:Byte;On:Boolean);
PROCEDURE ESFERA4 (X,Y:Word;Fondo,Oscuridad:Byte;On:Boolean);
PROCEDURE ESFERA5 (X,Y:Word;On:Boolean);
PROCEDURE ESFERA6 (X,Y:Word;On:Boolean);

IMPLEMENTATION

  uses memory;

  Var
  { Array where I keep Esfera3 and Esfera4 colors.}
    ColEsf3   : Array [1..97] of Byte;


  {-------------------------------------}
  { Save in an array the entire screen. }
  {-------------------------------------}
  Procedure ActPantalla;Assembler;

    Asm
      push ds
      push si

      mov ax, PSeg
      mov es,ax
      xor di,di

      mov ax,$a000
      mov ds,ax
      xor si,si

      mov cx,32000

      rep movsw

      pop si
      pop ds
    end;

  {------------------------------------------}
  { Restore from Pantalla the specific part. }
  {------------------------------------------}
  Procedure RestRectangle (X1,Y1,X2,Y2:Word); assembler;
    Var
      Ancho : Word;
      Alto  : Byte;

    Asm
      mov  ax,X2
      sub  ax,X1
      mov  Ancho,ax
      mov  ax,Y2
      sub  ax,Y1
      mov  Alto,al
      push ds
      push si

       mov ax, PSeg
       mov ds,ax

       mov ax,$a000
       mov es,ax

       mov bx,x1
       mov dx,y1

       xchg dh,dl

       mov di,dx
       shr di,1
       shr di,1
       add di,dx
       add di,bx


       mov dl,Alto

     @Columna :
       mov cx,Ancho
     @VerticalLine :
       mov si,di
       rep movsb

       mov cx,320
       sub cx,Ancho
       add di,cx

       dec dl
       jnz @Columna

      pop si
      pop ds
    End;



  {---------------------------------------}
  { Put a three colors ball(degrade).     }
  { This is a 7x7 ball(PANIC).            }
  { Color can take valours between 0-249. }
  {                                       }
  {  The degradation is got :             }
  {   ColorMediano = Color+3              }
  {   ColorOscuro  = Color+6              }
  {---------------------------------------}
  Procedure Esfera1 (x,y:Word;Color:Byte;On:Boolean);

    Var
      ColCla : Byte; { The upper part of the ball.  }
      ColMed : Byte; { The medium part of the ball. }
      ColOsc : Byte; { The down part of the ball.   }

    Begin
      Dec (x);
      Dec (y,3);
      If On then
              begin
                ColCla := Color;
                ColMed := Color;
                Inc (ColMed,3);
                ColOsc := ColMed;
                Inc (ColOsc,3);

                ASM
                  mov ax,$a000
                  mov es,ax
                  mov bx,x
                  mov dx,y

                  xchg dh,dl
                  mov di,dx
                  shr di,1
                  shr di,1
                  add di,dx
                  add di,bx

                  mov al,ColCla
                  mov ah,al
                  stosw
                  stosb

                  add di,316
                  stosw
                  mov al,ColMed
                  stosb
                  mov al,ColCla
                  stosb
                  mov al,ColMed
                  stosb

                  add di,314
                  mov al,ColCla
                  mov ah,al
                  stosw
                  mov al,ColMed
                  mov ah,al
                  stosw
                  stosw
                  stosb

                  add di,313
                  mov al,ColCla
                  stosb
                  mov al,ColMed
                  mov ah,al
                  stosw
                  stosw
                  mov al,ColOsc
                  stosb
                  mov al,ColMed
                  mov ah,al
                  stosb

                  add di,313
                  stosw
                  stosw
                  mov al,ColOsc
                  mov ah,al
                  stosw
                  stosb

                  add di,314
                  stosb
                  mov al,ColMed
                  stosb
                  mov al,ColOsc
                  mov ah,al
                  stosw
                  stosb

                  add di,316
                  stosw
                  stosb
                end;
              end
            else
              ASM
                push ds
                push si

                mov ax, PSeg
                mov ds,ax

                mov ax,$a000
                mov es,ax

                mov bx,x
                mov dx,y

                xchg dh,dl

                mov di,dx
                shr di,1
                shr di,1
                add di,dx
                add di,bx

                mov si,di
                mov cx,3
                movsw
                movsb

                add di,316
                mov si,di
                mov cx,2
                rep movsw
                movsb

                add di,314
                mov si,di
                mov cx,3
                rep movsw
                movsb

                add di,313
                mov si,di
                mov cx,3
                rep movsw
                movsb

                add di,313
                mov si,di
                mov cx,3
                rep movsw
                movsb

                add di,314
                mov si,di
                mov cx,2
                rep movsw
                movsb

                add di,316
                mov si,di
                movsw
                movsb

                pop si
                pop ds
              end;

    end;

  {------------------------------------------------------------------------}
  { I put an eight colors ball (degrade).                                  }
  { This ball is 17x17.           .                                        }
  { When it`s cleaned, recovers the background in Pantalla.                }
  {                                                                        }
  { Recommended colors  :  0- Black.                                       }
  {                        1- Red.                                         }
  {                        3- Yellow.                                      }
  {                        5- Green.                                       }
  {                        6- Cyan.                                        }
  {                        8- Sea blue.                                    }
  {                        9- Purple.                                      }
  {                       10- Pink.                                        }
  {                       11- Light brown.                                 }
  {                       12- Dark brown.                                  }
  {------------------------------------------------------------------------}
  Procedure Esfera2 (x,y:Word;Color:Byte;On:Boolean);

    Var
      Col1 : Byte ;
      Col2 : Byte ;
      Col3 : Byte ;
      Col4 : Byte ;
      Col5 : Byte ;
      Col6 : Byte ;
      Col7 : Byte ;
      Col8 : Byte ;

      Cnt  : Byte ;
      Suma : Byte ;

    Begin
      Dec (x,2);
      Dec (y,8);
      If On then
        begin
          Suma:=0;
          For Cnt:=1 to Color do Inc (Suma,16);
          Col1 :=17+Suma;
          Col2 :=19+Suma;
          Col3 :=21+Suma;
          Col4 :=23+Suma;
          Col5 :=25+Suma;
          Col6 :=27+Suma;
          Col7 :=29+Suma;
          Col8 :=31+Suma;

          ASM
            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx
            mov al,Col4
            mov ah,al

            stosw
            stosb
            mov al,Col5
            stosb
            mov al,Col4
            stosb

            add di,313
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            mov ah,al
            stosw
            stosb
            mov al,Col5
            mov ah,al
            stosw

            add di,310
            mov al,Col4
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            stosb

            add di,308
            mov al,Col4
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            mov ah,al
            stosw
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            stosb

            add di,306
            mov al,Col5
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            mov ah,al
            stosw
            mov al,Col1
            stosb
            mov al,Col2
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col6
            stosb
            mov al,Col5
            stosb
            mov al,Col7
            stosb

            add di,305
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col3
            stosb
            mov al,Col2
            stosb
            mov al,Col1
            mov ah,al
            stosw
            stosb
            mov al,Col2
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            stosb
            mov al,Col4
            stosb
            mov al,Col6
            mov ah,al
            stosw

            add di,304
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            mov ah,al
            stosw
            mov al,Col1
            stosb
            mov al,Col2
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            stosb
            mov al,Col4
            stosb
            mov al,Col6
            mov ah,al
            stosw

            add di,303
            mov al,Col5
            stosb
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            mov ah,al
            stosw
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            stosb
            mov al,col4
            stosb
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            stosb

            add di,303
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col3
            stosb
            mov al,Col4
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            mov ah,al
            stosw

            add di,303
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            mov ah,al
            stosw
            stosb
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            stosb
            mov al,Col7
            mov ah,al
            stosw
            mov al,Col8
            stosb

            add di,303
            mov al,Col5
            stosb
            mov al,Col6
            stosb
            mov al,Col4
            stosb
            mov al,Col5
            stosb
            mov al,Col4
            mov ah,al
            stosw
            stosw
            stosb
            mov al,Col5
            stosb
            mov al,Col4
            stosb
            mov al,Col6
            stosb
            mov al,Col5
            stosb
            mov al,Col6
            mov ah,al
            stosw
            mov al,Col8
            stosb
            mov al,Col7
            stosb

            add di,304
            mov al,Col6
            stosb
            mov al,Col5
            mov ah,al
            stosw
            stosw
            stosb
            mov al,Col4
            stosb
            mov al,Col5
            mov ah,al
            stosw
            stosw
            mov al,Col6
            mov ah,al
            stosw
            mov al,Col7
            mov ah,al
            stosw

            add di,305
            mov al,Col7
            stosb
            mov al,Col5
            stosb
            mov al,Col6
            stosb
            mov al,Col5
            stosb
            mov al,Col6
            stosb
            mov al,Col5
            mov ah,al
            stosw
            stosb
            mov al,Col6
            stosb
            mov al,Col5
            stosb
            mov al,Col6
            mov ah,al
            stosw
            mov al,Col7
            mov ah,al
            stosw
            mov al,Col8
            stosb

            add di,306
            mov al,Col7
            stosb
            mov al,Col6
            mov ah,al
            stosw
            stosw
            stosw
            stosb
            mov al,Col7
            mov ah,al
            stosw
            stosw
            mov al,Col8
            stosb

            add di,308
            mov al,Col7
            stosb
            mov al,Col6
            stosb
            mov al,Col7
            stosb
            mov al,Col6
            stosb
            mov al,Col7
            stosb
            mov al,Col6
            stosb
            mov al,Col7
            mov ah,al
            stosw
            mov al,Col8
            stosb
            mov al,Col7
            stosb
            mov al,Col8
            stosb

            add di,310
            mov al,Col7
            mov ah,al
            stosw
            stosw
            stosw
            stosw
            mov al,Col8
            stosb

            add di,313
            mov al,Col7
            stosb
            mov al,Col8
            stosb
            mov al,Col7
            stosb
            mov al,Col8
            stosb
            mov al,Col7
            stosb
          end;
        end
            else
        begin
          ASM
            push ds
            push si

            mov ax, PSeg
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx



            mov si,di
            mov cx,2
            rep movsw
            movsb

            add di,313
            mov si,di
            mov cx,4
            rep movsw
            movsb

            add di,310
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,308
            mov si,di
            mov cx,6
            rep movsw
            movsb

            add di,306
            mov si,di
            mov cx,7
            rep movsw
            movsb

            add di,305
            mov si,di
            mov cx,7
            rep movsw
            movsb

            add di,304
            mov si,di
            mov cx,8
            rep movsw
            movsb

            add di,303
            mov si,di
            mov cx,8
            rep movsw
            movsb

            add di,303
            mov si,di
            mov cx,8
            rep movsw
            movsb

            add di,303
            mov si,di
            mov cx,8
            rep movsw
            movsb

            add di,303
            mov si,di
            mov cx,8
            rep movsw
            movsb

            add di,304
            mov si,di
            mov cx,7
            rep movsw
            movsb

            add di,305
            mov si,di
            mov cx,7
            rep movsw
            movsb

            add di,306
            mov si,di
            mov cx,6
            rep movsw
            movsb

            add di,308
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,310
            mov si,di
            mov cx,4
            rep movsw
            movsb

            add di,313
            mov si,di
            mov cx,2
            rep movsw
            movsb

            pop si
            pop ds
          end;
        end;
    end;

  {---------------------------------------------------}
  { I fill the color table used in Esfera3 y Esfera4. }
  {---------------------------------------------------}
  Procedure FillColors;

    Var
      Col1 : Byte ;
      Col2 : Byte ;
      Col3 : Byte ;
      Col4 : Byte ;
      Col5 : Byte ;
      Col6 : Byte ;

      Cnt  : Byte;

    Begin
      Col1 := 16;
      Col2 := 18;
      Col3 := 20;
      Col4 := 22;
      Col5 := 24;
      Col6 := 26;

      For Cnt:= 1 to ActColEsf do Inc(Col1,16);
      For Cnt:= 1 to ActColEsf do Inc(Col2,16);
      For Cnt:= 1 to ActColEsf do Inc(Col3,16);
      For Cnt:= 1 to ActColEsf do Inc(Col4,16);
      For Cnt:= 1 to ActColEsf do Inc(Col5,16);
      For Cnt:= 1 to ActColEsf do Inc(Col6,16);

      ColEsf3 [ 1] := Col3;
      ColEsf3 [ 2] := Col3;
      ColEsf3 [ 3] := Col3;
      ColEsf3 [ 4] := Col3;
      ColEsf3 [ 5] := Col4;
      ColEsf3 [ 6] := Col3;
      ColEsf3 [ 7] := Col2;
      ColEsf3 [ 8] := Col3;
      ColEsf3 [ 9] := Col2;
      ColEsf3 [10] := Col3;
      ColEsf3 [11] := Col3;
      ColEsf3 [12] := Col4;
      ColEsf3 [13] := Col3;
      ColEsf3 [14] := Col2;
      ColEsf3 [15] := Col2;
      ColEsf3 [16] := Col1;
      ColEsf3 [17] := Col2;
      ColEsf3 [18] := Col2;
      ColEsf3 [19] := Col3;
      ColEsf3 [20] := Col3;
      ColEsf3 [21] := Col4;
      ColEsf3 [22] := Col4;
      ColEsf3 [23] := Col3;
      ColEsf3 [24] := Col2;
      ColEsf3 [25] := Col1;
      ColEsf3 [26] := Col1;
      ColEsf3 [27] := Col1;
      ColEsf3 [28] := Col2;
      ColEsf3 [29] := Col3;
      ColEsf3 [30] := Col4;
      ColEsf3 [31] := Col4;
      ColEsf3 [32] := Col5;
      ColEsf3 [33] := Col4;
      ColEsf3 [34] := Col3;
      ColEsf3 [35] := Col2;
      ColEsf3 [36] := Col2;
      ColEsf3 [37] := Col1;
      ColEsf3 [38] := Col2;
      ColEsf3 [39] := Col2;
      ColEsf3 [40] := Col3;
      ColEsf3 [41] := Col3;
      ColEsf3 [42] := Col5;
      ColEsf3 [43] := Col5;
      ColEsf3 [44] := Col4;
      ColEsf3 [45] := Col3;
      ColEsf3 [46] := Col3;
      ColEsf3 [47] := Col2;
      ColEsf3 [48] := Col3;
      ColEsf3 [49] := Col2;
      ColEsf3 [50] := Col3;
      ColEsf3 [51] := Col3;
      ColEsf3 [52] := Col4;
      ColEsf3 [53] := Col5;
      ColEsf3 [54] := Col5;
      ColEsf3 [55] := Col4;
      ColEsf3 [56] := Col4;
      ColEsf3 [57] := Col3;
      ColEsf3 [58] := Col3;
      ColEsf3 [59] := Col3;
      ColEsf3 [60] := Col4;
      ColEsf3 [61] := Col3;
      ColEsf3 [62] := Col4;
      ColEsf3 [63] := Col4;
      ColEsf3 [64] := Col5;
      ColEsf3 [65] := Col5;
      ColEsf3 [66] := Col5;
      ColEsf3 [67] := Col4;
      ColEsf3 [68] := Col4;
      ColEsf3 [69] := Col4;
      ColEsf3 [70] := Col4;
      ColEsf3 [71] := Col4;
      ColEsf3 [72] := Col4;
      ColEsf3 [73] := Col4;
      ColEsf3 [74] := Col5;
      ColEsf3 [75] := Col5;
      ColEsf3 [76] := Col6;
      ColEsf3 [77] := Col5;
      ColEsf3 [78] := Col4;
      ColEsf3 [79] := Col5;
      ColEsf3 [80] := Col4;
      ColEsf3 [81] := Col5;
      ColEsf3 [82] := Col4;
      ColEsf3 [83] := Col5;
      ColEsf3 [84] := Col5;
      ColEsf3 [85] := Col6;
      ColEsf3 [86] := Col5;
      ColEsf3 [87] := Col5;
      ColEsf3 [88] := Col5;
      ColEsf3 [89] := Col5;
      ColEsf3 [90] := Col5;
      ColEsf3 [91] := Col5;
      ColEsf3 [92] := Col6;
      ColEsf3 [93] := Col6;
      ColEsf3 [94] := Col5;
      ColEsf3 [95] := Col6;
      ColEsf3 [96] := Col5;
      ColEsf3 [97] := Col6;
    end;

  {------------------------------------------------------}
  { I put a six colors ball (degraded).                  }
  {        This is a 11x11 ball.                         }
  { This ball goes under all in the screen.              }
  { It goes dark if there is the color Gris.             }
  {                                                      }
  { Colores recomendados:                                }
  {   0-It puts the white ball.                          }
  {   1-Light Red.                                       }
  {   3-Yellow.                                          }
  {   5-Green.                                           }
  {   6-Beatiful Cyan.                                   }
  {   8-Dark blue.                                       }
  {   9-Purple.                                          }
  {  10-Dark pink.                                       }
  {  11-Light brown.                                     }
  {  12-Dark brown.                                      }
  {                                                      }
  { Colors to work with them are :                       }
  {   Fondo     : If this is the color, I put the ball.  }
  {   Gris      : If this is the color, the ball is dark.}
  {   Oscuridad : Dark Increment (from 1 to 5).          }
  {------------------------------------------------------}

  Procedure Esfera3 (x,y:Word;Fondo,Gris,Oscuridad:Byte;On:Boolean);

    Begin
      Dec (x,2);
      Dec (y,5);
      If On then
          ASM
            push ds
            push si

            mov ax, Seg ColEsf3
            mov ds,ax
            mov si, Offset ColEsf3

            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov cl,5

          @Line1:

            lodsb

            mov ah,[es:di]     { AH Color de la pantalla. }

            cmp ah,Gris        { gris.}
            jne @Negro
            add al,Oscuridad   { If it`s gris I change the color and jump.}
            jmp @Fin

          @Negro :
            cmp ah,Fondo
            je @Fin            { If it`s not the background color don`t }
            mov al,ah          { change nothing.}

          @Fin :
            stosb              { Put the color. }

            dec cl
            jnz @Line1

            add di,314
            mov cl,7

          @Line2:
            lodsb

            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro2
            add al,Oscuridad
            jmp @Fin2

          @Negro2 :
            cmp ah,Fondo
            je @Fin2
            mov al,ah

          @Fin2 :
            stosb

            dec cl

            jnz @Line2

            add di,312
            mov cl,9

          @Line3:
            lodsb


            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro3
            add al,Oscuridad
            jmp @Fin3

          @Negro3 :
            cmp ah,Fondo
            je @Fin3
            mov al,ah

          @Fin3 :
            stosb

            dec cl
            jnz @Line3

            add di,310
            mov cl,11

          @Line4:
            lodsb

            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro4
            add al,Oscuridad
            jmp @Fin4

          @Negro4 :
            cmp ah,Fondo
            je @Fin4
            mov al,ah

          @Fin4 :
            stosb

            dec cl
            jnz @Line4


            mov ch,4
          @CuatroLineas :

            add di,309
            mov cl,11

          @Line5:
            lodsb

            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro5
            add al,Oscuridad
            jmp @Fin5

          @Negro5 :
            cmp ah,Fondo
            je @Fin5
            mov al,ah

          @Fin5 :
            stosb

            dec cl
            jnz @Line5

            dec ch
            jnz @CuatroLineas

            add di,310
            mov cl,9

          @Line6:
            lodsb


            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro6
            add al,Oscuridad
            jmp @Fin6

          @Negro6 :
            cmp ah,Fondo
            je @Fin6
            mov al,ah

          @Fin6 :
            stosb

            dec cl
            jnz @Line6

            add di,312
            mov cl,7

          @Line7:
            lodsb


            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro7
            add al,Oscuridad
            jmp @Fin7

          @Negro7 :
            cmp ah,Fondo
            je @Fin7
            mov al,ah

          @Fin7 :
            stosb

            dec cl
            jnz @Line7

            add di,314
            mov cl,5

          @Line8:
            lodsb


            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro8
            inc al
            add al,Oscuridad
            jmp @Fin8

          @Negro8 :
            cmp ah,Fondo
            je @Fin8
            mov al,ah

          @Fin8 :
            stosb

            dec cl
            jnz @Line8

            pop si
            pop ds


        end
            else
          ASM
            push ds
            push si

            mov ax, PSeg
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx


            mov si,di
            mov cx,2
            rep movsw
            movsb

            add di,314
            mov si,di
            mov cx,3
            rep movsw
            movsb

            add di,312
            mov si,di
            mov cx,4
            rep movsw
            movsb

            add di,310
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,309
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,309
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,309
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,309
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,310
            mov si,di
            mov cx,4
            rep movsw
            movsb

            add di,312
            mov si,di
            mov cx,3
            rep movsw
            movsb

            add di,314
            mov si,di
            mov cx,2
            rep movsw
            movsb

            pop si
            pop ds
          end;
    end;

  {------------------------------------------------------}
  { I put a six colors ball(degraded).                   }
  {        This is a 11x11 ball.                         }
  { This ball goes on all the screen. It goes dark if    }
  { the color that it`s under, it is not the background. }
  {                                                      }
  {                                                      }
  { Recommend colors :                                   }
  {   0-White.                                           }
  {   1-Light red.                                       }
  {   3-Yellow.                                          }
  {   5-Green.                                           }
  {   6-Beatiful Cyan.                                   }
  {   8-Dark blue.                                       }
  {   9-Purple.                                          }
  {  10-Dark pink.                                       }
  {  11-Light brown.                                     }
  {  12-Drak brown.                                      }
  {                                                      }
  {                                                      }
  { Colors to work with them are :     .                 }
  {   Fondo     : Put the ball if this is the background.}
  {   Oscuridad : Drak increment (from 1 to 5).          }
  {------------------------------------------------------}

  Procedure Esfera4 (x,y:Word;Fondo,Oscuridad:Byte;On:Boolean);

    Begin
      Dec (x,2);
      Dec (y,5);
      If On then
          ASM
            push ds
            push si

            mov ax, Seg ColEsf3
            mov ds,ax
            mov si, Offset ColEsf3

            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov cl,5

          @Line1:

            lodsb

            mov ah,[es:di]     { AH Color de la pantalla. }

            cmp al,ah          { Compruebo si el color de fondo es }
            je @Fin            { el mismo que voy a poner.         }

            cmp ah,Fondo
            je @Fin            { Si no es el color de fondo oscurezco }
            add al,Oscuridad   { el punto que voy a poner.            }

          @Fin :
            stosb          { Pongo el color debido.}

            dec cl
            jnz @Line1

            add di,314
            mov cl,7

          @Line2:
            lodsb

            mov ah,[es:di]

            cmp al,ah
            je @Fin2

            cmp ah,Fondo
            je @Fin2
            add al,Oscuridad

          @Fin2 :
            stosb

            dec cl

            jnz @Line2

            add di,312
            mov cl,9

          @Line3:
            lodsb


            mov ah,[es:di]
            cmp al,ah
            je @Fin3

            cmp ah,Fondo
            je @Fin3
            add al,Oscuridad

          @Fin3 :
            stosb

            dec cl
            jnz @Line3

            add di,310
            mov cl,11

          @Line4:
            lodsb

            mov ah,[es:di]
            cmp al,ah
            je @Fin4

            cmp ah,Fondo
            je @Fin4
            add al,Oscuridad

          @Fin4 :
            stosb

            dec cl
            jnz @Line4


            mov ch,4
          @CuatroLineas :

            add di,309
            mov cl,11

          @Line5:
            lodsb

            mov ah,[es:di]
            cmp al,ah
            je @Fin5

            cmp ah,Fondo
            je @Fin5
            add al,Oscuridad

          @Fin5 :
            stosb

            dec cl
            jnz @Line5

            dec ch
            jnz @CuatroLineas

            add di,310
            mov cl,9

          @Line6:
            lodsb

            mov ah,[es:di]
            cmp al,ah
            je @Fin6

            cmp ah,Fondo
            je @Fin6
            add al,Oscuridad

          @Fin6 :
            stosb

            dec cl
            jnz @Line6

            add di,312
            mov cl,7

          @Line7:
            lodsb


            mov ah,[es:di]
            cmp al,ah
            je @Fin7

            cmp ah,Fondo
            je @Fin7
            add al,Oscuridad

          @Fin7 :
            stosb

            dec cl
            jnz @Line7

            add di,314
            mov cl,5

          @Line8:
            lodsb


            mov ah,[es:di]
            cmp al,ah
            je @Fin8

            cmp ah,Fondo
            je @Fin8
            add al,Oscuridad

          @Fin8 :
            stosb

            dec cl
            jnz @Line8

            pop si
            pop ds


        end
            else
        begin
          ASM
            push ds
            push si

            mov ax, PSeg
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx


            mov si,di
            mov cx,2
            rep movsw
            movsb

            add di,314
            mov si,di
            mov cx,3
            rep movsw
            movsb

            add di,312
            mov si,di
            mov cx,4
            rep movsw
            movsb

            add di,310
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,309
            mov cx,5
            rep movsw
            movsb

            add di,309
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,309
            mov si,di
            mov cx,5
            rep movsw
            movsb

            add di,309
            mov cx,5
            rep movsw
            movsb

            add di,310
            mov cx,4
            rep movsw
            movsb

            add di,312
            mov cx,3
            rep movsw
            movsb

            add di,314
            mov cx,2
            rep movsw
            movsb

            pop si
            pop ds
          end;
        end;
    end;

  {------------------------------------------------------}
  { I put a 17x17 ball.                                  }
  {                                                      }
  { This ball goes on all in the screen.                 }
  { It makes a Zoom x2.                                  }
  {                                                      }
  {------------------------------------------------------}

  Procedure Esfera5 (x,y:Word;On:Boolean);

    Const
      Gris   : Byte = 18; {Light gray. }

    Var
    { Here I keep the colors that are under the ball. }
      BajoB1 : Byte;
      BajoB2 : Byte;
      BajoB3 : Byte;
      BajoB4 : Byte;
      BajoB5 : Byte;
      BajoB6 : Byte;
      BajoB7 : Byte;
      BajoB8 : Byte;
    Begin
      Dec (x,2);
      Dec (y,8);
      If On then
          ASM
            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov al,Gris
            mov ah,al
            stosw
            stosw
            stosb

            add di,313
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB4,al
            stosw
            mov al,Gris
            stosb

            add di,310
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            mov al,BajoB2
            mov ah,al
            stosw
            mov al,BajoB3
            mov ah,al
            stosw
            mov al,BajoB4
            mov ah,al
            stosw
            mov al,Gris
            mov ah,al
            stosw

            add di,308
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            mov al,Gris
            stosb

            add di,306
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            mov al,BajoB2
            mov ah,al
            stosw
            mov al,BajoB3
            mov ah,al
            stosw
            mov al,BajoB4
            mov ah,al
            stosw
            mov al,BajoB5
            mov ah,al
            stosw
            mov al,BajoB6
            mov ah,al
            stosw
            mov al,Gris
            mov ah,al
            stosw

            add di,305
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            mov al,Gris
            stosb

            add di,304
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            mov al,BajoB2
            mov ah,al
            stosw
            mov al,BajoB3
            mov ah,al
            stosw
            mov al,BajoB4
            mov ah,al
            stosw
            mov al,BajoB5
            mov ah,al
            stosw
            mov al,BajoB6
            mov ah,al
            stosw
            mov al,BajoB7
            mov ah,al
            stosw
            mov al,Gris
            mov ah,al
            stosw

            add di,303
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB8,al
            mov ah,al
            stosw
            mov al,Gris
            stosb

            add di,303
            mov al,BajoB1
            mov ah,al
            stosw
            mov al,BajoB2
            mov ah,al
            stosw
            mov al,BajoB3
            mov ah,al
            stosw
            mov al,BajoB4
            mov ah,al
            stosw
            mov al,BajoB5
            mov ah,al
            stosw
            mov al,BajoB6
            mov ah,al
            stosw
            mov al,BajoB7
            mov ah,al
            stosw
            mov al,BajoB8
            mov ah,al
            stosw
            mov al,Gris
            stosb

            add di,303
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB8,al
            mov ah,al
            stosw
            mov al,Gris
            stosb

            add di,303
            mov al,BajoB1
            mov ah,al
            stosw
            mov al,BajoB2
            mov ah,al
            stosw
            mov al,BajoB3
            mov ah,al
            stosw
            mov al,BajoB4
            mov ah,al
            stosw
            mov al,BajoB5
            mov ah,al
            stosw
            mov al,BajoB6
            mov ah,al
            stosw
            mov al,BajoB7
            mov ah,al
            stosw
            mov al,BajoB8
            mov ah,al
            stosw
            mov al,Gris
            stosb

            add di,304
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            mov al,Gris
            stosb

            add di,305
            mov al,BajoB1
            mov ah,al
            stosw
            mov al,BajoB2
            mov ah,al
            stosw
            mov al,BajoB3
            mov ah,al
            stosw
            mov al,BajoB4
            mov ah,al
            stosw
            mov al,BajoB5
            mov ah,al
            stosw
            mov al,BajoB6
            mov ah,al
            stosw
            mov al,BajoB7
            mov ah,al
            stosw
            mov al,Gris
            stosb


            add di,306
            mov al,Gris
            stosb
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            mov al,Gris
            mov ah,al
            stosw

            add di,308
            mov al,BajoB1
            mov ah,al
            stosw
            mov al,BajoB2
            mov ah,al
            stosw
            mov al,BajoB3
            mov ah,al
            stosw
            mov al,BajoB4
            mov ah,al
            stosw
            mov al,BajoB5
            mov ah,al
            stosw
            mov al,Gris
            stosb

            add di,310
            mov al,Gris
            mov ah,al
            mov cx,4
            rep stosw
            stosb

            add di,313
            mov ah,al
            mov cx,2
            rep stosw
            stosb
          end
            else
          ASM
            push ds
            push si

            mov ax, PSeg
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov si,di
            mov cl,2
            rep movsw
            movsb

            add di,313
            mov si,di
            mov cl,4
            rep movsw
            movsb

            add di,310
            mov si,di
            mov cl,5
            rep movsw
            movsb

            add di,308
            mov si,di
            mov cl,6
            rep movsw
            movsb

            add di,306
            mov si,di
            mov cl,7
            rep movsw
            movsb

            add di,305
            mov si,di
            mov cl,7
            rep movsw
            movsb

            add di,304
            mov si,di
            mov cl,8
            rep movsw
            movsb

            add di,303
            mov si,di
            mov cl,8
            rep movsw
            movsb

            add di,303
            mov si,di
            mov cl,8
            rep movsw
            movsb

            add di,303
            mov si,di
            mov cl,8
            rep movsw
            movsb

            add di,303
            mov si,di
            mov cl,8
            rep movsw
            movsb

            add di,304
            mov si,di
            mov cl,7
            rep movsw
            movsb

            add di,305
            mov si,di
            mov cl,7
            rep movsw
            movsb

            add di,306
            mov si,di
            mov cl,6
            rep movsw
            movsb

            add di,308
            mov si,di
            mov cl,5
            rep movsw
            movsb

            add di,310
            mov si,di
            mov cl,4
            rep movsw
            movsb

            add di,313
            mov si,di
            mov cl,2
            rep movsw
            movsb

            pop si
            pop ds
          end;
    end;

  {------------------------------------------------------}
  { It puts a 31x31 ball.                                }
  {                                                      }
  { This ball goes on all in the screen.                 }
  { It makes a Zoom x3.                                  }
  {                                                      }
  {------------------------------------------------------}

  Procedure Esfera6 (x,y:Word;On:Boolean);

    Const
      Gris   : Byte = 18; {Light Gray.}

    Var
    { Here I keep the colors that are under the ball. }
      BajoB1 : Byte;
      BajoB2 : Byte;
      BajoB3 : Byte;
      BajoB4 : Byte;
      BajoB5 : Byte;
      BajoB6 : Byte;
      BajoB7 : Byte;
      BajoB8 : Byte;
      BajoB9 : Byte;
      BajoB10: Byte;

    Begin
      Dec (x,4);
      Dec (y,15);
      If On then
          ASM
            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov al,Gris
            mov ah,al
            mov cx,3
            rep stosw
            stosb

            add di,310
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,306
            mov ah,al
            stosw
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw
            stosb

            add di,302
            mov ah,al
            stosw
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            mov cx,2
            rep stosw

            add di,300
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            stosb

            add di,298
            mov al,Gris
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,296
            mov al,Gris
            mov ah,al
            stosw
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw

            add di,294
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            stosb
            mov BajoB8,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB9,al
            mov ah,al
            stosw
            stosb

            add di,293
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb

            add di,292
            mov al,Gris
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,291
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            stosb
            mov BajoB8,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB9,al
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw

            add di,291
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw

            add di,290
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw
            stosb

            add di,289
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            stosb
            mov BajoB8,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB9,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB10,al
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb
            mov al,BajoB10
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb
            mov al,BajoB10
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            stosb
            mov BajoB8,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB9,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB10,al
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb
            mov al,BajoB10
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb
            mov al,BajoB10
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,290
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            stosb
            mov BajoB8,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB9,al
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw

            add di,291
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw

            add di,291
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,BajoB9
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw

            add di,292
            mov al,Gris
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB7,al
            mov ah,al
            stosw
            stosb
            mov BajoB8,al
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,293
            mov ah,al
            stosw
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,294
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,BajoB7
            mov ah,al
            stosw
            stosb
            mov al,BajoB8
            mov ah,al
            stosw
            stosb

            add di,296
            mov al,Gris
            mov ah,al
            stosw
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB3,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB4,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB5,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB6,al
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw
            stosb

            add di,298
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            stosw

            add di,300
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,BajoB3
            mov ah,al
            stosw
            stosb
            mov al,BajoB4
            mov ah,al
            stosw
            stosb
            mov al,BajoB5
            mov ah,al
            stosw
            stosb
            mov al,BajoB6
            mov ah,al
            stosw
            stosb
            mov al,Gris
            stosb

            add di,302
            mov ah,al
            mov cx,2
            rep stosw
            stosb
            mov al,[es:di]
            mov BajoB1,al
            mov ah,al
            stosw
            stosb
            mov al,[es:di]
            mov BajoB2,al
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            mov cx,3
            rep stosw

            add di,306
            mov ah,al
            stosw
            stosb
            mov al,BajoB1
            mov ah,al
            stosw
            stosb
            mov al,BajoB2
            mov ah,al
            stosw
            stosb
            mov al,Gris
            mov ah,al
            mov cx,2
            rep stosw

            add di,310
            mov cx,3
            rep stosw
            stosb
        end
            else
        begin
          ASM
            push ds
            push si

            mov ax, PSeg
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov si,di
            mov cx,3
            rep movsw
            movsb

            add di,310
            mov si,di
            mov cx,6
            rep movsw
            movsb

            add di,306
            mov si,di
            mov cx,8
            rep movsw
            movsb

            add di,302
            mov si,di
            mov cx,9
            rep movsw
            movsb

            add di,300
            mov si,di
            mov cx,10
            rep movsw
            movsb

            add di,298
            mov si,di
            mov cx,11
            rep movsw
            movsb

            add di,296
            mov si,di
            mov cx,12
            rep movsw
            movsb

            add di,294
            mov si,di
            mov cx,13
            rep movsw
            movsb

            add di,293
            mov si,di
            mov cx,13
            rep movsw
            movsb

            add di,292
            mov si,di
            mov cx,14
            rep movsw
            movsb

            add di,291
            mov si,di
            mov cx,14
            rep movsw
            movsb

            add di,291
            mov si,di
            mov cx,14
            rep movsw
            movsb

            add di,290
            mov si,di
            mov cx,15
            rep movsw
            movsb

            mov dx,6
          @SeisLineas:

            add di,289
            mov si,di
            mov cx,15
            rep movsw
            movsb

            dec dx
            jnz @SeisLineas

            add di,290
            mov si,di
            mov cx,14
            rep movsw
            movsb

            add di,291
            mov si,di
            mov cx,14
            rep movsw
            movsb

            add di,291
            mov si,di
            mov cx,14
            rep movsw
            movsb

            add di,292
            mov si,di
            mov cx,13
            rep movsw
            movsb

            add di,293
            mov si,di
            mov cx,13
            rep movsw
            movsb

            add di,294
            mov si,di
            mov cx,12
            rep movsw
            movsb

            add di,296
            mov si,di
            mov cx,11
            rep movsw
            movsb

            add di,298
            mov si,di
            mov cx,10
            rep movsw
            movsb

            add di,300
            mov si,di
            mov cx,9
            rep movsw
            movsb

            add di,302
            mov si,di
            mov cx,8
            rep movsw
            movsb

            add di,306
            mov si,di
            mov cx,6
            rep movsw
            movsb

            add di,310
            mov si,di
            mov cx,3
            rep movsw
            movsb

            pop si
            pop ds
          end;
        end;
    end;

BEGIN
  Pantalla:=MemAllocSeg(64500);
  PSeg := Seg (Pantalla^);
END.