{ Voy arreglando por la segunda parte de Esferas 2. }
{$A+}
UNIT Esferas;
{
{ Put balls in differents sizes and colours.                              }
{                                                                         }
{ IMPORTANT : If you want to see the correct colors in your balls you must}
{             use Deluxe Paint palette, in MISC there is a procedure      }
{             called PutDpPalette.                                        }
{                                                                         }
{               Created by Spanish Lords Enero 1994.                      }
{                    Lords   Crom  &  Mitra.                              }
{                       Alcala de Henares                                 }
{                         M a d r i d                                     }
{                           (Spain)                                       }

INTERFACE

VAR
{ This is a buffer of video memory.}
  PANTALLA : Pointer;
  PSeg     : Word;
  POff     : Word;
{ Esfera3 and Esfera4 color}
  ActColEsf: Byte;

{ Las ESFERAS son:                                                       }
{     ESFERA1 : Bola de 7x7 toma 249 colores distintos.                  }
{     ESFERA2 : Bola de 17x17.                                           }
{     ESFERA3 : Bola de 11x11. Pasa por debajo de todo excepto del fondo }
{               y un color dado por ese color oscurece el nivel dado.    }
{     ESFERA4 : Bola de 11x11. se oscurece el trozo de bola donde haya   }
{               algo debajo.                                             }
{     ESFERA5 : Bola de 17x17. Hace zoom x2 de lo que haya debajo.       }
{     ESFERA6 : Bola de 31x31. Hace zoom x3 de lo que haya debajo.       }


PROCEDURE ACTPANTALLA;
PROCEDURE RESTRECTANGLE (X1,Y1,X2,Y2:Word);
PROCEDURE ESFERA1 (X,Y:Word;Color:Byte;On:Boolean);
PROCEDURE ESFERA2 (X,Y:Word;Color:Byte;On:Boolean);
PROCEDURE FILLCOLORS;
PROCEDURE ESFERA3 (X,Y:Word;Fondo,Gris,Oscuridad:Byte;On:Boolean);
PROCEDURE ESFERA4 (X,Y:Word;Fondo,Oscuridad:Byte;On:Boolean);
PROCEDURE ESFERA5 (X,Y:Word;On:Boolean);
PROCEDURE ESFERA6 (X,Y:Word;On:Boolean);

IMPLEMENTATION

  Var
  { Matriz donde guardo los colores de Esfera3 y Esfera4.}
    ColEsf3   : Array [1..97] of Byte;


  {-------------------------------------------}
  { Guardo en una matriz la pantalla completa.}
  {-------------------------------------------}
  Procedure ActPantalla;Assembler;

    Asm
      push ds
      push si

      mov ax, PSeg
      mov es,ax
      mov di, POff

      mov ax,$a000
      mov ds,ax
      xor si,si

      mov cx,32000

      rep movsw

      pop si
      pop ds
    end;

  {---------------------------------------------}
  { Restaura de Pantalla el trozo especificado. }
  {---------------------------------------------}
  Procedure RestRectangle (X1,Y1,X2,Y2:Word); assembler;
    Var
      Ancho : Word;
      Alto  : Byte;

    Asm
      mov  ax,X2
      sub  ax,X1
      mov  Ancho,ax
      mov  ax,Y2
      sub  ax,Y1
      mov  Alto,al
      push ds
      push si

       mov ax, PSeg
       mov bx, POff
       push bx
       mov ds,ax

       mov ax,$a000
       mov es,ax

       mov bx,x1
       mov dx,y1

       xchg dh,dl

       mov di,dx
       shr di,1
       shr di,1
       add di,dx
       add di,bx

       pop bx

       mov dl,Alto

     @Columna :
       mov cx,Ancho
     @VerticalLine :
       mov si,di
       add si,bx
       movsb
       dec cx
       jnz @VerticalLine

       mov cx,320
       sub cx,Ancho
       add di,cx

       dec dl
       jnz @Columna

      pop si
      pop ds
    End;



  {--------------------------------------------------}
  { Pongo una esfera de tres colores (degradada).    }
  { Esta esfera es de 7x7 pixel (PANIC)              }
  { La entrada color puede tomar valores 0-249.      }
  {                                                  }
  {  El degradado se consigue:                       }
  {   ColorMediano = Color+3                         }
  {   ColorOscuro  = Color+6                         }
  {--------------------------------------------------}
  Procedure Esfera1 (x,y:Word;Color:Byte;On:Boolean);

    Var
      ColCla : Byte;
      ColMed : Byte;
      ColOsc : Byte;

    Begin
      Dec (x);
      Dec (y,3);
      If On then
              begin
                ColCla := Color;
                ColMed := Color;
                Inc (ColMed,3);
                ColOsc := ColMed;
                Inc (ColOsc,3);

                ASM
                  mov ax,$a000
                  mov es,ax
                  mov bx,x
                  mov dx,y

                  xchg dh,dl
                  mov di,dx
                  shr di,1
                  shr di,1
                  add di,dx
                  add di,bx

                  mov al,ColCla
                  mov ah,al
                  stosw
                  stosb

                  add di,316
                  stosw
                  mov al,ColMed
                  stosb
                  mov al,ColCla
                  stosb
                  mov al,ColMed
                  stosb

                  add di,314
                  mov al,ColCla
                  mov ah,al
                  stosw
                  mov al,ColMed
                  mov ah,al
                  stosw
                  stosw
                  stosb

                  add di,313
                  mov al,ColCla
                  stosb
                  mov al,ColMed
                  mov ah,al
                  stosw
                  stosw
                  mov al,ColOsc
                  stosb
                  mov al,ColMed
                  mov ah,al
                  stosb

                  add di,313
                  stosw
                  stosw
                  mov al,ColOsc
                  mov ah,al
                  stosw
                  stosb

                  add di,314
                  stosb
                  mov al,ColMed
                  stosb
                  mov al,ColOsc
                  mov ah,al
                  stosw
                  stosb

                  add di,316
                  stosw
                  stosb
                end;
              end
            else
              ASM
                push ds
                push si

                mov ax, PSeg
                mov bx, POff
                push bx
                mov ds,ax

                mov ax,$a000
                mov es,ax

                mov bx,x
                mov dx,y

                xchg dh,dl

                mov di,dx
                shr di,1
                shr di,1
                add di,dx
                add di,bx

                pop bx

                mov cl,3
              @Salto1:
                mov si,di
                add si,bx
                movsb
                dec cl
                jnz @Salto1

                add di,316
                mov cl,5
              @Salto2:
                mov si,di
                add si,bx
                movsb
                dec cl
                jnz @Salto2

                add di,314
                mov cl,7
              @Salto3:
                mov si,di
                add si,bx
                movsb
                dec cl
                jnz @Salto3

                add di,313
                mov cl,7
              @Salto4:
                mov si,di
                add si,bx
                movsb
                dec cl
                jnz @Salto4

                add di,313
                mov cl,7
              @Salto5:
                mov si,di
                add si,bx
                movsb
                dec cl
                jnz @Salto5

                add di,314
                mov cl,5
              @Salto6:
                mov si,di
                add si,bx
                movsb
                dec cl
                jnz @Salto6

                add di,316
                mov cl,3
              @Salto7:
                mov si,di
                add si,bx
                movsb
                dec cl
                jnz @Salto7

                pop si
                pop ds
              end;

    end;

  {------------------------------------------------------------------------}
  { Pongo una esfera de ocho colores (degradada).                          }
  { Esta esfera es de 17x17 pixels.                                        }
  { Cuando se borra recupera el fondo que debe estar en la matriz pantalla.}
  {                                                                        }
  { Colores recomendados:  0- Negro.                                       }
  {                        1- Rojo.                                        }
  {                        3- Amarillo.                                    }
  {                        5- Verde.                                       }
  {                        6- Cyan.                                        }
  {                        8- Azul Marino.                                 }
  {                        9- Morado.                                      }
  {                       10- Rosa.                                        }
  {                       11- Marron claro.                                }
  {                       12- Marron oscuro.                               }
  {------------------------------------------------------------------------}
  Procedure Esfera2 (x,y:Word;Color:Byte;On:Boolean);

    Var
      Col1 : Byte ;
      Col2 : Byte ;
      Col3 : Byte ;
      Col4 : Byte ;
      Col5 : Byte ;
      Col6 : Byte ;
      Col7 : Byte ;
      Col8 : Byte ;

      Cnt  : Byte ;
      Suma : Byte ;

    Begin
      Dec (x,2);
      Dec (y,8);
      If On then
        begin
          Suma:=0;
          For Cnt:=1 to Color do Inc (Suma,16);
          Col1 :=17+Suma;
          Col2 :=19+Suma;
          Col3 :=21+Suma;
          Col4 :=23+Suma;
          Col5 :=25+Suma;
          Col6 :=27+Suma;
          Col7 :=29+Suma;
          Col8 :=31+Suma;

          ASM
            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx
            mov al,Col4
            mov ah,al

            stosw
            stosb
            mov al,Col5
            stosb
            mov al,Col4
            stosb

            add di,313
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            mov ah,al
            stosw
            stosb
            mov al,Col5
            mov ah,al
            stosw

            add di,310
            mov al,Col4
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            stosb

            add di,308
            mov al,Col4
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            mov ah,al
            stosw
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            stosb

            add di,306
            mov al,Col5
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            mov ah,al
            stosw
            mov al,Col1
            stosb
            mov al,Col2
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col6
            stosb
            mov al,Col5
            stosb
            mov al,Col7
            stosb

            add di,305
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col3
            stosb
            mov al,Col2
            stosb
            mov al,Col1
            mov ah,al
            stosw
            stosb
            mov al,Col2
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            stosb
            mov al,Col4
            stosb
            mov al,Col6
            mov ah,al
            stosw

            add di,304
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            mov ah,al
            stosw
            mov al,Col1
            stosb
            mov al,Col2
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            stosb
            mov al,Col4
            stosb
            mov al,Col6
            mov ah,al
            stosw

            add di,303
            mov al,Col5
            stosb
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            mov ah,al
            stosw
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            stosb
            mov al,col4
            stosb
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            stosb

            add di,303
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col3
            stosb
            mov al,Col4
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col2
            stosb
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            mov ah,al
            stosw

            add di,303
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col4
            mov ah,al
            stosw
            mov al,Col3
            mov ah,al
            stosw
            mov al,Col4
            stosb
            mov al,Col3
            stosb
            mov al,Col4
            mov ah,al
            stosw
            stosb
            mov al,Col5
            mov ah,al
            stosw
            mov al,Col6
            stosb
            mov al,Col7
            mov ah,al
            stosw
            mov al,Col8
            stosb

            add di,303
            mov al,Col5
            stosb
            mov al,Col6
            stosb
            mov al,Col4
            stosb
            mov al,Col5
            stosb
            mov al,Col4
            mov ah,al
            stosw
            stosw
            stosb
            mov al,Col5
            stosb
            mov al,Col4
            stosb
            mov al,Col6
            stosb
            mov al,Col5
            stosb
            mov al,Col6
            mov ah,al
            stosw
            mov al,Col8
            stosb
            mov al,Col7
            stosb

            add di,304
            mov al,Col6
            stosb
            mov al,Col5
            mov ah,al
            stosw
            stosw
            stosb
            mov al,Col4
            stosb
            mov al,Col5
            mov ah,al
            stosw
            stosw
            mov al,Col6
            mov ah,al
            stosw
            mov al,Col7
            mov ah,al
            stosw

            add di,305
            mov al,Col7
            stosb
            mov al,Col5
            stosb
            mov al,Col6
            stosb
            mov al,Col5
            stosb
            mov al,Col6
            stosb
            mov al,Col5
            mov ah,al
            stosw
            stosb
            mov al,Col6
            stosb
            mov al,Col5
            stosb
            mov al,Col6
            mov ah,al
            stosw
            mov al,Col7
            mov ah,al
            stosw
            mov al,Col8
            stosb

            add di,306
            mov al,Col7
            stosb
            mov al,Col6
            mov ah,al
            stosw
            stosw
            stosw
            stosb
            mov al,Col7
            mov ah,al
            stosw
            stosw
            mov al,Col8
            stosb

            add di,308
            mov al,Col7
            stosb
            mov al,Col6
            stosb
            mov al,Col7
            stosb
            mov al,Col6
            stosb
            mov al,Col7
            stosb
            mov al,Col6
            stosb
            mov al,Col7
            mov ah,al
            stosw
            mov al,Col8
            stosb
            mov al,Col7
            stosb
            mov al,Col8
            stosb

            add di,310
            mov al,Col7
            mov ah,al
            stosw
            stosw
            stosw
            stosw
            mov al,Col8
            stosb

            add di,313
            mov al,Col7
            stosb
            mov al,Col8
            stosb
            mov al,Col7
            stosb
            mov al,Col8
            stosb
            mov al,Col7
            stosb
          end;
        end
            else
        begin
          ASM
            push ds
            push si

            mov ax, PSeg
            mov bx, POff
            push bx
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            pop bx

            mov cl,5
          @Salto1:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto1

            add di,313
            mov cl,9
          @Salto2:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto2

            add di,310
            mov cl,11
          @Salto3:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto3

            add di,308
            mov cl,13
          @Salto4:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto4

            add di,306
            mov cl,15
          @Salto5:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto5

            add di,305
            mov cl,15
          @Salto6:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto6

            add di,304
            mov cl,17
          @Salto7:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto7

            add di,303
            mov cl,17
          @Salto8:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto8

            add di,303
            mov cl,17
          @Salto9:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto9

            add di,303
            mov cl,17
          @Salto10:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto10

            add di,303
            mov cl,17
          @Salto11:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto11

            add di,304
            mov cl,15
          @Salto12:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto12

            add di,305
            mov cl,15
          @Salto13:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto13

            add di,306
            mov cl,13
          @Salto14:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto14

            add di,308
            mov cl,11
          @Salto15:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto15

            add di,310
            mov cl,9
          @Salto16:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto16

            add di,313
            mov cl,5
          @Salto17:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto17

            pop si
            pop ds
          end;
        end;
    end;

  {---------------------------------------------------------}
  { Relleno la tabla de colores que usan Esfera3 y Esfera4. }
  {---------------------------------------------------------}
  Procedure FillColors;

    Var
      Col1 : Byte ;
      Col2 : Byte ;
      Col3 : Byte ;
      Col4 : Byte ;
      Col5 : Byte ;
      Col6 : Byte ;

      Cnt  : Byte;

    Begin
      Col1 := 16;
      Col2 := 18;
      Col3 := 20;
      Col4 := 22;
      Col5 := 24;
      Col6 := 26;

      For Cnt:= 1 to ActColEsf do Inc(Col1,16);
      For Cnt:= 1 to ActColEsf do Inc(Col2,16);
      For Cnt:= 1 to ActColEsf do Inc(Col3,16);
      For Cnt:= 1 to ActColEsf do Inc(Col4,16);
      For Cnt:= 1 to ActColEsf do Inc(Col5,16);
      For Cnt:= 1 to ActColEsf do Inc(Col6,16);

      ColEsf3 [ 1] := Col3;
      ColEsf3 [ 2] := Col3;
      ColEsf3 [ 3] := Col3;
      ColEsf3 [ 4] := Col3;
      ColEsf3 [ 5] := Col4;
      ColEsf3 [ 6] := Col3;
      ColEsf3 [ 7] := Col2;
      ColEsf3 [ 8] := Col3;
      ColEsf3 [ 9] := Col2;
      ColEsf3 [10] := Col3;
      ColEsf3 [11] := Col3;
      ColEsf3 [12] := Col4;
      ColEsf3 [13] := Col3;
      ColEsf3 [14] := Col2;
      ColEsf3 [15] := Col2;
      ColEsf3 [16] := Col1;
      ColEsf3 [17] := Col2;
      ColEsf3 [18] := Col2;
      ColEsf3 [19] := Col3;
      ColEsf3 [20] := Col3;
      ColEsf3 [21] := Col4;
      ColEsf3 [22] := Col4;
      ColEsf3 [23] := Col3;
      ColEsf3 [24] := Col2;
      ColEsf3 [25] := Col1;
      ColEsf3 [26] := Col1;
      ColEsf3 [27] := Col1;
      ColEsf3 [28] := Col2;
      ColEsf3 [29] := Col3;
      ColEsf3 [30] := Col4;
      ColEsf3 [31] := Col4;
      ColEsf3 [32] := Col5;
      ColEsf3 [33] := Col4;
      ColEsf3 [34] := Col3;
      ColEsf3 [35] := Col2;
      ColEsf3 [36] := Col2;
      ColEsf3 [37] := Col1;
      ColEsf3 [38] := Col2;
      ColEsf3 [39] := Col2;
      ColEsf3 [40] := Col3;
      ColEsf3 [41] := Col3;
      ColEsf3 [42] := Col5;
      ColEsf3 [43] := Col5;
      ColEsf3 [44] := Col4;
      ColEsf3 [45] := Col3;
      ColEsf3 [46] := Col3;
      ColEsf3 [47] := Col2;
      ColEsf3 [48] := Col3;
      ColEsf3 [49] := Col2;
      ColEsf3 [50] := Col3;
      ColEsf3 [51] := Col3;
      ColEsf3 [52] := Col4;
      ColEsf3 [53] := Col5;
      ColEsf3 [54] := Col5;
      ColEsf3 [55] := Col4;
      ColEsf3 [56] := Col4;
      ColEsf3 [57] := Col3;
      ColEsf3 [58] := Col3;
      ColEsf3 [59] := Col3;
      ColEsf3 [60] := Col4;
      ColEsf3 [61] := Col3;
      ColEsf3 [62] := Col4;
      ColEsf3 [63] := Col4;
      ColEsf3 [64] := Col5;
      ColEsf3 [65] := Col5;
      ColEsf3 [66] := Col5;
      ColEsf3 [67] := Col4;
      ColEsf3 [68] := Col4;
      ColEsf3 [69] := Col4;
      ColEsf3 [70] := Col4;
      ColEsf3 [71] := Col4;
      ColEsf3 [72] := Col4;
      ColEsf3 [73] := Col4;
      ColEsf3 [74] := Col5;
      ColEsf3 [75] := Col5;
      ColEsf3 [76] := Col6;
      ColEsf3 [77] := Col5;
      ColEsf3 [78] := Col4;
      ColEsf3 [79] := Col5;
      ColEsf3 [80] := Col4;
      ColEsf3 [81] := Col5;
      ColEsf3 [82] := Col4;
      ColEsf3 [83] := Col5;
      ColEsf3 [84] := Col5;
      ColEsf3 [85] := Col6;
      ColEsf3 [86] := Col5;
      ColEsf3 [87] := Col5;
      ColEsf3 [88] := Col5;
      ColEsf3 [89] := Col5;
      ColEsf3 [90] := Col5;
      ColEsf3 [91] := Col5;
      ColEsf3 [92] := Col6;
      ColEsf3 [93] := Col6;
      ColEsf3 [94] := Col5;
      ColEsf3 [95] := Col6;
      ColEsf3 [96] := Col5;
      ColEsf3 [97] := Col6;
    end;

  {------------------------------------------------------}
  { Pongo una esfera de seis colores (degradada).        }
  {        Esta esfera es de 11x11 pixels.               }
  { Esta bola pasa por debajo de lo que haya en pantalla.}
  { Se oscurece si hay un color Gris.                    }
  {                                                      }
  { Colores recomendados:                                }
  {   0-Pone la esfera blanca y la oscurece muy bien.    }
  {   1-Pone la esfera rojo brillante y oscurece bien.   }
  {   3-Pone la esfera amarilla.                         }
  {   5-Esfera en verde.                                 }
  {   6-Pone un Cyan muy bonito.                         }
  {   8-Azul oscuro.                                     }
  {   9-Morado.                                          }
  {  10-Rosa oscuro.                                     }
  {  11-Marron claro.                                    }
  {  12-Marron oscuro.                                   }
  {                                                      }
  { Colores con los que trabaja Esfera3.                 }
  {   Fondo     : Si el color es este pone la bola.      }
  {   Gris      : Si el color es este oscurece la bola.  }
  {   Oscuridad : Incremento de oscuridad (de 1 a 5).    }
  {------------------------------------------------------}

  Procedure Esfera3 (x,y:Word;Fondo,Gris,Oscuridad:Byte;On:Boolean);

    Begin
      Dec (x,2);
      Dec (y,5);
      If On then
          ASM
            push ds
            push si

            mov ax, Seg ColEsf3
            mov ds,ax
            mov si, Offset ColEsf3

            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov cl,5

          @Line1:

            lodsb

            mov ah,[es:di]     { AH Color de la pantalla. }

            cmp ah,Gris        { El gris.}
            jne @Negro
            add al,Oscuridad   { Si es gris cambio el color y me voy.}
            jmp @Fin

          @Negro :
            cmp ah,Fondo
            je @Fin            { Si no es el color de fondo dejo el color que habia.}
            mov al,ah

          @Fin :
            stosb              { Pongo el color debido.}

            dec cl
            jnz @Line1

            add di,314
            mov cl,7

          @Line2:
            lodsb

            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro2
            add al,Oscuridad
            jmp @Fin2

          @Negro2 :
            cmp ah,Fondo
            je @Fin2
            mov al,ah

          @Fin2 :
            stosb

            dec cl

            jnz @Line2

            add di,312
            mov cl,9

          @Line3:
            lodsb


            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro3
            add al,Oscuridad
            jmp @Fin3

          @Negro3 :
            cmp ah,Fondo
            je @Fin3
            mov al,ah

          @Fin3 :
            stosb

            dec cl
            jnz @Line3

            add di,310
            mov cl,11

          @Line4:
            lodsb

            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro4
            add al,Oscuridad
            jmp @Fin4

          @Negro4 :
            cmp ah,Fondo
            je @Fin4
            mov al,ah

          @Fin4 :
            stosb

            dec cl
            jnz @Line4


            mov ch,4
          @CuatroLineas :

            add di,309
            mov cl,11

          @Line5:
            lodsb

            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro5
            add al,Oscuridad
            jmp @Fin5

          @Negro5 :
            cmp ah,Fondo
            je @Fin5
            mov al,ah

          @Fin5 :
            stosb

            dec cl
            jnz @Line5

            dec ch
            jnz @CuatroLineas

            add di,310
            mov cl,9

          @Line6:
            lodsb


            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro6
            add al,Oscuridad
            jmp @Fin6

          @Negro6 :
            cmp ah,Fondo
            je @Fin6
            mov al,ah

          @Fin6 :
            stosb

            dec cl
            jnz @Line6

            add di,312
            mov cl,7

          @Line7:
            lodsb


            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro7
            add al,Oscuridad
            jmp @Fin7

          @Negro7 :
            cmp ah,Fondo
            je @Fin7
            mov al,ah

          @Fin7 :
            stosb

            dec cl
            jnz @Line7

            add di,314
            mov cl,5

          @Line8:
            lodsb


            mov ah,[es:di]

            cmp ah,Gris
            jne @Negro8
            inc al
            add al,Oscuridad
            jmp @Fin8

          @Negro8 :
            cmp ah,Fondo
            je @Fin8
            mov al,ah

          @Fin8 :
            stosb

            dec cl
            jnz @Line8

            pop si
            pop ds


        end
            else
        begin
          ASM
            push ds
            push si

            mov ax, PSeg
            mov bx, POff
            push bx
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            pop bx

            mov cl,5
          @Salto1:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto1

            add di,314
            mov cl,7
          @Salto2:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto2

            add di,312
            mov cl,9
          @Salto3:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto3

            add di,310
            mov cl,11
          @Salto4:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto4

            add di,309
            mov cl,11
          @Salto5:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto5

            add di,309
            mov cl,11
          @Salto6:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto6

            add di,309
            mov cl,11
          @Salto7:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto7

            add di,309
            mov cl,11
          @Salto8:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto8

            add di,310
            mov cl,9
          @Salto9:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto9

            add di,312
            mov cl,7
          @Salto10:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto10

            add di,314
            mov cl,5
          @Salto11:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto11

            pop si
            pop ds
          end;
        end;
    end;

  {------------------------------------------------------}
  { Pongo una esfera de seis colores (degradada).        }
  {        Esta esfera es de 11x11 pixels.               }
  { Esta bola pasa por encima de lo que haya en pantalla.}
  { Se oscurece si lo que hay debajo no es el fondo.     }
  {                                                      }
  {                                                      }
  { Colores recomendados:                                }
  {   0-Pone la esfera blanca.                           }
  {   1-Pone la esfera rojo brillante.                   }
  {   3-Pone la esfera amarilla.                         }
  {   5-Esfera en verde.                                 }
  {   6-Pone un Cyan muy bonito.                         }
  {   8-Azul oscuro.                                     }
  {   9-Morado.                                          }
  {  10-Rosa oscuro.                                     }
  {  11-Marron claro.                                    }
  {  12-Marron oscuro.                                   }
  {                                                      }
  {                                                      }
  { Colores con los que trabaja Esfera4.                 }
  {   Fondo     : Si el color es este pone la bola.      }
  {   Oscuridad : Incremento de oscuridad (de 1 a 5).    }
  {------------------------------------------------------}

  Procedure Esfera4 (x,y:Word;Fondo,Oscuridad:Byte;On:Boolean);

    Begin
      Dec (x,2);
      Dec (y,5);
      If On then
          ASM
            push ds
            push si

            mov ax, Seg ColEsf3
            mov ds,ax
            mov si, Offset ColEsf3

            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov cl,5

          @Line1:

            lodsb

            mov ah,[es:di]     { AH Color de la pantalla. }

            cmp al,ah          { Compruebo si el color de fondo es }
            je @Fin            { el mismo que voy a poner.         }

            cmp ah,Fondo
            je @Fin            { Si no es el color de fondo oscurezco }
            add al,Oscuridad   { el punto que voy a poner.            }

          @Fin :
            stosb          { Pongo el color debido.}

            dec cl
            jnz @Line1

            add di,314
            mov cl,7

          @Line2:
            lodsb

            mov ah,[es:di]

            cmp al,ah
            je @Fin2

            cmp ah,Fondo
            je @Fin2
            add al,Oscuridad

          @Fin2 :
            stosb

            dec cl

            jnz @Line2

            add di,312
            mov cl,9

          @Line3:
            lodsb


            mov ah,[es:di]
            cmp al,ah
            je @Fin3

            cmp ah,Fondo
            je @Fin3
            add al,Oscuridad

          @Fin3 :
            stosb

            dec cl
            jnz @Line3

            add di,310
            mov cl,11

          @Line4:
            lodsb

            mov ah,[es:di]
            cmp al,ah
            je @Fin4

            cmp ah,Fondo
            je @Fin4
            add al,Oscuridad

          @Fin4 :
            stosb

            dec cl
            jnz @Line4


            mov ch,4
          @CuatroLineas :

            add di,309
            mov cl,11

          @Line5:
            lodsb

            mov ah,[es:di]
            cmp al,ah
            je @Fin5

            cmp ah,Fondo
            je @Fin5
            add al,Oscuridad

          @Fin5 :
            stosb

            dec cl
            jnz @Line5

            dec ch
            jnz @CuatroLineas

            add di,310
            mov cl,9

          @Line6:
            lodsb

            mov ah,[es:di]
            cmp al,ah
            je @Fin6

            cmp ah,Fondo
            je @Fin6
            add al,Oscuridad

          @Fin6 :
            stosb

            dec cl
            jnz @Line6

            add di,312
            mov cl,7

          @Line7:
            lodsb


            mov ah,[es:di]
            cmp al,ah
            je @Fin7

            cmp ah,Fondo
            je @Fin7
            add al,Oscuridad

          @Fin7 :
            stosb

            dec cl
            jnz @Line7

            add di,314
            mov cl,5

          @Line8:
            lodsb


            mov ah,[es:di]
            cmp al,ah
            je @Fin8

            cmp ah,Fondo
            je @Fin8
            add al,Oscuridad

          @Fin8 :
            stosb

            dec cl
            jnz @Line8

            pop si
            pop ds


        end
            else
        begin
          ASM
            push ds
            push si

            mov ax, PSeg
            mov bx, POff
            push bx
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            pop bx

            mov cl,5
          @Salto1:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto1

            add di,314
            mov cl,7
          @Salto2:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto2

            add di,312
            mov cl,9
          @Salto3:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto3

            add di,310
            mov cl,11
          @Salto4:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto4

            add di,309
            mov cl,11
          @Salto5:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto5

            add di,309
            mov cl,11
          @Salto6:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto6

            add di,309
            mov cl,11
          @Salto7:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto7

            add di,309
            mov cl,11
          @Salto8:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto8

            add di,310
            mov cl,9
          @Salto9:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto9

            add di,312
            mov cl,7
          @Salto10:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto10

            add di,314
            mov cl,5
          @Salto11:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto11

            pop si
            pop ds
          end;
        end;
    end;

  {------------------------------------------------------}
  { Pongo una esfera de 17x17 pixels.                    }
  {                                                      }
  { Esta bola pasa por encima de lo que haya en pantalla.}
  { Su funcin es hacer de bola transparente con zoom.   }
  {                                                      }
  {------------------------------------------------------}

  Procedure Esfera5 (x,y:Word;On:Boolean);

    Const
      Gris   : Byte = 18; {Gris claro.}

    Var
    { Aqui guardo los colores que hay debajo de la bola }
    { (los que voy a ampliar).                          }
      BajoB1 : Byte;
      BajoB2 : Byte;
      BajoB3 : Byte;
      BajoB4 : Byte;
      BajoB5 : Byte;
      BajoB6 : Byte;
      BajoB7 : Byte;
      BajoB8 : Byte;
    Begin
      Dec (x,2);
      Dec (y,8);
      If On then
        begin
          ASM
            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov al,Gris
            stosb
            stosb
            stosb
            stosb
            stosb

            add di,313
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            mov al,Gris
            stosb

            add di,310
            stosb
            mov al,BajoB1
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,308
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            mov al,Gris
            stosb

            add di,306
            stosb
            mov al,BajoB1
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,305
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            mov al,Gris
            stosb

            add di,304
            stosb
            mov al,BajoB1
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,303
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB8,al
            stosb
            stosb
            mov al,Gris
            stosb

            add di,303
            mov al,BajoB1
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            mov al,Gris
            stosb

            add di,303
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB8,al
            stosb
            stosb
            mov al,Gris
            stosb

            add di,303
            mov al,BajoB1
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            mov al,Gris
            stosb

            add di,304
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            mov al,Gris
            stosb

            add di,305
            mov al,BajoB1
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            mov al,Gris
            stosb


            add di,306
            mov al,Gris
            stosb
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,308
            mov al,BajoB1
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            mov al,Gris
            stosb

            add di,310
            mov al,Gris
            stosb
            stosb
            stosb
            stosb
            stosb
            stosb
            stosb
            stosb
            stosb

            add di,313
            stosb
            stosb
            stosb
            stosb
            stosb
          end;
        end
            else
        begin
          ASM
            push ds
            push si

            mov ax, PSeg
            mov bx, POff
            push bx
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            pop bx

            mov cl,5
          @Salto1:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto1

            add di,313
            mov cl,9
          @Salto2:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto2

            add di,310
            mov cl,11
          @Salto3:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto3

            add di,308
            mov cl,13
          @Salto4:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto4

            add di,306
            mov cl,15
          @Salto5:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto5

            add di,305
            mov cl,15
          @Salto6:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto6

            add di,304
            mov cl,17
          @Salto7:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto7

            add di,303
            mov cl,17
          @Salto8:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto8

            add di,303
            mov cl,17
          @Salto9:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto9

            add di,303
            mov cl,17
          @Salto10:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto10

            add di,303
            mov cl,17
          @Salto11:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto11

            add di,304
            mov cl,15
          @Salto12:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto12

            add di,305
            mov cl,15
          @Salto13:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto13

            add di,306
            mov cl,13
          @Salto14:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto14

            add di,308
            mov cl,11
          @Salto15:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto15

            add di,310
            mov cl,9
          @Salto16:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto16

            add di,313
            mov cl,5
          @Salto17:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto17

            pop si
            pop ds
          end;
        end;
    end;

  {------------------------------------------------------}
  { Pongo una esfera de 31x31 pixels.                    }
  {                                                      }
  { Esta bola pasa por encima de lo que haya en pantalla.}
  { Su funcin es hacer de bola transparente con zoom y  }
  { deformidad.                                          }
  {                                                      }
  {------------------------------------------------------}

  Procedure Esfera6 (x,y:Word;On:Boolean);

    Const
      Gris   : Byte = 18; {Gris claro.}

    Var
    { Aqui guardo los colores que hay debajo de la bola }
    { (los que voy a ampliar).                          }
      BajoB1 : Byte;
      BajoB2 : Byte;
      BajoB3 : Byte;
      BajoB4 : Byte;
      BajoB5 : Byte;
      BajoB6 : Byte;
      BajoB7 : Byte;
      BajoB8 : Byte;
      BajoB9 : Byte;
      BajoB10: Byte;

    Begin
      Dec (x,4);
      Dec (y,15);
      If On then
          ASM
            mov ax,$a000
            mov es,ax
            mov bx,x
            mov dx,y

            xchg dh,dl
            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            mov al,Gris
            stosb
            stosb
            stosb
            stosb
            stosb
            stosb
            stosb

            add di,310
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,306
            stosb
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb
            stosb

            add di,302
            stosb
            stosb
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb
            stosb
            stosb

            add di,300
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            stosb

            add di,298
            mov al,Gris
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,296
            mov al,Gris
            stosb
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,294
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            stosb
            mov BajoB8,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB9,al
            stosb
            stosb
            stosb

            add di,293
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb

            add di,292
            mov al,Gris
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,291
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            stosb
            mov BajoB8,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB9,al
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,291
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,290
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb
            stosb

            add di,289
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            stosb
            mov BajoB8,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB9,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB10,al
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb
            mov al,BajoB10
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb
            mov al,BajoB10
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            stosb
            mov BajoB8,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB9,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB10,al
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb
            mov al,BajoB10
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,289
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb
            mov al,BajoB10
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,290
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            stosb
            mov BajoB8,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB9,al
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,291
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,291
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,BajoB9
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,292
            mov al,Gris
            stosb
            stosb
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB7,al
            stosb
            stosb
            stosb
            mov BajoB8,al
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,293
            stosb
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,294
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,BajoB7
            stosb
            stosb
            stosb
            mov al,BajoB8
            stosb
            stosb
            stosb

            add di,296
            mov al,Gris
            stosb
            stosb
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB3,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB4,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB5,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB6,al
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb
            stosb

            add di,298
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb

            add di,300
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,BajoB3
            stosb
            stosb
            stosb
            mov al,BajoB4
            stosb
            stosb
            stosb
            mov al,BajoB5
            stosb
            stosb
            stosb
            mov al,BajoB6
            stosb
            stosb
            stosb
            mov al,Gris
            stosb

            add di,302
            stosb
            stosb
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB1,al
            stosb
            stosb
            stosb
            mov al,[es:di]
            mov BajoB2,al
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb
            stosb
            stosb
            stosb
            stosb

            add di,306
            stosb
            stosb
            stosb
            mov al,BajoB1
            stosb
            stosb
            stosb
            mov al,BajoB2
            stosb
            stosb
            stosb
            mov al,Gris
            stosb
            stosb
            stosb
            stosb

            add di,310
            stosb
            stosb
            stosb
            stosb
            stosb
            stosb
            stosb
        end
            else
        begin
          ASM
            push ds
            push si

            mov ax, PSeg
            mov bx, POff
            push bx
            mov ds,ax

            mov ax,$a000
            mov es,ax

            mov bx,x
            mov dx,y

            xchg dh,dl

            mov di,dx
            shr di,1
            shr di,1
            add di,dx
            add di,bx

            pop bx

            mov cl,7
          @Salto1:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto1

            add di,310
            mov cl,13
          @Salto2:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto2

            add di,306
            mov cl,17
          @Salto3:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto3

            add di,302
            mov cl,19
          @Salto4:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto4

            add di,300
            mov cl,21
          @Salto5:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto5

            add di,298
            mov cl,23
          @Salto6:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto6

            add di,296
            mov cl,25
          @Salto7:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto7

            add di,294
            mov cl,27
          @Salto8:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto8

            add di,293
            mov cl,27
          @Salto9:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto9

            add di,292
            mov cl,29
          @Salto10:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto10

            add di,291
            mov cl,29
          @Salto11:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto11

            add di,291
            mov cl,29
          @Salto12:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto12

            add di,290
            mov cl,31
          @Salto13:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto13

            mov ch,6
          @SeisLineas:

            add di,289
            mov cl,31
          @Salto14:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto14

            dec ch
            jnz @SeisLineas

            add di,290
            mov cl,29
          @Salto15:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto15

            add di,291
            mov cl,29
          @Salto16:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto16

            add di,291
            mov cl,29
          @Salto17:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto17

            add di,292
            mov cl,27
          @Salto18:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto18

            add di,293
            mov cl,27
          @Salto19:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto19

            add di,294
            mov cl,25
          @Salto20:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto20

            add di,296
            mov cl,23
          @Salto21:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto21

            add di,298
            mov cl,21
          @Salto22:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto22

            add di,300
            mov cl,19
          @Salto23:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto23

            add di,302
            mov cl,17
          @Salto24:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto24

            add di,306
            mov cl,13
          @Salto25:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto25

            add di,310
            mov cl,7
          @Salto26:
            mov si,di
            add si,bx
            lodsb
            stosb
            dec cl
            jnz @Salto26

            pop si
            pop ds
          end;
        end;
    end;

BEGIN
  GetMem (Pantalla,64500);
  PSeg := Seg (Pantalla^);
  POff := Ofs (Pantalla^);
END.