{
{             Programa que dibuja curvas de Lissajous .                   }
{                                                                         }
{               Creada por Spanish Lords Enero 1994.                      }
{                    Lords   Crom  &  Mitra.                              }
{                       Alcala de Henares                                 }
{                         M a d r i d                                     }
{                           (Spain)                                       }

PROGRAM Lissajous;

{$M 6000,0,255360}

USES
  Crt,Dos,MCGA,Esferas;


VAR
  Retardo   : Byte;
  Code      : Integer;

  Continue  : Boolean;
  Direction : Byte;
  Old       : Procedure;

{-----------------------------------------------------------------}
{ Apaga la pantalla y la reduce a un punto. Como en el PANIC.     }
{ Parametros: ColApaga: Color del que queda la pantalla al apagar.}
{             ColRaya : Color de la raya que va dibujando.        }
{             Retardo : Pues eso (en ms).                         }
{-----------------------------------------------------------------}
Procedure Apaga(ColApaga,ColRaya:Byte;Raya:Boolean;Retardo:Word);
  Var
    CntUp   : Word;
    CntDown : Word;
  Begin
    CntUp    := 000;
    CntDown  := 199;
    For CntUp:=0 to 98 do
      begin
        DrawLineH (0,319,CntUp,ColApaga);
        If Raya then DrawLIneH (0,319,CntUp+1,ColRaya);
        DrawLineH (0,319,CntDown,ColApaga);
        If Raya then DrawLineH (0,319,CntDown-1,ColRaya);
        Dec (CntDown);
        Delay (Retardo);
      end;
    CntDown:=319;
    Delay (1000);
    For CntUp:=0 to 158 do
      begin
        DrawLineV (CntUp    ,99,100,ColApaga);
        DrawLineV (CntUp+1  ,99,100,ColRaya);
        DrawLineV (CntDown  ,99,100,ColApaga);
        DrawLineV (CntDown-1,99,100,ColRaya);
        Dec (CntDown);
        Delay (Retardo);
      end;
    Delay (200);
    FillBlock (0,0,319,199,15);
    FillBlock (0,0,319,199,0);
  End;

{-------------------------------------------------------}
{ Restaura en pantalla la Pantalla de la unidad Esferas.}
{ Todo excepto las 70 primeras columnas de pixels.      }
{-------------------------------------------------------}
PROCEDURE RestPantalla;Assembler;
  Asm
    push ds
    push si

    mov ax, Seg Pantalla
    mov ds,ax
    mov si, Offset Pantalla

    mov ax,$a000
    mov es,ax
    mov di,0000

    mov ch,199
  @HastaFin :
    add si,71
    add di,71
    mov cl,249
  @Finlinea :
    lodsb
    stosb
    dec cl
    jnz @FinLinea

    Dec ch
  jnz @HastaFin

    pop si
    pop ds

  End;



{---------------------------------------------------------}
{ Pone la pantalla en color 0 de la paleta de DP (negro). }
{---------------------------------------------------------}
PROCEDURE PantallaNegra;Assembler;

  Asm
    mov ax, $A000
    mov es,ax
    mov di, 0000

    xor ax,ax
    mov cx,63999

  @HastaFin :

    stosb

    Dec cx
    jnz @HastaFin

  end;

Procedure ClearBuffer; assembler;

ASM
   cli                   { Deactivate interrupts. }

   xor  ax,ax            { AX := 0 }
   mov  es,ax            { ES := 0 }
   mov  al,es:[$41A]     { AL := Keyboard buffer begin. }
   mov  es:[$41C],al     { Keyboard buffer tail := Keyboard buffer begin. }

   sti                   { Enable interrupts. }
END;

{$S-,W-,F+}
procedure Teclado; interrupt;
begin
  If Port[$60]= 1                     then Continue:=False; { ESCAPE      }
  If Port[$60]=72                     then Direction:=1;    { UP ARROW    }
  If Port[$60]=75                     then Direction:=2;    { LEFT ARROW  }
  If Port[$60]=77                     then Direction:=3;    { RIGHT ARROW }
  If Port[$60]=80                     then Direction:=4;    { DOWN ARROW  }
  If (Port[$60]=27) or (Port[$60]=78) then Direction:=5;    { + KEY       }
  If (Port[$60]=53) or (Port[$60]=74) then Direction:=6;    { - KEY       }

  inline ($9C); { PUSHF }
  Old;

  ClearBuffer;
end;
{$F-,S+}



{                                                                         }
{ La composicin de movimientos armnicos de direcciones perpendiculares  }
{ da lugar a las conocidas curvas de Lissajous.                           }
{    La componente x ser: x = A1 sen (w1t + Desf1)                       }
{    La componente y ser  y = A2 sen (w2t + Desf2)                       }
{ Las curvas de Lissanjous se repiten cada 2 pi veces, lo cual quiere     }
{ decir que si dibujamos la curva para todos los valores de t entre 0 y   }
{ 2 pi la curva queda totalmemte definida.                                }
{                                                                         }
PROCEDURE Curvas;

  Var
  { Voy a dibujar un mximo de 60 puntos a la vez, su pos. la guardo aqui.}
  { En la primera columna de el array guardo x y en la segunda y.         }
  {                                                                       }
  {   StPuntos:La Cola circular donde voy a guardar las coordenadas de    }
  {            las bolas.                                                 }
  {   NumBolas:Guarda el numero de bolas que dibujo.Maximo: 60            }
  {   PBola1  :Guarda la posicin de la cola circular donde guardo las    }
  {            coordenadas de la primera bola.                            }
  {   PBolaFin:Guarda la posicin de la cola circular donde guardo las    }
  {            coordenadas de la ultima bola.                             }

    StPuntos  : Array [1..60,1..2] of Integer;
    NumBolas  : Integer;
    PBola1    : Byte;
    PBolaFin  : Byte;


  { Coordenadas X,Y que pinto actualmente.}
    CoorX     : Integer;
    CoorY     : Integer;
  { Tipo de bola.}
    TipoEsfera: Integer;
    OldTipoEsf: Integer;

  { Contadores que manejan los parametros de la curva.                    }
  {                                                                       }
  { Cnt       : Un Contador.                                              }
  { CntAng    : Determina el numero de grados que incremento en cada paso.}
  { CntA1     : Valor de la amplitud de la primera curva.                 }
  { CntA2     : Valor de la amplitud de la segunda curva.                 }
  { Cntw1     : Valor de la pulsacion de la primera curva.                }
  { Cntw2     : Valor de la pulsacin de la segunda curva.                }
  { CntDesf1  : Valor del desfase de la primera curva.                    }
  { CntDesf2  : Valor del desfase de la segunda curva.                    }
  { CntIniX   : Coordenada x donde empiezo a dibujar la curva.            }
  { CntIniY   : Coordenada y donde empiezo a dibujar la curva.            }
  { CntColor  : Valor del color de la esfera.                             }

    CntAng    : Integer;
    CntA1     : Integer;
    CntA2     : Integer;
    Cntw1     : Integer;
    Cntw2     : Integer;
    CntDesf1  : Integer;
    CntDesf2  : Integer;
    CntIniX   : Integer;
    CntIniY   : Integer;
    CntColor  : Integer;

    OldNumBolas : Integer;
    OldCntAng   : Integer;
    OldCntA1    : Integer;
    OldCntA2    : Integer;
    OldCntw1    : Integer;
    OldCntw2    : Integer;
    OldCntDesf1 : Integer;
    OldCntDesf2 : Integer;
    OldCntColor : Integer;

    ValA1    : Real;
    ValA2    : Real;
    Valw1    : Real;
    Valw2    : Real;
    ValDesf1 : Real;
    ValDesf2 : Real;
    Cntt     : Real;

    Opcion   : Byte;
    OldOpcion: Byte;

    Suma     : Boolean;
    Resta    : Boolean;

  {-------------------------------------------------------------------------}
  { Las variables de entrada sacan el valor de X,Y para la curva dada.      }
  { Trabajo en grados.El procedimiento multiplica por PI y divide entre 180 }
  {-------------------------------------------------------------------------}
  Procedure Valores(VAR X,Y:Integer;A1,A2,w1,w2,Desf1,Desf2,t:Real);

    Const
      PI = 3.141592654;
    Var
      Wt     : Real;
      WtD    : Real;
      AngRad : Real;
      Aux    : Real;
    Begin
      Wt     := W1*t;
      AngRad := (Desf1*PI)/180;
      WtD    := Wt+AngRad;
      AngRad := (WtD*PI)/180;
      Aux    := A1*(SIN (AngRad));
      X      := CntIniX+Trunc (Aux);

      Wt     := W2*t;
      AngRad := (Desf2*PI)/180;
      WtD    := Wt+AngRad;
      AngRad := (WtD*PI)/180;
      Aux    := A2*(SIN (AngRad));
      Y      := CntIniY+Trunc (Aux);
    End;

  {---------------------------------------------------------}
  { Relleno la tabla con los colores y datos la primera vez.}
  {---------------------------------------------------------}
  Procedure FillArray;

    Var
      Cnt    : Integer;
      CntIni : Integer;
      CntFin : Integer;

    Begin
      PBola1   := 1;
      PBolaFin := 0;

      For Cnt:=1 to NumBolas do
        Begin
          Valores (StPuntos[Cnt,1],StPuntos[Cnt,2],ValA1,ValA2,Valw1,Valw2,
                   ValDesf1,ValDesf2,Cntt);
          Cntt:=Cntt+CntAng;
          Inc (PBolaFin);
        end;
    end;

  {------------------------------------------------------------------}
  { Actualiza los punteros PBola1 y PBolaFin que indican la posicin }
  { de inicio y de fin de la cola circular.                          }
  {------------------------------------------------------------------}
  Procedure ActualizaP;
    Begin
      If PBola1   = NumBolas then PBola1:=1
                             else Inc(PBola1);
      If PBolaFin = NumBolas then PBolaFin:=1
                             else Inc (PBolaFin);
    end;



  {-----------------------------------------------------------}
  { Pongo una esfera y borro otra con los parametros actuales.}
  {-----------------------------------------------------------}
  Procedure ActCurva;
    Var
      Cnt   : Byte;
      AuxP1 : Byte;
      AuxP2 : Byte;

    Begin
        Valores  (CoorX,CoorY,ValA1,ValA2,Valw1,Valw2,ValDesf1,ValDesf2,Cntt);
        Case TipoEsfera of
          1 : Esfera1 (StPuntos[PBola1,1],StPuntos[PBola1,2],CntColor,False);
          2 : Esfera2 (StPuntos[PBola1,1],StPuntos[PBola1,2],CntColor,False);
          3 : Esfera3 (StPuntos[PBola1,1],StPuntos[PBola1,2],0,26,4,False);
          4 : Esfera4 (StPuntos[PBola1,1],StPuntos[PBola1,2],0,5,False);
          5 : Esfera5 (StPuntos[PBola1,1],StPuntos[PBola1,2],False);
          6 : Esfera6 (StPuntos[PBola1,1],StPuntos[PBola1,2],False);
        end;

        ActualizaP;

        StPuntos [PBolaFin,1] := CoorX;
        StPuntos [PBolaFin,2] := CoorY;

        Cnt :=PBola1;
        If Cnt =1 then Cnt :=NumBolas
                  else Dec (Cnt);
        Repeat
          If Cnt = NumBolas then Cnt:=1
                            else Inc(Cnt);
          Case TipoEsfera of
            1 : Esfera1 (StPuntos[Cnt,1],StPuntos[Cnt,2],CntColor,True);
            2 : Esfera2 (StPuntos[Cnt,1],StPuntos[Cnt,2],CntColor,True);
            3 : Esfera3 (StPuntos[Cnt,1],StPuntos[Cnt,2],0,26,4,True);
            4 : Esfera4 (StPuntos[Cnt,1],StPuntos[Cnt,2],0,5,True);
            5 : Esfera5 (StPuntos[Cnt,1],StPuntos[Cnt,2],True);
            6 : Esfera6 (StPuntos[Cnt,1],StPuntos[Cnt,2],True);
          end;
        Until Cnt=PBolaFin;
    end;


    {-----------------------------------------------}
    { Escribe un numero en pantalla en modo grafico.}
    {-----------------------------------------------}
    Procedure WriteNum (X,Y,Num:Integer;IncX:Byte;Color:Byte);

      Var
        AuxNum : Integer;
        Numero : Byte;
        Car    : Char;

      Procedure PintaNum;
        Begin
          Case AuxNum of
            0 : GrWrite (X,Y,Color,'0');
            1 : GrWrite (X,Y,Color,'1');
            2 : GrWrite (X,Y,Color,'2');
            3 : GrWrite (X,Y,Color,'3');
            4 : GrWrite (X,Y,Color,'4');
            5 : GrWrite (X,Y,Color,'5');
            6 : GrWrite (X,Y,Color,'6');
            7 : GrWrite (X,Y,Color,'7');
            8 : GrWrite (X,Y,Color,'8');
            9 : GrWrite (X,Y,Color,'9');
          end;
          X:=X+IncX
        End;

      Begin
        AuxNum:=Num div 100;
        PintaNum;
        Num:=Num-(AuxNum*100);
        AuxNum:=Num div 10;
        PintaNum;
        AuxNum:=Num-(AuxNum*10);
        PintaNum;
      End;

    {------------------------------------------------------------}
    { Actualiza en pantalla las modificaciones de los parametros.}
    {------------------------------------------------------------}
    Procedure ActParametros;
      Procedure Cursor (Opcion:Byte;On:Boolean);
        Var
          Color1  : Byte;
          Color2  : Byte;

          YOpc   : Byte;

        Begin
          If On then begin
                       Color1 := 160;
                       Color2 := 162;
                     end
                else begin
                       Color1 :=  114;
                       Color2 :=  116;
                     end;
          Case Opcion of
            1 : begin
                  Grwrite (5, 60,Color1,'Amplitude:');
                  Grwrite (7, 70,Color2,'X:');
                end;
            2 : begin
                  Grwrite (5, 60,Color1,'Amplitude:');
                  GrWrite (7, 80,Color2,'Y:');
                end;
            3 : begin
                  GrWrite (5, 90,Color1,'Pulsation:');
                  Grwrite (7,100,Color2,'X:');
                end;
            4 : begin
                  GrWrite (5, 90,Color1,'Pulsation:');
                  GrWrite (7,110,Color2,'Y:');
                end;
            5 : begin
                  Grwrite (5,120,Color1,'Phase:');
                  Grwrite (7,130,Color2,'X:');
                end;
            6 : begin
                  Grwrite (5,120,Color1,'Phase:');
                  GrWrite (7,140,Color2,'Y:');
                end;
            7 : Grwrite (7,160,Color2,'Balls  :');
            8 : GrWrite (7,170,Color2,'Inc.Ang:');
            9 : Grwrite (7,180,Color2,'Color  :');
           10 : GrWrite (7,190,Color2,'Kind   :');
          end;
        end;

      Procedure MasColor;
        Procedure Color34;
          Begin
            If (TipoEsfera=3) or (TipoEsfera=4) then
              begin
                ActColEsf:=CntColor;
                FillColors;
              end;
          end;
        Begin
          If (TipoEsfera=1) then begin If CntColor<249 then Inc (CntColor) end
                            else begin If CntColor<12  then begin
                                                        Inc (CntColor);
                                                        Color34;
                                                      end
                                                 else begin
                                                        CntColor:=12;
                                                        Color34;
                                                      end;
                                 end;
        End;

      Procedure MenosColor;
        Begin
          If CntColor>0 then begin
                               Dec (CntColor);
                               If (TipoEsfera=3) or (TipoEsfera=4) then
                                 begin
                                   ActColEsf:=CntColor;
                                   FillColors;
                                 end;
                             end;
        End;

      Begin
        If Opcion<>OldOpcion then begin
                                    Cursor (OldOpcion,False);
                                    Case Opcion of
                                       0 : Opcion:=10;
                                      11 : Opcion:= 1;
                                    end;
                                    OldOpcion:=Opcion;
                                    Cursor (Opcion,True);
                                  end;

        If Suma  then Case Opcion of
                        1 : If CntA1<    100 then Inc (CntA1);
                        2 : If CntA2<     80 then Inc (CntA2);
                        3 : If Cntw1<     50 then Inc (Cntw1);
                        4 : If Cntw2<     50 then Inc (Cntw2);
                        5 : If CntDesf1< 360 then Inc (CntDesf1);
                        6 : If CntDesf2< 360 then Inc (CntDesf2);
                        7 : If NumBolas<  60 then begin
                                                    RestPantalla;
                                                    Inc (NumBolas);
                                                    FillArray;
                                                  end;
                        8 : If CntAng  <  45 then Inc (CntAng);
                       10 : Begin
                              RestPantalla;
                              If TipoEsfera< 6 then begin
                                                      Inc (TipoEsfera);
                                                      ActColEsf:=CntColor;
                                                      FillColors;
                                                    end;
                              If (Tipoesfera<>1) and (CntColor>12) then
                                begin
                                  CntColor:=12;
                                  ActColesf:=CntColor;
                                  Fillcolors;
                                end;
                           end;
                        9 : MasColor;
                      end;
        If Resta then Case Opcion of
                        1 : If CntA1>    1 then Dec (CntA1);
                        2 : If CntA2>    1 then Dec (CntA2);
                        3 : If Cntw1>    1 then Dec (Cntw1);
                        4 : If Cntw2>    1 then Dec (Cntw2);
                        5 : If CntDesf1> 0 then Dec (CntDesf1);
                        6 : If CntDesf2> 0 then Dec (CntDesf2);
                        7 : If NumBolas> 1 then begin
                                                  RestPantalla;
                                                  Dec (NumBolas);
                                                  FillArray;
                                                end;
                        8 : If CntAng  > 1 then Dec (CntAng);
                       10 : Begin
                             RestPantalla;
                             If TipoEsfera> 1 then begin
                                                      Dec (TipoEsfera);
                                                      ActColEsf:=CntColor;
                                                      FillColors;
                                                    end;
                              If (Tipoesfera<>1) and (CntColor>12) then
                                begin
                                  CntColor:=12;
                                  ActColesf:=cntColor;
                                  Fillcolors;
                                end;
                            end;
                        9 : MenosColor;
                      end;
        If CntA1<>OldCntA1 then begin
                                  OldCntA1:=CntA1;
                                  ValA1:=CntA1;
                                  FillBlock (22,70,69,80,0);
                                  WriteNum (22,70,CntA1,6,128);
                                end;
        If CntA2<>OldCntA2 then begin
                                  OldCntA2:=CntA2;
                                  ValA2:=CntA2;
                                  FillBlock (22,80,69,90,0);
                                  WriteNum (22,80,CntA2,6,128);
                                end;
        If Cntw1<>OldCntw1 then begin
                                  OldCntw1:=Cntw1;
                                  Valw1:=Cntw1;
                                  FillBlock (22,100,69,110,0);
                                  WriteNum (22,100,Cntw1,6,128);
                                end;
        If Cntw2<>OldCntw2 then begin
                                  OldCntw2:=Cntw2;
                                  Valw2:=Cntw2;
                                  FillBlock (22,110,69,120,0);
                                  WriteNum (22,110,Cntw2,6,128);
                                end;

        If CntDesf1<>OldCntDesf1 then begin
                                        OldCntDesf1:=CntDesf1;
                                        ValDesf1:=CntDesf1;
                                        FillBlock (22,130,69,140,0);
                                        WriteNum (22,130,CntDesf1,6,128);
                                      end;
        If CntDesf2<>OldCntDesf2 then begin
                                        OldCntDesf2:=CntDesf2;
                                        Valdesf2:=CntDesf2;
                                        FillBlock (22,140,69,150,0);
                                        WriteNum (22,140,CntDesf2,6,128);
                                      end;
        If NumBolas<>OldNumBolas then begin
                                        OldNumBolas:=NumBolas;
                                        FillBlock (52,160,69,170,0);
                                        WriteNum (52,160,NumBolas,6,128);
                                      end;
        If CntAng<>OldCntAng then begin
                                    OldCntAng:=CntAng;
                                    FillBlock (52,170,69,180,0);
                                    WriteNum (52,170,CntAng,6,128);
                                  end;
        If CntColor<>OldCntColor then begin
                                        OldCntColor:=CntColor;
                                        FillBlock (52,180,69,190,0);
                                        WriteNum (52,180,CntColor,6,128);
                                      end;
        If TipoEsfera<>OldTipoEsf then begin
                                         OldTipoEsf:=TipoEsfera;
                                         FillBlock (52,190,69,198,0);
                                         WriteNum (52,190,TipoEsfera,6,128);
                                       end;

      End;

    {-------------------------------------------}
    { Pone los textos aclaratorios del programa.}
    {-------------------------------------------}
    Procedure PonerTextos;

      Var
        Cnt : Byte;

      Begin
        For Cnt:=0 to 70 do DrawLineV (Cnt,0,199,0);
        Rectangle (0,0,70,55,104);
        Rectangle (0,57,70,199,144);
        SetText (1,1,2,1,2);
        GrWrite (3, 0,88,'Lissajous');
        GrWrite (3,10,90,' curves');
        GrWrite (3,20,92,'  view');
        SetText (2,1,1,1,1);
        Grwrite (5, 60,114,'Amplitude:');
        Grwrite (7, 70,116,'X:');
        GrWrite (7, 80,116,'Y:');
        GrWrite (5, 90,114,'Pulsation:');
        Grwrite (7,100,116,'X:');
        GrWrite (7,110,116,'Y:');
        Grwrite (5,120,114,'Phase:');
        Grwrite (7,130,116,'X:');
        GrWrite (7,140,116,'Y:');
        Grwrite (7,160,116,'Balls  :');
        GrWrite (7,170,116,'Inc.Ang:');
        Grwrite (7,180,116,'Color  :');
        GrWrite (7,190,116,'Kind   :');
      End;


{                                                                            }
{------- M A I N   D E    C U R V A S ---------------------------------------}
{                                                                            }
  Begin
    Continue:=True;
    Exec ('PCX.EXE','CREALISS.PCX');
    LoadPalette('LISSA');
    LoadFont  (1,'TRIP');
    LoadFont  (2,'LITT');
    PonerTextos;
    ActPantalla;

    Opcion     :=           1;
    OldOpcion  :=    Opcion+1;

    TipoEsfera :=           1;
    OldTipoEsf :=TipoEsfera+1;

    NumBolas   :=          10;
    OldNumBolas:=  NumBolas+1;
    CntAng     :=           1;
    OldCntAng  :=    CntAng+1;

    ValA1      :=          80;
    ValA2      :=          80;

    Valw1      :=           5;
    Valw2      :=           6;

    ValDesf1   :=           0;
    ValDesf2   :=          90;

    Cntt       :=           0;
    CntColor   :=          48;
    OldCntColor:=  CntColor+1;
    ActColEsf  :=           5;

    CntA1      := Trunc ( ValA1);
    OldCntA1   :=        CntA1+1;
    CntA2      := Trunc ( ValA2);
    OldCntA2   :=        CntA2+1;
    Cntw1      := Trunc ( Valw1);
    OldCntw1   :=        Cntw1+1;
    Cntw2      := Trunc ( Valw2);
    OldCntw2   :=        Cntw2+1;
    CntDesf1   := Trunc ( ValDesf1);
    OldCntDesf1:=     CntDesf1+1;
    CntDesf2   := Trunc ( ValDesf2);
    OldCntdesf2:=     CntDesf2+1;

    CntIniX    :=     200;
    CntIniY    :=     100;

    FillColors;
    FillArray;

{ Aqui se maneja el MOGOLLON.                                     }
{                                                                 }
{ Variamos el diseo de las curvas para conseguir bonitos efectos.}
{                                                                 }

  { Guardo la interrupcin de teclado antigua y pongo la ma. }
    GetIntVec($9,@Old);
    SetIntVec($9,@Teclado);
 { Ejecuto hasta la pulsacin de ESCAPE. }
    Repeat
      {---------------------------------------------}
      { Pongo una curva con los parametros actuales.}
      {---------------------------------------------}
      Repeat
        ActCurva;
        ActParametros;
        Suma :=False;
        Resta:=False;
        Delay (Retardo);
        Case Direction of
             1 : Dec (Opcion);                     { Arriba }
             2 : Resta:=True;                      { Izqda. }
             3 : Suma :=True;                      { Drcha. }
             4 : Inc (Opcion);                     { Abajo. }
             5 : If Retardo<100 then Inc (Retardo); { + Key. }
             6 : If Retardo>  0 then Dec (Retardo); { - Key. }
        end;
        Direction := $FF;
       If  Cntt<=360 then Cntt := Cntt+CntAng
                      else Cntt := CntAng;

      Until (Cntt>=360) or (not Continue);
    Until not Continue;
    Apaga (0,112,False,2);
    Delay (2000);
  { Restauro la interrupcin 9. }
    SetIntVec($9,@Old);


  end;
{----------------------------------------- M A I N --------------------------}
BEGIN                 {                                                      }
  Retardo:=10;        {          Create and modify Lissajous curves.         }
  McgaOn;             {                                                      }
  Curvas;             {                   C o d e d   b y :                  }
  McgaOff;            {          L o r d s   C r o m   &   M i t r a .       }
END.                  {                                                      }
{----------------------------------------------------------------------------}
