;----------------------------------------------------------------------------
; MICACO BBS INTRO version 1.00
; Junio de 1994
;----------------------------------------------------------------------------
; Code: Chc/Reset-Tvc
;----------------------------------------------------------------------------
; NOTA: las rutinas son en modo 320x200x16 colores
;----------------------------------------------------------------------------

; Esto para el ensamblaje condicional...

;	 TRANSPARENT = 1
;	 CLIPX = 1
;	 CLIPY = 1

; Segmento de pila

pila	SEGMENT para stack 'STACK'

	dw 512 dup(0)

pila	ENDS

; Segmento de datos

data	SEGMENT para public 'DATA'

	include driver.inc			; driver include file
	MusicOffset = $-data			; Offset for the music
	include song.inc			; the music!

	include 3d.inc
	include poly.inc	; las definiciones de las variables que usa
				; la rutina de polgonos...
	escape db 0		; la variable de la tecla ESC
	logical dw 0		; pantalla lgica
	physical dw 16000	; pantalla fsica

	paleta LABEL BYTE
	include paleta.inc
	paltable db 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0

	error	 db 'Sorry...but this intro needs at least a 386 to run... $'

	dibujo LABEL BYTE
	include pic.inc



        credits LABEL BYTE
                 db 'Vull expresar la meva sincera gratitut a tots els usuaris que han ajudat        '
                 db 'a Micaco a ser un BBS constant i, el ms difcil, gratuit. Tamb donar-li       '
                 db 'les grcies a Ken i Roberta Williams per haver aixecat una companya            '
                 db '(Sierra On-Line) de la manera tan increble com ho han fet, a John Halovanic,   '
                 db 'creador del Silver Bullet -el primer soft de BBS que va tenir Micaco-, Wayne    '
                 db 'Bell pel WWIV i Roland de Graff pel VBBS.                                       '
                 db '                                                                                '
                 db 'Truca a Micaco BBS ara!!                                                        '
                 db '                                                                                '
                 db '       Linea 1 : +34-3-3846169    28k8, 24hrs                                   '
                 db '       Linea 2 : +34-3-4641875    14k4, 24hrs                                   '
                 db '                                                                                '
                 db '  Programaci, grfics i disseny : Chc/Reset-Tvc                               '
                 db '  Programaci Adlib : JCH/Vibrants                                             '
                 db '  Msica : ???                                                                 '
                 db '                                                                                '
                 db '  Les salutacions van per :                                                    '
                 db '                       King Graham, Darkmind, Dyonisos, D-ph$$d!, Elfo,      '
                 db '                       Slump, Fiber, Skatur, Spiral, FXSoftware, Bauber &       '
                 db '                       Ripness de Postummum, Luis Crespo, Roberto III i a       '
                 db '                       tota la resta!!!                                         '
                 db 0

        endtext  db 10,13,10,13,10,13,10,13,10,13,10,13,10,13,10,13,10,13
                 db 10,13,10,13,10,13,10,13,10,13,10,13,10,13,10,13,10,13
                 db 10,13,10,13,10,13,'$'

	;mensaje del scroll de texto...
        texto LABEL BYTE
                db ' IN MAY 1989 THE FIRST BBS OF BADALONA (SPAIN) WAS BORN.               DES DE SEMPRE '
                db 'MICACO HA OFERT UN PUNT DE TROBADA PELS FANS DE LES AVENTURES '
                db 'SIERRA ON-LINE (GRACIES KEN I ROBERTA WILLIAMS) :-) , I PROMOCIONA EL CORREU '
                db 'ELECTRONIC A NIVELL NACIONAL I INTERNACIONAL.                      ATDT3846169..............CONNECT '
                db '28800 V.FC........ENTER YOUR NAME:....NEW...... WELCOME TO MICACO BBS * * * '
                db '....       US SONA ? :-)                       MES DE 4 ANYS AMB UNA PLACA 286 I MES DE 3 AMB UN '
                db '2400, I SEMPRE AMB L',34,'AJUDA DELS USUARIS (HEY USER!) AMB ELS QUE HEM ANAT '
                db 'CREIXENT... A TOTS ELLS GRACIES! PERO... AIXO NO S',34,'ACABA ENCARA... DIUEN '
                db 'QUE EL 12 D',34,'AGOST DE 1981 VA NEIXER L',34,'IBM PC... 7 ANYS DESPRES HO VA FER '
                db 'MICACO... QUE AIXO ES CONVERTEIXI EN HISTORIA NOMES DEPEN DE TU... GRACIES!!! '
                db '................NO CARRIER...................                          '
                db '                                                    ',0

		 ;para el scroll de texto utilizo un doble buffer de intermedio,
		 ;que me quita algo de memoria pero es MUY rpido...

        buffer   db 40*8 dup(0)

		 ;fuente a utilizar en el scroll de texto

		 include font.inc
        font2 LABEL BYTE
                 include font2.inc

data	ENDS

;  Segmento de cdigo principal  

code	SEGMENT para public 'CODE'
	ASSUME cs:code,ds:data,ss:pila

	.386				;Instrucciones 386...

	include 3d.asm
	include mode.asm


; escribe el texto final

WriteEnd        PROC NEAR

                mov ax,0b800h
                mov es,ax               ;segmento de texto

                xor di,di
                mov si,OFFSET credits

more:           mov al,[si]
                test al,0ffh
                jz fuera_credits

                mov es:[di],al
                inc di
                inc di
                inc si
                jmp more
fuera_credits:
                ret

                ENDP

; scroll de texto

;aqui utilizo una tabla para buscar la letra correspondiente

letras  db 'ABCDEFGHIJKLMNOPQRSTUVWXYZ.,!-',34,':014? 2356789()*',0
bufpos	dw 0			;posicin del buffer visualizada actualmente
textpos dw OFFSET texto 	;posicin en el texto
contpos dw 1			;contador de anchura de una letra...
actlet	dw 0			;letra actual que se est dibujando...

scroll	proc

	mov ax,0a000h		;segmento de video
	mov es,ax

	mov ah,0
	call SetWriteMode

	xor bx,bx
	call SetReset		; el color y la mscara de activacin de color

	mov dx,SC_INDEX
	mov ax,0202h
	out dx,ax

	dec byte ptr cs:[contpos]
	jnz no_new_letter	;mira si es necesaria una nueva letra

	inc word ptr cs:[textpos]

	mov bx,cs:[textpos]
	mov al,[bx]		;si se necesita una nueva letra bscala, excepto
	test al,0ffh		;si es un 0...que indica que es el final del
	jnz no_restart		;scroll...

	mov bx,OFFSET texto	;restaura en ese caso la posicin del scroll
	mov cs:[textpos],bx
	mov al,[bx]

no_restart:
	xor bx,bx
	mov di,OFFSET letras
siu:	cmp al,cs:[di]		;buscas la letra en la tabla para saber su
	je acaba		;posicin real en la fuente...
	inc di
	inc bx
	jmp siu

acaba:  cmp bx,37
        jge car_extendidos
        shl bx,3                ;*8
        add bx,OFFSET font
        jmp normal_car
car_extendidos:
        sub bx,37
        shl bx,3
        add bx,OFFSET font2
normal_car:
        mov cs:[actlet],bx      ;en BX est la posicin real de la letra en la
				;fuente
	mov byte ptr cs:[contpos],8

no_new_letter:
	mov si,OFFSET buffer
	mov cx,6
@@ot_linea:
	cc=39
	REPT 40
		mov al,[si+cc]
		rcl al,1
		mov [si+cc],al
		cc=cc-1
	ENDM

	add si,40
	dec cx
	jnz @@ot_linea

	mov bx,cs:[actlet]	;ahora coge la posicin de la letra
	inc word ptr cs:[actlet]

	mov di,OFFSET buffer	;a esa posicin en el buffer de video...
	add di,39
	mov al,[bx]
        and al,01000000b
        shr al,6
        or [di],al
	mov al,[bx+320]
        and al,01000000b
        shr al,6
        or [di+40],al
	mov al,[bx+320*2]
        and al,01000000b
        shr al,6
        or [di+40*2],al
	mov al,[bx+320*3]
        and al,01000000b
        shr al,6
        or [di+40*3],al
	mov al,[bx+320*4]
        and al,01000000b
        shr al,6
        or [di+40*4],al
	mov al,[bx+320*5]
        and al,01000000b
        shr al,6
        or [di+40*5],al

	mov si,OFFSET buffer		;ahora pasa el buffer intermedio a la
	mov di,[logical]		;memoria de video...
        add di,40*175
	cld

	mov cx,40*6
	rep movsb

	mov ah,3
	call SetWriteMode

	mov bl,01111b
	mov bh,4
	call SetReset		; el color y la mscara de activacin de color

	ret

scroll	endp

; interrupcin de teclado

int09	proc

	push	ax bx ds

	mov ax,data	;segmento de datos
	mov ds,ax

	in al,60h	; lee la tecla

	;haz un strobe del teclado...

	mov bh,al
	in al,61h
	mov ah,al	;el strobe consiste en poner a uno y despus a zero
	or al,80h	;el bit de ms peso del registro de control del
	out 61h,al	;controlador del teclado
	xchg ah,al
	out 61h,al

	;comprueba si es un escape...

	dec	bh
	jnz	npres	 ;si no hay escape no hagas nada...

	mov	byte ptr [Escape],1  ;si hay escape indcalo...
npres:

	;EOI

	mov	al,20h
	out	20h,al

	pop	ds bx ax

	iret	      ;vuelve a donde estaba...

	oldint09	dd	0

int09	endp

; interrupcin de reloj

int08	proc

	push ax ds

	mov ax,data
	mov ds,ax

        inc word ptr [Xan]
	and word ptr [Xan],1ffh
        inc word ptr [Yan]
	and word ptr [Yan],1ffh
        inc word ptr [Zan]
	and word ptr [Zan],1ffh

	;EOI

	mov	al,20h
	out	20h,al

	pop ds ax

	iret	      ;vuelve a donde estaba...

	oldint08	dd	0

int08	endp

; pon la paleta apropiada

SetPaleta PROC
	  push ds es

	  mov ax,ds
	  mov es,ax
	  mov ax,1002h
	  lea dx,paltable
	  int 10h

	  pop es ds

	  mov dx,3c8h
	  xor al,al
	  out dx,al
	  inc dx
	  mov si,OFFSET paleta
	  mov cx,768
@@nn:	  mov al,[si]
	  inc si
	  out dx,al
	  jmp $+2
	  dec cx
	  jnz @@nn

	  ret
	  ENDP

; Borra la paleta

ClearPal  PROC NEAR

	  mov dx,3c8h
	  xor al,al
	  out dx,al
	  jmp $+2
	  inc dx
	  mov cx,768
@@cl2:	  xor al,al
	  out dx,al
	  jmp $+2
	  loop @@cl2
	  ret

	  ENDP

; inicializa la pantalla

InitScreen	PROC NEAR

		mov ax,SCREEN_SEG
		mov es,ax

		mov [rcol],2
		mov [oomin_y],10
		mov [oomax_y],190
		mov [oomin_x],0
		mov [oomax_x],319
		rectangle
		mov [rcol],1
		mov [oomin_y],11
		mov [oomax_y],189
		mov [oomin_x],0
		mov [oomax_x],319
		rectangle

		mov dx,SC_INDEX
		mov ax,0f02h
		out dx,ax

		mov bl,01111b
		mov bh,4
		call SetReset		; el color y la mscara de activacin de color

		mov si,OFFSET dibujo
                add si,160*5
                mov di,[logical]
                add di,40*10

		mov cx,125
@@sig_linea:	mov dx,40
@@sig_byte:	mov al,[si]
		mov bl,es:[di]
		mov es:[di],al
		inc si
		inc di
		dec dx
		jnz @@sig_byte

		add si,120
		dec cx
		jnz @@sig_linea


		ret
		ENDP

; Esta es la llamada al driver de msica...

MusicDriver	proc near

MusicPatch	label
	nop
	call	dword ptr cs:[Player]	;llama al driver de msica...
	ret

Player	DW	0,0

		endp

; punto de entrada

start	PROC NEAR

	mov ax,data
	mov ds,ax			;DS apunta a los datos

	; esta es la rutina de deteccin del micro 386...

	pushf
	xor ah,ah
	push ax
	popf
	pushf
	pop ax
	and ah,0f0h
	cmp ah,0f0h
	je detectno386
	popf
	jmp si_386
detectno386:

	;no se ha detectado un 386...
	popf
	mov dx,OFFSET error		;pon el mensaje de error
	mov ah,9
	int 21h
	mov ah,04ch			;vuelve al DOS...
	int 21h
si_386:

	; Inicializa las rutinas de msica

	mov	ax, data		;segmento del driver de msica...
	mov	cs:Player[2], ax

	push	ds

	push	cs
	pop	ds

	mov	ah, 6			;inicializa el driver de msica...
	call	MusicDriver

	jnc	InitializedOk		;se ha encontrado la tarjeta de sonido

	;si no se inicializ bien la msica pon un RET para que las prximas
	;llamadas al driver vuelvan sin hacer nada...

	mov	byte ptr cs:[MusicPatch], 0C3h

InitializedOk:
	;Inicializa la msica...
	mov	ah, 0				;funcin 0: inicializa msica
	mov	bx, data			;segmento de la msica
	mov	cx, MusicOffset 		;offset de la msica
	call	MusicDriver

	mov	ah, 2
	mov	bx, 0				;esto sirve para algo...
	call	MusicDriver			;pero no s para que...

	pop	ds


	cli

	;pon la frecuencia apropiada en el timer (55 hz's)

	mov	dx,0012h		;1193000 en dx:ax
	mov	ax,34DCh
        mov     cx,110                  ;frecuencia del timer...
	div	cx			;ahora calculamos los datos para el
	mov	bx,ax

	mov	al,54
	out	43h,al
	mov	al,bl
	out	40h,al
	mov	al,bh			;pon la frecuencia apropiada en el timer
	out	40h,al

	;Salva la anterior interrupcin...

	xor	ax,ax
	mov	es,ax
	mov	di,8*4			;cambia el vector de interrupcin
	mov	bx,es:[di]		;de la IRQ 0,1, salvndolo
	mov	si,es:[di+2]		;previamente en variables de apoyo...
	mov	word ptr cs:[oldint08],bx
	mov	word ptr cs:[oldint08+2],si
	mov	bx,es:[di+4]
	mov	si,es:[di+6]
	mov	word ptr cs:[oldint09],bx
	mov	word ptr cs:[oldint09+2],si

	;pon la nueva interrupcin...

	mov	di,8*4
	mov	word ptr es:[di],OFFSET int08
	mov	word ptr es:[di+2],SEG int08
	mov	word ptr es:[di+4],OFFSET int09
	mov	word ptr es:[di+6],SEG int09

	sti


	mov ax,0dh
	int 10h 	      ; inicia modo 320x200x16 colores

	mov ah,3
	call SetWriteMode     ; modo de escritura nmero 3

	call ClearPal	      ; borra la paleta

	mov [logical],0       ; inicializa el grfico inicial
	call InitScreen
	mov [logical],16000
	call InitScreen
	mov [logical],0       ; restablece el valor inicial

	; el primer borrado del objeto no ha de ser tal

	mov [oomin_y],30
	mov [oomax_y],30
	mov [oomin_x],0
	mov [oomax_x],0

	call SetPaleta	      ; inicializa la paleta

	mov [escape],0
keypressed:
	call FlipPages
	call Vsync

	mov ah, 3
	call MusicDriver	     ;llama a la rutina de msica...
	call scroll		     ;scroll de texto

	call DoShades		     ;rutina de sombras

	mov ax,SCREEN_SEG
	mov es,ax

	call DrawObject

	;espera que se pulse una tecla

	test	[escape],0ffh
	jz	keypressed

	;Restaura la interrupcin anterior...

	cli				;fuera interrupciones...
	xor	ax,ax
	mov	es,ax
	mov	di,8*4			;posicin de la IRQ 0
	mov	si,OFFSET oldint08
	mov	ax,cs:[si]
	mov	es:[di],ax
	mov	ax,cs:[si+2]
	mov	es:[di+2],ax
	mov	si,OFFSET oldint09
	mov	ax,cs:[si]
	mov	es:[di+4],ax
	mov	ax,cs:[si+2]
	mov	es:[di+6],ax

	;pon el timer a la frecuencia inicial

	mov	al,36h			;restaura el valor inicial del timer
	out	43h,al			;del reloj del PC
	xor	ax,ax
	out	40h,al
	mov	al,ah
	out	40h,al

	sti

	;apaga la msica...

	mov	ah, 2
	mov	bx, 0
	call	MusicDriver		;apaga la msica...

	mov ax,3			; restaura el modo de texto...
	int 10h

        mov dx,OFFSET endtext
        mov ah,9
        int 21h

        call writeend

	mov ah,4ch
	int 21h 			;vuelve al DOS...

	ENDP

; Final del programa

code	ENDS
	END start
