'
'Written by: Yann/Iguana
'      Date: 27/9/93
'

	PI2 = 2 * 3.131593
       
	NumTags = 200
	SamplePoints = NumTags + 1
	Radius = 9.5
	Height = 1.5
       
	DIM PointsArray(SamplePoints, 3)
	DIM SpeedArray(SamplePoints, 3)

	'Calc points' coordinates
	FOR r = 0 TO SamplePoints - 1
		Theta = PI2 * r / SamplePoints
		PointsArray(r, 0) = 256 * Radius * COS(Theta)
		PointsArray(r, 1) = 256 * Radius * SIN(Theta)
		PointsArray(r, 2) = 256 * Height * SIN(4 * Theta)
		SpeedArray(r, 0) = -256 * Radius * SIN(Theta)
		SpeedArray(r, 1) = 256 * Radius * COS(Theta)
		SpeedArray(r, 2) = 4 * 256 * Height * COS(4 * Theta)
		SpeedArray(r, 0) = PointsArray(r, 0) + SpeedArray(r, 0)
		SpeedArray(r, 1) = PointsArray(r, 1) + SpeedArray(r, 1)
		SpeedArray(r, 2) = PointsArray(r, 2) + SpeedArray(r, 2)
	NEXT

	'write the numbers neatly to a file
	KILL "roadm.inc"
	OPEN "roadm.inc" FOR OUTPUT AS 1
	FOR r = 0 TO NumTags - 2
	 PRINT #1, "  DW 0"
	 FOR s = 0 TO 1
	  PRINT #1, "   DW ";
	  PRINT #1, USING "#####"; CINT(PointsArray(r + s, 0));
	  PRINT #1, ",";
	  PRINT #1, USING "#####"; CINT(PointsArray(r + s, 1));
	  PRINT #1, ",";
	  PRINT #1, USING "#####"; 128 + CINT(PointsArray(r + s, 2));
	  PRINT #1, ",";
	  PRINT #1, USING "#####"; CINT(SpeedArray(r + s, 0));
	  PRINT #1, ",";
	  PRINT #1, USING "#####"; CINT(SpeedArray(r + s, 1));
	  PRINT #1, ",";
	  PRINT #1, USING "#####"; 128 + CINT(SpeedArray(r + s, 2))
	 NEXT s
	 PRINT #1, "   DW 100, 1"
	NEXT r
	CLOSE #1



