; **************************************************************************
; 3D FixedPoint (8.8)  Retarded vectors - I got the idea from the PANIC demo
; Jon Beltran de Heredia, Aug'93
; Inspired on code by Bios/<odeaion 1993 Mar-93
; **************************************************************************

	.MODEL	SMALL
	.STACK
; --------------------------------------------------------------------------
; Here we have global data
; --------------------------------------------------------------------------
	.DATA

; These values setup the projection environment
HAng	DW 0
VAng	DW 0
deltaX	DW 0
deltaY	DW 0
deltaZ	DW 200
dPP	DW 200d	; Distance from the viewpoint to the projection plane

; These values model the shape of the object

N_POINTS EQU 8
N_LINES  EQU 8
; Points that compose the object, as from the local coordinate system.
LPoints	DW -50,-50,-50
	DW  50,-50,-50
	DW  50, 50,-50
	DW -50, 50,-50
	DW -50,-50, 50
	DW  50,-50, 50
	DW  50, 50, 50
	DW -50, 50, 50

ObjLines DW 0,1
	DW 1,2
	DW 2,3
	DW 3,0
	DW 4,5
	DW 5,6
	DW 6,7
	DW 7,4


; These are calculated by ProjectPoints and F3Dto2D
; Points that compose the object, as from the observer coordinate system.
; We store the projected X and Y coordinates only.
OPoints	DW N_POINTS DUP (0,0)

; Increasing Intensity colors
LineColors DW 1,2,3,4,5,6,7,8

; Nice ( :-? ) goodbye message (well, not so nice as those from Iguana)
ByeText LABEL BYTE
 DB '3D FixedPoint Retarded-Vectors...', 0Dh, 0Ah
 DB 'Coded by Jon Beltran de Heredia - Aug93', 0Dh, 0Ah
 DB 'Got the idea from the PANIC demo', 0Dh, 0Ah
 DB 'Inspired on original code from Bios/<odeaion',0Dh,0Ah
 DB 'Greetings to all dudes in the spanish PC Scene!', 0Dh, 0Ah
 DB 'VSG JMP to:', 0Dh, 0Ah
 DB '  * Jare/Iguana', 0Dh, 0Ah
 DB '  * Bios/<odeaion,',0Dh,0Ah
 DB '  * Aitor Garay (what about our demogroup?)', 0Dh, 0Ah
 DB '  * & to everyone in Fido conferences PROASM_E and R34.DEMOS... keep on it!!!'
 DB '$'

.CODE
; --------------------------------------------------------------------------
; Function to calculate the values for the rotation 3*3 matrix from the
; current values of HAng and VAng.
; --------------------------------------------------------------------------
.DATA
;SinTable created by Jon Beltran de Heredia
;Sines are in 8.8 fixedpoint, from 0 degree to 360+90 degree (in order to
; calculate the cosines with the same table)
SinTbl	LABEL	WORD
dw 0,4,9,13,18,22,27,31,36,40,44,49,53,58,62
dw 66,71,75,79,83,88,92,96,100,104,108,112,116,120,124
dw 128,132,136,139,143,147,150,154,158,161,165,168,171,175,178
dw 181,184,187,190,193,196,199,202,204,207,210,212,215,217,219
dw 222,224,226,228,230,232,234,236,237,239,241,242,243,245,246
dw 247,248,249,250,251,252,253,254,254,255,255,255,256,256,256
dw 256,256,256,256,255,255,255,254,254,253,252,251,250,249,248
dw 247,246,245,243,242,241,239,237,236,234,232,230,228,226,224
dw 222,219,217,215,212,210,207,204,202,199,196,193,190,187,184
dw 181,178,175,171,168,165,161,158,154,150,147,143,139,136,132
dw 128,124,120,116,112,108,104,100,96,92,88,83,79,75,71
dw 66,62,58,53,49,44,40,36,31,27,22,18,13,9,4
dw 0,-4,-9,-13,-18,-22,-27,-31,-36,-40,-44,-49,-53,-58,-62
dw -66,-71,-75,-79,-83,-88,-92,-96,-100,-104,-108,-112,-116,-120,-124
dw -128,-132,-136,-139,-143,-147,-150,-154,-158,-161,-165,-168,-171,-175,-178
dw -181,-184,-187,-190,-193,-196,-199,-202,-204,-207,-210,-212,-215,-217,-219
dw -222,-224,-226,-228,-230,-232,-234,-236,-237,-239,-241,-242,-243,-245,-246
dw -247,-248,-249,-250,-251,-252,-253,-254,-254,-255,-255,-255,-256,-256,-256
dw -256,-256,-256,-256,-255,-255,-255,-254,-254,-253,-252,-251,-250,-249,-248
dw -247,-246,-245,-243,-242,-241,-239,-237,-236,-234,-232,-230,-228,-226,-224
dw -222,-219,-217,-215,-212,-210,-207,-204,-202,-199,-196,-193,-190,-187,-184
dw -181,-178,-175,-171,-168,-165,-161,-158,-154,-150,-147,-143,-139,-136,-132
dw -128,-124,-120,-116,-112,-108,-104,-100,-96,-92,-88,-83,-79,-75,-71
dw -66,-62,-58,-53,-49,-44,-40,-36,-31,-27,-22,-18,-13,-9,-4
dw 0,4,9,13,18,22,27,31,36,40,44,49,53,58,62
dw 66,71,75,79,83,88,92,96,100,104,108,112,116,120,124
dw 128,132,136,139,143,147,150,154,158,161,165,168,171,175,178
dw 181,184,187,190,193,196,199,202,204,207,210,212,215,217,219
dw 222,224,226,228,230,232,234,236,237,239,241,242,243,245,246
dw 247,248,249,250,251,252,253,254,254,255,255,255,256,256,256,256

_sh	DW ?
_sv	DW ?
_ch	DW ?
_cv	DW ?
_shsv	DW ?
_chcv	DW ?
_shcv	DW ?
_chsv	DW ?

.CODE
Calc	PROC
	mov	bx,HAng
	shl	bx,1
	mov	ax,SinTbl[bx]
	mov	_sh,ax
	mov	ax,SinTbl[bx+180]
	mov	_ch,ax
	mov	bx,VAng
	shl	bx,1
	mov	ax,SinTbl[bx]
	mov	_sv,ax
	mov	ax,SinTbl[bx+180]
	mov	_cv,ax
	imul	_ch	
	mov	byte ptr _chcv,ah
	mov	byte ptr _chcv+1,dl
	mov	ax,_sh
	imul	_sv
	mov	byte ptr _shsv,ah
	mov	byte ptr _shsv+1,dl
	mov	ax,_sh
	imul	_cv
	mov	byte ptr _shcv,ah
	mov	byte ptr _shcv+1,dl
	mov	ax,_sv
	imul	_ch
	mov	byte ptr _chsv,ah
	mov	byte ptr _chsv+1,dl
	ret
Calc	ENDP

; --------------------------------------------------------------------------
; Function to project a triad of words, representing the local coordinates
; of a vertex of the object, to obtain the 2D screen coords, usin the
; values for the rotation matrix calculated by the 'Calc' function.
; --------------------------------------------------------------------------
.CODE
F3Dto2D	PROC	; takes word ptr [si],[si+2] and [si+4] as 3D coords, projects
		; 'em and stores 2D projected coords in word ptr [di],[di+2]

	; rotate, move and project...
	lodsw
	imul	_ch
	mov	bx,ax
	lodsw
	neg	ax
	imul	_shsv
	add	bx,ax
	lodsw
	neg	ax
	imul	_shcv
	add	bx,ax
	mov	cl,8
	sar	bx,cl	; must be 'sar' and not 'shr', 'cos it might be neg...
	sub	si,4	; starting with the 'y' coordinate
	lodsw
	imul	_cv
	mov	bp,ax
	lodsw
	neg	ax
	imul	_sv
	add	bp,ax
	mov	cl,8
	sar	bp,cl
	sub	si,6
	lodsw
	imul	_sh
	mov	cx,ax
	lodsw
	imul	_chsv
	add	cx,ax
	lodsw
	imul	_chcv
	add	cx,ax
	mov	cl,8
	sar	cx,cl
	add	cx,deltaZ
	mov	ax,bx
	add	ax,deltaX
	imul	dPP
	idiv	cx
	add	ax,160d		; center in screen
	stosw

	mov	ax,bp
	add	ax,deltaY
	imul	dPP	
	idiv	cx
	neg	ax
	add	ax,100d		; center in screen
	stosw
	ret
F3Dto2D	ENDP

; --------------------------------------------------------------------------
; Function to project the vertices of the object, using the current values
; of HAng and VAng, and store them in OPoints
; --------------------------------------------------------------------------
ProjectPoints PROC
	call	Calc
	mov	si,OFFSET LPoints
	mov	di,OFFSET OPoints
	mov	cx,N_POINTS
L0:	push	cx
	call	F3Dto2D
	pop	cx
	loop	L0
	ret
ProjectPoints ENDP

; --------------------------------------------------------------------------
; Function to draw the lines specified in OPoints.
; Performs the vector-retardin'.
; --------------------------------------------------------------------------
.DATA
; Number of retarded vectors
N_RETARD EQU 7
; Buffers to store the retarded vectors
OldLines0 DW N_LINES DUP (0,0,0,0)
OldLines1 DW N_LINES DUP (0,0,0,0)
OldLines2 DW N_LINES DUP (0,0,0,0)
OldLines3 DW N_LINES DUP (0,0,0,0)
OldLines4 DW N_LINES DUP (0,0,0,0)
OldLines5 DW N_LINES DUP (0,0,0,0)
OldLines6 DW N_LINES DUP (0,0,0,0)
OldLines7 DW N_LINES DUP (0,0,0,0)
OldLinesBuffers	DW OFFSET OldLines0, OFFSET OldLines1
		DW OFFSET OldLines2, OFFSET OldLines3
		DW OFFSET OldLines4, OFFSET OldLines5
		DW OFFSET OldLines6, OFFSET OldLines7
; In which buffer we have to store the next set of lines
StoreNextSet	DW 0

.CODE
DrawLines PROC
	mov	ax,StoreNextSet
	or	ax,ax
	jz	DontDrawStoredOldLines
	call	DrawStoredLines
 DontDrawStoredOldLines:
	mov	di,StoreNextSet
	shl	di,1
	mov	di,OldLinesBuffers[di]	
	mov	cx,N_LINES
	mov	si,OFFSET ObjLines
L1:	push	cx
	lodsw		; Number of first vertex of line
	shl	ax,1
	shl	ax,1
	mov	bx,ax
	mov	ax,OPoints[bx]
	stosw
	mov	x1,ax
	mov	ax,OPoints[bx+2]
	stosw
	mov	y1,ax	
	lodsw		; Num of second vertex of this line
	shl	ax,1
	shl	ax,1	
	mov	bx,ax
	mov	ax,OPoints[bx]
	stosw
	mov	x2,ax
	mov	ax,OPoints[bx+2]
	stosw
	mov	y2,ax	
	mov	ah,BYTE PTR LineColors[7]
	push	bx
	call	Line
	pop	bx
	pop	cx
	loop	L1
	inc	StoreNextSet
	ret
DrawLines ENDP

DrawStoredLines	PROC
	mov	bx,0
 SetsLoop:
	push	bx
	shl	bx,1
	mov	si,OldLinesBuffers[bx]
	mov	cx,N_LINES
L2:	push	cx
	lodsw
	mov	x1,ax
	lodsw
	mov	y1,ax	
	lodsw
	mov	x2,ax
	lodsw
	mov	y2,ax	
	mov	ah,BYTE PTR LineColors[bx]
	push	bx
	call	Line
	pop	bx
	pop	cx
	loop	L2
	pop	bx	; Set number to dump
	inc	bx
	cmp	bx,StoreNextSet
	je	NoMoreSets
	jmp	SetsLoop

 NoMoreSets:
 	ret
DrawStoredLines	ENDP

; --------------------------------------------------------------------------
; Function to erase the lines specified in the retarded-vectors buffers.
; --------------------------------------------------------------------------
EraseLines PROC
	mov	bx,0
 ELSetsLoop:
	push	bx
	shl	bx,1
	mov	si,OldLinesBuffers[bx]
	mov	cx,N_LINES
L3:	push	cx
	lodsw
	mov	x1,ax
	lodsw
	mov	y1,ax	
	lodsw
	mov	x2,ax
	lodsw
	mov	y2,ax	
	mov	ah,0
	push	bx
	call	Line
	pop	bx
	pop	cx
	loop	L3
	pop	bx	; Set number to dump
	inc	bx
	cmp	bx,StoreNextSet
	je	ELNoMoreSets
	jmp	ELSetsLoop
 ELNoMoreSets:
 	ret
EraseLines ENDP

; --------------------------------------------------------------------------
; Function to move the buffered vectors one buffer back, so that they get
; darker and finally disappear. Kind o'fade-out!!
; --------------------------------------------------------------------------
SlideVectors PROC
	cmp	StoreNextSet,N_RETARD
	jne	NotComplete
	mov	si,[OldLinesBuffers+2]
	mov	di,[OldLinesBuffers]
	mov	cx,(OFFSET OldLines7 - OFFSET OldLines0)/2
	rep	movsw
	dec	StoreNextSet
 NotComplete:
 	ret
SlideVectors ENDP


; --------------------------------------------------------------------------
; Line drawing code by Michael Abrash, from Dr. Dobb's Journal, Dec'92
; --------------------------------------------------------------------------
; Input: AH is the color, coors are in the following vars
.DATA
x1	DW ?
x2	DW ?
y1	DW ?
y2	DW ?
.CODE
SCREEN_SEGMENT EQU 0A000h
color	DB ?
SCREEN_WIDTH EQU 320d
; Local variables.
AdjUp   equ -2  ;error term adjust up on each advance
AdjDown equ -4  ;error term adjust down when error term turns over
WholeStep equ   -6      ;minimum run length
XAdvance equ    -8      ;1 or -1, for direction in which X advances
LOCAL_SIZE equ  8
Line	PROC		; draws a line WITHOUT CLIPPING, so beware!
    mov color,ah
    push    bp  ;preserve caller's stack frame
    mov bp,sp   ;point to our stack frame
    sub sp,LOCAL_SIZE   ;allocate space for local variables
    push    si  ;preserve C register variables
    push    di
    push    ds  ;preserve caller's DS
    push    es
; We'll draw top to bottom, to reduce the number of cases we have to handle,
; and to make lines between the same endpoints always draw the same pixels.
    mov ax,y1
    cmp ax,y2
    jle LineIsTopToBottom
    xchg y2,ax    ;swap endpoints
    mov y1,ax  
    mov bx,x1
    xchg x2,bx
    mov x1,bx  
LineIsTopToBottom:
; Point DI to the first pixel to draw.
    mov dx,SCREEN_WIDTH
    mul dx              ;YStart * SCREEN_WIDTH
    mov si,x1
    mov di,si
    add di,ax           ;DI = YStart * SCREEN_WIDTH + XStart
                ; = offset of initial pixel
; Figure out how far we're going vertically (guaranteed to be positive).
    mov cx,y2
    sub cx,y1  ;CX = YDelta
; Figure out whether we're going left or right, and how far we're going
; horizontally. In the process, special-case vertical lines, for speed and
; to avoid nasty boundary conditions and division by 0.
    mov dx,x2
    sub dx,si       ;XDelta
    jnz NotVerticalLine ;XDelta == 0 means vertical line
                ;it is a vertical line
                ;yes, special case vertical line
    mov ax,SCREEN_SEGMENT
    mov ds,ax           ;point DS:DI to the first byte to draw
    mov al,color
VLoop:
    mov [di],al
    add di,SCREEN_WIDTH
    dec cx
    jns VLoop
    jmp Done
; Special-case code for horizontal lines.
    align   2
IsHorizontalLine:
    mov ax,SCREEN_SEGMENT
    mov es,ax           ;point ES:DI to the first byte to draw
    mov al,color
    mov ah,al       ;duplicate in high byte for word access
    and bx,bx   ;left to right?
    jns DirSet  ;yes
    sub di,dx   ;currently right to left, point to left end so we
            ; can go left to right (avoids unpleasantness with
            ; right to left REP STOSW)
DirSet:
        mov     cx,dx
        inc     cx      ;# of pixels to draw
    shr cx,1    ;# of words to draw
    rep stosw   ;do as many words as possible
    adc cx,cx
    rep stosb   ;do the odd byte, if there is one
    jmp Done
; Special-case code for diagonal lines.
    align   2
IsDiagonalLine:
    mov ax,SCREEN_SEGMENT
    mov ds,ax           ;point DS:DI to the first byte to draw
    mov al,color
    add bx,SCREEN_WIDTH ;advance distance from one pixel to next
DLoop:
    mov [di],al
    add di,bx
    dec cx
    jns DLoop
    jmp Done

    align   2
NotVerticalLine:
    mov bx,1        ;assume left to right, so XAdvance = 1
                ;***leaves flags unchanged***
    jns LeftToRight ;left to right, all set
    neg bx      ;right to left, so XAdvance = -1
    neg dx      ;|XDelta|
LeftToRight:
; Special-case horizontal lines.
    and cx,cx   ;YDelta == 0?
    jz  IsHorizontalLine ;yes
; Special-case diagonal lines.
    cmp cx,dx   ;YDelta == XDelta?
    jz  IsDiagonalLine ;yes
; Determine whether the line is X or Y major, and handle accordingly.
        cmp     dx,cx
        jae     XMajor
        jmp     YMajor
; X-major (more horizontal than vertical) line.
        align   2
XMajor:
    mov ax,SCREEN_SEGMENT
    mov es,ax           ;point ES:DI to the first byte to draw
        and     bx,bx           ;left to right?
        jns     DFSet           ;yes, CLD is already set
        std                     ;right to left, so draw backwards
DFSet:
        mov     ax,dx           ;XDelta
        sub     dx,dx           ;prepare for division
        div     cx              ;AX = XDelta/YDelta
                                ; (minimum # of pixels in a run in this line)
                                ;DX = XDelta % YDelta
        mov     bx,dx           ;error term adjust each time Y steps by 1;
        add     bx,bx           ; used to tell when one extra pixel should be
        mov     [bp].AdjUp,bx   ; drawn as part of a run, to account for
                                ; fractional steps along the X axis per
                                ; 1-pixel steps along Y
        mov     si,cx           ;error term adjust when the error term turns
        add     si,si           ; over, used to factor out the X step made at
        mov     [bp].AdjDown,si ; that time
; Initial error term; reflects an initial step of 0.5 along the Y axis.
        sub     dx,si           ;(XDelta % YDelta) - (YDelta * 2)
                                ;DX = initial error term
; The initial and last runs are partial, because Y advances only 0.5 for
; these runs, rather than 1. Divide one full run, plus the initial pixel,
; between the initial and last runs.
        mov     si,cx           ;SI = YDelta
        mov     cx,ax           ;whole step (minimum run length)
        shr     cx,1
        inc     cx              ;initial pixel count = (whole step / 2) + 1;
                                ; (may be adjusted later). This is also the
                ; final run pixel count
        push    cx              ;remember final run pixel count for later
; If the basic run length is even and there's no fractional advance, we have
; one pixel that could go to either the initial or last partial run, which
; we'll arbitrarily allocate to the last run.
; If there is an odd number of pixels per run, we have one pixel that can't
; be allocated to either the initial or last partial run, so we'll add 0.5 to
; the error term so this pixel will be handled by the normal full-run loop.
        add     dx,si           ;assume odd length, add YDelta to error term
                ; (add 0.5 of a pixel to the error term)
        test    al,1            ;is run length even?
        jnz     XMajorAdjustDone ;no, already did work for odd case, all set
        sub     dx,si           ;length is even, undo odd stuff we just did
        and     bx,bx           ;is the adjust up equal to 0?
        jnz     XMajorAdjustDone ;no (don't need to check for odd length,
                 ; because of the above test)
        dec     cx              ;both conditions met; make initial run 1
                                ; shorter
XMajorAdjustDone:
        mov     [bp].WholeStep,ax ;whole step (minimum run length)
        mov     al,color   ;AL = drawing color
; Draw the first, partial run of pixels.
        rep     stosb           ;draw the final run
        add     di,SCREEN_WIDTH ;advance along the minor axis (Y)
; Draw all full runs.
        cmp     si,1            ;are there more than 2 scans, so there are
                ; some full runs? (SI = # scans - 1)
        jna     XMajorDrawLast  ;no, no full runs
        dec     dx              ;adjust error term by -1 so we can use
                                ; carry test
        shr     si,1            ;convert from scan to scan-pair count
        jnc     XMajorFullRunsOddEntry  ;if there is an odd number of scans,
                                        ; do the odd scan now
XMajorFullRunsLoop:
        mov     cx,[bp].WholeStep ;run is at least this long
        add     dx,bx           ;advance the error term and add an extra
        jnc     XMajorNoExtra   ; pixel if the error term so indicates
        inc     cx              ;one extra pixel in run
        sub     dx,[bp].AdjDown ;reset the error term
XMajorNoExtra:
    rep     stosb           ;draw this scan line's run
        add     di,SCREEN_WIDTH ;advance along the minor axis (Y)
XMajorFullRunsOddEntry:         ;enter loop here if there is an odd number
                                ; of full runs
        mov     cx,[bp].WholeStep ;run is at least this long
        add     dx,bx           ;advance the error term and add an extra
        jnc     XMajorNoExtra2  ; pixel if the error term so indicates
        inc     cx              ;one extra pixel in run
        sub     dx,[bp].AdjDown ;reset the error term
XMajorNoExtra2:
    rep     stosb           ;draw this scan line's run
        add     di,SCREEN_WIDTH ;advance along the minor axis (Y)

        dec     si
        jnz     XMajorFullRunsLoop
; Draw the final run of pixels.
XMajorDrawLast:
        pop     cx              ;get back the final run pixel length
        rep     stosb           ;draw the final run

        cld                     ;restore normal direction flag
        jmp     Done
; Y-major (more vertical than horizontal) line.
        align   2
YMajor:
        mov     [bp].XAdvance,bx ;remember which way X advances
    mov ax,SCREEN_SEGMENT
    mov ds,ax           ;point DS:DI to the first byte to draw
        mov     ax,cx           ;YDelta
        mov     cx,dx           ;XDelta
        sub     dx,dx           ;prepare for division
        div     cx              ;AX = YDelta/XDelta
                                ; (minimum # of pixels in a run in this line)
                                ;DX = YDelta % XDelta
        mov     bx,dx           ;error term adjust each time X steps by 1;
        add     bx,bx           ; used to tell when one extra pixel should be
        mov     [bp].AdjUp,bx   ; drawn as part of a run, to account for
                                ; fractional steps along the Y axis per
                                ; 1-pixel steps along X
        mov     si,cx           ;error term adjust when the error term turns
        add     si,si           ; over, used to factor out the Y step made at
        mov     [bp].AdjDown,si ; that time

; Initial error term; reflects an initial step of 0.5 along the X axis.
        sub     dx,si           ;(YDelta % XDelta) - (XDelta * 2)
                                ;DX = initial error term
; The initial and last runs are partial, because X advances only 0.5 for
; these runs, rather than 1. Divide one full run, plus the initial pixel,
; between the initial and last runs.
        mov     si,cx           ;SI = XDelta
        mov     cx,ax           ;whole step (minimum run length)
        shr     cx,1
        inc     cx              ;initial pixel count = (whole step / 2) + 1;
                                ; (may be adjusted later)
        push    cx              ;remember final run pixel count for later

; If the basic run length is even and there's no fractional advance, we have
; one pixel that could go to either the initial or last partial run, which
; we'll arbitrarily allocate to the last run.
; If there is an odd number of pixels per run, we have one pixel that can't
; be allocated to either the initial or last partial run, so we'll add 0.5 to
; the error term so this pixel will be handled by the normal full-run loop.
        add     dx,si           ;assume odd length, add XDelta to error term
        test    al,1            ;is run length even?
        jnz     YMajorAdjustDone ;no, already did work for odd case, all set
        sub     dx,si           ;length is even, undo odd stuff we just did
        and     bx,bx           ;is the adjust up equal to 0?
        jnz     YMajorAdjustDone ;no (don't need to check for odd length,
                 ; because of the above test)
        dec     cx              ;both conditions met; make initial run 1
                                ; shorter
YMajorAdjustDone:
        mov     [bp].WholeStep,ax ;whole step (minimum run length)
        mov     al,color          ;AL = drawing color
        mov     bx,[bp].XAdvance  ;which way X advances
; Draw the first, partial run of pixels.
YMajorFirstLoop:
        mov     [di],al         ;draw the pixel
        add     di,SCREEN_WIDTH ;advance along the major axis (Y)
        dec     cx
        jnz     YMajorFirstLoop
        add     di,bx           ;advance along the minor axis (X)
; Draw all full runs.
        cmp     si,1            ;# of full runs. Are there more than 2
                ; columns, so there are some full runs?
                ; (SI = # columns - 1)
        jna     YMajorDrawLast  ;no, no full runs
        dec     dx              ;adjust error term by -1 so we can use
                                ; carry test
        shr     si,1            ;convert from column to column-pair count
        jnc     YMajorFullRunsOddEntry  ;if there is an odd number of
                                        ; columns, do the odd column now
YMajorFullRunsLoop:
        mov     cx,[bp].WholeStep ;run is at least this long
        add     dx,[bp].AdjUp   ;advance the error term and add an extra
        jnc     YMajorNoExtra   ; pixel if the error term so indicates
        inc     cx              ;one extra pixel in run
        sub     dx,[bp].AdjDown ;reset the error term
YMajorNoExtra:
                                ;draw the run
YMajorRunLoop:
        mov     [di],al         ;draw the pixel
        add     di,SCREEN_WIDTH ;advance along the major axis (Y)
        dec     cx
        jnz     YMajorRunLoop
        add     di,bx           ;advance along the minor axis (X)
YMajorFullRunsOddEntry:         ;enter loop here if there is an odd number
                                ; of full runs
        mov     cx,[bp].WholeStep ;run is at least this long
        add     dx,[bp].AdjUp   ;advance the error term and add an extra
        jnc     YMajorNoExtra2  ; pixel if the error term so indicates
        inc     cx              ;one extra pixel in run
        sub     dx,[bp].AdjDown ;reset the error term
YMajorNoExtra2:
                                ;draw the run
YMajorRunLoop2:
        mov     [di],al         ;draw the pixel
        add     di,SCREEN_WIDTH ;advance along the major axis (Y)
        dec     cx
        jnz     YMajorRunLoop2
        add     di,bx           ;advance along the minor axis (X)

        dec     si
        jnz     YMajorFullRunsLoop
; Draw the final run of pixels.
YMajorDrawLast:
        pop     cx              ;get back the final run pixel length
YMajorLastLoop:
        mov     [di],al         ;draw the pixel
        add     di,SCREEN_WIDTH ;advance along the major axis (Y)
        dec     cx
        jnz     YMajorLastLoop
Done:
    pop es
    pop ds  ;restore caller's DS
    pop di
    pop si  ;restore C register variables
    mov sp,bp   ;deallocate local variables
    pop bp  ;restore caller's stack frame
    ret
Line	ENDP

; --------------------------------------------------------------------------
; Function to initialize the DAC palette RGB values.
; --------------------------------------------------------------------------
.DATA
Paleta LABEL BYTE
	I = 0
	REPT N_RETARD+1
	 I = I + (63/N_RETARD-1)
	 DB I,0,0
	ENDM

.CODE
InitPal PROC
	cli
	mov	dx,3C8h
	mov	al,1
	out	dx,al
	inc	dx
	mov	si,OFFSET Paleta
	mov	cx,1+N_RETARD
    L4:	lodsb
    	out	dx,al
	lodsb
	out	dx,al
	lodsb
	out	dx,al
	loop	L4
	sti
	ret
InitPal	ENDP

; **************************************************************************
; **************************************************************************
;  At last, here we have the main loop (this looks like Pascal, doesn't it?).
;  OK, I can imagine nothing interesting or funny to write 'ere.
; **************************************************************************
; **************************************************************************
.DATA
	IncDZ DW ?
.CODE
Main	PROC
	cld
	mov	ax,@DATA
	mov	ds,ax
	mov	es,ax
	mov	ax,13h
	int	10h
	call	InitPal
	mov	IncDZ,5
	mov	cx,10
OutLoop:push	cx
	mov	ax,0	
MLoop:	mov	HAng,ax
	push	ax
	call	ProjectPoints
	call	DrawLines
	mov	dx,3DAh
WaitVR1:in	al,dx
	and	al,8
	jz	WaitVR1
WaitDE: in	al,dx
	and	al,1
	jnz	WaitDE
WaitVR2:in	al,dx
	and	al,8
	jz	WaitVR2
	call	EraseLines
	call	SlideVectors
	pop	ax
	add	ax,5
	add	VAng,5
	mov	bx,incDZ
	add	deltaZ,bx
	cmp	ax,360d
	jnae	MLoop
	mov	HAng,0
	mov	VAng,0
	pop	cx
	neg	IncDZ
	loop	OutLoop

	mov	ax,3
	int	10h
	mov	ah,9
	mov	dx,offset ByeText
	int	21h
	mov	ax,4C00h
	int	21h
Main	ENDP

	END	Main