/*
	PATOUT.C

	GUS PAT output Version 1.00

		Programmed by Syuichi.Ogasawara
			Copyright 1993 Sigma,Inc.

	code based on EXAMPLE.C from GUS SDK V2.01
	must compile with config.c from GUS SDK V2.01

*/
#define __WATCOMC__ 0

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h> 
#include <dos.h>

#include <malloc.h>
#define close _dos_close

/********** Include files from GUS SDK V2.01 **********/
#include "forte.h"
#include "gf1proto.h"
#include "extern.h"
#include "ultraerr.h"

int fd;
unsigned int temp_val;

/* PAT header variables */

char			header[13] = {"           "};
char			gravis_id[11] = {"         "};;
char			description[60];
unsigned char	instruments;
char			voices;
char			channels;
unsigned int	wave_forms;
unsigned int	master_volume;
unsigned long	data_size;

unsigned int	instrument;
char			instrument_name[17] = {"                "};
long			instrument_size;
char			layers;

char			layer_duplicate;
char			layer;
long			layer_size;
char			samples;

char			wave_name[8] = {"       "};
unsigned char	fractions;
long			wave_size;
long			start_loop;
long			end_loop;
unsigned int	sample_rate;
long			low_frequency;
long			high_frequency;
long			root_frequency;
int				tune;
unsigned char	balance;
unsigned char	envelope_rate[6];
unsigned char	envelope_offset[6];
unsigned char	tremolo_sweep;
unsigned char	tremolo_rate;
unsigned char	tremolo_depth;
unsigned char	vibrato_sweep;
unsigned char	vibrato_rate;
unsigned char	vibrato_depth;
char			modes;
int				scale_frequency;
unsigned int	scale_factor;

/* Dummy buffer */
char			cdat[64];

/* GUS SDK Version */
int *mjv,*mnv;

main(argc,argv)
int argc;
char **argv;
{
unsigned char control;
void *data_ptr;
int temp;
int voice_num = 0;		/* examples use voice #0 */
unsigned long dram_loc;
ULTRA_CFG config;

	printf("\n");

	if(argc != 2) {
		printf("PAT output to GUS version 1.00\n");
		printf("  usage : PATOUT filename.PAT\n");
		exit(0);
		}

	/* Get the ULTRASND environment string parameters */
	UltraGetCfg(&config);

	if (UltraProbe(config.base_port) == NO_ULTRA)
		{
		printf("No card found\n");
		exit(-1);
		}

	if (UltraOpen(&config,32) == NO_ULTRA)
		{
		printf("No card found\n");
		exit(-1);
		}

	/* Get SDK Version */
/*	UltraVersion(mjv,mnv); */
/*	printf("GUS SDK Version : %d.%d\n",*mjv,*mnv); */

	/** Reset GUS **/
	temp = UltraGetOutput();
	UltraDisableOutput();
	UltraReset(32);
	if (temp)
		UltraEnableOutput();

	/** Read Sample **/
	_dos_open(argv[1],O_RDONLY|O_BINARY,&fd);
	if (fd == -1)
		{
		printf("Can't open file\n");
		done();
		}
	
	readheader();

	strcpy(cdat,&header[8]);
	header[8] = '\0';
	if(strcmp(header,"GF1PATCH")) {
		printf("Invalid PAT Header\n");
		done();
		}

	if(strcmp(gravis_id,"ID#000002")) {
		printf("Invalid gravis_id\n");
		done();
		}

	printf("File name       : %s\n",argv[1]);
	printf("PAT version     : %s\n",cdat);
	for(temp = 0; temp < 60; temp++) {
		if(description[temp] == '\0') break;
		if(description[temp] < (char)0x20 || description[temp] >= (char)0x7f) description[temp] = ' ';
		}
	printf("Description     : %s\n",description);
	if(instruments > 1) printf("\nThis is multi instruments file.\n\n");
/*	if(wave_forms > 1) printf("\nMultiple wave forms in this file.\n\n"); */
	printf("Instrument name : \"%s\"\n",instrument_name);
	if(layers > 1) printf("\nMultiple layers in this instrument (not supported)\n");
/*	if(samples > 1) printf("\nMultiple samples in this instrument\n"); */
	printf("\nPress any key to continue\n\n");

	while(samples) {
		samples--;
		readshead();

		printf("Wave            : \"%s\", %5u Hz, %5lu bytes (%1.2f sec) ",wave_name,sample_rate,wave_size,(float)((float)wave_size*(float)(1.0/(float)sample_rate)));

		if(wave_size > 65536L) {
			printf("\nYou cannot download over 64K wave.\n");
			done();
			}
		data_ptr = malloc((unsigned int)wave_size);

		if (data_ptr == NULL)
			{
			printf("\nMemory Full\n");
			close(fd);
			done();
			}
		_dos_read(fd,data_ptr,(unsigned int)wave_size,&temp_val);
		if (temp_val != (unsigned int)wave_size)
			{
			printf("\nRead failure %d\n",temp_val);
			free(data_ptr);
			close(fd);
			done();
			}

		dram_loc = 0L;
		control = 0;

		if (modes & (char)0x01) control |= DMA_16;

		if (modes & (char)0x02)	control |= DMA_CVT_2;

		UltraDownload(data_ptr,control,dram_loc,(unsigned int)wave_size,TRUE);
		free(data_ptr);

		/** Note On **/
		control = 0;

		if(modes & 0x04) control |= 0x08;
		if(modes & 0x08) control |= 0x10;

		if (modes & (char)0x01) control |= 0x04;

		UltraSetLinearVolume(voice_num,256);
/*		UltraSetFrequency(voice_num,sample_rate); */
		UltraSetBalance(voice_num,(int)balance);
		UltraVoiceOn(voice_num,0L,start_loop,end_loop,control,sample_rate);

		/** Wait **/
/*		printf("\nPress Any Key to Stop .... "); */
		if(control & (unsigned char)0x18) getch();
		printf("\n");

		/** Note Off **/
		/* This could be used to change the end point and let the sample */
		/* stop at end (sampled decay.... ) */
		control &= (unsigned char)0xe7;
		UltraSetVoiceEnd(voice_num,(unsigned int)wave_size);
		UltraSetLoopMode(voice_num,control);
		UltraVoiceOff(voice_num,(unsigned int)wave_size);
		while(!UltraVoiceStopped(voice_num)) printf(" \010");
	}
	close(fd);

	/** Done **/
	done();
}

done()
{
	/* Shut sound down & re-init hardware ... */
	UltraClose();
	exit(0);
}

readheader()
{
	_dos_read(fd,(char *)header,12,&temp_val);
	_dos_read(fd,(char *)gravis_id,10,&temp_val);
	_dos_read(fd,(char *)description,60,&temp_val);
	_dos_read(fd,(char *)&instruments,1,&temp_val);
	_dos_read(fd,(char *)&voices,1,&temp_val);
	_dos_read(fd,(char *)&channels,1,&temp_val);
	_dos_read(fd,(char *)&wave_forms,2,&temp_val);
	_dos_read(fd,(char *)&master_volume,2,&temp_val);
	_dos_read(fd,(char *)&data_size,4,&temp_val);
	_dos_read(fd,(char *)cdat,36,&temp_val);

	_dos_read(fd,(char *)&instrument,2,&temp_val);
	_dos_read(fd,(char *)instrument_name,16,&temp_val);
	_dos_read(fd,(char *)&instrument_size,4,&temp_val);
	_dos_read(fd,(char *)&layers,1,&temp_val);
	_dos_read(fd,(char *)cdat,40,&temp_val);

	_dos_read(fd,(char *)&layer_duplicate,1,&temp_val);
	_dos_read(fd,(char *)&layer,1,&temp_val);
	_dos_read(fd,(char *)&layer_size,4,&temp_val);
	_dos_read(fd,(char *)&samples,1,&temp_val);
	_dos_read(fd,(char *)cdat,40,&temp_val);
}

readshead()
{
	_dos_read(fd,(char *)wave_name,7,&temp_val);
	_dos_read(fd,(char *)&fractions,1,&temp_val);
	_dos_read(fd,(char *)&wave_size,4,&temp_val);
	_dos_read(fd,(char *)&start_loop,4,&temp_val);
	_dos_read(fd,(char *)&end_loop,4,&temp_val);
	_dos_read(fd,(char *)&sample_rate,2,&temp_val);
	_dos_read(fd,(char *)&low_frequency,4,&temp_val);
	_dos_read(fd,(char *)&high_frequency,4,&temp_val);
	_dos_read(fd,(char *)&root_frequency,4,&temp_val);
	_dos_read(fd,(char *)&tune,2,&temp_val);
	_dos_read(fd,(char *)&balance,1,&temp_val);
	_dos_read(fd,(char *)envelope_rate,6,&temp_val);
	_dos_read(fd,(char *)envelope_offset,6,&temp_val);
	_dos_read(fd,(char *)&tremolo_sweep,1,&temp_val);
	_dos_read(fd,(char *)&tremolo_rate,1,&temp_val);
	_dos_read(fd,(char *)&tremolo_depth,1,&temp_val);
	_dos_read(fd,(char *)&vibrato_sweep,1,&temp_val);
	_dos_read(fd,(char *)&vibrato_rate,1,&temp_val);
	_dos_read(fd,(char *)&vibrato_depth,1,&temp_val);
	_dos_read(fd,(char *)&modes,1,&temp_val);
	_dos_read(fd,(char *)&scale_frequency,2,&temp_val);
	_dos_read(fd,(char *)&scale_factor,2,&temp_val);
	_dos_read(fd,(char *)cdat,36,&temp_val);
}

