// -------------------------------------------------------------
// Copyright (c) 2003 - 2004 Wolfgang F. Engel (wolf@direct3d.net)
// All rights reserved.
// -------------------------------------------------------------

// -------------------------------------------------------------
// variables that are provided by the application
// -------------------------------------------------------------
float4x4 matWorldViewProj;	
float4x4 matWorld;	
float4 vecEye;
texture		txScene;


texture CubeMap;
samplerCUBE CubeMapSampler = sampler_state
{
   Texture = <CubeMap>;
   MinFilter = Linear;
   MagFilter = Linear;
   AddressU  = Clamp;
   AddressV  = Clamp;
   AddressW  = Clamp;   
};

texture CubeFaceMap;
sampler2D CubeFaceSampler = sampler_state
{
   Texture = <CubeFaceMap>;
   MinFilter = Linear;
   MagFilter = Linear;
   AddressU  = Clamp;
   AddressV  = Clamp;
};
// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUTSKYBOX
{
    float4 Pos		: POSITION;
	float3 Normal	: TEXCOORD0;	
	float2 Tex		: TEXCOORD1;	
	float3 Light	: TEXCOORD2;
};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUTSKYBOX VSSkybox(float4 Pos : POSITION, float3 Normal : NORMAL, float2 Tex : TEXCOORD0)
{
    VS_OUTPUTSKYBOX Out = (VS_OUTPUTSKYBOX)0;      
    Out.Pos = mul(Pos, matWorldViewProj);	// transform Position
 
	Out.Tex = Tex;
	
   return Out;
}

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------
float4 PSSkybox(float3 Norm : TEXCOORD0, 
				float2 Tex : TEXCOORD1,
				float3 Light : TEXCOORD2) : COLOR
{
    return tex2D( CubeFaceSampler, Tex );
}


// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float3 Incident : TEXCOORD0;
    float3 Norm : TEXCOORD1;
    float3 PosAdj : TEXCOORD2;
    float2 Tex : TEXCOORD3;
};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUT VS(float4 Pos : POSITION, float2 Tex : TEXCOORD, float3 Normal : NORMAL)
{
    VS_OUTPUT Out = (VS_OUTPUT)0;      
    
    Out.Pos = mul(Pos, matWorldViewProj);	// transform Position
    Out.Norm = mul(Normal, matWorld);
   
    // get a vector toward the camera/eye -> V
    float3 PosWorld  = normalize(mul(Pos, matWorld));
    //Out.Incident = normalize(PosWorld  - vecEye);
    
	float OneThroughRadius = 10.0f;      
    Out.PosAdj = PosWorld * OneThroughRadius;  
    Out.Tex = Tex;   
    
   return Out;
}

sampler  g_samScene =
sampler_state
{
    Texture = <txScene>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Point;
};

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------
float4 PS(VS_OUTPUT input) : COLOR
{

float3 Incident = input.Incident;
float3 Norm = input.Norm; 
float3 PosAdj = input.PosAdj;
float2 Tex = input.Tex;

	// direction of light from sky
	const float3 DirFromSky = {0.0f, 1.0f, 1.0f};   
	const float4 ModelColor = { 1.0f, 1.0f, 1.0f, 1.0f}; 
	const float4 GroundColor = { 0.3f, 0.3f, 0.3f, 1.0f};
	const float HemiIntensity = {0.9f};
	const float EnvIntensity = {0.1f};
	const float Occlusion = {0.65f};
	
	float3 N = normalize(Norm);
	float3 I = normalize(Incident);

	float3 ref = reflect(I, N);
	float3 coord = PosAdj + ref;
	float4 EnvColor = texCUBE(CubeMapSampler, coord); 
	
//    float4 temp = HemiIntensity * lerp(GroundColor, ModelColor, ((dot(N, DirFromSky) + 1) / 2) * (1 - Occlusion));
    float4 temp = HemiIntensity * lerp(GroundColor, ModelColor, (dot(N, DirFromSky) * 0.5f) + 0.5f); 

   return (temp + EnvIntensity * EnvColor);//*tex2D( g_samScene, Tex );
}

// -------------------------------------------------------------
// Techniques
// -------------------------------------------------------------
technique RenderSkybox
{
    pass P0
    {
        VertexShader = compile vs_1_1 VSSkybox();
        PixelShader  = compile ps_1_4 PSSkybox();
    }
}
// -------------------------------------------------------------
// 
// -------------------------------------------------------------
technique TShader
{
    pass P0
    {         
        //Sampler[0] = (CubeFaceSampler);		
        //Sampler[1] = (CubeMapSampler);		
    
        // compile shaders
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
