#pragma once

#pragma comment(lib,"dxguid.lib")
#pragma comment(lib,"d3d9.lib")
#pragma comment(lib,"d3dx9.lib")
#pragma comment(lib,"winmm.lib")

#include <windows.h>
#include <D3D9.h>
#include <D3DX9.h>
#include <dxerr9.h>
#include "CameraDX.h"

#define KEYDOWN(vk_code) ((GetAsyncKeyState(vk_code) & 0x8000) ? 1 : 0)
#define SAFE_RELEASE( p )	{ if(p) { (p)->Release(); (p) = NULL; } }
#define SAFE_DELETE( p )       { if(p) { delete (p); (p)=NULL; } }
#define SAFE_DELETE_ARRAY( p ) { if(p) { delete[] (p); (p)=NULL; } }

#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 600
#define QUAD_SIDE 1.0f


#define D3DFVF_VERTEXCODE_HM ( D3DFVF_XYZ | D3DFVF_DIFFUSE )
struct D3DFVF_VERTEX_HM
{
	D3DXVECTOR3 p;
	DWORD       diffuse;
};

bool g_Windowed = FALSE;

CameraDX *g_pCamara = 0;

LPDIRECT3D9				g_pD3D = 0;
LPDIRECT3DDEVICE9		g_pD3DDevice = 0;
LPDIRECT3DSURFACE9		g_pD3DSurface = 0;
LPDIRECT3DVERTEXBUFFER9	*g_ppHeightMapVB = 0;

LRESULT WINAPI MsgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );
void IniciarD3D( HWND hWnd );
void CerrarD3D();
void IniciarDatos();
void CerrarDatos();
void Renderizar();
void Actualizar();
void CargarHeightMap( char *nombreArchivo );
void LoadTexture( LPCTSTR pFileName, DWORD colorKey, LPDIRECT3DTEXTURE9 *ppTexture );