#include "main.h"

void LoadTexture( LPCTSTR pFileName, DWORD colorKey, LPDIRECT3DTEXTURE9 *ppTexture )
{
	D3DXCreateTextureFromFileEx(	g_pD3DDevice,
		pFileName,
		0,0,1,0,
		D3DFMT_UNKNOWN,
		D3DPOOL_MANAGED,
		D3DX_FILTER_NONE,
		D3DX_FILTER_NONE,
		colorKey,
		NULL,
		NULL,
		ppTexture );
}
void CargarHeightMap( char *nombreArchivo )
{

	g_pD3DDevice->CreateOffscreenPlainSurface( 1024, 768, D3DFMT_X8R8G8B8, D3DPOOL_SCRATCH, &g_pD3DSurface, NULL );


	D3DXLoadSurfaceFromFile( g_pD3DSurface, NULL, NULL, nombreArchivo, NULL, D3DX_FILTER_NONE, 0, NULL );
	D3DLOCKED_RECT LockedRect;
	g_pD3DSurface->LockRect( &LockedRect, NULL, D3DLOCK_READONLY );

	g_ppHeightMapVB = new LPDIRECT3DVERTEXBUFFER9[ 767 ];

	DWORD alterno = 0;

	for ( UINT VBIndex = 0; VBIndex < 767; VBIndex++ )
	{

		g_pD3DDevice->CreateVertexBuffer(	2 * 1024 * sizeof(D3DFVF_VERTEX_HM), 
			D3DUSAGE_WRITEONLY, D3DFVF_VERTEXCODE_HM, D3DPOOL_MANAGED,
			&g_ppHeightMapVB[ VBIndex ], NULL );

		D3DFVF_VERTEX_HM*	pVBData;

		g_ppHeightMapVB[ VBIndex ]->Lock( 0,0,(void **)&pVBData, D3DLOCK_NOSYSLOCK );

		int offset = 1024;
		int x = 0;
		int z = 0;

		for ( DWORD index = 0; index < 2 * 1024; index++ )
		{
			DWORD ceroCuandoIndexPar = index % 2;
			DWORD pixelColor = ( ( DWORD* ) LockedRect.pBits )[ alterno + ( 1024 * ceroCuandoIndexPar )];
			if ( ceroCuandoIndexPar )
				alterno++;

			((D3DFVF_VERTEX_HM*)pVBData)[index].diffuse	= pixelColor;
			((D3DFVF_VERTEX_HM*)pVBData)[index].p.x		= (float)x;
			if ( ceroCuandoIndexPar ) 
			{
				x++;
			}

			int height = ( pixelColor & 0x00FF0000 ) >> 16;

			((D3DFVF_VERTEX_HM*)pVBData)[index].p.y		= (float)( height ) / 10.0f;

			((D3DFVF_VERTEX_HM*)pVBData)[index].p.z		= -(float)( VBIndex + ceroCuandoIndexPar );	
		}

		g_ppHeightMapVB[ VBIndex ]->Unlock();

	}
}

LRESULT WINAPI MsgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
	case WM_DESTROY:
		PostQuitMessage( 0 );
		return 0;

	case WM_SETCURSOR:
		SetCursor( LoadCursor(NULL, NULL));
		return 0;
		break;
	}

	return DefWindowProc( hWnd, msg, wParam, lParam );
}

INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR, INT )
{
	WNDCLASSEX wc;
	ZeroMemory(&wc, sizeof(WNDCLASSEX));

	wc.cbSize = sizeof( WNDCLASSEX );
	wc.lpfnWndProc = MsgProc;
	wc.lpszClassName = "D3DWindow";

	RegisterClassEx( &wc );

	HWND hWnd = CreateWindow(	"D3DWindow", 
								"Fast Montanyas", 
								WS_OVERLAPPEDWINDOW, 
								0, 0, SCREEN_WIDTH, SCREEN_HEIGHT,
								GetDesktopWindow(), 
								NULL, hInst, NULL );


	if ( IDYES == MessageBox( NULL, "FullScreen?", "FastMontanyas", MB_YESNO ) )
		g_Windowed = false;
	else
		g_Windowed = true;


	IniciarD3D( hWnd );
	IniciarDatos();

	ShowWindow( hWnd , SW_SHOWDEFAULT );

	MSG  msg;
	msg.message = WM_NULL;

	while( WM_QUIT != msg.message )
	{
		if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
		{
			DispatchMessage( &msg );
		}
		{
			Renderizar();
			Actualizar();
		}
	}

	CerrarDatos(); 
	CerrarD3D();

	return 0;
}


void IniciarD3D( HWND hWnd )
{
	g_pD3D = Direct3DCreate9( D3D_SDK_VERSION );

	D3DPRESENT_PARAMETERS d3dpp; 
	ZeroMemory( &d3dpp, sizeof( d3dpp ) );

	d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
	//d3dpp.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;
	d3dpp.BackBufferCount = 0;
	d3dpp.BackBufferFormat = D3DFMT_X8R8G8B8;
	d3dpp.BackBufferWidth = SCREEN_WIDTH;
	d3dpp.BackBufferHeight = SCREEN_HEIGHT;
	d3dpp.EnableAutoDepthStencil = TRUE;
	d3dpp.AutoDepthStencilFormat = D3DFMT_D16;
	d3dpp.MultiSampleType = D3DMULTISAMPLE_NONE;
	d3dpp.MultiSampleQuality = D3DMULTISAMPLE_NONE;

	if (g_Windowed)
		d3dpp.Windowed = TRUE;
	else
	{
		ShowCursor( false );
		d3dpp.Windowed = FALSE;
	}

	D3DCAPS9 caps;
	g_pD3D->GetDeviceCaps( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, &caps );

	if ( caps.DevCaps && D3DDEVCAPS_HWTRANSFORMANDLIGHT )
	{
		g_pD3D->CreateDevice(	D3DADAPTER_DEFAULT, 
								D3DDEVTYPE_HAL, 
								hWnd,
								D3DCREATE_HARDWARE_VERTEXPROCESSING,
								&d3dpp, 
								&g_pD3DDevice );
	}
	else
	{
		g_pD3D->CreateDevice(	D3DADAPTER_DEFAULT, 
								D3DDEVTYPE_HAL, 
								hWnd,
								D3DCREATE_SOFTWARE_VERTEXPROCESSING,
								&d3dpp, 
								&g_pD3DDevice );
	}

}

void CerrarD3D()
{
	SAFE_RELEASE( g_pD3DDevice );
	SAFE_RELEASE( g_pD3D );
}

void IniciarDatos()
{
	D3DXMATRIX m_d3dmMatrizMundo;
	D3DXMatrixIdentity( &m_d3dmMatrizMundo );

	g_pD3DDevice->SetTransform( D3DTS_WORLD, &m_d3dmMatrizMundo );
	
	g_pCamara = new CameraDX();
	g_pCamara->SetPosition( 500.0f, 30.0f, -500.0f );
	g_pCamara->SetPlanes( 1.0f, 1500.0f );
	g_pD3DDevice->SetTransform( D3DTS_PROJECTION, g_pCamara->GetProjectionMatrix() );

	CargarHeightMap( "heightmap.png" );

	g_pD3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );

	g_pD3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

}

void CerrarDatos()
{
	SAFE_RELEASE( g_pD3DSurface );
	SAFE_DELETE( g_pCamara );

	for ( UINT index = 0; index < 768 - 1; index++ )
		SAFE_RELEASE( g_ppHeightMapVB[ index ] );
	SAFE_DELETE_ARRAY( g_ppHeightMapVB );
}


void Renderizar()
{
	g_pD3DDevice->Clear( 0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, 0xFF000000, 1.0f, 0 );
	g_pD3DDevice->BeginScene();
	g_pD3DDevice->SetFVF( D3DFVF_VERTEXCODE_HM );

	for ( UINT index = 0; index < 765; index++ )
	{
		g_pD3DDevice->SetStreamSource( 0, g_ppHeightMapVB[ index ], 0, sizeof(D3DFVF_VERTEX_HM) );
		g_pD3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, (765)*2 );
	}

	g_pD3DDevice->EndScene();
	g_pD3DDevice->Present( NULL, NULL, NULL, NULL );
}

void Actualizar()
{
	static DWORD TiempoAnterior = GetTickCount();

	DWORD TiempoActual = GetTickCount(); 
	float delta = ( float )( TiempoActual - TiempoAnterior );
	TiempoAnterior = TiempoActual;

	static float yaw = D3DX_PI * 0.6f;
	static float pitch = 0.0f;
	static float roll = 0.0f;

	static float giro = 0;
	giro += delta * 0.001f;
	g_pCamara->SetOrientation( giro, pitch, roll );


		g_pCamara->MoveFrontFly( delta );

	if ( KEYDOWN(VK_ESCAPE) )
		PostQuitMessage(0);

	g_pD3DDevice->SetTransform( D3DTS_PROJECTION, g_pCamara->GetProjectionMatrix() );

	g_pD3DDevice->SetTransform( D3DTS_VIEW, g_pCamara->GetViewMatrix() );
}

