//***************LIBRERIAS DEL SISTEMA*****************//
#include <math.h>
#include <stdio.h>
#include <d3dx8.h>

//***************LIBRERIAS DEL ENGINE 3D***************//
#include "Motor3d\Matematicas\Vector2d.h"
#include "Motor3d\Matematicas\Vector3d.h"
#include "Motor3d\Ventana\Ventana.h"


float tInicio,tActual;

//***************DECLARACIN DE VARIABLES***************//

//-------------------Ventana---------------------------------
VentanaGL		*g_ventanaGL;
int				AnchoVentana=800;
int				AltoVentana=600;
int				Bits=16;



//********************************PROTOTIPOS DE FUNCIONES**************/
void Inicializacion();
void CapturaTeclas();
void ActualizarJuego();
void RenderScene();




/*********************************RENDER EN PANTALLA******************************/
void MuestraInformacion()										// Calculo de Frames por Segundo
{
	static float fps               = 0.0f;						
    static float tiempoAnterior    = 0.0f;	
	static char  cadenaFPS[256];
	
	float tiempoActual = (GetTickCount() * 0.001f);				

    ++fps;	// Incrementamos el contador de fps

    if( tiempoActual - tiempoAnterior > 1.0f )
    {
	    tiempoAnterior = tiempoActual;
		
		sprintf(cadenaFPS, "FPS: %.0f",fps);
		
		SetWindowText(g_ventanaGL->m_hWnd, cadenaFPS);
        fps = 0.0f;
    }
}


//************************FUNCIONES WINDOWS***********************************


LRESULT	CALLBACK GestorMensajes(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam)
{
	switch (Message)									
	{
		case WM_SYSCOMMAND:							// Interceptacin de comandos del sistema
		{
			switch (wParam)							// Chequea las llamadas del sistema
			{
				case SC_SCREENSAVE:					// Intento de pasar a modo salvapantallas...
				case SC_MONITORPOWER:				// Intento de suspender el monitor...
				return 0;							// Nos prevenimos de que ocurra.
			}
			break;									
		}

		case WM_CLOSE:								// Si recibimos un mensaje cerrar		
		{											// ejecutamos el mtodo cerrar de g_ventanaGL
			g_ventanaGL->cerrar();					
			return 0;								
		}

		case WM_SIZE:								// Si se redimensiona la ventana ejecutamos resize con los parametros aqu puestos
		{
			g_ventanaGL->resize(LOWORD(lParam),HIWORD(lParam));
		}
	}

	return DefWindowProc(hWnd,Message,wParam,lParam);
}


WPARAM LoopPrincipal()
{
	MSG  msg;
	bool fin=false;
	
	while(!fin)											// Hacemos loop infinito hasta que no sea el fin de la demo
	{													
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))   // Procesamos los mensajes de Windows
        { 
			if(msg.message == WM_QUIT)					
				break;

            TranslateMessage(&msg);						
            DispatchMessage(&msg);						
        }
		else											
		{	
			tActual=GetTickCount()-tInicio;

			//Capturamos las ordenes del usuario y actualizamos la informacion del juego/aplicacion
			if(tActual>=22000)
				CapturaTeclas();
			
			//Renderizamos toda la informacion grfica
			glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
			glLoadIdentity();

			RenderScene();

			//Swapeamos todo el render
			g_ventanaGL->update();

			//Mostramos informacion como los fps
			MuestraInformacion();
		}													
	}

	return(msg.wParam);									
}


//***************PUNTO DE COMIENZO DEL JUEGO***************//

int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
	g_ventanaGL=new VentanaGL;

	if(!g_ventanaGL->crear("Practica Opengl 1",AnchoVentana,AltoVentana,Bits,true))
	{
		MessageBox(NULL,"No se ha creado la ventana como debiera","Error",MB_OK);
		return false;
	}
	
	tInicio=GetTickCount();

	Inicializacion();	

	return LoopPrincipal();
}

					
