//***************LIBRERIAS DEL SISTEMA*****************//
#include <math.h>
#include <stdio.h>
#include <d3dx8.h>
#include <windows.h>
#include <stdlib.h>

//***************LIBRERIAS DEL ENGINE 3D***************//
#include "Motor3d\Cargador3d\3ds.h"
#include "Motor3d\Renderer\Opengl\Ventana.h"
#include "Motor3d\GFX\Texturas.h"
#include "Motor3d\Miscelanea\Objeto.h"
#include "Motor3d\Miscelanea\Texto.h"
#include "Motor3d\Miscelanea\Cajas.h"
#include "Motor3d\Octree\Octree.h"
#include "Motor3d\Frustum\Frustum.h"
#include "Motor3d\Camara\Camara.h"
#include "Motor3d\DirectInput\Input.h"

//***************DECLARACION DE MACROS******************//

//-------------------Fichero Configuracion-------------------
#define FICHERO_CONFIGURACION "scr.txt"

//-------------------Ventana---------------------------------
#define RUTA_PINGUINO	"MODELOS/pinguino.3DS"		
#define RUTA_CHURCH		"MODELOS/church.3DS"	

//***************DECLARACIN DE VARIABLES***************//

//-------------------Ventana---------------------------------
VentanaGL		*g_ventanaGL;
bool			g_bPantallaCompleta=true;
int				AnchoVentana=1024;
int				AltoVentana=768;
int				Bits=16;

//-------------------Configuracion de render Opengl----------
bool			g_bIluminacion=true;
bool			g_bNiebla=true;
bool			g_bMuestraNodos=false;

//-------------------Objetos 3d del juego---------------------
COGLObjeto		g_Pinguino(RUTA_PINGUINO);
float			g_posXterrorista;
float			g_posYterrorista;
float			g_posZterrorista;
bool			g_bColisiona;


COGLObjeto	    g_Parque(RUTA_CHURCH);


COGLCaja	    Porta1;
COGLCaja     	Porta2;
COGLCaja	    Boton;


//-------------------Octree-----------------------------------
sModelo3d		g_mPinguino;
sModelo3d		g_mParque;
UINT			g_mTexturas[MAX_TEXTURAS] = {0};			// Matriz Texturas 

//-------------------Camara-----------------------------------

float			g_fVelocidadAvance=0.3f;					// Velocidad del movimiento de la camara adelante/atras
float			g_fVelocidadRetroceso=0.2f;
float			g_fVelocidadRotacion=0.1f;					// Velocidad del movimiento de la camara rotando
float			g_fVelocidadStrafing=5.0f;					// Velocidad del movimiento de la camara estrafeando

COGLCamara		g_CamaraGL;
COGLVector3d	g_vector_posicion(0.0,10.0,40.0);
COGLVector3d	g_vector_vista(0.0,0.0,-3.0);
COGLVector3d	g_vector_up(0.0,1.0,0.0);

//-------------------Direct Input----------------------------

COGLDInput		g_InputGL;									// Objeto para manejo de teclado y ratn

//----------------------Fuentes----------------------------

GLuint			g_Fuente_Arial_48;
GLuint			g_Fuente_Arial_24;
GLuint			g_Fuente_Arial_18;
GLuint			g_Fuente_Comic_48;

//-------------------Octree----------------------------------

COGLOctree		g_Octree;
int				g_MaximoTriangulos=10;
int				g_MaximaSubdivision=4;
int				g_CuentaNodosFinal=0;
int				g_TotalNodosDibujando=0;
int				g_TotalTestColisiones=0;
int				g_TotalColisiones=0;

//-------------------Visualizacion/Depuracion Octree----------

COGLDepuracion  g_Depuracion;

//-------------------Frustum----------------------------------

COGLFrustum		g_Frustum;

//-------------------Luces----------------------------------

float g_fLuzDifusa[]= { 1.0, 1.0, 1.0, 1.0 };		// Definimos valores de luz difusa (maxima intensidad de luz blanca)
float g_fLuzAmbiente[]= { 0.5, 0.5, 0.5, 1.0 };	// Definimos valores de luz ambiente
float g_fLuzSpecular[]= { 0.0, 0.0, 0.0, 0.0};	// Definimos el valor specular de la luz
float g_fLuzEmision[]= { 0.0, 0.0, 0.0, 0.0};	// Definimos el valor de emisin de la luz
float g_fPosicion[]= { 1.0, 2.0, 2.0 , 0.0};     // La posicin de la luz


//---------------VARIABLES JUEGO--------------------------------
int				g_NumeroFrames=0;
float			g_fAngulo=0.0f;
float			g_fAltura=0.0f;
bool			g_bSalto=false;

/*********************************DIRECTX******************************/

void CapturaTeclas()
{
	if(g_InputGL.TeclaPulsada(DIK_LEFT)) 
	{
		g_fAngulo+=5.73f;
		g_CamaraGL.RotaAlrededor(g_CamaraGL.m_vector_vista,g_fVelocidadRotacion,0,1,0);
	}


	if(g_InputGL.TeclaPulsada(DIK_RIGHT)) 
	{
		g_fAngulo-=5.73f;
		g_CamaraGL.RotaAlrededor(g_CamaraGL.m_vector_vista,-g_fVelocidadRotacion,0,1,0);	
	}


	if(g_InputGL.TeclaPulsada(DIK_W))
	{
		if(!g_bColisiona)
			g_CamaraGL.MueveCamara(g_fVelocidadAvance);	
		else
			g_CamaraGL.MueveCamara(-g_fVelocidadRetroceso*2.5);
	}


	if(g_InputGL.TeclaPulsada(DIK_S)) 
	{
		if(!g_bColisiona)
			g_CamaraGL.MueveCamara(-g_fVelocidadAvance);				
		else
			g_CamaraGL.MueveCamara(g_fVelocidadRetroceso*2.5);
	}


	if(g_InputGL.TeclaPulsada(DIK_A)) 
	{
		if(!g_bColisiona)
			g_CamaraGL.StrafeaCamara(-g_fVelocidadStrafing);
		else
			g_CamaraGL.StrafeaCamara(g_fVelocidadStrafing*2.5);	
	}


	if(g_InputGL.TeclaPulsada(DIK_D)) 
	{
		if(!g_bColisiona)
			g_CamaraGL.StrafeaCamara(g_fVelocidadStrafing);	
		else
			g_CamaraGL.StrafeaCamara(-g_fVelocidadStrafing*2.5);
	}


	if(g_InputGL.TeclaPulsada(DIK_SPACE))
	{	
		if(g_fAltura==0.0)
			g_bSalto=true;
	}

	if(g_InputGL.TeclaPulsada(DIK_ESCAPE))
		g_ventanaGL->cerrar();

	if(g_fAltura>=12.0)
		g_bSalto=false;
	
	if(g_InputGL.TeclaPulsada(DIK_F))
	{	
		//PRUEBA PUERTA1
		//controlar z
		if ((g_Pinguino.m_vector_posicion.m_z-100<=Porta1.posicion_inicial.m_z) && (g_Pinguino.m_vector_posicion.m_z+100>=Porta1.posicion_inicial.m_z))
		{	
			//controlar x
			//if ((g_Pinguino.m_vector_posicion.m_x-<=Porta1.posicion_inicial.m_x) && (g_Pinguino.m_vector_posicion.m_x>=Porta1.posicion_inicial.m_x))
			if (Porta1.posicion_actual.m_y==Porta1.posicion_inicial.m_y)
			{
				Porta1.Accionar();
			}
		}	


		//PRUEBA BOTON1
		//controlar z
		if ((g_Pinguino.m_vector_posicion.m_z-80<=Boton.posicion_inicial.m_z) && (g_Pinguino.m_vector_posicion.m_z+80>=Boton.posicion_inicial.m_z))
		{	
			if (Porta2.posicion_actual.m_y==Porta2.posicion_inicial.m_y)
			{
				Boton.Accionar();
				if (Boton.g_bAccionada)
					Porta2.Accionar();
				
			}
		}	
	}
}


/*********************************INICIALIZACION******************************/

void IniciaDirectInput()
{
	g_InputGL.Iniciar(g_ventanaGL->m_hWnd);
}


void IniciaFuentes()
{
	//Arial-48
	CreaFuenteBitmap("Arial", 48, g_ventanaGL->m_hDC, g_Fuente_Arial_48);

	//Arial-24
	CreaFuenteBitmap("Arial", 24, g_ventanaGL->m_hDC, g_Fuente_Arial_24);

	//Arial-18
	CreaFuenteBitmap("Arial", 18, g_ventanaGL->m_hDC, g_Fuente_Arial_18);

	CreaFuenteBitmap("Comic Sans",48, g_ventanaGL->m_hDC, g_Fuente_Comic_48);
}


void IniciaCamara()
{
	g_CamaraGL.PosicionCamara(g_vector_posicion,g_vector_vista,g_vector_up);
}


void IniciaObjetos()
{
	g_Pinguino.CargarTexturasModelo();
	g_Parque.CargarTexturasModelo();
	
	Porta1.CargarTextura("RedBrick.bmp",2);
	Porta1.AsignaPosicion(-110,-40,-450,0,1);

	Porta2.CargarTextura("Redbrick.bmp",3);
	Porta2.AsignaPosicion(-110,-40,-870,0,1);
		
	Boton.CargarTextura("LEET_SKI.bmp",4);
	Boton.AsignaPosicion(-150,-10,-864,1,5);
}

void IniciaOctree()
{
	//Lo primero que tenemos que hacer antes de crear nuestro octree es encontrar
	//el ancho total del nodo raiz inicial. Pasamos el modelo3d como parmetro
	//al metodo obtenerdimensiones3ds

	g_Octree.ObtenerDimensiones3ds(&g_Parque.m_MiModelo);

	//Almacenamos el numero total de triangulos del mundo 3d, para despus pasarselo
	//como parmetro a creanodo

	int NumeroTotalTriangulos = g_Octree.ObtenerTriangulos3ds(&g_Parque.m_MiModelo);

	//Ahora subdividiremos recursivamente el mundo 3d, de acuerdo con las restricciones
	//globales

	g_Octree.CreaNodo(&g_Parque.m_MiModelo, NumeroTotalTriangulos, g_Octree.ObtenerCentro(), g_Octree.ObtenerAncho());

	//Ya hemos creado el octree. Para incrementar la eficiencia usaremos las listas display
	//para cada nodo final(nodo hijo). De esta manera, solo tenemos que llamar a un identificador
	//de lista display para dibujar un nodo. Los vertex arrays tambien los utilizaremos para aumentar
	//el rendimiento del render del octree

	//Obtenemos el identificador de la lista display base y la almacenamos en el nodo raiz.
	//Cada nodo tiene su propio identificador, lo que corresponde a una serie de comandos Opengl

	g_Octree.PonIDListaDisplay( glGenLists(g_CuentaNodosFinal) );

	//Creamos una lista display para cada nodo final(nodo hijo), de esta maner, solo tenemos que llamar
	//a un identificador de lista display para dibujar un nodo

	g_Octree.CreaListaDisplay(&g_Parque,&g_Octree, g_Octree.ObtenerIDListaDisplay());

	//g_Octree.CreaListaDisplay(&g_Octree,&g_Parque.m_MiModelo,g_Octree.ObtenerIDListaDisplay());
}



void IniciaOpengl()
{
	//LUCES
	glLightfv(GL_LIGHT0, GL_DIFFUSE,  g_fLuzDifusa);	// Ponemos valores a la luz 0
	glLightfv(GL_LIGHT0, GL_AMBIENT,  g_fLuzAmbiente);	// Ponemos valores a la luz 0
	glLightfv(GL_LIGHT0, GL_SPECULAR, g_fLuzSpecular);  // Ponemos valores a la luz 0
	glLightfv(GL_LIGHT0, GL_EMISSION, g_fLuzEmision);	// Ponemos valores a la luz 0
	glLightfv(GL_LIGHT0, GL_POSITION, g_fPosicion);		// Ponemos la posicin para gl_light1

	glEnable(GL_LIGHT0);								
	glEnable(GL_LIGHTING);								
	glEnable(GL_COLOR_MATERIAL);					
}


void Inicializacion()
{
	IniciaFuentes();

	glClear(GL_COLOR_BUFFER_BIT);
	glClearColor(0.0,0.0,0.0,0.0);
	glPushMatrix();

	glLoadIdentity();
	glTranslatef(0.0f, 0.0f, -1.0f);
	glColor3f(0.25f, 0.25f, 1.0f);
	glRasterPos2f(-0.15f, 0.0f);
	printfGL(g_Fuente_Comic_48, "CARGANDO...");
	glFlush();  

	g_ventanaGL->update();

	IniciaDirectInput();
	IniciaCamara();
	IniciaObjetos();
	IniciaOctree();
	IniciaOpengl();

}

/*********************************LIBERACION MEMORIA******************************/
void DestruyeFuentes()
{
	DestruyeFuente(g_Fuente_Arial_48);
	DestruyeFuente(g_Fuente_Arial_24);
	DestruyeFuente(g_Fuente_Arial_18);
}

void Desinicializacion()
{
	DestruyeFuentes();
}



/*********************************RENDER EN PANTALLA******************************/
void RenderizaJuego()
{
	glEnable(GL_DEPTH_TEST);
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);	

	glLoadIdentity();

	g_CamaraGL.Mira();
	
	g_Octree.DibujaOctree(&g_Octree, &g_Parque.m_MiModelo);
	

	//Renderizamos los cubos nodales para visualizar el octree
	if(g_bMuestraNodos)
		g_Depuracion.RenderizaLineasDepuracion();

	//****MOVIMIENTOS PERSONAJE*****
	if(g_bSalto==true)
		g_fAltura+=1.0;
	else
	{
		if(g_fAltura>0.0)
			g_fAltura-=1.0;
	}

	g_posXterrorista = g_CamaraGL.m_vector_vista.m_x;
	g_posYterrorista=g_fAltura;
	g_posZterrorista = g_CamaraGL.m_vector_vista.m_z;
	//g_PosRotterrorista=g_CamaraGL.m_vector_vista.m_y;
	
	g_TotalTestColisiones = 0;
	g_TotalColisiones = 0;
	g_bColisiona=g_Octree.ColisionObjeto(&g_Pinguino,&g_Parque.m_MiModelo);
		
	//g_Pinguino.AsignaPosicion(g_posXterrorista,g_posYterrorista,g_posZterrorista,anguloY);
	g_Pinguino.AsignaPosicion(g_posXterrorista,g_posYterrorista,g_posZterrorista,0);
	g_Pinguino.DibujaModelo(false);

	//******************************
	
	
	//*************Boton************
	glPushMatrix();
		Boton.DibujaCaja(4,4,5,Boton.IDTextura,Boton.Tipo,Boton.Orientacion);
	glPopMatrix();

	//******************************

	//*************Puerta2 Boton************
	glPushMatrix();
		Porta2.DibujaCaja(180,80,5,Porta2.IDTextura,Porta2.Tipo,Porta2.Orientacion);
	glPopMatrix();

	//******************************

	g_ventanaGL->update();	
}

void MuestraInformacion()										// Calculo de Frames por Segundo
{
	static float fps               = 0.0f;						
    static float tiempoAnterior    = 0.0f;	
	static char  cadenaFPS[256];

	float tiempoActual = (GetTickCount() * 0.001f);				

    ++fps;	// Incrementamos el contador de fps

    if( tiempoActual - tiempoAnterior > 1.0f )
    {
	    tiempoAnterior = tiempoActual;
		sprintf(cadenaFPS, "Arroutada 11-Fast coding by Chillido");

		SetWindowText(g_ventanaGL->m_hWnd, cadenaFPS);
        fps = 0.0f;
    }
}


//************************FUNCIONES WINDOWS***********************************


LRESULT	CALLBACK GestorMensajes(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam)
{
	switch (Message)									
	{
		case WM_SYSCOMMAND:							// Interceptacin de comandos del sistema
		{
			switch (wParam)							// Chequea las llamadas del sistema
			{
				case SC_SCREENSAVE:					// Intento de pasar a modo salvapantallas...
				case SC_MONITORPOWER:				// Intento de suspender el monitor...
				return 0;							// Nos prevenimos de que ocurra.
			}
			break;									
		}

		case WM_CLOSE:								// Si recibimos un mensaje cerrar		
		{											// ejecutamos el mtodo cerrar de g_ventanaGL
			g_ventanaGL->cerrar();					
			return 0;								
		}

		case WM_SIZE:								// Si se redimensiona la ventana ejecutamos resize con los parametros aqu puestos
		{
			g_ventanaGL->resize(LOWORD(lParam),HIWORD(lParam));
		}
	}
	return DefWindowProc(hWnd,Message,wParam,lParam);
}

WPARAM LoopPrincipal()
{
	MSG  msg;
	bool fin=false;

	while(!fin)											// Hacemos loop infinito hasta que no sea el fin de la demo
	{													
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))   // Procesamos los mensajes de Windows
        { 
			if(msg.message == WM_QUIT)					
				break;

            TranslateMessage(&msg);						
            DispatchMessage(&msg);						
        }
		else											
		{	
			g_InputGL.Actualizar();

			CapturaTeclas();

			g_CamaraGL.Actualiza();
			g_Frustum.CalcularFrustum();
			RenderizaJuego();
			MuestraInformacion();
		}													
	}

	return(msg.wParam);									
}


//***************PUNTO DE COMIENZO DEL JUEGO***************//

int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
	g_ventanaGL=new VentanaGL;

	if(!g_ventanaGL->crear("Videojuego 3d modo cooperativo multijugador",FICHERO_CONFIGURACION))
		return false;

	Inicializacion();	
	
	return LoopPrincipal();

}



					

