#include "Ventana.h"





VentanaGL::VentanaGL()

{

	m_hDC=NULL;

	m_hRC=NULL;

	m_hWnd=NULL;

	m_hInstance=NULL;

}

			

bool VentanaGL::crear(char *titulo,char *nFichero)

{

	FILE		*fp;

	WNDCLASS	wc;

	DWORD		dwStyle;

	GLuint		PixelFormat;

	char		cadena[256];



	strcpy(m_titulo,titulo);



	//Registra la clase

	(m_hInstance)=GetModuleHandle(NULL);

	wc.cbClsExtra=0;

	wc.cbWndExtra=0;

	wc.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);

	wc.hCursor=LoadCursor(NULL,IDC_ARROW);

	wc.hIcon=LoadIcon(NULL,IDI_HAND);

	wc.hInstance=m_hInstance;

	wc.lpfnWndProc=(WNDPROC)GestorMensajes;

	wc.lpszClassName=titulo;

	wc.lpszMenuName=NULL;

	wc.style=CS_HREDRAW|CS_VREDRAW;



	if(!RegisterClass(&wc))

	{

		MessageBox(NULL,"Fallo al registrar la ventana.","ERROR",MB_OK | MB_ICONINFORMATION);

		return false;

	}



	if(!(fp=fopen(nFichero,"r")))

	{

		sprintf(cadena,"No se ha podido abrir %s",nFichero);

		MessageBox(NULL,cadena,"Aviso",MB_OK);

		return false;

	}

	else

	{

		fscanf(fp,"Ancho=%d\nAlto=%d\nBits=%d\nFullscreen=%d",&m_ancho,&m_alto,&m_bits,&m_pantalla_completa);

	}



	if(m_pantalla_completa==true)

	{			

		dwStyle = WS_POPUP | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;		//Para que la ventana no tenga ni barra de 

		PonPantallaCompleta();										//de titulo ni bordes							

		ShowCursor(false);											//No se muestra la flecha del ratn

	}

	else if(m_pantalla_completa==false)
	{
		
		dwStyle = WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;		//Modo de ventana normalita
		ShowCursor(false);											//No se muestra la flecha del ratn
	}



	//Crea la ventana

	if(!(m_hWnd=CreateWindow(titulo,

							 titulo,

							 dwStyle,

							 0,0,

							 m_ancho,m_alto,

							 NULL,

							 NULL,

							 m_hInstance,

							 NULL)))

	{

		cerrar();

		MessageBox(NULL,"Fallo al crear la ventana.","ERROR",MB_OK | MB_ICONINFORMATION);

		return false;

	}



	static	PIXELFORMATDESCRIPTOR pfd= 

	{

		sizeof(PIXELFORMATDESCRIPTOR),

		1,

		PFD_DRAW_TO_WINDOW |

		PFD_SUPPORT_OPENGL |

		PFD_DOUBLEBUFFER,

		PFD_TYPE_RGBA,

		m_bits,

		0, 0, 0, 0, 0, 0,

		0,

		0,

		0,

		0, 0, 0, 0,

		32,

		0,

		0,

		PFD_MAIN_PLANE,

		0,

		0, 0, 0

	};



	if (!(m_hDC=GetDC(m_hWnd)))	

	{

		cerrar();

		MessageBox(NULL,"No se puede crear un Device Context.","ERROR",MB_OK | MB_ICONEXCLAMATION);

		return false;

	}

	

	if (!(PixelFormat=ChoosePixelFormat(m_hDC,&pfd))) 

	{

		cerrar();

		MessageBox(NULL,"No se puede encontrar un formato de pixel adecuado.","ERROR",MB_OK | MB_ICONEXCLAMATION);

		return false;

	}



	if(!SetPixelFormat(m_hDC,PixelFormat,&pfd))	

	{

		cerrar();

		MessageBox(NULL,"No se puede poner el formato de pixel.","ERROR",MB_OK | MB_ICONEXCLAMATION);

		return false;

	}



	if (!(m_hRC=wglCreateContext(m_hDC)))	

	{

		cerrar();

		MessageBox(NULL,"No se puede crear un rendering context.","ERROR",MB_OK | MB_ICONEXCLAMATION);

		return false;	

	}



	if(!wglMakeCurrent(m_hDC,m_hRC))

	{

		cerrar();

		MessageBox(NULL,"No se puede activar el rendering context.","ERROR",MB_OK | MB_ICONEXCLAMATION);

		return false;

	}



	ShowWindow(m_hWnd,SW_SHOW);

	SetForegroundWindow(m_hWnd);

	SetFocus(m_hWnd);

	

	resize(m_ancho,m_alto);

	return true;

}



void VentanaGL::cerrar()

{

	if (m_pantalla_completa)	

	{

		ChangeDisplaySettings(NULL,0);

		ShowCursor(TRUE);

	}

	

    if (m_hRC) 

	{

		if (!wglMakeCurrent(NULL,NULL))	

		{

			MessageBox(NULL,"Fallo al intentar liberar el device context y el rendering context.","ERROR",MB_OK | MB_ICONINFORMATION);

		}

		if (!wglDeleteContext(m_hRC)) 

		{

			MessageBox(NULL,"Fallo al intentar liberar el rendering context.","ERROR",MB_OK | MB_ICONINFORMATION);

		}

		m_hRC=NULL;

	}



	if (m_hDC && !ReleaseDC(m_hWnd,m_hDC)) 

	{

		MessageBox(NULL,"Fallo al intentar liberar el device context.","ERROR",MB_OK | MB_ICONINFORMATION);

		m_hDC=NULL;

	}



	if (m_hWnd && !DestroyWindow(m_hWnd)) 

	{

		MessageBox(NULL,"Fallo al cerrar la ventana.","ERROR",MB_OK | MB_ICONINFORMATION);

		m_hWnd=NULL;

	}



	if (!UnregisterClass(m_titulo,m_hInstance)) 

	{

		MessageBox(NULL,"Fallo al intentar desregistrar la clase.","ERROR",MB_OK | MB_ICONINFORMATION);

		m_hInstance=NULL;

	}



	PostQuitMessage(0);

}



void VentanaGL::update()

{

	SwapBuffers(m_hDC);

}



void VentanaGL::resize(GLsizei ancho,GLsizei alto)

{

	GLfloat fAspecto;



	if(alto==0)	alto=1;



	fAspecto=(GLfloat)ancho/(GLfloat)alto;



	glViewport(0,0,ancho,alto);

	

	glMatrixMode(GL_PROJECTION);

	glLoadIdentity();

	gluPerspective(45.0f,fAspecto, 1.0f, 5000.0f);



	glMatrixMode(GL_MODELVIEW);

	glLoadIdentity();

}







void VentanaGL::PonPantallaCompleta()

{

	DEVMODE dmSettings;									



	memset(&dmSettings,0,sizeof(dmSettings));			// Me aseguro de limpiar la memoria de dmSettings



	if(!EnumDisplaySettings(NULL,ENUM_CURRENT_SETTINGS,&dmSettings))

	{

		MessageBox(NULL, "Fallo al enumerar los display settings", "ERROR",MB_OK | MB_ICONINFORMATION);

		return;

	}



	dmSettings.dmPelsWidth	= 800;				

	dmSettings.dmPelsHeight	= 600;			

	

	int result = ChangeDisplaySettings(&dmSettings,CDS_FULLSCREEN);	



	

	if(result != DISP_CHANGE_SUCCESSFUL)				// Compruebo si cambi de modo

	{

		MessageBox(NULL, "Modo de visualizacin no compatible", "ERROR",MB_OK | MB_ICONINFORMATION);

		PostQuitMessage(0);

	}

}









