#include "Octree.h"



int g_subdivision_actual = 0;

int g_numero_octree=0;



//Aade en la lista m_vLineas lineas especificadas por vector_punto1 y vector_punto2, es decir, los extremos de la lnea

void COGLDepuracion::LineaDepuracion(COGLVector3d vector_punto1, COGLVector3d vector_punto2)

{

	m_vLineas.push_back(vector_punto1);

	m_vLineas.push_back(vector_punto2);

}



//Lo mismo que LineaDepuracin, aade a la lista m_vLineas, en este caso cubos, es decir las lineas que forman los cubos, 

//cuyos parmetros se especifican por el centro del cubo(vector_centro) el ancho, el alto y la profundidad.

void COGLDepuracion::CuboDepuracion(COGLVector3d vector_centro, float ancho, float alto, float profundidad)

{

	ancho /= 2.0f;	alto /= 2.0f;	profundidad /= 2.0f;



	COGLVector3d vector_ArribaIzquierdaFrontal( vector_centro.m_x - ancho, vector_centro.m_y + alto, vector_centro.m_z + profundidad);

	COGLVector3d vector_ArribaIzquierdaTrasero(  vector_centro.m_x - ancho, vector_centro.m_y + alto, vector_centro.m_z - profundidad);

	COGLVector3d vector_ArribaDerechaTrasero( vector_centro.m_x + ancho, vector_centro.m_y + alto, vector_centro.m_z - profundidad);

	COGLVector3d vector_ArribaDerechaFrontal(vector_centro.m_x + ancho, vector_centro.m_y + alto, vector_centro.m_z + profundidad);



	COGLVector3d vector_AbajoIzquierdaFrontal( vector_centro.m_x - ancho, vector_centro.m_y - alto, vector_centro.m_z + profundidad);

	COGLVector3d vector_AbajoIzquierdaTrasero(  vector_centro.m_x - ancho, vector_centro.m_y - alto, vector_centro.m_z - profundidad);

	COGLVector3d vector_AbajoDerechaTrasero( vector_centro.m_x + ancho, vector_centro.m_y - alto, vector_centro.m_z - profundidad);

	COGLVector3d vector_AbajoDerechaFrontal(vector_centro.m_x + ancho, vector_centro.m_y - alto, vector_centro.m_z + profundidad);



	

	m_vLineas.push_back(vector_ArribaIzquierdaFrontal);	m_vLineas.push_back(vector_ArribaDerechaFrontal);

	m_vLineas.push_back(vector_ArribaIzquierdaTrasero);  m_vLineas.push_back(vector_ArribaDerechaTrasero);

	m_vLineas.push_back(vector_ArribaIzquierdaFrontal);	m_vLineas.push_back(vector_ArribaIzquierdaTrasero);

	m_vLineas.push_back(vector_ArribaDerechaFrontal);	m_vLineas.push_back(vector_ArribaDerechaTrasero);



	m_vLineas.push_back(vector_AbajoIzquierdaFrontal);	m_vLineas.push_back(vector_AbajoDerechaFrontal);

	m_vLineas.push_back(vector_AbajoIzquierdaTrasero);	m_vLineas.push_back(vector_AbajoDerechaTrasero);

	m_vLineas.push_back(vector_AbajoIzquierdaFrontal);	m_vLineas.push_back(vector_AbajoIzquierdaTrasero);

	m_vLineas.push_back(vector_AbajoDerechaFrontal);		m_vLineas.push_back(vector_AbajoDerechaTrasero);



	m_vLineas.push_back(vector_ArribaIzquierdaFrontal);	m_vLineas.push_back(vector_AbajoIzquierdaFrontal);

	m_vLineas.push_back(vector_ArribaIzquierdaTrasero);	m_vLineas.push_back(vector_AbajoIzquierdaTrasero);

	m_vLineas.push_back(vector_ArribaDerechaTrasero);	m_vLineas.push_back(vector_AbajoDerechaTrasero);

	m_vLineas.push_back(vector_ArribaDerechaFrontal);	m_vLineas.push_back(vector_AbajoDerechaFrontal);

}



//Recorremos la lista m_vLineas donde almacenamos las lineas y las mostramos por pantalla

void COGLDepuracion::RenderizaLineasDepuracion()

{

	glDisable(GL_LIGHTING);					



	glBegin(GL_LINES);						



		glColor3ub(255, 0.0f, 0.0f);			



		for(int i = 0; i < m_vLineas.size(); i++)

		{

			glVertex3f(m_vLineas[i].m_x, m_vLineas[i].m_y, m_vLineas[i].m_z);

		}	



	glEnd();								

	

	if(g_bIluminacion) 

		glEnable(GL_LIGHTING);

}



//Vaciamos la lista mediante la funcin genrica clear

void COGLDepuracion::Limpia()					

{

	m_vLineas.clear();

}







COGLOctree::COGLOctree()

{



	m_bSubdividido = false;



	m_Ancho = 0; 



	m_NumeroTriangulos = 0;



	m_vector_centro = COGLVector3d(0, 0, 0);



	m_pModelo3ds = NULL;



	memset(m_pNodosOctree, 0, sizeof(m_pNodosOctree));		



	m_pListaTestObjetos.clear();



	g_numero_octree++;

}



COGLOctree::~COGLOctree()

{

	if( m_pModelo3ds )

	{

		for(int i = 0; i < m_pModelo3ds->NumeroObjetos; i++)

		{

			if( m_pModelo3ds->pObjeto[i].pCaras )

			{

				delete [] m_pModelo3ds->pObjeto[i].pCaras;	

				m_pModelo3ds->pObjeto[i].pCaras = NULL;

			}		



			if( m_pModelo3ds->pObjeto[i].pIndices )

			{

				delete [] m_pModelo3ds->pObjeto[i].pIndices;	

				m_pModelo3ds->pObjeto[i].pIndices = NULL;

			}

		}

	

		delete m_pModelo3ds;

		m_pModelo3ds = NULL;

	}



	for(int i = 0; i < 8; i++)

	{

		if( m_pNodosOctree[i] )

		{

			delete m_pNodosOctree[i];

			m_pNodosOctree[i] = NULL;

		}

	}

}





void COGLOctree::ObtenerDimensiones3ds(sModelo3d *Modelo3ds)

{
	if(!Modelo3ds)

		return;



	//Primero recorremos todos los objetos del modelo3d y sumamos el 

	//numero de vertices que tenga cada uno de ellos.

	int numeroVertices=0;



	for(int i=0;i<Modelo3ds->NumeroObjetos;i++)

	{

		numeroVertices+=Modelo3ds->pObjeto[i].NumeroVertices;



		for(int j=0;j<Modelo3ds->pObjeto[i].NumeroVertices;j++)

		{

			m_vector_centro=m_vector_centro+Modelo3ds->pObjeto[i].pVertices[j];

		}

	}

	//Y ahora utilizamos la formula de hallar el punto medio de toda la

	//vida, este ser el punto central del nodo padre.

	m_vector_centro.m_x /= numeroVertices;

	m_vector_centro.m_y /= numeroVertices;	

	m_vector_centro.m_z /= numeroVertices;



	int AnchoActual = 0, AltoActual = 0, ProfundidadActual = 0;

	float AnchoMaximo = 0, AlturaMaxima = 0, ProfundidadMaxima = 0;

	

	//Miramos cul es la mayor distancia que exista hasta el punto central previamente

	//calculado

	for(i = 0; i < Modelo3ds->NumeroObjetos; i++)

	{

		for(int j = 0; j < Modelo3ds->pObjeto[i].NumeroVertices; j++)

		{

			AnchoActual  = abs(Modelo3ds->pObjeto[i].pVertices[j].m_x - m_vector_centro.m_x);	

			AltoActual = abs(Modelo3ds->pObjeto[i].pVertices[j].m_y - m_vector_centro.m_y);		

			ProfundidadActual  = abs(Modelo3ds->pObjeto[i].pVertices[j].m_z - m_vector_centro.m_z);



			if(AnchoActual  > AnchoMaximo)	AnchoMaximo  = AnchoActual;



			if(AltoActual > AlturaMaxima)	AlturaMaxima = AltoActual;



			if(ProfundidadActual > ProfundidadMaxima)		ProfundidadMaxima  = ProfundidadActual;

		}

	}



	//Multiplicamos por 2 las posibles cantidades a ser nombradas lado del nodo padre,

	//comprobamos cual es la mayor y la asignamos a la variable miembro m_ancho que ser

	//el susodicho lado

	AnchoMaximo *= 2;		AlturaMaxima *= 2;		ProfundidadMaxima *= 2;



	if(AnchoMaximo > AlturaMaxima && AnchoMaximo > ProfundidadMaxima)

		m_Ancho = AnchoMaximo;



	else if(AlturaMaxima > AnchoMaximo && AlturaMaxima > ProfundidadMaxima)

		m_Ancho = AlturaMaxima;



	else

		m_Ancho = ProfundidadMaxima;
}





int COGLOctree::ObtenerTriangulos3ds(sModelo3d *Modelo3ds)

{

	//Ni mas ni menos que obtener el numero de tringulos del modelo 3d

	//hacemos el tipico for y vamos sumando todos los tringulos de todos

	//los objetos, si el modelo estuviera compuesto de quads pues habra que

	//aadir un atributo a la estructura sModelo3d numeroQuads for example :p

	int numeroTriangulos=0;



	for(int i = 0; i < Modelo3ds->NumeroObjetos; i++)

	{

		numeroTriangulos += Modelo3ds->pObjeto[i].NumeroCaras;

	}

	return numeroTriangulos;

}





void COGLOctree::IndiceObjetoLista(int indice)

{



	for(int i = 0; i < m_pListaObjetos.size(); i++)

	{

		if(m_pListaObjetos[i] == indice)

			return;

	}



	m_pListaObjetos.push_back(indice);

	m_pListaTestObjetos.push_back( false );
}





COGLVector3d COGLOctree::ObtenerCentroNuevoNodo(COGLVector3d vector_centro,float ancho,int IDNodo)

{

	COGLVector3d vector_nodo_centro(0, 0, 0);



	COGLVector3d vCtr = vector_centro;



	switch(IDNodo)							

	{

		case ARRIBA_IZQUIERDA_ADELANTE:

			vector_nodo_centro = COGLVector3d(vCtr.m_x - ancho/4, vCtr.m_y + ancho/4, vCtr.m_z + ancho/4);

			break;



		case ARRIBA_IZQUIERDA_ATRAS:

			vector_nodo_centro = COGLVector3d(vCtr.m_x - ancho/4, vCtr.m_y + ancho/4, vCtr.m_z - ancho/4);

			break;



		case ARRIBA_DERECHA_ATRAS:

			vector_nodo_centro = COGLVector3d(vCtr.m_x + ancho/4, vCtr.m_y + ancho/4, vCtr.m_z - ancho/4);

			break;



		case ARRIBA_DERECHA_ADELANTE:

			vector_nodo_centro = COGLVector3d(vCtr.m_x + ancho/4, vCtr.m_y + ancho/4, vCtr.m_z + ancho/4);

			break;



		case ABAJO_IZQUIERDA_ADELANTE:

			vector_nodo_centro = COGLVector3d(vCtr.m_x - ancho/4, vCtr.m_y - ancho/4, vCtr.m_z + ancho/4);

			break;



		case ABAJO_IZQUIERDA_ATRAS:

			vector_nodo_centro = COGLVector3d(vCtr.m_x - ancho/4, vCtr.m_y - ancho/4, vCtr.m_z - ancho/4);

			break;



		case ABAJO_DERECHA_ATRAS:

			vector_nodo_centro = COGLVector3d(vCtr.m_x + ancho/4, vCtr.m_y - ancho/4, vCtr.m_z - ancho/4);

			break;



		case ABAJO_DERECHA_ADELANTE:

			vector_nodo_centro = COGLVector3d(vCtr.m_x + ancho/4, vCtr.m_y - ancho/4, vCtr.m_z + ancho/4);

			break;

	}



	return vector_nodo_centro;

}





void COGLOctree::CreaNodo(sModelo3d *Modelo3ds,int numeroTriangulos,COGLVector3d vector_centro,float ancho)

{

	//Creamos los Nodos del Octree recursivamente



	m_vector_centro = vector_centro;



	m_Ancho = ancho;



	g_Depuracion.CuboDepuracion(vector_centro, ancho, ancho, ancho);



	//Para finalizar la recursin aqu utilizamos combinadas la tcnica del nmero de triangulos

	//y subdivisiones, si se cumplen dividimos.

	if( (numeroTriangulos > g_MaximoTriangulos) && (g_subdivision_actual < g_MaximaSubdivision) )

	{

		m_bSubdividido = true;

	

		vector<sListaCaras> pLista1(Modelo3ds->NumeroObjetos);		// nodo de la lista ARRIBA_IZQUIERDA_ADELANTE 

		vector<sListaCaras> pLista2(Modelo3ds->NumeroObjetos);		// nodo de la lista ARRIBA_IZQUIERDA_ATRAS 

		vector<sListaCaras> pLista3(Modelo3ds->NumeroObjetos);		// nodo de la lista ARRIBA_DERECHA_ATRAS 

		vector<sListaCaras> pLista4(Modelo3ds->NumeroObjetos);		// nodo de la lista ARRIBA_DERECHA_ADELANTE 

		vector<sListaCaras> pLista5(Modelo3ds->NumeroObjetos);		// nodo de la lista ABAJO_IZQUIERDA_ADELANTE 

		vector<sListaCaras> pLista6(Modelo3ds->NumeroObjetos);		// nodo de la lista ABAJO_IZQUIERDA_ATRAS 

		vector<sListaCaras> pLista7(Modelo3ds->NumeroObjetos);		// nodo de la lista ABAJO_DERECHA_ATRAS 

		vector<sListaCaras> pLista8(Modelo3ds->NumeroObjetos);		// nodo de la lista ABAJO_DERECHA_ADELANTE 

	

		COGLVector3d vCtr = vector_centro;



		for(int i = 0; i < Modelo3ds->NumeroObjetos; i++)

		{

			sObjeto3d *pObjeto = &(Modelo3ds->pObjeto[i]);



			pLista1[i].pListaCaras.resize(pObjeto->NumeroCaras);

			pLista2[i].pListaCaras.resize(pObjeto->NumeroCaras);

			pLista3[i].pListaCaras.resize(pObjeto->NumeroCaras);

			pLista4[i].pListaCaras.resize(pObjeto->NumeroCaras);

			pLista5[i].pListaCaras.resize(pObjeto->NumeroCaras);

			pLista6[i].pListaCaras.resize(pObjeto->NumeroCaras);

			pLista7[i].pListaCaras.resize(pObjeto->NumeroCaras);

			pLista8[i].pListaCaras.resize(pObjeto->NumeroCaras);



			for(int j = 0; j < pObjeto->NumeroCaras; j++)

			{

				for(int nVrt = 0; nVrt < 3; nVrt++)

				{

					COGLVector3d vPunto = pObjeto->pVertices[pObjeto->pCaras[j].IndiceVertice[nVrt]];



					if( (vPunto.m_x <= vCtr.m_x) && (vPunto.m_y >= vCtr.m_y) && (vPunto.m_z >= vCtr.m_z) ) 

						pLista1[i].pListaCaras[j] = true;



					if( (vPunto.m_x <= vCtr.m_x) && (vPunto.m_y >= vCtr.m_y) && (vPunto.m_z <= vCtr.m_z) ) 

						pLista2[i].pListaCaras[j] = true;



					if( (vPunto.m_x >= vCtr.m_x) && (vPunto.m_y >= vCtr.m_y) && (vPunto.m_z <= vCtr.m_z) ) 

						pLista3[i].pListaCaras[j] = true;



					if( (vPunto.m_x >= vCtr.m_x) && (vPunto.m_y >= vCtr.m_y) && (vPunto.m_z >= vCtr.m_z) ) 

						pLista4[i].pListaCaras[j] = true;



					if( (vPunto.m_x <= vCtr.m_x) && (vPunto.m_y <= vCtr.m_y) && (vPunto.m_z >= vCtr.m_z) ) 

						pLista5[i].pListaCaras[j] = true;



					if( (vPunto.m_x <= vCtr.m_x) && (vPunto.m_y <= vCtr.m_y) && (vPunto.m_z <= vCtr.m_z) ) 

						pLista6[i].pListaCaras[j] = true;



					if( (vPunto.m_x >= vCtr.m_x) && (vPunto.m_y <= vCtr.m_y) && (vPunto.m_z <= vCtr.m_z) ) 

						pLista7[i].pListaCaras[j] = true;



					if( (vPunto.m_x >= vCtr.m_x) && (vPunto.m_y <= vCtr.m_y) && (vPunto.m_z >= vCtr.m_z) ) 

						pLista8[i].pListaCaras[j] = true;

				}

			}	



			pLista1[i].NumeroCaras = 0;		pLista2[i].NumeroCaras = 0;

			pLista3[i].NumeroCaras = 0;		pLista4[i].NumeroCaras = 0;

			pLista5[i].NumeroCaras = 0;		pLista6[i].NumeroCaras = 0;

			pLista7[i].NumeroCaras = 0;		pLista8[i].NumeroCaras = 0;

		}



		int triCount1 = 0;	int triCount2 = 0;	int triCount3 = 0;	int triCount4 = 0;

		int triCount5 = 0;	int triCount6 = 0;	int triCount7 = 0;	int triCount8 = 0;

			

		for(i = 0; i < Modelo3ds->NumeroObjetos; i++)

		{

			for(int j = 0; j < Modelo3ds->pObjeto[i].NumeroCaras; j++)

			{

				if(pLista1[i].pListaCaras[j])	{ pLista1[i].NumeroCaras++; triCount1++; }

				if(pLista2[i].pListaCaras[j])	{ pLista2[i].NumeroCaras++; triCount2++; }

				if(pLista3[i].pListaCaras[j])	{ pLista3[i].NumeroCaras++; triCount3++; }

				if(pLista4[i].pListaCaras[j])	{ pLista4[i].NumeroCaras++; triCount4++; }

				if(pLista5[i].pListaCaras[j])	{ pLista5[i].NumeroCaras++; triCount5++; }

				if(pLista6[i].pListaCaras[j])	{ pLista6[i].NumeroCaras++; triCount6++; }

				if(pLista7[i].pListaCaras[j])	{ pLista7[i].NumeroCaras++; triCount7++; }

				if(pLista8[i].pListaCaras[j])	{ pLista8[i].NumeroCaras++; triCount8++; }

			}

		}



		CreaNuevoNodo(Modelo3ds, pLista1, triCount1, vector_centro, ancho, ARRIBA_IZQUIERDA_ADELANTE);

		CreaNuevoNodo(Modelo3ds, pLista2, triCount2, vector_centro, ancho, ARRIBA_IZQUIERDA_ATRAS);

		CreaNuevoNodo(Modelo3ds, pLista3, triCount3, vector_centro, ancho, ARRIBA_DERECHA_ATRAS);

		CreaNuevoNodo(Modelo3ds, pLista4, triCount4, vector_centro, ancho, ARRIBA_DERECHA_ADELANTE);

		CreaNuevoNodo(Modelo3ds, pLista5, triCount5, vector_centro, ancho, ABAJO_IZQUIERDA_ADELANTE);

		CreaNuevoNodo(Modelo3ds, pLista6, triCount6, vector_centro, ancho, ABAJO_IZQUIERDA_ATRAS);

		CreaNuevoNodo(Modelo3ds, pLista7, triCount7, vector_centro, ancho, ABAJO_DERECHA_ATRAS);

		CreaNuevoNodo(Modelo3ds, pLista8, triCount8, vector_centro, ancho, ABAJO_DERECHA_ADELANTE);

	}

	else

	{

		AsignaTriangulosNodo(Modelo3ds, numeroTriangulos);

	}



}





void COGLOctree::CreaNuevoNodo(sModelo3d *Modelo3ds,vector<sListaCaras> pLista,int NumeroTriangulos,

					   COGLVector3d vector_centro,float ancho,int IDNodo)

{



	if(!NumeroTriangulos) return;

	

	sModelo3d *pMundoTemp = new sModelo3d;



	memset(pMundoTemp, 0, sizeof(sModelo3d));

	pMundoTemp->NumeroObjetos = Modelo3ds->NumeroObjetos;

	

	for(int i = 0; i < Modelo3ds->NumeroObjetos; i++)

	{

		sObjeto3d *pObjeto = &(Modelo3ds->pObjeto[i]);



		sObjeto3d ObjetoNuevo;

		memset(&ObjetoNuevo, 0, sizeof(sObjeto3d));

		pMundoTemp->pObjeto.push_back(ObjetoNuevo);



		pMundoTemp->pObjeto[i].NumeroCaras  = pLista[i].NumeroCaras;

		pMundoTemp->pObjeto[i].IDMaterial  = pObjeto->IDMaterial;

		pMundoTemp->pObjeto[i].TieneTextura = pObjeto->TieneTextura;

		pMundoTemp->pObjeto[i].pVertices      = pObjeto->pVertices;



		pMundoTemp->pObjeto[i].pCaras = new sCara [pMundoTemp->pObjeto[i].NumeroCaras];



		int indice = 0;



		for(int j = 0; j < pObjeto->NumeroCaras; j++)

		{

			if(pLista[i].pListaCaras[j])	

			{

				pMundoTemp->pObjeto[i].pCaras[indice] = pObjeto->pCaras[j];

				indice++;

			}

		}

	}



	m_pNodosOctree[IDNodo] = new COGLOctree;



	COGLVector3d vNodeCenter = ObtenerCentroNuevoNodo(vector_centro, ancho, IDNodo);

		

	g_subdivision_actual++;





	m_pNodosOctree[IDNodo]->CreaNodo(pMundoTemp, NumeroTriangulos, vNodeCenter, ancho * 0.5f);



	g_subdivision_actual--;





	for(i = 0; i < Modelo3ds->NumeroObjetos; i++)

	{

		if(pMundoTemp->pObjeto[i].pCaras)

			delete [] pMundoTemp->pObjeto[i].pCaras;

	}



	delete pMundoTemp;



}





void COGLOctree::AsignaTriangulosNodo(sModelo3d *Modelo3ds,int numeroTriangulos)

{

	//Almacenamos los indices de las caras que necesitan ser renderizados

	m_bSubdividido = false;



	m_NumeroTriangulos = numeroTriangulos;



	m_pModelo3ds = new sModelo3d;

	memset(m_pModelo3ds, 0, sizeof(sModelo3d));



	m_pModelo3ds->NumeroObjetos = Modelo3ds->NumeroObjetos;



	for(int i = 0; i < m_pModelo3ds->NumeroObjetos; i++)

	{

		sObjeto3d *pObjeto = &(Modelo3ds->pObjeto[i]);



		sObjeto3d ObjetoNuevo;

		memset(&ObjetoNuevo, 0, sizeof(sObjeto3d));



		if(pObjeto->NumeroCaras)

			IndiceObjetoLista(i);



		m_pModelo3ds->pObjeto.push_back(ObjetoNuevo);



		int NumeroCaras = pObjeto->NumeroCaras;



		m_pModelo3ds->pObjeto[i].NumeroCaras = NumeroCaras;



		m_pModelo3ds->pObjeto[i].pCaras = new sCara [NumeroCaras];

		m_pModelo3ds->pObjeto[i].pIndices = new UINT [NumeroCaras * 3];



		memset(m_pModelo3ds->pObjeto[i].pIndices, 0, sizeof(UINT) * NumeroCaras * 3);



		memcpy(m_pModelo3ds->pObjeto[i].pCaras, pObjeto->pCaras, sizeof(sCara) * NumeroCaras);



		for(int j = 0; j < NumeroCaras * 3; j += 3)

		{

			m_pModelo3ds->pObjeto[i].pIndices[j]     = m_pModelo3ds->pObjeto[i].pCaras[j / 3].IndiceVertice[0];

			m_pModelo3ds->pObjeto[i].pIndices[j + 1] = m_pModelo3ds->pObjeto[i].pCaras[j / 3].IndiceVertice[1];

			m_pModelo3ds->pObjeto[i].pIndices[j + 2] = m_pModelo3ds->pObjeto[i].pCaras[j / 3].IndiceVertice[2];

		}



		delete [] m_pModelo3ds->pObjeto[i].pCaras;

		m_pModelo3ds->pObjeto[i].pCaras = NULL;

	}



	m_IDListaDisplay = g_CuentaNodosFinal;



	g_CuentaNodosFinal++;

}





void COGLOctree::DibujaOctree(COGLOctree *pNodo,sModelo3d *pMundoRaiz)

{

	//Dibujamos el Octree!!!, lo nico que hacemos es llamar a los identificadores de

	//nuestra display list, primero chequeamos si el nodo actual est dentro del frustum

	//En caso afirmativo, nos cercioramos de que no est subdividido debido a que solo

	//tenemos que pintar los nodos finales, es decir, los nodos hijos.

	if(!pNodo)

		return;



	if(!g_Frustum.CuboEnFrustum(pNodo->m_vector_centro.m_x, pNodo->m_vector_centro.m_y, 

								pNodo->m_vector_centro.m_z, pNodo->m_Ancho / 2) )

	{

		return;

	}



	if(pNodo->EstaSubdividido())

	{

		DibujaOctree(pNodo->m_pNodosOctree[ARRIBA_IZQUIERDA_ADELANTE],		pMundoRaiz);

		DibujaOctree(pNodo->m_pNodosOctree[ARRIBA_IZQUIERDA_ATRAS],		pMundoRaiz);

		DibujaOctree(pNodo->m_pNodosOctree[ARRIBA_DERECHA_ATRAS],		pMundoRaiz);

		DibujaOctree(pNodo->m_pNodosOctree[ARRIBA_DERECHA_ADELANTE],		pMundoRaiz);

		DibujaOctree(pNodo->m_pNodosOctree[ABAJO_IZQUIERDA_ADELANTE],	pMundoRaiz);

		DibujaOctree(pNodo->m_pNodosOctree[ABAJO_IZQUIERDA_ATRAS],		pMundoRaiz);

		DibujaOctree(pNodo->m_pNodosOctree[ABAJO_DERECHA_ATRAS],	pMundoRaiz);

		DibujaOctree(pNodo->m_pNodosOctree[ABAJO_DERECHA_ADELANTE],	pMundoRaiz);

	}

	else

	{

		g_TotalNodosDibujando++;



		if(!pNodo->m_pModelo3ds) return;

			

		glCallList(pNodo->m_IDListaDisplay);



	}

}





/*

void COGLOctree::CreaListaDisplay(COGLOctree *pNodo,sModelo3d *pMundoRaiz,int DesplazamientoListaDisplay)

{

	if(!pNodo)

		return;



	if(pNodo->EstaSubdividido())

	{

		CreaListaDisplay(pNodo->m_pNodosOctree[ARRIBA_IZQUIERDA_ADELANTE],	pMundoRaiz, DesplazamientoListaDisplay);

		CreaListaDisplay(pNodo->m_pNodosOctree[ARRIBA_IZQUIERDA_ATRAS],		pMundoRaiz, DesplazamientoListaDisplay);

		CreaListaDisplay(pNodo->m_pNodosOctree[ARRIBA_DERECHA_ATRAS],	pMundoRaiz, DesplazamientoListaDisplay);

		CreaListaDisplay(pNodo->m_pNodosOctree[ARRIBA_DERECHA_ADELANTE],	pMundoRaiz, DesplazamientoListaDisplay);

		CreaListaDisplay(pNodo->m_pNodosOctree[ABAJO_IZQUIERDA_ADELANTE],	pMundoRaiz, DesplazamientoListaDisplay);

		CreaListaDisplay(pNodo->m_pNodosOctree[ABAJO_IZQUIERDA_ATRAS],	pMundoRaiz, DesplazamientoListaDisplay);

		CreaListaDisplay(pNodo->m_pNodosOctree[ABAJO_DERECHA_ATRAS],	pMundoRaiz, DesplazamientoListaDisplay);

		CreaListaDisplay(pNodo->m_pNodosOctree[ABAJO_DERECHA_ADELANTE],pMundoRaiz, DesplazamientoListaDisplay);

	}

	else 

	{

		if(!pNodo->m_pModelo3ds) return;



		pNodo->m_IDListaDisplay += DesplazamientoListaDisplay;



		glNewList(pNodo->m_IDListaDisplay,GL_COMPILE);



		int contador = 0;

		

		int cuentaObjetos = pNodo->m_pListaObjetos.size();

		int cuentaMateriales = pMundoRaiz->pMateriales.size();



		while(contador < cuentaObjetos)

		{

			int i = pNodo->m_pListaObjetos[contador];



			sObjeto3d *pObjeto     = &pNodo->m_pModelo3ds->pObjeto[i];

			sObjeto3d *pObjetoRaiz = &pMundoRaiz->pObjeto[i];



			if(pObjetoRaiz->TieneTextura) 

			{

				glEnable(GL_TEXTURE_2D);



				glColor3ub(255, 255, 255);



				glBindTexture(GL_TEXTURE_2D, g_mTexturas[pObjetoRaiz->IDMaterial]);

			} 

			else 

			{

				glDisable(GL_TEXTURE_2D);



				glColor3ub(255, 255, 255);

			}



			if(cuentaMateriales && pObjetoRaiz->IDMaterial >= 0) 

			{

				BYTE *pColor = pMundoRaiz->pMateriales[pObjetoRaiz->IDMaterial].color;



				glColor3ub(pColor[0], pColor[1], pColor[2]);

			}



			if(pObjetoRaiz->pCoordenadas) 

			{

				glEnableClientState(GL_TEXTURE_COORD_ARRAY);



				glTexCoordPointer(2, GL_FLOAT, 0, pObjetoRaiz->pCoordenadas);

			}



			if(pObjetoRaiz->pVertices)

			{

				glEnableClientState(GL_VERTEX_ARRAY);



				glVertexPointer(3, GL_FLOAT, 0, pObjetoRaiz->pVertices);

			}



			if(pObjetoRaiz->pNormales)

			{

				glEnableClientState(GL_NORMAL_ARRAY);



				glNormalPointer(GL_FLOAT, 0, pObjetoRaiz->pNormales);

			}



			glDrawElements(GL_TRIANGLES,    pObjeto->NumeroCaras * 3, 

						   GL_UNSIGNED_INT, pObjeto->pIndices);



			contador++;

		}



		glEndList();

	}

}

*/



void COGLOctree::CreaListaDisplay(COGLObjeto *pObj,COGLOctree *pNodo,int DesplazamientoListaDisplay)

{

	if(!pNodo)

		return;



	if(pNodo->EstaSubdividido())

	{

		CreaListaDisplay(pObj,pNodo->m_pNodosOctree[ARRIBA_IZQUIERDA_ADELANTE], DesplazamientoListaDisplay);

		CreaListaDisplay(pObj,pNodo->m_pNodosOctree[ARRIBA_IZQUIERDA_ATRAS], DesplazamientoListaDisplay);

		CreaListaDisplay(pObj,pNodo->m_pNodosOctree[ARRIBA_DERECHA_ATRAS], DesplazamientoListaDisplay);

		CreaListaDisplay(pObj,pNodo->m_pNodosOctree[ARRIBA_DERECHA_ADELANTE], DesplazamientoListaDisplay);

		CreaListaDisplay(pObj,pNodo->m_pNodosOctree[ABAJO_IZQUIERDA_ADELANTE], DesplazamientoListaDisplay);

		CreaListaDisplay(pObj,pNodo->m_pNodosOctree[ABAJO_IZQUIERDA_ATRAS], DesplazamientoListaDisplay);

		CreaListaDisplay(pObj,pNodo->m_pNodosOctree[ABAJO_DERECHA_ATRAS], DesplazamientoListaDisplay);

		CreaListaDisplay(pObj,pNodo->m_pNodosOctree[ABAJO_DERECHA_ADELANTE], DesplazamientoListaDisplay);

	}

	else 

	{

		if(!pNodo->m_pModelo3ds) return;



		pNodo->m_IDListaDisplay += DesplazamientoListaDisplay;



		glNewList(pNodo->m_IDListaDisplay,GL_COMPILE);



		int contador = 0;

		

		int cuentaObjetos = pNodo->m_pListaObjetos.size();

		int cuentaMateriales = pObj->m_MiModelo.pMateriales.size();



		while(contador < cuentaObjetos)

		{

			int i = pNodo->m_pListaObjetos[contador];



			sObjeto3d *pObjeto     = &pNodo->m_pModelo3ds->pObjeto[i];

			sObjeto3d *pObjetoRaiz = &pObj->m_MiModelo.pObjeto[i];



			if(pObjetoRaiz->TieneTextura) 

			{

				glEnable(GL_TEXTURE_2D);
				glColor3ub(255, 255, 255);
				glBindTexture(GL_TEXTURE_2D, pObj->m_mTexturas[pObjetoRaiz->IDMaterial]);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);


			} 

			else 

			{

				glDisable(GL_TEXTURE_2D);



				glColor3ub(255, 255, 255);

			}



			if(cuentaMateriales && pObjetoRaiz->IDMaterial >= 0) 

			{

				BYTE *pColor = pObj->m_MiModelo.pMateriales[pObjetoRaiz->IDMaterial].color;



				glColor3ub(pColor[0], pColor[1], pColor[2]);

			}



			if(pObjetoRaiz->pCoordenadas) 

			{

				glEnableClientState(GL_TEXTURE_COORD_ARRAY);



				glTexCoordPointer(2, GL_FLOAT, 0, pObjetoRaiz->pCoordenadas);

			}



			if(pObjetoRaiz->pVertices)

			{

				glEnableClientState(GL_VERTEX_ARRAY);



				glVertexPointer(3, GL_FLOAT, 0, pObjetoRaiz->pVertices);

			}



			if(pObjetoRaiz->pNormales)

			{

				glEnableClientState(GL_NORMAL_ARRAY);



				glNormalPointer(GL_FLOAT, 0, pObjetoRaiz->pNormales);

			}



			glDrawElements(GL_TRIANGLES,    pObjeto->NumeroCaras * 3, 

						   GL_UNSIGNED_INT, pObjeto->pIndices);



			contador++;

		}



		glEndList();

	}

}





void DibujaCubo( float x, float y, float z, float size)

{

	glColor3f( 1,0,0 );



	//Calculamos el minimo y el maximo de los puntos del cubo

	float minX = x - size,

		  maxX = x + size;

	float minY = y - size,

		  maxY = y + size;

	float minZ = z - size,

		  maxZ = z + size;



	glBegin( GL_LINES );			

			glVertex3f( minX, minY, minZ );

			glVertex3f( maxX, minY, minZ );



			glVertex3f( minX, minY, maxZ );

			glVertex3f( maxX, minY, maxZ );



			glVertex3f( minX, maxY, minZ );

			glVertex3f( maxX, maxY, minZ );



			glVertex3f( minX, maxY, maxZ );

			glVertex3f( maxX, maxY, maxZ );



			glVertex3f( minX, minY, minZ );

			glVertex3f( minX, maxY, minZ );



			glVertex3f( minX, minY, maxZ );

			glVertex3f( minX, maxY, maxZ );



			glVertex3f( maxX, minY, minZ );

			glVertex3f( maxX, maxY, minZ );



			glVertex3f( maxX, minY, maxZ );

			glVertex3f( maxX, maxY, maxZ );

			

			glVertex3f( minX, minY, minZ );

			glVertex3f( minX, minY, maxZ );



			glVertex3f( minX, maxY, minZ );

			glVertex3f( minX, maxY, maxZ );



			glVertex3f( maxX, minY, minZ );

			glVertex3f( maxX, minY, maxZ );



			glVertex3f( maxX, maxY, minZ );

			glVertex3f( maxX, maxY, maxZ );

	glEnd();	 

}




/*
//COLISIONES CON EL OCTREE

bool COGLOctree::ColisionObjeto( COGLObjeto *pObjeto,sModelo3d *pNodoRaiz )

{

	if( !pObjeto->ColisionCubo( m_vector_centro.m_x, m_vector_centro.m_y, m_vector_centro.m_z, m_Ancho*0.5f ) )

		return false;



	DibujaCubo( m_vector_centro.m_x, m_vector_centro.m_y, m_vector_centro.m_z, m_Ancho*0.5f );	



	if( EstaSubdividido() )

	{

		

		return   ( m_pNodosOctree[ARRIBA_IZQUIERDA_ADELANTE    ] ? m_pNodosOctree[ARRIBA_IZQUIERDA_ADELANTE    ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )

			   ||( m_pNodosOctree[ARRIBA_IZQUIERDA_ATRAS     ] ? m_pNodosOctree[ARRIBA_IZQUIERDA_ATRAS     ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )

			   ||( m_pNodosOctree[ARRIBA_DERECHA_ATRAS    ] ? m_pNodosOctree[ARRIBA_DERECHA_ATRAS    ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )

			   ||( m_pNodosOctree[ARRIBA_DERECHA_ADELANTE   ] ? m_pNodosOctree[ARRIBA_DERECHA_ADELANTE   ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )

			   ||( m_pNodosOctree[ABAJO_IZQUIERDA_ADELANTE ] ? m_pNodosOctree[ABAJO_IZQUIERDA_ADELANTE ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )

			   ||( m_pNodosOctree[ABAJO_IZQUIERDA_ATRAS  ] ? m_pNodosOctree[ABAJO_IZQUIERDA_ATRAS  ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )

			   ||( m_pNodosOctree[ABAJO_DERECHA_ATRAS ] ? m_pNodosOctree[ABAJO_DERECHA_ATRAS ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )

			   ||( m_pNodosOctree[ABAJO_DERECHA_ADELANTE] ? m_pNodosOctree[ABAJO_DERECHA_ADELANTE]->ColisionObjeto(pObjeto, pNodoRaiz ) : false );



	}

	else

	{

		//Si este nodo no est subdividido puede tener algo de geometra

		int contador = 0;			

		bool ret = false;			



		int cuentaObjetos = m_pListaObjetos.size();



		while( contador < cuentaObjetos )

		{

				int i = m_pListaObjetos[ contador++ ];			

				

				sObjeto3d *pObject    = &(  m_pModelo3ds->pObjeto[i]);

				sObjeto3d *pObjetoRaiz = &(pNodoRaiz->pObjeto[i]);				



				COGLVector3d triangulo[3];



				//Recorremos todas las caras y testeamos la posible interseccin esfera-tringulo

				for(int j = 0; j < pObject->NumeroCaras*3; j+=3)

				{		

						triangulo[0]  = pObjetoRaiz->pVertices[ pObject->pIndices[j] ];

						triangulo[1]  = pObjetoRaiz->pVertices[ pObject->pIndices[j+1] ];

						triangulo[2]  = pObjetoRaiz->pVertices[ pObject->pIndices[j+2] ];

						

						ret = pObjeto->ColisionTriangulo( triangulo );



						if( ret )

						{

							glColor3f( 1, 1, 1 );

							g_TotalColisiones++;			

						}

						else

							glColor3f( 0, 0, 1 );



							glBegin( GL_LINE_STRIP );

								glVertex3f( triangulo[0].m_x, triangulo[0].m_y, triangulo[0].m_z );

								glVertex3f( triangulo[1].m_x, triangulo[1].m_y, triangulo[1].m_z );

								glVertex3f( triangulo[2].m_x, triangulo[2].m_y, triangulo[2].m_z );

								glVertex3f( triangulo[0].m_x, triangulo[0].m_y, triangulo[0].m_z );

							glEnd();



						g_TotalTestColisiones++;

						

						if( ret)

							return true;

				}

		}



		return false;

	}

}
*/

//COLISIONES CON EL OCTREE
bool COGLOctree::ColisionObjeto( COGLObjeto *pObjeto,sModelo3d *pNodoRaiz )
{
	if( !pObjeto->ColisionCubo( m_vector_centro.m_x, m_vector_centro.m_y, m_vector_centro.m_z, m_Ancho*0.5f ) )
		return false;

	//DibujaCubo( m_vector_centro.m_x, m_vector_centro.m_y, m_vector_centro.m_z, m_Ancho*0.5f );	

	if( EstaSubdividido() )
	{
		
		return   ( m_pNodosOctree[ARRIBA_IZQUIERDA_ADELANTE    ] ? m_pNodosOctree[ARRIBA_IZQUIERDA_ADELANTE    ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )
			   ||( m_pNodosOctree[ARRIBA_IZQUIERDA_ATRAS     ] ? m_pNodosOctree[ARRIBA_IZQUIERDA_ATRAS     ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )
			   ||( m_pNodosOctree[ARRIBA_DERECHA_ATRAS    ] ? m_pNodosOctree[ARRIBA_DERECHA_ATRAS    ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )
			   ||( m_pNodosOctree[ARRIBA_DERECHA_ADELANTE   ] ? m_pNodosOctree[ARRIBA_DERECHA_ADELANTE   ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )
			   ||( m_pNodosOctree[ABAJO_IZQUIERDA_ADELANTE ] ? m_pNodosOctree[ABAJO_IZQUIERDA_ADELANTE ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )
			   ||( m_pNodosOctree[ABAJO_IZQUIERDA_ATRAS  ] ? m_pNodosOctree[ABAJO_IZQUIERDA_ATRAS  ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )
			   ||( m_pNodosOctree[ABAJO_DERECHA_ATRAS ] ? m_pNodosOctree[ABAJO_DERECHA_ATRAS ]->ColisionObjeto(pObjeto, pNodoRaiz ) : false )
			   ||( m_pNodosOctree[ABAJO_DERECHA_ADELANTE] ? m_pNodosOctree[ABAJO_DERECHA_ADELANTE]->ColisionObjeto(pObjeto, pNodoRaiz ) : false );

	}
	else
	{
		//Si este nodo no est subdividido puede tener algo de geometra
		int contador = 0;			
		bool ret = false;			

		int cuentaObjetos = m_pListaObjetos.size();

		while( contador < cuentaObjetos )
		{
				int i = m_pListaObjetos[ contador++ ];			
				
				sObjeto3d *pObject    = &(  m_pModelo3ds->pObjeto[i]);
				sObjeto3d *pObjetoRaiz = &(pNodoRaiz->pObjeto[i]);				

				COGLVector3d triangulo[3];

				//Recorremos todas las caras y testeamos la posible interseccin esfera-tringulo
				for(int j = 0; j < pObject->NumeroCaras*3; j+=3)
				{		
						triangulo[0]  = pObjetoRaiz->pVertices[ pObject->pIndices[j] ];
						triangulo[1]  = pObjetoRaiz->pVertices[ pObject->pIndices[j+1] ];
						triangulo[2]  = pObjetoRaiz->pVertices[ pObject->pIndices[j+2] ];
						
						ret = pObjeto->ColisionTriangulo( triangulo );

						if( ret )
						{
							glColor3f( 1, 1, 1 );
							g_TotalColisiones++;			
						}
						else

							g_TotalTestColisiones++;
								
							if( ret)
								return true;
				}
		}

		return false;
	}
}






//Notas sobre el OSP (Octree Space Partition)

//

//Existen dos formas principales de construir una estructura octree:

//-Limite de volumenes jerrquico

//-La subdivisin cannica del espacio

//Existen varias opciones para finalizar la recursin del octree:

//-Por nmero de tringulos

//-Por nivel de subdivisin

//-Por nmero de nodos

