#include "..\Miscelanea\Cajas.h"
#include "..\GFX\Texturas.h"

	
UINT	g_mTexturasCajas[50] = {0};			// Matriz Texturas 


COGLCaja::COGLCaja()
{
	g_bAccionada=false;
}


void COGLCaja::Accionar()
{
	if (posicion_actual.m_y=posicion_inicial.m_y)
		g_bAccionada=true;

}	


void COGLCaja::CargarTextura(char *pNombreArchivo,int Textura)
{
	COGLTextura		TexturaCaja;

	TexturaCaja.CargarArchivo(g_mTexturasCajas,pNombreArchivo,Textura);
	IDTextura=Textura;
}


void COGLCaja::AsignaPosicion(float posx, float posy, float posz, int Tip,int Ori)
{
	float PosFin=0;
	
	//Posicion caja sin accionar
	posicion_inicial.m_x=posx;
	posicion_inicial.m_y=posy;
	posicion_inicial.m_z=posz;

	if (Tip==0) 
    	PosFin=100;
	else if (Tip==1) 
		PosFin=3;
	else if (Tip==2) 
		PosFin=0;

	Tipo=Tip;
	

	//Posicion caja accionada segun su orientacion
	//X
	if (Ori==0) 
    {
		posicion_final.m_x=posicion_inicial.m_x+PosFin;
		posicion_final.m_y=posicion_inicial.m_y;
		posicion_final.m_z=posicion_inicial.m_z;

	}
	//Y
	else if (Ori==1) 
    {
		posicion_final.m_x=posicion_inicial.m_x;
		posicion_final.m_y=posicion_inicial.m_y+PosFin;
		posicion_final.m_z=posicion_inicial.m_z;
	}
	//Z
	else if (Ori==2) 
    {
		posicion_final.m_x=posicion_inicial.m_x;
		posicion_final.m_y=posicion_inicial.m_y;
		posicion_final.m_z=posicion_inicial.m_z+PosFin;
	}
	//-X
	else if (Ori==3) 
    {
		posicion_final.m_x=posicion_inicial.m_x-PosFin;
		posicion_final.m_y=posicion_inicial.m_y;
		posicion_final.m_z=posicion_inicial.m_z;
	}
	//-Y
	else if (Ori==4) 
    {
		posicion_final.m_x=posicion_inicial.m_x;
		posicion_final.m_y=posicion_inicial.m_y-PosFin;
		posicion_final.m_z=posicion_inicial.m_z;
	}
	//-Z
	else if (Ori==5) 
    {
		posicion_final.m_x=posicion_inicial.m_x;
		posicion_final.m_y=posicion_inicial.m_y;
		posicion_final.m_z=posicion_inicial.m_z-PosFin;
	}
	
	Orientacion=Ori;

	//Posicion actual
	posicion_actual.m_x=posicion_inicial.m_x;
	posicion_actual.m_y=posicion_inicial.m_y;
	posicion_actual.m_z=posicion_inicial.m_z;
}



void COGLCaja::DibujaCaja(float ancho, float alto, float largo, int Textura, int Tipo, int Orientacion)
{		
	
	float velAccion;


	if (Tipo==0) 
    	velAccion=0.8;
	else if (Tipo==1) 
		velAccion=0.5;
	else if (Tipo==2) 
		velAccion=0;


	if(g_bAccionada==true) 
	{	
		//X
		if (Orientacion==0)  
		{
			posicion_actual.m_x+=velAccion;
			if(posicion_actual.m_x>=posicion_final.m_x)
				g_bAccionada=false;
		}
		//Y
		else if (Orientacion==1)  
		{
			posicion_actual.m_y+=velAccion;
			if(posicion_actual.m_y>=posicion_final.m_y)
				g_bAccionada=false;
		}
		//Z
		else if (Orientacion==2) 
		{
			posicion_actual.m_z+=velAccion;
			if(posicion_actual.m_z>=posicion_final.m_z)
				g_bAccionada=false;
		}
		//-X
		else if (Orientacion==3) 
		{
			posicion_actual.m_x-=velAccion;
			if(posicion_actual.m_x<=posicion_final.m_x)
				g_bAccionada=false;
		}
		//-Y
		else if (Orientacion==4) 
		{
			posicion_actual.m_y-=velAccion;
			if(posicion_actual.m_y<=posicion_final.m_y)
				g_bAccionada=false;
		}
		//-Z
		else if (Orientacion==5) 
		{
			posicion_actual.m_z-=velAccion;
			if(posicion_actual.m_z<=posicion_final.m_z)
				g_bAccionada=false;
		}

	}
	//X
	else if (Orientacion==0)  
		{
			if(posicion_actual.m_x>posicion_inicial.m_x)
			posicion_actual.m_x-=velAccion;
		}
	//Y
	else if (Orientacion==1)  
		{
			if(posicion_actual.m_y>posicion_inicial.m_y)
			posicion_actual.m_y-=velAccion;
		}
	//Z
	else if (Orientacion==2)  
		{
			if(posicion_actual.m_z>posicion_inicial.m_z)
			posicion_actual.m_z-=velAccion;
		}
	//-X
	else if (Orientacion==3)  
		{
			if(posicion_actual.m_x<posicion_inicial.m_x)
			posicion_actual.m_x+=velAccion;
		}
	//-Y
	else if (Orientacion==4)  
		{
			if(posicion_actual.m_y<posicion_inicial.m_y)
			posicion_actual.m_y+=velAccion;
		}
	//-Z
	else if (Orientacion==5)  
		{
			if(posicion_actual.m_z<posicion_inicial.m_z)
			posicion_actual.m_z+=velAccion;
		}		
	

	//Se crea una caja con la textura y dimensiones especificadas
    glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, Textura);
	glBegin(GL_QUADS);
		glTexCoord2f(1.0f, 0.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y,	     posicion_actual.m_z);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y + alto, posicion_actual.m_z); 
		glTexCoord2f(0.0f, 1.0f); glVertex3f(posicion_actual.m_x,			posicion_actual.m_y + alto, posicion_actual.m_z);
		glTexCoord2f(0.0f, 0.0f); glVertex3f(posicion_actual.m_x,			posicion_actual.m_y,		 posicion_actual.m_z);
	glEnd();
	
	glBegin(GL_QUADS);	
		glTexCoord2f(1.0f, 0.0f); glVertex3f(posicion_actual.m_x,		   posicion_actual.m_y,		posicion_actual.m_z + largo);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(posicion_actual.m_x,		   posicion_actual.m_y + alto, posicion_actual.m_z + largo);
		glTexCoord2f(0.0f, 1.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y + alto, posicion_actual.m_z + largo); 
		glTexCoord2f(0.0f, 0.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y,		posicion_actual.m_z + largo);
	glEnd();

	glBegin(GL_QUADS);		
		glTexCoord2f(1.0f, 0.0f); glVertex3f(posicion_actual.m_x,		   posicion_actual.m_y,			posicion_actual.m_z);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(posicion_actual.m_x,		   posicion_actual.m_y,			posicion_actual.m_z + largo);
		glTexCoord2f(0.0f, 1.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y,			posicion_actual.m_z + largo); 
		glTexCoord2f(0.0f, 0.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y,			posicion_actual.m_z);
	glEnd();

	glBegin(GL_QUADS);		
		glTexCoord2f(0.0f, 1.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y + alto, posicion_actual.m_z);
		glTexCoord2f(0.0f, 0.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y + alto, posicion_actual.m_z + largo); 
		glTexCoord2f(1.0f, 0.0f); glVertex3f(posicion_actual.m_x,		   posicion_actual.m_y + alto,	posicion_actual.m_z + largo);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(posicion_actual.m_x,		   posicion_actual.m_y + alto,	posicion_actual.m_z);
	glEnd();

	glBegin(GL_QUADS);		
		glTexCoord2f(1.0f, 1.0f); glVertex3f(posicion_actual.m_x,			posicion_actual.m_y + alto,	posicion_actual.m_z);	
		glTexCoord2f(0.0f, 1.0f); glVertex3f(posicion_actual.m_x,			posicion_actual.m_y + alto,	posicion_actual.m_z + largo); 
		glTexCoord2f(0.0f, 0.0f); glVertex3f(posicion_actual.m_x,			posicion_actual.m_y,			posicion_actual.m_z + largo);
		glTexCoord2f(1.0f, 0.0f); glVertex3f(posicion_actual.m_x,			posicion_actual.m_y,			posicion_actual.m_z);		
	glEnd();

	glBegin(GL_QUADS);		
		glTexCoord2f(0.0f, 0.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y,		posicion_actual.m_z);
		glTexCoord2f(1.0f, 0.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y,		posicion_actual.m_z + largo);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y + alto,	posicion_actual.m_z + largo); 
		glTexCoord2f(0.0f, 1.0f); glVertex3f(posicion_actual.m_x + ancho, posicion_actual.m_y + alto,	posicion_actual.m_z);
	glEnd();
	glDisable(GL_TEXTURE_2D);

}
