#ifndef __VECTOR_H__
#define __VECTOR_H__

#include <math.h>


class COGLVector3d{

public:
	//Constructor por defecto
	COGLVector3d() {}

	//Este el constructor que permite inicializar el vector
	COGLVector3d(float x,float y,float z)
	{
		m_x=x;
		m_y=y;
		m_z=z;
	}

	/////////////////////////////////////////////////////////////////////////
	// Sobrecarga de operadores para poder hacer operaciones entre vectores//
	/////////////////////////////////////////////////////////////////////////
	COGLVector3d operator+(COGLVector3d vector_temp)
	{
		return COGLVector3d(vector_temp.m_x + m_x, vector_temp.m_y + m_y, vector_temp.m_z + m_z);
	}

	COGLVector3d operator-(COGLVector3d vector_temp)
	{
		return COGLVector3d(m_x - vector_temp.m_x, m_y - vector_temp.m_y, m_z - vector_temp.m_z);
	}
	
	COGLVector3d operator*(float num)
	{
		return COGLVector3d(m_x * num, m_y * num, m_z * num);
	}

	COGLVector3d operator/(float num)
	{
		return COGLVector3d(m_x / num, m_y / num, m_z / num);
	}

	float m_x;
	float m_y;
	float m_z;
};

#endif __VECTOR_H__