#ifndef __GEOMETRIA_H__
#define __GEOMETRIA_H__

#include <float.h>

#include "Vector2d.h"
#include "Vector3d.h"

#define PI 3.1415926535897932					

#define DETRAS 0
#define INTERSECCION 1
#define ADELANTE 2

/////////////////////////////////////////////////////////////////////////
// Funciones bsicas vectores										   //
/////////////////////////////////////////////////////////////////////////
COGLVector2d CreaVector2d(COGLVector3d punto1, COGLVector3d punto2);
COGLVector3d CreaVector3d(COGLVector3d punto1, COGLVector3d punto2);

float		 LongitudVector2d(COGLVector2d vector_temp);
float		 LongitudVector3d(COGLVector3d vector_temp);

COGLVector2d NormalizarVector2d(COGLVector2d vector_temp);
COGLVector3d NormalizarVector3d(COGLVector3d vector_temp);
COGLVector3d Normalizar(COGLVector3d vPoligono[]);

float		 Absoluto(float num);
float		 ProductoEscalar(COGLVector3d vector1,COGLVector3d vector2);
COGLVector3d ProductoVectorial(COGLVector3d vector1, COGLVector3d vector2);
COGLVector3d DivideVectorPorEscalar(COGLVector3d vector_temp, float escalar);

double		 AnguloEntreVectores(COGLVector3d vector1,COGLVector3d vector2);

float		 DistanciaPlano(COGLVector3d Normal,COGLVector3d Punto);
bool		 InterseccionPlano(COGLVector3d Poligono[],COGLVector3d Linea[],COGLVector3d &vector_normal,float &distancia_origen);
COGLVector3d PuntoInterseccionLineaPlano(COGLVector3d vector_normal, COGLVector3d Linea[], double distancia);
bool		 DentroPoligono(COGLVector3d vector_interseccion, COGLVector3d poligono[], long nVertices);
bool		 InterseccionPoligono(COGLVector3d Poligono[], COGLVector3d Linea[], int nVertices);
int			 ClasificacionEsfera(COGLVector3d &vector_centro,COGLVector3d &vector_normal, COGLVector3d &punto, float radio, float &distancia);
bool		 ColisionEsferaPoligono(COGLVector3d Poligono[],COGLVector3d &vector_centro, int nVertices, float Radio);
COGLVector3d PuntoMasCerradoLinea(COGLVector3d vector1, COGLVector3d vector2, COGLVector3d Punto);
bool		 EdgeSphereCollision(COGLVector3d &vector_centro,COGLVector3d Poligono[], int nVertices, float Radio);
COGLVector3d ConsigueDesplazamientoColision(COGLVector3d &vector_normal, float radio, float distancia);
//////////////////////////////////////////////////////////////////////////

#endif