#include "Texturas.h"
#include <stdio.h>
#include <string.h>

#define GL_CLAMP_TO_EDGE  0x812F

void COGLTextura::CargarArchivo(UINT MatrizTexturas[],char *pNombreArchivo,int IDTextura)
{
	char NombreArchivo[22]="Texturas/";
	strcat(NombreArchivo,pNombreArchivo);
		
	//COMPROBACION DE TIPO
	//BMP  
	if ( (strstr(NombreArchivo, ".bmp")) || (strstr(NombreArchivo, ".BMP")) )
	{
		CargarBMP(MatrizTexturas,NombreArchivo,IDTextura);
	}
}


void COGLTextura::CargarBMP(UINT MatrizTexturas[], char NombreArchivo[22],int IDTextura)
{
	FILE *pArchivo= NULL;
	if((pArchivo = fopen(NombreArchivo, "rb")) == NULL)  // Si tenemos un puntero valido hemos encontrado el archivo
	{
		MessageBox(NULL,("Error al abrir la textura %s",NombreArchivo),"CargaTexturaBMP",MB_OK);
		exit(1);
	} 

	_AUX_RGBImageRec *pImagenBMP;
	pImagenBMP= auxDIBImageLoadA( NombreArchivo );  // Cargar el mapa de bits y almacenar la informacion

	GenerarTextura(pImagenBMP->sizeX, pImagenBMP->sizeY, pImagenBMP->data, GL_RGB, MatrizTexturas,IDTextura);

	fclose(pArchivo);

	if (pImagenBMP)										// Si se ha cargado el mapa de bits
	{
		if (pImagenBMP->data)								// Si se ha cargado informacion de textura
 		{
			free(pImagenBMP->data);						// Se descarga la informacion de textura
		}
		free(pImagenBMP);									// se descarga el mapa de bits
	}
}	


void COGLTextura::GenerarTextura(int Ancho,int Alto, unsigned char *Datos,int TipoTextura,UINT MatrizTexturas[],int IDTextura)
{
	// Generamos la textura con el ID de la matriz
	glGenTextures(1, &MatrizTexturas[IDTextura]); 
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

	// Asociamos la textura a la matriz
	glBindTexture(GL_TEXTURE_2D, MatrizTexturas[IDTextura]);

	// Se crean diferentes versiones de la imagen para distintas distancias
	gluBuild2DMipmaps(	GL_TEXTURE_2D, 3, Ancho,Alto,TipoTextura,GL_UNSIGNED_BYTE,Datos);

	//Se establece la calidad de la textura Linear= suavizada, Nearest=pixelada
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR_MIPMAP_LINEAR);

	//Evita la repeticion de textura para cubrir una superficie
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
}
