#include "Frustum.h"

///////////////////////////////// NORMALIZAR PLANO \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	Normaliza el plano que le digamos(lado) del frustum(frustum).
/////
///////////////////////////////// NORMALIZAR PLANO \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
void NormalizaPlano(float frustum[6][4], int lado)
{
	//Primero calculamos el valor absoluto(magnitud) de la normal del
	//plano, usease (punto A B C), es decir, el vector normal al plano
	//Para obtener el valor absoluto utilizaremos la formula de toda la
	//vida |v|=sqrt(x*x+y*y+z*z)
	float magnitud = (float)sqrt(frustum[lado][A] * frustum[lado][A] + 
								 frustum[lado][B] * frustum[lado][B] + 
								 frustum[lado][C] * frustum[lado][C] );

	//Y por ltimo dividimos los coeficientes del plano por el valor absoluto
	//de la normal, y ya t :)
	frustum[lado][A] /= magnitud;
	frustum[lado][B] /= magnitud;
	frustum[lado][C] /= magnitud;
	frustum[lado][D] /= magnitud; 
}


void COGLFrustum::CalcularFrustum()
{
	float matriz_proyeccion[16];
	float matriz_modelado[16];
	float matriz_clipping[16];

	//Obtenemos la matriz de proyeccion de Opengl, se almacena como un vector[16], no como una matriz[4][4]
	glGetFloatv(GL_PROJECTION_MATRIX,matriz_proyeccion);
	//Lo mismo que antes, ahora con la de modelado
	glGetFloatv(GL_MODELVIEW_MATRIX,matriz_modelado);

	//Dadas la matriz de proyeccion y la de modelado ahora obtenemos los planos de corte, es decir la matriz de
	//recorte, la formula es:
	//Nota:La matriz de modelado y la de proyeccion son dos vectores, pero se multiplican en forma de matriz, es
	//decir, vector[1,2,3,4,5,6,7,8] <=>matriz[1,2,3,4]	
	//										  [5,6,7,8]
	//MODELVIEW*PROYECCION=CLIPPING
	matriz_clipping[0]=matriz_modelado[0]*matriz_proyeccion[0]+matriz_modelado[1]*matriz_proyeccion[4]+
						 matriz_modelado[2]*matriz_proyeccion[8]+matriz_modelado[3]*matriz_proyeccion[12];
	matriz_clipping[1]=matriz_modelado[0]*matriz_proyeccion[1]+matriz_modelado[1]*matriz_proyeccion[5]+
						 matriz_modelado[2]*matriz_proyeccion[9]+matriz_modelado[3]*matriz_proyeccion[13];
	matriz_clipping[2]=matriz_modelado[0]*matriz_proyeccion[2]+matriz_modelado[1]*matriz_proyeccion[6]+
						 matriz_modelado[2]*matriz_proyeccion[10]+matriz_modelado[3]*matriz_proyeccion[14];
	matriz_clipping[3]=matriz_modelado[0]*matriz_proyeccion[3]+matriz_modelado[1]*matriz_proyeccion[7]+
						 matriz_modelado[2]*matriz_proyeccion[11]+matriz_modelado[3]*matriz_proyeccion[15];

	matriz_clipping[4]=matriz_modelado[4]*matriz_proyeccion[0]+matriz_modelado[5]*matriz_proyeccion[4]+
						 matriz_modelado[6]*matriz_proyeccion[8]+matriz_modelado[7]*matriz_proyeccion[12];
	matriz_clipping[5]=matriz_modelado[4]*matriz_proyeccion[1]+matriz_modelado[5]*matriz_proyeccion[5]+
						 matriz_modelado[6]*matriz_proyeccion[9]+matriz_modelado[7]*matriz_proyeccion[13];
	matriz_clipping[6]=matriz_modelado[4]*matriz_proyeccion[2]+matriz_modelado[5]*matriz_proyeccion[6]+
						 matriz_modelado[6]*matriz_proyeccion[10]+matriz_modelado[7]*matriz_proyeccion[14];
	matriz_clipping[7]=matriz_modelado[4]*matriz_proyeccion[3]+matriz_modelado[5]*matriz_proyeccion[7]+
						 matriz_modelado[6]*matriz_proyeccion[11]+matriz_modelado[7]*matriz_proyeccion[15];

	matriz_clipping[8]=matriz_modelado[8]*matriz_proyeccion[0]+matriz_modelado[9]*matriz_proyeccion[4]+
						 matriz_modelado[10]*matriz_proyeccion[8]+matriz_modelado[11]*matriz_proyeccion[12];
	matriz_clipping[9]=matriz_modelado[8]*matriz_proyeccion[1]+matriz_modelado[9]*matriz_proyeccion[5]+
						 matriz_modelado[10]*matriz_proyeccion[9]+matriz_modelado[11]*matriz_proyeccion[13];
	matriz_clipping[10]=matriz_modelado[8]*matriz_proyeccion[2]+matriz_modelado[9]*matriz_proyeccion[6]+
						 matriz_modelado[10]*matriz_proyeccion[10]+matriz_modelado[11]*matriz_proyeccion[14];
	matriz_clipping[11]=matriz_modelado[8]*matriz_proyeccion[3]+matriz_modelado[9]*matriz_proyeccion[7]+
						 matriz_modelado[10]*matriz_proyeccion[11]+matriz_modelado[11]*matriz_proyeccion[15];

	matriz_clipping[12]=matriz_modelado[12]*matriz_proyeccion[0]+matriz_modelado[13]*matriz_proyeccion[4]+
						 matriz_modelado[14]*matriz_proyeccion[8]+matriz_modelado[15]*matriz_proyeccion[12];
	matriz_clipping[13]=matriz_modelado[12]*matriz_proyeccion[1]+matriz_modelado[13]*matriz_proyeccion[5]+
						 matriz_modelado[14]*matriz_proyeccion[9]+matriz_modelado[15]*matriz_proyeccion[13];
	matriz_clipping[14]=matriz_modelado[12]*matriz_proyeccion[2]+matriz_modelado[13]*matriz_proyeccion[6]+
						 matriz_modelado[14]*matriz_proyeccion[10]+matriz_modelado[15]*matriz_proyeccion[14];
	matriz_clipping[15]=matriz_modelado[12]*matriz_proyeccion[3]+matriz_modelado[13]*matriz_proyeccion[7]+
						 matriz_modelado[14]*matriz_proyeccion[11]+matriz_modelado[15]*matriz_proyeccion[15];


	/**************************************
	  CLCULO DE LOS PLANOS DEL FRUSTUM
	 
	  Cclip=columna de la matriz clipping
	
	  PLANO_IZQUIERDO=Cclip[3]+Cclip[0]
	  PLANO_DERECHO=Cclip[3]-Cclip[0]
	  PLANO_INFERIOR=Cclip[3]+Cclip[1]
	  PLANO_SUPERIOR=Cclip[3]-Cclip[1]
	  PLANO_LEJANO=Cclip[3]+Cclip[2]
	  PLANO_CERCANO=Cclip[3]-Cclip[2]
	***************************************/
	
	//Extraemos el plano derecho
	m_matriz_frustum[PLANO_DERECHO][A] = matriz_clipping[ 3] - matriz_clipping[ 0];
	m_matriz_frustum[PLANO_DERECHO][B] = matriz_clipping[ 7] - matriz_clipping[ 4];
	m_matriz_frustum[PLANO_DERECHO][C] = matriz_clipping[11] - matriz_clipping[ 8];
	m_matriz_frustum[PLANO_DERECHO][D] = matriz_clipping[15] - matriz_clipping[12];

	//Normalizamos el plano derecho
	NormalizaPlano(m_matriz_frustum, PLANO_DERECHO);

	//Extraemos el plano izquierdo
	m_matriz_frustum[PLANO_IZQUIERDO][A] = matriz_clipping[ 3] + matriz_clipping[ 0];
	m_matriz_frustum[PLANO_IZQUIERDO][B] = matriz_clipping[ 7] + matriz_clipping[ 4];
	m_matriz_frustum[PLANO_IZQUIERDO][C] = matriz_clipping[11] + matriz_clipping[ 8];
	m_matriz_frustum[PLANO_IZQUIERDO][D] = matriz_clipping[15] + matriz_clipping[12];

	//Normalizamos el plano izquierdo
	NormalizaPlano(m_matriz_frustum, PLANO_IZQUIERDO);

	//Extraemos el plano inferior
	m_matriz_frustum[PLANO_INFERIOR][A] = matriz_clipping[ 3] + matriz_clipping[ 1];
	m_matriz_frustum[PLANO_INFERIOR][B] = matriz_clipping[ 7] + matriz_clipping[ 5];
	m_matriz_frustum[PLANO_INFERIOR][C] = matriz_clipping[11] + matriz_clipping[ 9];
	m_matriz_frustum[PLANO_INFERIOR][D] = matriz_clipping[15] + matriz_clipping[13];

	//Normalizamos el plano inferior
	NormalizaPlano(m_matriz_frustum, PLANO_INFERIOR);

	//Extraemos el plano superior
	m_matriz_frustum[PLANO_SUPERIOR][A] = matriz_clipping[ 3] - matriz_clipping[ 1];
	m_matriz_frustum[PLANO_SUPERIOR][B] = matriz_clipping[ 7] - matriz_clipping[ 5];
	m_matriz_frustum[PLANO_SUPERIOR][C] = matriz_clipping[11] - matriz_clipping[ 9];
	m_matriz_frustum[PLANO_SUPERIOR][D] = matriz_clipping[15] - matriz_clipping[13];

	//Normalizamos el plano superior
	NormalizaPlano(m_matriz_frustum, PLANO_SUPERIOR);

	//Extraemos el plano lejano
	m_matriz_frustum[PLANO_LEJANO][A] = matriz_clipping[ 3] - matriz_clipping[ 2];
	m_matriz_frustum[PLANO_LEJANO][B] = matriz_clipping[ 7] - matriz_clipping[ 6];
	m_matriz_frustum[PLANO_LEJANO][C] = matriz_clipping[11] - matriz_clipping[10];
	m_matriz_frustum[PLANO_LEJANO][D] = matriz_clipping[15] - matriz_clipping[14];

	//Normalizamos el plano lejano
	NormalizaPlano(m_matriz_frustum, PLANO_LEJANO);

	//Extraemos el plano cercano
	m_matriz_frustum[PLANO_CERCANO][A] = matriz_clipping[ 3] + matriz_clipping[ 2];
	m_matriz_frustum[PLANO_CERCANO][B] = matriz_clipping[ 7] + matriz_clipping[ 6];
	m_matriz_frustum[PLANO_CERCANO][C] = matriz_clipping[11] + matriz_clipping[10];
	m_matriz_frustum[PLANO_CERCANO][D] = matriz_clipping[15] + matriz_clipping[14];

	//Normalizamos el plano cercano
	NormalizaPlano(m_matriz_frustum, PLANO_CERCANO);
}


///////////////////////////////// PUNTO EN FRUSTUM? \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	Determina si un punto est dentro del frustum.
/////
///////////////////////////////// PUNTO EN FRUSTUM? \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
bool COGLFrustum::PuntoEnFrustum( float x, float y, float z )
{
	//Recorremos todos los planos del frustum
	for(int i = 0; i < 6; i++ )
	{
		//Calculamos la ecuacin del plano y comprobamos si el punto est detrs del plano del frustum
		//Es la formula de toda la vida, A*x+B*y+C*z+D->si <0 est detrs si es 0 est en el plano y si es >0 est delante
		if(m_matriz_frustum[i][A] * x + m_matriz_frustum[i][B] * y + m_matriz_frustum[i][C] * z + m_matriz_frustum[i][D] <= 0)
		{
			//Si est detrs del plano, es que no est dentro del frustum
			return false;
		}
	}

	return true;
}

///////////////////////////////// ESFERA EN FRUSTUM? \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	Determina si una esfera est dentro del frustum.
/////
///////////////////////////////// ESFERA EN FRUSTUM? \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
bool COGLFrustum::EsferaEnFrustum(float x, float y, float z, float radio )
{
	//Es lo mismo que lo anteriormente comentado en punto en frustum, a diferencia
	//que aqu para comprobar si est dentro es A*x+B*y+C*z+D->si es menor que -radio est
	//detrs
	for(int i = 0; i < 6; i++ )	
	{
		if( m_matriz_frustum[i][A] * x + m_matriz_frustum[i][B] * y + m_matriz_frustum[i][C] * z + m_matriz_frustum[i][D] <= -radio )
		{
			return false;
		}
	}
	
	return true;
}

///////////////////////////////// CUBO EN FRUSTUM? \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
/////
/////	Determina si un cubo esta dentro o alrededor del frustum por su centro y la
/////	mitad de su longitud
/////
///////////////////////////////// CUBO EN FRUSTUM? \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*
bool COGLFrustum::CuboEnFrustum( float x, float y, float z, float size )
{
	//Comprobamos todos los vertices del cubo, si alguno de ellos est dentro
	//del frustum se rompe el for y devolvemos true :p
	for(int i = 0; i < 6; i++ )
	{
		if(m_matriz_frustum[i][A] * (x - size) + m_matriz_frustum[i][B] * (y - size) + m_matriz_frustum[i][C] * (z - size) + m_matriz_frustum[i][D] > 0)
		   continue;
		if(m_matriz_frustum[i][A] * (x + size) + m_matriz_frustum[i][B] * (y - size) + m_matriz_frustum[i][C] * (z - size) + m_matriz_frustum[i][D] > 0)
		   continue;
		if(m_matriz_frustum[i][A] * (x - size) + m_matriz_frustum[i][B] * (y + size) + m_matriz_frustum[i][C] * (z - size) + m_matriz_frustum[i][D] > 0)
		   continue;
		if(m_matriz_frustum[i][A] * (x + size) + m_matriz_frustum[i][B] * (y + size) + m_matriz_frustum[i][C] * (z - size) + m_matriz_frustum[i][D] > 0)
		   continue;
		if(m_matriz_frustum[i][A] * (x - size) + m_matriz_frustum[i][B] * (y - size) + m_matriz_frustum[i][C] * (z + size) + m_matriz_frustum[i][D] > 0)
		   continue;
		if(m_matriz_frustum[i][A] * (x + size) + m_matriz_frustum[i][B] * (y - size) + m_matriz_frustum[i][C] * (z + size) + m_matriz_frustum[i][D] > 0)
		   continue;
		if(m_matriz_frustum[i][A] * (x - size) + m_matriz_frustum[i][B] * (y + size) + m_matriz_frustum[i][C] * (z + size) + m_matriz_frustum[i][D] > 0)
		   continue;
		if(m_matriz_frustum[i][A] * (x + size) + m_matriz_frustum[i][B] * (y + size) + m_matriz_frustum[i][C] * (z + size) + m_matriz_frustum[i][D] > 0)
		   continue;

		return false;
	}

	return true;
}