#ifndef _3DS_H
#define _3DS_H

#include <math.h>
#include <fstream>
#include <vector>

#include <windows.h>
#include <gl\gl.h>										
#include <gl\glu.h>										
#include <gl\glaux.h>

//Clases de vectores
#include "..\Matematicas\Geometria.h"

using namespace std;

//------ Chunk primario al principio de cada .3ds
#define PRIMARIO       0x4D4D

//------ Chunks principales
#define INFO_OBJETO   0x3D3D				// Informacion de objetos y materiales
#define VERSION       0x0002				// Informacion de el .3ds
#define EDITKEYFRAME  0xB000				// Informacion del key-frame

//------ sub chunks de INFO_OBJETO
#define MATERIAL	  0xAFFF				// Informacion de Textura
#define OBJETO		  0x4000				// Informacion de caras, vertices, etc.

//------ sub chunks de MATERIAL
#define NOMBREMAT       0xA000				// Almacena el nombre del material
#define MATDIFUSO       0xA020				// Almacena el color del objeto/material
#define MATTEXT         0xA200				// Header para nuevo material
#define MATTEXT_ARCHIVO 0xA300				// Almacena el nombre del archivo de textura

#define MALLA_OBJETO    0x4100				// Informacion de cada objeto leido

//------ sub chunks de MALLA_OBJETO
#define VERTICES_OBJETO     0x4110			// Vertices del objeto
#define CARAS_OBJETO   	   	0x4120			// Caras del objeto
#define MATERIAL_OBJETO		0x4130			// Aparece si el objeto tiene un material,textura o color
#define UV_OBJETO			0x4140			// Coordenadas V


// Almacena las matrices de vertices y coordenadas de textura, asi sabemos qu vertices
// forman cada cara y sus coordenadas de textura
struct sCara
{
	int IndiceVertice[3];			// Vertices que forman el triangulo
	int IndiceCoordenada[3];		// Coordenadas de textura para esta cara
};

// Almacena la informacion sobre el material, puede ser una textura o un color.
struct sInfo_Material
{
	char  Nombre[255];			// Nombre de la Textura
	char  Archivo[255];			// Archivo de textura (si tiene uno asignado)
	BYTE  color[3];				// Color del objeto (R,G,B)
	int   IDTextura;			// ID de la textura

	/*
	float uTile;				// u tiling of texture  (Currently not used)
	float vTile;				// v tiling of texture	(Currently not used)
	float uOffset;			    // u offset of texture	(Currently not used)
	float vOffset;				// v offset of texture	(Currently not used)
	*/

} ;

// Almacena informacion sobre el objeto
struct sObjeto3d 
{
	int  NumeroVertices;		// Numero de vertices del modelo (objeto?)
	int  NumeroCaras;			// Numero de caras del modelo (objeto?)
	int  NumeroCoordenada;		// Numero de coordenadas de textura
	int  IDMaterial;			// ID que se usara como indice en la matriz de texturas
	bool TieneTextura;			// Es 'TRUE' si el objeto tiene una textura asignada
	char Nombre[255];			// Nombre del objeto
	
	UINT      *pIndices;		

	COGLVector3d  *pVertices;	// Vertices del Objeto
	COGLVector3d  *pNormales;	// Normales del Objeto
	COGLVector2d  *pCoordenadas;// Coordenadas UV de textura
	sCara *pCaras;				// Informacion de caras del objeto
};


// Almacena informacion sobre el modelo/escena
// !!! Usamos vectores STL (Standar Template Library) !!!
struct sModelo3d 
{
	int NumeroObjetos;					// Numero de objetos que forman el modelo
	int NumeroMateriales;				// Numero de materiales del modelo
	vector<sInfo_Material> pMateriales;	// Conjunto (lista) de informacion de materiales (Texturas y colores)
	vector<sObjeto3d> pObjeto;			// Conjunto (lista) de objetos del modelo
};


//**************************************************************************************
// Here is our structure for our 3DS indicies (since .3DS stores 4 unsigned shorts)
struct sIndices {							

	unsigned short a, b, c, bVisible;		// This will hold point1, 2, and 3 index's into the vertex array plus a visible flag
};
//**************************************************************************************

// Almacena la informacion del chunk
struct sChunk
{
	unsigned short int ID;					
	unsigned int longitud;					
	unsigned int bytesLeidos;				// Cantidad de bytes leidos del chunk
};



class COGL3DS
{
public:
	//Constructor por defecto
	COGL3DS();							

	// Funcion a la que se llama para cargar el modelo
	bool Importar3DS(sModelo3d *pModelo, char *NombreArchivo);

	void DestruyeObjetos(sModelo3d pModelo);

private:
	// This reads in a string and saves it in the char array passed in
	int GetString(char *);

	// Lee el siguiente chunk
	void LeeChunk(sChunk *);

	// Lee el siguiente chunk principal
	void ProcesaSigChunk(sModelo3d *pModelo, sChunk *);

		// Lee los chunks OBJETO
	void ProcesaSigChunkObjeto(sModelo3d *pModelo, sObjeto3d *pObjeto, sChunk *);

	// Lee los chunks MATERIAL
	void ProcesaSigChunkMaterial(sModelo3d *pModelo, sChunk *);

	// Lee el valor RGB del color del objeto
	void LeeChunkColor(sInfo_Material *pMaterial, sChunk *pChunk);

	// Lee los vertices del objeto
	void LeeVertices(sObjeto3d *pObjeto, sChunk *);

	// Lee la informacion de las caras del objeto
	void LeeIndicesVertices(sObjeto3d *pObjeto, sChunk *);

	// Lee las coordenadas de texturas del objeto
	void LeeCoordenadasUV(sObjeto3d *pObjeto, sChunk *);

	// Lee el nombre del material asignado al objeto y le asigna un ID de material
	void LeeMaterialObjeto(sModelo3d *pModelo, sObjeto3d *pObjeto, sChunk *pChunkAnterior);
	
	// Calcula las normales de cada vertice del objeto 
	// (las normales establecen cmo se refleja la luz en la superficie del objeto)
	void CalculaNormales(sModelo3d *pModelo);

	// Liberar memoria y cerrar el archivo
	void Liberar();
	
	FILE *pFichero;
};


#endif


