// Font.cpp: implementation of the CFont class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <windows.h>
#include "Font.h"
#include "viewport.h"
#include "system.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTextFont::CTextFont()
{
	base_2d = base_3d_polys = base_3d_lines = 0;
	file = name = NULL;
}

CTextFont::~CTextFont()
{
	destroy();
}

bool CTextFont::load(char *file, char *name, int height, int style, float extrusion)
{
	CTextFont::height = height;
	destroy();
	CTextFont::file = strdup(file);
	CTextFont::name = strdup(name);
	if (file != NULL && !AddFontResource(file)) return false;
	int weight = FW_NORMAL;
	if (style & FONT_BOLD) weight = FW_BOLD;
	handle = CreateFont(-height, 0, 0, 0, weight, style & FONT_ITALIC, style & FONT_UNDERLINE, 
						style & FONT_STRIKEOUT, ANSI_CHARSET, OUT_TT_PRECIS, CLIP_DEFAULT_PRECIS,
						ANTIALIASED_QUALITY, FF_DONTCARE | DEFAULT_PITCH, name);
	if (handle == NULL) return false;
	base_2d = glGenLists(256);
	base_3d_polys = glGenLists(256);
	base_3d_lines = glGenLists(256);
	if (!base_2d || !base_3d_polys || !base_3d_lines) return false;
	CViewport *vp = CSystem::getDefaultViewport();
	if (vp == NULL || vp->getDC() == NULL) return false;
	HGDIOBJ old_obj = SelectObject(vp->getDC(), handle);
	if (!wglUseFontBitmaps(vp->getDC(), 0, 255, base_2d) ||
		!wglUseFontOutlines(vp->getDC(), 0, 255, base_3d_polys, 0, extrusion, WGL_FONT_POLYGONS, gmf) ||
		!wglUseFontOutlines(vp->getDC(), 0, 255, base_3d_lines, 0, extrusion, WGL_FONT_LINES, gmf)) return false;
	if (!GetCharWidth(vp->getDC(), 0, 255, cwidths)) return false;
	// MAYSCULAS
/*	cwidths[0xc0] =	cwidths['A'];	// ''	
	cwidths[0xc1] = cwidths['A'];	// ''
	cwidths[0xc7] = cwidths['C'];	// ''
	cwidths[0xc8] = cwidths['E'];	// ''
	cwidths[0xc9] = cwidths['E'];	// ''
	cwidths[0xcd] = cwidths['I'];	// ''
	cwidths[0xcf] =	cwidths['I'];	// ''
	cwidths[0xd1] =	cwidths['N'];	// ''
	cwidths[0xd2] =	cwidths['O'];	// ''
	cwidths[0xd3] =	cwidths['O'];	// ''
	cwidths[0xda] =	cwidths['U'];	// ''
	cwidths[0xdc] =	cwidths['U'];	// ''*/
	// minsculas
/*	cwidths[0xe0] =	cwidths['a'];	// ''	
	cwidths[0xe1] = cwidths['a'];	// ''
	cwidths[0xe7] = cwidths['c'];	// ''
	cwidths[0xe8] = cwidths['e'];	// ''
	cwidths[0xe9] = cwidths['e'];	// ''
	cwidths[0xed] = cwidths['i'];	// ''
	cwidths[0xef] =	cwidths['i'];	// ''
	cwidths[0xf1] =	cwidths['n'];	// ''
	cwidths[0xf2] =	cwidths['o'];	// ''
	cwidths[0xf3] =	cwidths['o'];	// ''
	cwidths[0xfa] =	cwidths['u'];	// ''
	cwidths[0xfc] =	cwidths['u'];	// ''*/
	for (int i = 0; i < 256; i++) {
		POINT point;
		point.x = cwidths[i];
		point.y = 0;
		LPtoDP(vp->getDC(), &point, 1);
		cwidths[i] = point.x;
	}
	SelectObject(vp->getDC(), old_obj);
	return true;
}

void CTextFont::destroy()
{
	RemoveFontResource(file);
	if (file != NULL) delete [] file;
	if (name != NULL) delete [] name;
	if (base_2d != 0) glDeleteLists(base_2d, 256);	
	if (base_3d_polys != 0) glDeleteLists(base_3d_polys, 256);	
	if (base_3d_lines != 0) glDeleteLists(base_3d_lines, 256);	
}

void CTextFont::print2d(CVector &pos, CColor &color, char *str)
{
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glTranslatef(0, 0, -1);

	glPushAttrib(GL_LIST_BIT | GL_ENABLE_BIT);

	glDisable(GL_LIGHTING);
	glColor4fv(color.rgba.ca);
	glRasterPos2f(pos.x, pos.y);

	glListBase(base_2d);
	glCallLists(strlen(str), GL_UNSIGNED_BYTE, str);
	glPopAttrib();

	glPopMatrix();

	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}

void CTextFont::print3dp(CVector &pos, CColor &color, char *str)
{
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glTranslatef(pos.x, pos.y, pos.z);
	glColor4fv(color.rgba.ca);
	print3dp(str);
	glPopMatrix();

	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}

void CTextFont::print3dl(CVector &pos, CColor &color, char *str)
{
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glTranslatef(pos.x, pos.y, pos.z);
	glColor4fv(color.rgba.ca);
	print3dl(str);
	glPopMatrix();

	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}

void CTextFont::print3dp(char *str)
{
	glPushAttrib(GL_LIST_BIT);
	glListBase(base_3d_polys);
	glCallLists(strlen(str), GL_UNSIGNED_BYTE, str);
	glPopAttrib();
}

void CTextFont::print3dl(char *str)
{
	glPushAttrib(GL_LIST_BIT);
	glListBase(base_3d_lines);
	glCallLists(strlen(str), GL_UNSIGNED_BYTE, str);
	glPopAttrib();
}

int CTextFont::getCharWidthPixels(char c)
{
	return cwidths[(unsigned int)c & 0xff];
}

float CTextFont::pointsToLogical(int p)
{
	return (p / 72.0f) * 100;
}

int CTextFont::getHeightPixels() 
{
	POINT point;
	point.x = 0;
	point.y = (int)pointsToLogical(height);
	LPtoDP(CSystem::getDefaultViewport()->getDC(), &point, 1);
	return point.y;
}

int CTextFont::getStringWidthPixels(char *s)
{
	int tp = 0;
	for (int i = 0; s[i] != '\0'; i++)
		tp += getCharWidthPixels(s[i]);
	return tp;
}
