// Color.cpp: implementation of the CColor class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Color.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CColor temp_c;

CColor::CColor()
{
	rgba.c.b = 1; rgba.c.g = 1; rgba.c.r = 1; rgba.c.a = 1;
}

CColor::~CColor()
{

}

bool CColor::operator == (CColor &c)
{
	return rgba.c.b == c.rgba.c.b && rgba.c.g == c.rgba.c.g && rgba.c.r == c.rgba.c.r && rgba.c.a == c.rgba.c.a;
}

bool CColor::operator !=(CColor &c)
{
	return !(*this == c);
}

void CColor::operator = (CColor &c)
{
	rgba.c.b = c.rgba.c.b;
	rgba.c.g = c.rgba.c.g;
	rgba.c.r = c.rgba.c.r;
	rgba.c.a = c.rgba.c.a;
}

CColor::CColor(float r, float g, float b, float a)
{
	rgba.c.b = b;
	rgba.c.g = g;
	rgba.c.r = r;
	rgba.c.a = a;	
}

CColor & CColor::operator * (float f) 
{
	temp_c.rgba.c.r = rgba.c.r * f;
	if (temp_c.rgba.c.r > 1) temp_c.rgba.c.r = 1;
	temp_c.rgba.c.g = rgba.c.g * f;
	if (temp_c.rgba.c.g > 1) temp_c.rgba.c.g = 1;
	temp_c.rgba.c.b = rgba.c.b * f;
	if (temp_c.rgba.c.b > 1) temp_c.rgba.c.b = 1;
	return temp_c;
}

CColor & CColor::operator + (CColor &c)
{
	temp_c.rgba.c.r = rgba.c.r + c.rgba.c.r;
	if (temp_c.rgba.c.r > 1) temp_c.rgba.c.r = 1;
	if (temp_c.rgba.c.r < 0) temp_c.rgba.c.r = 0;
	temp_c.rgba.c.g = rgba.c.g + c.rgba.c.g;
	if (temp_c.rgba.c.g > 1) temp_c.rgba.c.g = 1;
	if (temp_c.rgba.c.g < 0) temp_c.rgba.c.g = 0;
	temp_c.rgba.c.b = rgba.c.b + c.rgba.c.b;
	if (temp_c.rgba.c.b > 1) temp_c.rgba.c.b = 1;
	if (temp_c.rgba.c.b < 0) temp_c.rgba.c.b = 0;
	temp_c.rgba.c.a = rgba.c.a + c.rgba.c.a;
	if (temp_c.rgba.c.a > 1) temp_c.rgba.c.a = 1;
	if (temp_c.rgba.c.a < 0) temp_c.rgba.c.a = 0;
	return temp_c;
}

void CColor::operator += (CColor &c) 
{
	rgba.c.r += c.rgba.c.r;
	rgba.c.g += c.rgba.c.g;
	rgba.c.b += c.rgba.c.b;
	rgba.c.a += c.rgba.c.a;
	if (rgba.c.r > 1) rgba.c.r = 1;
	if (rgba.c.g > 1) rgba.c.g = 1;
	if (rgba.c.b > 1) rgba.c.b = 1;
	if (rgba.c.a > 1) rgba.c.a = 1;
	if (rgba.c.r < 0) rgba.c.r = 0;
	if (rgba.c.g < 0) rgba.c.g = 0;
	if (rgba.c.b < 0) rgba.c.b = 0;
	if (rgba.c.a < 0) rgba.c.a = 0;
}

void CColor::operator -= (CColor &c) 
{
	rgba.c.r -= c.rgba.c.r;
	rgba.c.g -= c.rgba.c.g;
	rgba.c.b -= c.rgba.c.b;
	rgba.c.a -= c.rgba.c.a;
	if (rgba.c.r > 1) rgba.c.r = 1;
	if (rgba.c.g > 1) rgba.c.g = 1;
	if (rgba.c.b > 1) rgba.c.b = 1;
	if (rgba.c.a > 1) rgba.c.a = 1;
	if (rgba.c.r < 0) rgba.c.r = 0;
	if (rgba.c.g < 0) rgba.c.g = 0;
	if (rgba.c.b < 0) rgba.c.b = 0;
	if (rgba.c.a < 0) rgba.c.a = 0;
}


