#include "gpdef.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpmain.h"
#include "math.h"

GPDRAWSURFACE gpDraw;

void Point (float x, float y, float z)
{
	int p_x,p_y;

	p_y=(int)(2.0f*(x-z));
	p_x=(int)(y*2+z+x);

	GpRectFill(NULL, &gpDraw, p_x, p_y, 8, 8, (unsigned char) (z*0.5));
}

void GpMain(void *arg)
{
	int i,y,t;
	float xx,yy,zz;

	i = GpLcdSurfaceGet(&gpDraw, 0);  	// surface create							
	GpRectFill(NULL, &gpDraw, 0, 0, gpDraw.buf_w, gpDraw.buf_h, 0xff);	//surface fill color in white
	
	GpSurfaceSet(&gpDraw);	//make gpDraw with primary surface
	
	if ( !(GPC_LCD_ON_BIT & GpLcdStatusGet()) ) GpLcdEnable(); 	//ɼ - default lcd Ƿ..
	                                                            //   ڸƮ .

//	GpRectFill(NULL, &gpDraw, 120, 60, 10, 80, 0xe0);	// surface (80*80) ũ red box ׸.
	
	for (t=0; t<1000; t++)
	{
		for (xx=10.0f; xx<130.75f; xx=xx+2.0f)
			{
			for (y=-40; y<30; y+=1)
				{
				yy=((float)y+20.0f)/40.0f*100.0f;
				zz=(float)12.0f*(sin ((xx+t*5)*(0.05))+cos ((yy+t*5)*0.05));
				Point (xx,yy,zz);
				}
			}

	}

	while(1)
	;
}
