/*
    main.cpp

    base para los fast_code.

    soporta modos de cualquier bpp. soporta tambin modos de paleta
    (emulado sobre 32bpp).


    iq + una-i
*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <mmsystem.h>           // timeGetTime();
#include <malloc.h>             // malloc()
#include <string.h>             // memset(), memcpy()


#include "ffx.h"
#include "dd7.h"

extern int xres;
extern int yres;
extern int  bpp;





//------ emulacion de 8 a 32-------------------

static long coltable[256];
static void convert8to32( long *dst, unsigned char *ori )
{
    int i;
    for( i=0; i<(xres*yres); i++ )
        *dst++ = coltable[*ori++];
}

void set_palette( long *palette )
{
    int i;

    if( palette )
        memcpy( coltable, palette, 256*4 );
    else
        for( i=0; i<256; i++ )
            coltable[i] = 0xff000000|(i<<16)|(i<<8)|i;
}

void set_color( int i, int r, int g, int b )
{
    coltable[i] = 0xff000000|(r<<16)|(g<<8)|b;
}


//-------------------------------------------------------------------

static HWND     hwnd;
static long     to;
static BOOL     active;


//-------------------------------------------------------------------

long FAR PASCAL WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    switch( message )
        {
        case WM_ACTIVATEAPP:
            active = wParam;
            break;

        case WM_SETCURSOR:
            SetCursor( NULL );
            return( TRUE );

        case WM_SYSCOMMAND:
            switch( wParam )
                {
                case SC_SCREENSAVE:
                case SC_MONITORPOWER:
                return( 0 );
                }
            break;

        case WM_CREATE:
            break;

        case WM_KEYDOWN:
            switch( wParam )
                {
                case VK_SPACE:
                    DDRAW_TogleFPS();
                    break;

                case VK_LEFT:
                    break;
                case VK_RIGHT:
                    break;

                case VK_ESCAPE:
                   PostMessage( hWnd, WM_CLOSE, 0, 0 );
                   break;
                }
            break;

        case WM_DESTROY:
            PostQuitMessage( 0 );
            break;
        }

   return( DefWindowProc(hWnd, message, wParam, lParam) );
}


//-------------------------------------------------------------------


static int WIN_Init( HINSTANCE hInstance, int nCmdShow )
{
    WNDCLASS         wc;

    wc.style         = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc   = WindowProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = hInstance;
    wc.hCursor       = LoadCursor( NULL, IDC_ARROW );
    wc.hIcon=          LoadIcon( hInstance, IDI_APPLICATION );
    wc.hbrBackground = NULL;
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = "cname";

    if( !RegisterClass(&wc) )
        {
        return( 0 );
        }



    DWORD exStyle = 0;
    DWORD style = WS_POPUP;

    hwnd = CreateWindowEx( exStyle,"cname","cname",style,0,0,
                           GetSystemMetrics(SM_CXSCREEN),
                           GetSystemMetrics(SM_CYSCREEN),
                           NULL,NULL, hInstance,NULL );

    if( !hwnd )
        {
        return( 0 );
        }

    ShowWindow( hwnd, nCmdShow );
    UpdateWindow( hwnd );
    SetFocus( hwnd );

    return( 1 );
}




static void *mibuf=0;
static long *aux=0;

static void doframe( void )
{
    char    *buffer, *ori;
    int     j, pitch;
    int     incr;

    pitch  = DDRAW_GetPitch();
    buffer = (char*)DDRAW_GetPtr();
    if( !buffer )
        return;

    if( bpp==8 )
        {
        convert8to32( aux, (unsigned char*)mibuf );

        incr = xres*4;
        ori  = (char*)aux;
        for( j=0; j<yres; j++ )
            {
            memcpy( buffer, ori, incr );
            buffer += pitch;
            ori    += incr;
            }
        }
    else
        {
        incr = (xres*bpp>>3);
        ori  = (char*)mibuf;
        for( j=0; j<yres; j++ )
            {
            memcpy( buffer, ori, xres*bpp>>3 );
            buffer += pitch;
            ori    += incr;
            }
        }

    DDRAW_EndFrame();

}

int WINAPI WinMain( HINSTANCE   hInstance, HINSTANCE   hPrevInstance,
                    LPSTR       lpCmdLine, int         nCmdShow )
{
    MSG     msg;
    long    done = 0;


    if( !WIN_Init( hInstance, nCmdShow ) )
        {
        MessageBox( NULL, "WIN_Init", "ERROR", MB_OK|MB_ICONEXCLAMATION );
        return( 0 );
        }


    if( bpp==8 )
        {
        set_palette( 0 );
        aux   = (long*)malloc( xres*yres*4 );
        mibuf = (void*)malloc( xres*yres );
        if( !aux | !mibuf )
            return( 0 );
        memset( mibuf, 0, xres*yres );
        if( !DDRAW_Init( xres, yres, 32, hwnd ) )
            {
            MessageBox( NULL, "DDRAW_Init", "ERROR", MB_OK|MB_ICONEXCLAMATION );
            return( 0 );
            }
        }
    else
        {
        mibuf = (void*)malloc( xres*yres*bpp>>3 );
        if( !mibuf )
            return( 0 );
        if( !DDRAW_Init( xres, yres, bpp, hwnd ) )
            {
            MessageBox( NULL, "DDRAW_Init", "ERROR", MB_OK|MB_ICONEXCLAMATION );
            return( 0 );
            }
        }


    if( !FFX_Init( mibuf ) )
        {
        MessageBox( NULL, "FFX_Init", "ERROR", MB_OK|MB_ICONEXCLAMATION);
        return( 0 );
        }


    to = timeGetTime();

    while( !done )
        {
        if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE) )
            {
            if(!GetMessage( &msg, NULL, 0, 0 ) )
                {
                done = 1;
                }
            TranslateMessage( &msg );
            DispatchMessage( &msg );
            }
        else
            { 
            if( active )
                {
                FFX_DoFrame( mibuf, (float)(timeGetTime()-to)/1000.0f );
                doframe();
                DDRAW_Flip();
                }
            else
                {
                WaitMessage();
                }
            }
        }

    FFX_End();

    return( msg.wParam );
}
