#include "util.h"
#include "gpmem.h"
#include "gpstdio.h"
#include <stdlib.h>
#include <string.h>
#include <math.h>


void Delay(int ms) {

	unsigned int ticks;

	ticks=GpTickCountGet();
	while((GpTickCountGet()-ticks)<ms);
}

/*------------------------------------------------------------------
	util_load_file
	
		reserva memoria y carga un fichero en ella,
		en caso de error devuelve NULL
------------------------------------------------------------------*/

u8 *util_load_file(char *filename,int size) {
	int result;
	ulong readed_bytes;
	F_HANDLE file;
	u8 *buffer;
	
	result=GpFileOpen(filename,OPEN_R,&file);
	if (result!=SM_OK) return NULL;   /* error abriendo fichero */
	
	buffer=(u8 *)gp_mem_func.malloc(size);
	
	if (!buffer) return NULL; /* error reservando memoria */
	
	result=GpFileRead(file,buffer,size,&readed_bytes);
	
	GpFileClose(file);
	
	if (readed_bytes!=size) {
		gp_mem_func.free(buffer);
		return NULL;
	}
	
	return buffer;
	
}

/*------------------------------------------------------------------
	load_sprite_RGBA8
	
		carga un sprite en memoria en formato RGBA, 
		8 bits por canal
------------------------------------------------------------------*/

st_sprite *load_sprite_RGBA8(char *filename,u32 x_size, u32 y_size){

	u8 *buffer;
	u8 *src,*src_lastline;
	u16 *bitmap,*bitmap_dst;
	u8 *alpha,*alpha_dst;
	st_sprite *sprite;
	int x,y,r,g,b;
	u8 a;
	u32 size;
	
	size=x_size*y_size*4;
	
	buffer=util_load_file(filename,size);
	
	if (!buffer) return NULL;  /* en caso de error al cargar devuelve NULL */
	
	
	/* reservar memoria para el bitmap */
	bitmap=(u16 *)gp_mem_func.malloc(x_size*y_size*sizeof(u16));
	if (!bitmap) {
		gp_mem_func.free(buffer);
		return NULL;
	}	
	
	/* reservar memoria para el canal alpha */
	alpha = (u8 *)gp_mem_func.malloc(x_size*y_size);
	if (!alpha) {
		gp_mem_func.free(buffer);
		gp_mem_func.free(bitmap);
		return NULL;
	}	
	
	/* reservar memoria para la estructura del sprite */
	sprite=(st_sprite *)gp_mem_func.malloc(sizeof(st_sprite));
	if (!sprite) {
		gp_mem_func.free(buffer);
		gp_mem_func.free(bitmap);
		gp_mem_func.free(alpha);
		return NULL;
	}	
	
	/* saco una copia de los punteros al bitmap y canal alpha para ir
	   almacenando los datos  											*/
	   
	bitmap_dst=bitmap;
	alpha_dst=alpha;
	
	/* copio el bitmap y canal alpha, pero rotados */
	src_lastline=&buffer[((y_size-1)*x_size)*4];
	 for (x=0;x<x_size;x++) {
	 	src=src_lastline;
	 	src_lastline+=4;
	 	
	 	for (y=y_size-1; y>=0;y--){
	 	
	 		r=src[0];
	 		g=src[1];
	 		b=src[2];
	 		a=src[3];
	 		
	 		*bitmap_dst++=RGB15_8(r,g,b);
	 		*alpha_dst++=a;
	 		
	 		src-=x_size*4;
	 	
		}
	}
	
	gp_mem_func.free(buffer);
	
	sprite->x_size = x_size;
	sprite->y_size = y_size;
	sprite->bitmap = bitmap;
	sprite->alpha  = alpha;
	
	return sprite;
	
}

st_sprite *load_sprite_RGB8 (char *filename,u32 x_size, u32 y_size){

	u8 *buffer;
	u8 *src,*src_lastline;
	u16 *bitmap,*bitmap_dst;
	
	st_sprite *sprite;
	int x,y,r,g,b;
	
	u32 size;
	
	size=x_size*y_size*3;
	
	buffer=util_load_file(filename,size);
	
	if (!buffer) return NULL;  /* en caso de error al cargar devuelve NULL */
	
	
	/* reservar memoria para el bitmap */
	bitmap=(u16 *)gp_mem_func.malloc(x_size*y_size*sizeof(u16));
	if (!bitmap) {
		gp_mem_func.free(buffer);
		return NULL;
	}	
	
	/* reservar memoria para la estructura del sprite */
	sprite=(st_sprite *)gp_mem_func.malloc(sizeof(st_sprite));
	if (!sprite) {
		gp_mem_func.free(buffer);
		gp_mem_func.free(bitmap);
		return NULL;
	}	
	
	/* saco una copia de los punteros al bitmap 
	   almacenando los datos  											*/
	   
	bitmap_dst=bitmap;
		
	/* copio el bitmap y canal alpha, pero rotados */
	src_lastline=&buffer[((y_size-1)*x_size)*3];
	 for (x=0;x<x_size;x++) {
	 	src=src_lastline;
	 	src_lastline+=3;
	 	
	 	for (y=y_size-1; y>=0;y--){
	 	
	 		r=src[0];
	 		g=src[1];
	 		b=src[2];
	 		
	 		
	 		*bitmap_dst++=RGB15_8(r,g,b);
	 			 		
	 		src-=x_size*3;
	 	
		}
	}
	
	gp_mem_func.free(buffer);
	
	sprite->x_size = x_size;
	sprite->y_size = y_size;
	sprite->bitmap = bitmap;
	sprite->alpha  = NULL;
	
	
	return sprite;
}

st_sprite *load_sprite_RGB15(char *filename,u32 x_size, u32 y_size){
	
	return NULL;
}

void free_sprite(st_sprite *sprite) {
	
	if (!sprite) return;
	
	if (sprite->bitmap){
		 gp_mem_func.free(sprite->bitmap);
		 sprite->bitmap=NULL;
	}
	
	if (sprite->alpha){
		gp_mem_func.free(sprite->alpha);
		sprite->alpha=NULL;
	}
	
	sprite->x_size=0;
	sprite->y_size=0;
	
}


st_sprite *gen_sphere_sprite(int size,float rc,float gc,float bc)
{   
	float a,b;
    int x,y;

	float intensidad;
	st_sprite *sprite;
	float proporcion=512.0/(float)size;
	u16 *ptr=(u16 *) gp_mem_func.malloc( size*size *sizeof(u16));
	
	memset(ptr,0,size*size*sizeof(u16));
		
	for (x=0;x<size;x++)
	for (y=0;y<size;y++)
	{
		a=((float)x)*proporcion-256; b=((float)y)*proporcion-256;
		if (sqrt(a*a+b*b)<255) {
				intensidad= 255.0-((float)sqrt(a*a+b*b));
				ptr[x+y*size]=RGB15_8(((u8)(rc*intensidad)),((u8)(gc*intensidad)),((u8)(bc*intensidad)));
			}
	}
	
	sprite=(st_sprite *)gp_mem_func.malloc(sizeof(st_sprite));
	sprite->bitmap=ptr;
	sprite->alpha=NULL;
	sprite->x_size=size;
	sprite->y_size=size;
	
	return(sprite);
}
