#include <math.h>
#include <stdlib.h>
#include <string.h>

#include "gpdef.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpfont.h"
#include "gpmm.h"
#include "gpcomm.h"
#include "gpstdio.h"
#include "gpnetlib.h"
#include "util\util.h"
#include "graphics.h"
#include "sprites.h"
#include "drawing.h"

#include "gpmain.h"

int mouse_speed;
st_sprite *mouse;
int mouse_x,mouse_y;

void mouse_init() {
	
	mouse_x=0;
	mouse_y=0;
	mouse_speed=2;
	mouse=load_sprite_RGB8("pt_13_20.raw",13,20);
	
}

int mouse_exec(int *x,int*y) {

		
		int key;
		
		key=GpKeyGet();
		
		if (key&GPC_VK_UP)    mouse_y+=mouse_speed;
		if (key&GPC_VK_DOWN)  mouse_y-=mouse_speed;
		if (key&GPC_VK_RIGHT) mouse_x+=mouse_speed;
		if (key&GPC_VK_LEFT)  mouse_x-=mouse_speed;
		
		if ((mouse_x+13)>319) mouse_x=319-13;
		if (mouse_x<0) mouse_x=0;
		if ((mouse_y+20)>239) mouse_y=239-20;
		if (mouse_y<0) mouse_y=0;
		
		draw_sprite_trans(mouse,(u16 *)gpDraw[nflip].ptbuffer,mouse_x,mouse_y);

		if (x) *x=mouse_x; 
		if (y) *y=mouse_y+20;
		
		return key;
}

void test_mouse (void){
	
	mouse_init();

	while (1) {
					
		memset(gpDraw[nflip].ptbuffer,0xff,320*240*2);
		
		mouse_exec(NULL,NULL);
		
		GpSurfaceFlip(&gpDraw[nflip++]);
		nflip &= 0x01;
	
	}


}


//-------------------------------------------------------------------------------------------
//  funciones para el test de dibujado de lineas
//-------------------------------------------------------------------------------------------

int test_line_random(u16 *buffer,p_line_draw line_draw_proc,int num_lineas) {
	
	int milisegundos;
	int i;
	int x0,y0,x1,y1;
	u16 color;
	float ms_linea;

	memset(buffer,0xff,320*240*2);
	milisegundos=GpTickCountGet();
	for (i=0;i<num_lineas;i++) {
		x0=(rand()&0xff) +(320-256)/2;
		y0=(rand()&0xff) +1;
		x1=(rand()&0xff) +(320-256)/2;
		y1=(rand()&0xff) +1;
		line_draw_proc(buffer,x0,y0,x1,y1,color&0xfffe);
		color=rand();
	}
	
	milisegundos=GpTickCountGet()-milisegundos;
	ms_linea=((float)milisegundos)/((float)num_lineas);
	return (int)(ms_linea*1000.0);

} 

int test_line_fixed(u16 *buffer,p_line_draw line_draw_proc,int num_lineas) {
	int milisegundos;
	int i;
	int x0,y0,x1,y1;
	u16 color;
	float ms_linea;

	memset(buffer,0xff,320*240*2);
	milisegundos=GpTickCountGet();
	y0=1;
	for (i=0;i<num_lineas;i++) {
		y0=y0+1;
		if (y0>238) y0=1;
		line_draw_proc(buffer,1,y0,318,240-y0,color&0xfffe);
		color++;
	}
	
	milisegundos=GpTickCountGet()-milisegundos;
	ms_linea=((float)milisegundos)/((float)num_lineas);
	return (int)(ms_linea*1000.0);

} 

//dibujado del texto con un dato
test_lines_draw_result(char *rutina, int num_lineas, int ns_linea,int X,int Y) {

    char str_buffer[256];
    
    sprintf(str_buffer,"%s:\n%d lineas, %d us/linea",rutina,num_lineas,ns_linea);
	
	GpTextOut16(NULL,&gpDraw[nflip],X+1,Y+1,str_buffer,0x0);
	GpTextOut16(NULL,&gpDraw[nflip],X,Y,str_buffer,0xfffe);

}



//dibujado del texto con los datos de random y fixed
test_lines_draw_result2(char *rutina, int num_lineas, int ns_linea,int ns_linea_rand,int X,int Y) {

    char str_buffer[256];
    
    sprintf(str_buffer,"%s: %d lineas\n random:%d us/linea\n fixed: %d us/linea",rutina,num_lineas,ns_linea_rand,ns_linea);
	
	GpTextOut16(NULL,&gpDraw[nflip],X+1,Y+1,str_buffer,0x0);
	GpTextOut16(NULL,&gpDraw[nflip],X,Y,str_buffer,0xfffe);   

}

#define PI 3.14159

#define lados 6.0
#define lados_int 6
#define angulo_segmento (2.0*PI/lados)

// circulito que rota en el final.....

int test_draw_circle(u16 *buffer,p_line_draw line_draw_proc,int X,int Y,int radio,float angulo_in,u16 color) {

	int i,lastx,lasty,newx,newy;
	float angulo=angulo_in;
	
	newx=X+(cos(angulo)*((float)radio));
	newy=Y+(sin(angulo)*((float)radio));
	
	for (i=0;i<=lados_int;i++) {
		lastx=newx;
		lasty=newy;	
		newx=X+(cos(angulo)*((float)radio));
		newy=Y+(sin(angulo)*((float)radio));
			
			line_draw_proc(buffer,lastx,lasty,newx,newy,color);
		
		angulo+=angulo_segmento;
	
	}
}

void test_lines(int num_lineas) {

	u16 *buffer;
	int ns_DDA,ns_bresenham,ns_xiaolin;
	int ns_DDA_random, ns_bresenham_random, ns_xiaolin_random;
	float angulo=0.0;
	
	
	buffer=(u16 *)gpDraw[nflip].ptbuffer;
	
	memset(buffer,0xff,320*240*2);
	GpSurfaceSet(&gpDraw[nflip]);
	
	// primero ejecuto tests de dibujado con cada una de las funciones en modo aleatorio

	ns_DDA_random=test_line_random(buffer,&line_draw_dda,num_lineas);
	test_lines_draw_result("DDA",num_lineas,ns_DDA_random,50,10);
	Delay(2000);
	
	
	memset(buffer,0xff,320*240*2);
	
	ns_bresenham_random=test_line_random(buffer,&line_draw_bresenham,num_lineas);
	test_lines_draw_result("bresenham",num_lineas,ns_bresenham_random,50,10);
	Delay(2000);	
	
	
	memset(buffer,0xff,320*240*2);
	
	ns_xiaolin_random=test_line_random(buffer,&line_draw_xiaolin,num_lineas);
	test_lines_draw_result("xiaolin",num_lineas,ns_xiaolin_random,50,10);
	Delay(2000);
	
	
	// despues vuelvo a realizar los tests, pero esta vez las lineas varian la inclinacion, 
	// pero no son aleatorias
	
	memset(buffer,0xff,320*240*2);
	
	ns_DDA=test_line_fixed(buffer,&line_draw_dda,num_lineas);
	test_lines_draw_result("DDA",num_lineas,ns_DDA,50,10);
	Delay(2000);
	
	
	memset(buffer,0xff,320*240*2);
	
	ns_bresenham=test_line_fixed(buffer,&line_draw_bresenham,num_lineas);
	test_lines_draw_result("bresenham",num_lineas,ns_bresenham,50,10);
	Delay(2000);
	
	
	memset(buffer,0xff,320*240*2);
	
	ns_xiaolin=test_line_fixed(buffer,&line_draw_xiaolin,num_lineas);
	test_lines_draw_result("xiaolin",num_lineas,ns_xiaolin,50,10);
	Delay(2000);
	
	//pinto los resultados finales
	
	while(!GpKeyGet()) {
		memset(gpDraw[nflip].ptbuffer,0xdd,320*240*2);
		test_lines_draw_result2("DDA"      ,num_lineas,ns_DDA      ,ns_DDA_random      ,50,20);
		test_draw_circle((u16 *)gpDraw[nflip].ptbuffer,&line_draw_dda,260,LCD_SIZE_Y-(20+30),20,angulo,0xfffe);
		test_draw_circle((u16 *)gpDraw[nflip].ptbuffer,&line_draw_dda,260,LCD_SIZE_Y-(20+30),35,angulo,0xfffe);
		
		test_lines_draw_result2("bresenham",num_lineas,ns_bresenham,ns_bresenham_random,50,90);
		test_draw_circle((u16 *)gpDraw[nflip].ptbuffer,&line_draw_bresenham,260,LCD_SIZE_Y-(90+30),20,-angulo,0xfffe);
		test_draw_circle((u16 *)gpDraw[nflip].ptbuffer,&line_draw_bresenham,260,LCD_SIZE_Y-(90+30),35,-angulo,0xfffe);		
		
		test_lines_draw_result2("xiaolin"  ,num_lineas,ns_xiaolin  ,ns_xiaolin_random  ,50,160);
		test_draw_circle((u16 *)gpDraw[nflip].ptbuffer,&line_draw_xiaolin,260,LCD_SIZE_Y-(160+30),20,angulo,0xfffe);
		test_draw_circle((u16 *)gpDraw[nflip].ptbuffer,&line_draw_xiaolin,260,LCD_SIZE_Y-(160+30),35,angulo,0xfffe);
		GpSurfaceSet(&gpDraw[nflip++]);
		nflip=nflip&1;
		angulo+=0.025;
		
	}
	while (GpKeyGet());

}

//-----------------------------------------------------------------------------------------------
//			Test de sprites
//-----------------------------------------------------------------------------------------------


void test_sprites(void) {

	st_sprite *fondo,*bola,*estrella,*estrella_grande;
	st_sprite *sprite[3];
	int keys,lastkeys;
	int n_trans,n_normal;
	int n,i,j;
	int sx,sy;
	float frame,inc;
	
	fondo=load_sprite_RGB8("sprimenu.raw",320,240);
	
	bola            = load_sprite_RGB8 ("bola.rgb"    ,53 ,53);
    estrella   	    = load_sprite_RGB8 ("estrella.rgb",32 ,32);
	estrella_grande = load_sprite_RGB8 ("starbig.rgb" ,64 ,64);

	sprite[0]=bola;
	sprite[1]=estrella;
	sprite[2]=estrella_grande;
		
	keys=0;
	n_trans=0; n_normal=0;
	
	frame=0.0;
	
	while(!(keys&GPC_VK_START)) {
		lastkeys=keys;
		keys=GpKeyGet();
		memcpy(gpDraw[nflip].ptbuffer,fondo->bitmap,320*240*2);
		
		if ((keys&GPC_VK_FA)&&(!(lastkeys&GPC_VK_FA))) {
			
			n_normal++;
			
		}
		
		if ((keys&GPC_VK_FB)&&(!(lastkeys&GPC_VK_FB))) {
			
			n_trans++;
		}
		
		i=0;
		j=0;
		frame+=0.025;
		for(n=0;n<(n_normal+n_trans);n++) {
			
			inc=((float)n)/2.5;
			sx=120+cos(frame+inc)*120.0*sin(frame*0.3+inc);
			sy=90+cos(frame+inc)*80.0*sin(frame*0.4+inc*0.3);
			
			
			if (n>=n_normal) {
				
				draw_sprite_trans(sprite[i],(u16 *)gpDraw[nflip].ptbuffer,sx,sy);
				i=(i+1)%3;
				
			} else {
				
				draw_sprite(sprite[j],(u16 *)gpDraw[nflip].ptbuffer,sx,sy);
				j=(j+1)%3;
			}
			
		}	
			
			
		GpSurfaceFlip(&gpDraw[nflip++]);
		nflip=nflip&1;
	
	}
	
	free_sprite(estrella_grande);
	free_sprite(estrella);
	free_sprite(bola);
	
	free_sprite(fondo);
	
}


//-----------------------------------------------------------------------------------------------
//			Test de sprites/sobreiluminacin
//-----------------------------------------------------------------------------------------------

void test_iluminacion(void) {

	st_sprite *fondo,*vela;
	st_sprite *luz[4];
	st_sprite *mini_luz[8];	
	int keys,lastkeys;
	int n_trans,n_normal,angulo;
	int n,i,j;
	int sx,sy,x,y;
	float frame,inc;
	
#define vela_x 131
#define vela_y 68

	fondo = load_sprite_RGB8 ("fondovla.raw" ,320,240);
	vela  = load_sprite_RGB8 ("vela.raw"     ,47 ,112);
	
	luz[0]=gen_sphere_sprite(24,1.0,1.0,0.0);
	luz[1]=gen_sphere_sprite(24,0.5,0.5,0.5);
	luz[2]=gen_sphere_sprite(24,1.0,1.0,1.0);
	luz[3]=gen_sphere_sprite(24,0.8,0.8,0.8);


	mini_luz[4]=gen_sphere_sprite(8,1.0,1.0,0.0);
	mini_luz[5]=gen_sphere_sprite(8,0.6,0.6,0.0);
	mini_luz[6]=gen_sphere_sprite(8,0.9,0.9,1.0);
	mini_luz[7]=gen_sphere_sprite(8,0.8,0.8,0.8);	
	
	for (i=0;i<4;i++) mini_luz[i]=luz[i];
		

	x=0;y=0;
	n_normal=0;
	frame=0.0;
	keys=0;
	
	while(!(keys&GPC_VK_START)) {
	
		lastkeys=keys;
		keys=GpKeyGet();
		memcpy(gpDraw[nflip].ptbuffer,fondo->bitmap,320*240*2);
		
		if ((keys&GPC_VK_FA)&&(!(lastkeys&GPC_VK_FA))) {  // si acaban de pulsar la tecla A
			n_normal++;									  // introduzco otra luz
		}
		
		frame+=0.1;
		
		
		//dibujo las luces de atras
		
		for(n=0;n<(n_normal);n++) {
			
			inc=((float)n)/2.5;
			angulo=(frame+inc)*180.0/PI;
			
			angulo=angulo%360;
			if (angulo<180) {
			
				sx=150+cos(frame+inc)*70.0;
				sy=110+sin(frame+inc)*30.0;
			
				draw_sprite_add(luz[n&0x3],(u16 *)gpDraw[nflip].ptbuffer,sx,sy);
			}
						
		}	
		
		//redibujo la vela
		
		draw_sprite_trans(vela,(u16 *)gpDraw[nflip].ptbuffer,vela_x,vela_y);
		
		//dibujo las luces de alante
		
		for(n=0;n<(n_normal);n++) {
			
			inc=((float)n)/2.5;
			angulo=(frame+inc)*180.0/PI;
			
			angulo=angulo%360;
			if (angulo>=180) {
			
				sx=150+cos(frame+inc)*70.0;
				sy=110+sin(frame+inc)*30.0;
			
				draw_sprite_add(luz[n&0x3],(u16 *)gpDraw[nflip].ptbuffer,sx,sy);
			}
						
		}	
		
		
		//dibujo las llamas de la vela 
		
		for (n=0;n<12;n++) {  
			
			inc=((float)n)/2.5;
						
			sx=vela_x+ 10+rand()%6;
			sy=vela_y+100+sin(frame+inc)*10.0+ sin((frame+inc)*3.0)*10.0;
			
			if ((n&7)>=4) {
							sx+=8;
							sy+=20;
						  }
			
			draw_sprite_add(mini_luz[n&0x7],(u16 *)gpDraw[nflip].ptbuffer,sx,sy);
			
		}
			
					
	
		GpSurfaceFlip(&gpDraw[nflip++]);
		nflip=nflip&1;
	}
	free_sprite(fondo);
	free_sprite(vela);
	for (i=0;i<8;i++) {
		free_sprite(mini_luz[i]);
	}
	
}

//-----------------------------------------------------------------------------------------------
//			Test general
//-----------------------------------------------------------------------------------------------


void test_general (void) {

	int i,n;
	int	cnt_surface;
	float tf,balls,maxballs;
	st_sprite 	*fondo_luna,
		  		*bola,
	          	*estrella,
	          	*estrella_big;
			  
	int lastX,lastY,x,y;
	
	 st_sprite *esferas[4];
    u32 *ptrclear;
    volatile u32 *ptun_noise;
	int milisegundos;
	char buffer[256];
	
	
	fondo_luna = load_sprite_RGBA8("luna.rga"    ,320,240);
	bola       = load_sprite_RGB8 ("bola.rgb"    ,53 ,53);
    estrella   = load_sprite_RGB8 ("estrella.rgb",32 ,32);

    	
	esferas[0]=gen_sphere_sprite(24,1.0,0.0,0.0);
	esferas[1]=gen_sphere_sprite(24,0.0,1.0,0.0);
	esferas[2]=gen_sphere_sprite(24,0.0,0.0,1.0);
	esferas[3]=gen_sphere_sprite(24,1.0,1.0,1.0);
	
	milisegundos=0;
	maxballs=1.0;
	
	while ( !(GpKeyGet()&GPC_VK_START) )
	{	
		tf+=0.025;
			
		if (maxballs<5.4) maxballs+=0.005;
		
		if (fondo_luna) {
			sprintf(buffer,"%d ms %d balls",milisegundos,(int)(maxballs/0.1));
			if (!GpKeyGet())
				 memcpy(gpDraw[nflip].ptbuffer,fondo_luna->bitmap,320*240*2);
			else {
				if(GpKeyGet()==GPC_VK_START) GpAppExit();
				memset(gpDraw[nflip].ptbuffer,0,320*240*2);
					
			}
			GpTextOut16(NULL,&gpDraw[nflip],11,11+sin(tf)*10.0,buffer,0x0);
			GpTextOut16(NULL,&gpDraw[nflip],10,10+sin(tf)*10.0,buffer,0xfffe);
		}
		
		
		
	
		milisegundos=GpTickCountGet();	
		n=0;
		balls=0.0;
		
		pixel_draw(((u16 *)gpDraw[nflip].ptbuffer),10,10,0xfffe);
		
		line_draw_bresenham((u16 *)gpDraw[nflip].ptbuffer,195+sin(tf+balls)*50.0*sin(tf*0.3+balls)-20,
							    110+cos(tf+balls)*80.0*sin(tf*0.4+balls*0.3)-20,0,0,
							    0xfffe);
							    
		draw_sprite_trans(bola,(u16 *)gpDraw[nflip].ptbuffer,195+sin(tf+balls)*50.0*sin(tf*0.3+balls)-20,
							             110+cos(tf+balls)*80.0*sin(tf*0.4+balls*0.3)-20);
							             
		x=0;
		y=0;						             
		for (balls=0.0;balls<maxballs;balls+=0.1) {
			lastX=x;
			lastY=y;
			
			x=195+sin(tf+balls)*50.0*sin(tf*0.3+balls);
			y=110+cos(tf+balls)*80.0*sin(tf*0.4+balls*0.3);
			
			draw_sprite_add(esferas[n++],(u16 *)gpDraw[nflip].ptbuffer,x,y);
			if ((lastX!=0) && (lastY!=0)) 
					line_draw_xiaolin((u16 *)gpDraw[nflip].ptbuffer,lastX,lastY,x,y,0xfffe);
			n=n&0x3;
		}
		
		draw_sprite_trans(estrella,(u16 *)gpDraw[nflip].ptbuffer,
				195+sin(tf+balls)*50.0*sin(tf*0.3+balls)-8,
				110+cos(tf+balls)*80.0*sin(tf*0.4+balls*0.3)+8);
				
		circle_draw_dda((u16 *)gpDraw[nflip].ptbuffer,160,100,50+(sin(tf)*49.0),0xfffe);
		
		milisegundos=GpTickCountGet()-milisegundos;
		
		GpSurfaceSet(&gpDraw[nflip++]);
		nflip &= 0x01;
	}
	
	for (i=0;i<4;i++) free_sprite(esferas[i]);
	
	free_sprite(estrella);
	free_sprite(fondo_luna);
	free_sprite(bola);
	
}
