
#include <math.h>
#include <stdlib.h>
#include <string.h>

#include "gpdef.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpfont.h"
#include "gpmm.h"
#include "gpcomm.h"
#include "gpstdio.h"
#include "gpnetlib.h"
#include "util\util.h"
#include "graphics.h"

GPDRAWSURFACE gpDraw[2];		
GPDRAWTAG gpdrawtag;
int nflip;					


void CPU_alignment_and_cache() {
__asm {

    MRC p15, 0, R5, c1, c0, 0 // read control register
//    BIC r5,r5,#2		   // align control OFF
    MOV r6,0x1004      
    ORR r5,r5,r6              // I/D cache ON
    MCR p15, 0, R5, c1, c0, 0 //write control register

}
}
typedef void (*p_menu_func)(void);


void draw_sprite_add(st_sprite *sprite,u16 *buffer,int x_pos,int y_pos) {
	int x,y;
	u16 *dst_line,*dst,*src,pixel,pixeld;
	
	u16 r0,g0,b0;
	
	src=sprite->bitmap;
	dst_line=buffer+(x_pos*LCD_SIZE_Y + y_pos);
	
	for (x=0;x<sprite->x_size;x++) {
		dst=dst_line;
		for (y=0;y<sprite->y_size;y++) {
			pixel=*src++; 
			if (pixel) {
				pixeld=*dst;
				r0=RGB15_R(pixeld);
				g0=RGB15_G(pixeld);
				b0=RGB15_B(pixeld);
				
				r0+=RGB15_R(pixel);
				g0+=RGB15_G(pixel);
				b0+=RGB15_B(pixel);
				
				if (r0>31) r0=31;
				if (g0>31) g0=31;
				if (b0>31) b0=31;
				
				
				*dst=RGB15_5(r0,g0,b0); 
			}
			dst++;
			
		}
		
		dst_line+=LCD_SIZE_Y;
	}
}

void draw_sprite(st_sprite *sprite,u16 *buffer,int x_pos,int y_pos, int pos, int lng) {
	int x,y;
	u16 *dst_line,*dst,*src;
	u16 y_size4;
	u16 sum;

	y_size4 = sprite->y_size&(~0x3);
	sum=(sprite->y_size)-lng;

	src=sprite->bitmap+pos;
	dst_line=buffer+(x_pos*LCD_SIZE_Y + y_pos);
	
	for (x=0;x<sprite->x_size;x++) {
		dst=dst_line;
		
		for (y=0 ; y<lng ; y++)
			*dst++=*src++;
			
		src+=sum;
		
		dst_line+=LCD_SIZE_Y;
	}
}

void draw_sprite_trans(st_sprite *sprite,u16 *buffer,int x_pos,int y_pos) {
	int x,y;
	u16 *dst_line,*dst,*src,pixel;
	u16 y_size4;
	
	y_size4 = sprite->y_size&(~0x3);
	
	src=sprite->bitmap;
	dst_line=buffer+(x_pos*LCD_SIZE_Y + y_pos);
	
	for (x=0;x<sprite->x_size;x++) {
		dst=dst_line;
		for (y=0; y<y_size4; y+=4) {
			pixel=*src++; if (pixel) *dst=pixel; dst++;
			pixel=*src++; if (pixel) *dst=pixel; dst++;
			pixel=*src++; if (pixel) *dst=pixel; dst++;
			pixel=*src++; if (pixel) *dst=pixel; dst++;
		}
		for (  ;y<(sprite->y_size);y++) {
			pixel=*src++;
			if (pixel) *dst=pixel;
			dst++;
		}
		dst_line+=LCD_SIZE_Y;
	}
}

void line_draw_dda(u16 *buffer,int x0,int y0,int x1,int y1,u16 color){

s32 dx,dy,L,x,y,round_dx,round_dy,i;

	dx=x1-x0;
	dy=y1-y0;
	
	if (abs(dx)>=abs(dy)) L=abs(dx); 
	else		      L=abs(dy);
	
	if (L==0) {
		pixel_draw(buffer,x0,y0,color);
		return;
	}
	
	dx=(dx<<16)/L;		//hallo dx y dy
	dy=(dy<<16)/L;		//en coma fija 16:16
	
	x=(x0<<16);
	y=(y0<<16);
	
	for (i=0;i<L;i++) {
		pixel_draw(buffer,(x>>16),(y>>16) ,color);
		x+=dx;
		y+=dy;
	}
	

}

void GpMain(void * arg)
{		
	int i,n,keys;
	int	cnt_surface;
	st_sprite *pantalla_sprite;
	st_sprite *track_sprite;
	st_sprite *numero[10];
	st_sprite *luz[6];
	float tf;
 	int track_pos=0;

	char nombre_sprite[255];		 
	int x,y;
	
	// llamamos al SDK para activar el modo 16bits
	cnt_surface = GpGraphicModeSet(16, NULL);
	
	// reservamos 2 superficies de visualizacion
	i = GpLcdSurfaceGet(&gpDraw[0], 0);   
	i = GpLcdSurfaceGet(&gpDraw[1], 1);
	
	// activamos la visualizacion en la primera de ellas
	GpSurfaceSet(&gpDraw[0]);
	
	GpClockSpeedChange (132000000, 0x3a011, 3);
	CPU_alignment_and_cache();
	
	// inicializamos el sistema de ficheros
	
	GpFatInit();	
	GpRelativePathSet("gp:\\gpmm\\fast\\");   
	
	// cargo los sprites en .RAW RGB (8bits)
	
	pantalla_sprite=load_sprite_RGB8("pantalla.raw",320,240);
	track_sprite=load_sprite_RGB8 ("track.raw",61,121);
	
	for (i=0;i<10;i++) {
		sprintf(nombre_sprite,"%d.raw",i);
		numero[i]=load_sprite_RGB8(nombre_sprite,15,20);
	}
	
		
	for (i=1;i<=6;i++) {
		sprintf(nombre_sprite,"luz%d.raw",i);
		luz[i-1]=load_sprite_RGB8(nombre_sprite,64,64);
	}
	
	
	
	nflip=0;
	
#define TOP_TRACK1_Y (240-109)
#define TOP_TRACK1_X  11

#define SIZ_TRACK_Y  65
	track_pos=33;
	
	while (1) {

		memcpy(gpDraw[nflip].ptbuffer,pantalla_sprite->bitmap,320*240*2);
		track_pos--;
		if (track_pos<=0) track_pos=120;
		
		
		
		draw_sprite(track_sprite,(u16 *)gpDraw[nflip].ptbuffer,TOP_TRACK1_X,TOP_TRACK1_Y-SIZ_TRACK_Y,track_pos,SIZ_TRACK_Y);
		draw_sprite(track_sprite,(u16 *)gpDraw[nflip].ptbuffer,TOP_TRACK1_X+80,TOP_TRACK1_Y-SIZ_TRACK_Y,track_pos,SIZ_TRACK_Y);
		draw_sprite(track_sprite,(u16 *)gpDraw[nflip].ptbuffer,TOP_TRACK1_X+80*2,TOP_TRACK1_Y-SIZ_TRACK_Y,track_pos,SIZ_TRACK_Y);
		draw_sprite(track_sprite,(u16 *)gpDraw[nflip].ptbuffer,TOP_TRACK1_X+80*3,TOP_TRACK1_Y-SIZ_TRACK_Y,track_pos,SIZ_TRACK_Y);
		tf+=0.2;
		for (i=0;i<6;i++) {
		
				
			x=160-32+sin(tf+((float)i))*50.0*sin(tf*0.3+((float)i));
			y=120-32+cos(tf+((float)i))*80.0*sin(tf*0.4+((float)(i))*0.3);
			
			draw_sprite_add(luz[i],(u16 *)gpDraw[nflip].ptbuffer,x,y);
			
		}
		GpSurfaceFlip(&gpDraw[nflip]);
	    nflip=(nflip +1)&1;
	    
	}
	
	/*	
	for(i=0;i<256;i++) {
		
		if ((i&1)) {
			if ((i+2)&2) memset(gpDraw[nflip].ptbuffer,0xffff,320*240*2);  //fondo parpadeante
			else	 memset(gpDraw[nflip].ptbuffer,0x0000,320*240*2);
		}
	    //cuadro alrededor de la barra...
		line_draw_dda((u16 *)gpDraw[nflip].ptbuffer,31,103,31,103+32+2,0xffff);
		line_draw_dda((u16 *)gpDraw[nflip].ptbuffer,31,103,31+256+1,103,0xffff);
		line_draw_dda((u16 *)gpDraw[nflip].ptbuffer,31,103+32+1,31+256+1,103+32+1,0xffff);
		line_draw_dda((u16 *)gpDraw[nflip].ptbuffer,31+256+1,103,31+256+1,103+32+1,0xffff);
		
		draw_sprite_len(main_bar_sprite,(u16 *)gpDraw[nflip].ptbuffer,32,104,i);	
		GpSurfaceFlip(&gpDraw[nflip]);
		nflip=(nflip +1)&1;
		
	}
	
	*/
	Delay(2000);
	
	
	
	//memcpy(gpDraw[nflip].ptbuffer,main_logo_sprite->bitmap,320*240*2);
	
	while(1);	
	
	GpAppExit();
	
}
