#define XRES    320
#define YRES    200

#include <malloc.h>     // malloc(), free()
#include <math.h>       // sqrt(), atan2()
#include <string.h>     // memcpy()

#include "gfx.h"
//--- data ------------------------------------------------------------------

static unsigned short   *tabla=0;
static unsigned char    *text=0;

//--- code ------------------------------------------------------------------

static void crea_tabla( unsigned short *ta, int xr, int yr )
{
    int     i, j;
    float   x, y;
    int     u, v;
    float   a, r;

    for( j=0; j<yr; j++ )
    for( i=0; i<xr; i++ )
        {
        x = -1.0 + 2.0*(float)i/(float)(xr-1);
        y =  1.0 - 2.0*(float)j/(float)(yr-1);

        r = sqrt( x*x + y*y );
        a = atan2( x, y );

        //a += 2.0*r;
        r = r*r;
        //r = 3.0-r;
        u = 128.0*r*cos(a);
        v = 128.0*r*sin(a);

        u &= 255;
        v &= 255;
        *(ta++) = (v<<8)+u;
        }

}

static void tabla_doframe( unsigned char    *buffer,
                           unsigned short   *tabla,
                           unsigned char    *text,
                           int ox, int oy, int xr, int yr )
{
    int i;
    int offs;

    i = xr*yr;
    while( i-- )
        {
        offs = *(tabla++);
        offs += oy;
        offs += (ox<<8);

        offs &= 0x0000ffff;
        *(buffer++) = text[offs];
        }
}


static void crea_textura( unsigned char *buffer )
{
    int i, j;

    int k;

    for( j=0; j<256; j++ )
    for( i=0; i<256; i++ )
        {
        k = i^j;

        k = 128.0 + 64.0*sin(6.2831*4*i/256.0) +
                    32.0*sin(6.2831*6*j/256.0) +
                    32.0*sin(6.2831*7*j/256.0);

        /*
        if( k<64 )
            k=0;
        else
            k=255;
        */
        buffer[256*j+i] = k;
        }


}


                            
static void copia_cuadrado( unsigned char *text,
                            unsigned char *buffer, int xr, int yr,
                            int an, int al)
{
    
    int x0, y0;

    x0 = (xr-an)>>1;
    y0 = (yr-al)>>1;

    buffer += xr*y0 + x0;
    

    while( al-- )
        {
        memcpy( text, buffer, an );
        buffer += xr;
        text += 256;
        }
}

static void soften( unsigned char *buffer, int xr, int yr )
{
    int i, j, k;

    memset( buffer, 0, xr );
    memset( buffer+xr*(yr-1), 0, xr );

    buffer += xr;
    for( j=1; j<(yr-1); j++ )
        {
        for( i=1; i<(xr-1); i++ )
            {
            k = buffer[i-1] + buffer[i+1] + buffer[i-xr] + buffer[i+xr];
            k >>= 2;
            buffer[i] = k;
            }
        buffer += xr;
        }
}

int  FFX_Init( void )
{
    int i;

    tabla  = (unsigned short *)malloc( XRES*YRES*2 );
    text   = (unsigned char  *)malloc( 256*256*1 );

    if( !tabla || !text )
        return( 0 );


    crea_tabla( tabla, XRES, YRES );
    crea_textura( text );



    return( 1 );
}


void FFX_DoFrame( unsigned char *buffer, float t )
{
    int k, i, j, a, b;


    for( i=0; i<256; i++ )
        {
        j = 32 + 32*sin(0.00+6.28*i/256);
        a = 32 + 32*sin(0.02+6.28*i/256);
        b = 32 + 32*sin(0.04+6.28*i/256);
        gfx_setcolor( i, j, a, b );
        }


    i = 2*100.0*sin(t);
    j = 2*50*t;
    /*
    a = 200.0+ 55.0*sin(.9*6.28*t);
    b = 150.0+ 49.0*sin(.9*6.28*t);
    */
    a = 250;
    b = 194;

 

    tabla_doframe( buffer, tabla, text, j, i, XRES, YRES );

    soften( buffer, XRES, YRES );

    copia_cuadrado( text, buffer, XRES, YRES, a, b );
}

void FFX_Free( void )
{
    free( text );
    free( tabla );
}
