#include "part01.h"
#include "general.h"

scene_t scene01;

static UINT destello = 1001;
static UINT hallowdemo = 3007;


static float baseTime = 40.0;

int LoadPart01()
{
	int Status;

	aseLoad("models/calabaza.ase", &scene01);

	Status = loadTGA("maps/destello.tga", destello);
	Status = loadTGA("maps/hallowdemotxt.tga", hallowdemo);

    return Status;
}

int SetPart01 ()
{
	BuildFont();

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);

	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);


	return 1;
}

//Changes in part
static float subpart[13] = { 8.0f,	//instat of time where change
							10.0f,
							12.0f,
							14.0f,
							16.0f,
							18.0f,
							20.0f,
							22.0f,
							24.0f,
							26.0f,
							28.0,
							30.0f,
							42.0f 
};

static float transz = 0.0f;
static float rot = 0.0f;
static float roty = 0.0f;
static float xhallowtxt = 4.0f;
static float val01 = 0.0f;
static float val02 = 0.0f;
static float val03 = 0.0f;
static float pz = -10.0f;

static int pos=0;

int DrawPart01 (float time)
{
if (runStat != STOP){
/*******************DRAW PART*************************************/

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	if (viewTime) printTime(time);
	if (viewFps) printFps(time);

	glLoadIdentity();

	glRotatef(180.0f, 0.0f, 1.0f, 0.0f);

	glColor3f(1.0f, 1.0f, 1.0f);

	
	glEnable(GL_LIGHTING);	
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_BLEND);


	int index = 0;	//Actual subpart

	while (time > subpart[index])
		index ++;

	switch (index)
	{
		case 0: glTranslatef(0.0f, 0.0f, transz);				
				glRotatef(roty, 0.0f, 1.0f, 0.0f);
				glRotatef(sin(val01)*8.0f, 1.0f, 0.0f, 0.0f);
				transz += 4.0f * (time - lastTime);
				roty += 4.0f * (time - lastTime);				
				val01 += 2.0f * (time - lastTime);
				break;

		case 1:	glTranslatef(0.0f, 0.0f, transz);
				glRotatef(roty, 0.0f, 1.0f, 0.0f);
				glRotatef(sin(rot/10)*8.0f, 0.0f, 0.0f, 1.0f);				
				break;

		case 2:	glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, -1.0f, 1.0f, -0.2f);
				break;

		case 3:	glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, 1.0f, -0.5f, 0.6f);
				break;

		case 4:	glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, 1.0f, 1.0f, -0.6f);
				break;

		case 5:	glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, 0.2f, 1.0f, 0.0f);
				break;

		case 6:	glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, -0.2f, -1.0f, 0.0f);
				break;
					
		case 7:	glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, 0.2f, 1.0f, -0.1f);
				break;

		case 8:	glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, -0.2f, -1.0f, -0.1f);
				break;
				
		case 9: glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, 0.0f, 1.0f, 0.5f);
				break;
				
		case 10:glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, -0.5f, 1.0f, 0.5f);					
				break;
				
		case 11:glTranslatef(0.0f, 0.0f, transz);
				
				break;

		case 12:glTranslatef(0.0f, 0.0f, transz);
				glRotatef(rot, 0.0f, 1.0f, 0.0f);
				break;

		default:done = TRUE;
				break;

	}	

	glScalef(0.05f, 0.05f, 0.05f);

/*	if (pos > 99)
		pos = 0;
*/
	if((index % 2)==0){
		//glDisable(GL_DEPTH_TEST);
		drawScene(&scene01, FILL, 1, 1, 0, 0, 0);				

		//Destellos
		glLoadIdentity();
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glDisable(GL_DEPTH_TEST);
		for(int cont=0; cont<20; cont++){
			glColor4f(1.0f, 1.0f, 1.0f, 0.5f);
			glEnable(GL_TEXTURE_2D);
			glBindTexture(GL_TEXTURE_2D, destello);
			plane(sin(val02)*cos(val02/10), cos(val02/10)*sin(val02), sin(pz), 0.2f, 0.2f, 1.0f, 1.0f);			
			plane(sin(val02/10)*cos(val03), cos(val03)*sin(val02/10), cos(pz), 0.2f, 0.2f, 1.0f, 1.0f);			
			plane(cos(val02)*sin(val02/10), sin(val02/10)*cos(val02), sin(pz), 0.2f, 0.2f, 1.0f, 1.0f);			
			plane(cos(val02/10)*sin(val03), sin(val03)*cos(val02/10), cos(pz), 0.2f, 0.2f, 1.0f, 1.0f);			
			val02 += 0.01 * (time - lastTime)*cont;
			val03 += 0.02 * (time - lastTime)*cont/2;
			pz += 0.01 * (time - lastTime)*cont;										
		}
	}

	if((index % 2)!=0){
		glLoadIdentity();

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glDisable(GL_DEPTH_TEST);
		//Texto hellowdemo
		glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, hallowdemo);
		plane(xhallowtxt, -0.85f, -5.5f, 4.5f, 1.7f, 1.0f, 1.0f);
		
	}
	xhallowtxt -= 0.2 * (time - lastTime);

//	pos++;

	rot += 30.0f * (time - lastTime);		

	lastTime = time;

/***************************************************************************/
}//if runStat
	return 1;
}

static void partFree()
{
	aseFree(&scene01);

	KillFont();
}

int Part01 ()
{
	SetPart01();

	while (!appExit && !done)
	{
		if (!BucleMsg())
		{
			if (active && !DrawPart01(COUNTER_Get() + timeDisplacement))	// Active?  Was There A Quit Received?
			{
				appExit=TRUE;							// ESC or DrawGLScene Signalled A Quit
			}
			else									// Not Time To Quit, Update Screen
			{
				SwapBuffers(hDC);					// Swap Buffers (Double Buffering)
			}
		}
	}
	
	partFree();

	done = FALSE;

	return 1;
}