/*
    Copyright 1999 by Nate 'm|d' Miller
    For non-commercial use only!

    File        -- ase.h
    Date        -- 5/29/99
    Author      -- Nate 'm|d' Miller
    Contact     -- vandals1@home.com
    Web         -- http://members.home.com/vandals1
*/

/*
	Modifies and Addons by Alejandro Barrio:  (you can obtain the original files contacting with Nate)
			 e-mail: thdcode@teleline.es
			 Web: http://thd.iespana.es

					start: (4/8/2001)
		- entire scenes loading support.
				+ multiple objects and materials.
				+ no multitexture support.
				+ scene_t structure. Contains all objects, materials and info about the loaded scene.
				+ function drawScene. Draws all models in the scene.
				+ the function drawModel needs the texture of the model.
				+ the functions to get info about the scene are divided in different functions object by object.
		- Type of rendering, fill polygons or wireframe.
					finish: (8/10/2001)

					start: (8/10/2001)
		- load lighting.
				+ omnidirectional lights.
				+ spot lights.
				+ Only renders 8 lights.
					finish: (8/14/2001)

					start: (8/18/2001)
		- Animation
		- Cameras

					

*/

#define FILL				1
#define WIRE				2

#define OBJ_NAME			"*NODE_NAME"
#define FIRST_FRAME			"*SCENE_FIRSTFRAME"
#define LAST_FRAME			"*SCENE_LASTFRAME"
#define FRAME_SPEED			"*SCENE_FRAMESPEED"
#define TICKS_PER_FRAME		"*SCENE_TICKSPERFRAME"
#define OBJECT				"*GEOMOBJECT"
#define SHAPE				"*SHAPEOBJECT"
#define NUM_MATERIALS		"*MATERIAL_COUNT"
#define LIGHT				"*LIGHTOBJECT"
#define POSITION			"*TM_POS"
#define ROT_AXIS			"*TM_ROTAXIS"
#define ROT_ANGLE			"*TM_ROTANGLE"
//Light
#define L_COLOR				"*LIGHT_COLOR"
#define L_INTES				"*LIGHT_INTENS"
#define OMNI				0
#define SPOT				1
#define SPOT_FALLOFF		"*LIGHT_FALLOFF"
#define NAME				"*NODE_NAME"
//Camera
#define CAMERA				"*CAMERAOBJECT"
#define CAM_NEAR			"*CAMERA_NEAR"
#define CAM_FAR				"*CAMERA_FAR"
#define CAM_FOV				"*CAMERA_FOV"
#define CAM_TDIST			"*CAMERA_TDIST"
//Animation
#define ANIMATION			"*TM_ANIMATION"
#define CONTROL_POS_BEZIER	"*CONTROL_POS_BEZIER"
#define CONTROL_ROT_TCB		"*CONTROL_ROT_TCB"
#define BEZIER_POS_KEY		"*CONTROL_BEZIER_POS_KEY"
#define TCB_ROT_KEY			"*CONTROL_TCB_ROT_KEY"
#define ROT_KEY				"*CONTROL_ROT_KEY"
#define POS_SAMPLE			"*CONTROL_POS_SAMPLE"
#define ROT_SAMPLE			"*CONTROL_ROT_SAMPLE"

//Object
#define NUM_VERTEX			"*MESH_NUMVERTEX"
#define NUM_FACES			"*MESH_NUMFACES"
#define NUM_TVERTEX			"*MESH_NUMTVERTEX"
#define NUM_TFACES			"*MESH_NUMTVFACES"
#define VERTEX_LIST			"*MESH_VERTEX_LIST"
#define VERTEX				"*MESH_VERTEX"
#define FACE_LIST			"*MESH_FACE_LIST"
#define FACE				"*MESH_FACE"
#define NORMALS				"*MESH_NORMALS"
#define FACE_NORMAL			"*MESH_FACENORMAL"
#define NVERTEX				"*MESH_VERTEXNORMAL"
#define TVERTEX				"*MESH_TVERT"
#define TFACE				"*MESH_TFACE"
#define MAT_REF				"*MATERIAL_REF"
#define WIRE_COLOR			"*WIREFRAME_COLOR"

//Materials
#define MATERIAL			"*MATERIAL"
#define MAT_NAME			"*MATERIAL_NAME"
#define MAT_CLASS			"*MATERIAL_CLASS"
#define MAT_AMBIENT			"*MATERIAL_AMBIENT"
#define MAT_DIFFUSE			"*MATERIAL_DIFFUSE"
#define MAT_SPECULAR		"*MATERIAL_SPECULAR"
#define	MAT_SHINE			"*MATERIAL_SHINE"
#define MAT_SHINESTRENGTH	"*MATERIAL_SHINESTRENGTH"
#define MAT_TRANSPARENCY	"*MATERIAL_TRANSPARENCY"
#define MAT_WIRE_SIZE		"*MATERIAL_WIRESIZE"
#define MAT_SELFILUM		"*MATERIAL_SELFILLUM"
//Maps
#define TEXTURE				"*BITMAP"
#define UTILE				"*UVW_U_TILING"
#define VTILE				"*UVW_V_TILING"
#define UOFFSET				"*UVW_U_OFFSET"
#define VOFFSET				"*UVW_V_OFFSET"

#ifndef __ASEH__
#define __ASEH__
// make sure that we have the structures i love to use defined
#ifndef vec_t
typedef float vec_t;
#endif

#ifndef vec2_t
typedef vec_t vec2_t[2];
#endif

#ifndef vec3_t
typedef vec_t vec3_t[3];
#endif

//animation
typedef struct
{
	long	instant;
	vec3_t	key;
	vec3_t	bezRight;
	vec3_t	bezLeft;
	int		val;
} key_t;

//Vector y angulo de giro en grados
typedef struct
{
	vec3_t	rot;
	float	deg;
} rotGrad_t;

typedef struct
{
	int numPosKeys;			//Number of keys to translate
	int numRotKeys;			//Number of keys to rotate
	
	key_t *posKey;			//Sucession of translation values
	key_t *rotKey;			//Sucession of rotation values

	vec3_t *posCalc;
	rotGrad_t *rotCalc;
} animation_t;

//Camera
typedef struct
{
	char		name[255];
	vec3_t		position;		// 
	vec3_t		view;		// 
	float		rotAngle;		// angle in grades
	vec3_t		rotAxis;		// 
	float		cnear;			// min. distance
	float		cfar;			// max. distance
	float		fov;			// 
	float		tdist;			// target distance
	animation_t anim;		// Animation of the camera	
} camera_t;

// a triangle in the model
typedef struct
{
	int		vertIndex[3];	// indicies for the verts that make up this triangle
	int		coordIndex[3];	// indicies for the tex coords to texture this face
	vec3_t	normal;			// face normal
	int		texID;			// Texture ID
} triangle_t;

// texture information for the model
typedef struct 
{
	char	texName[255];	// texture name
	int		texId;			// texture id
	int		recipient;	   
	vec_t	uTile;			// u tiling of texture
	vec_t	vTile;			// v tiling of texture
	vec_t	uOffset;		// u offset of texture
	vec_t	vOffset;		// v offset of texture
} texture_t;

typedef struct
{
	char		name[255];		//Material name
	char		type[255];		//Material type
	int			matId;

	float		shine;
	float		shineStrength;
	float		wireSize;
	float		transparency;
	float		selfIlum;

	vec3_t		ambient;		//Ambient light incidence			|
	vec3_t		diffuse;		//diffuse light incidence			|	R G B
	vec3_t		specular;		//specular light incidence			|

	int			withTex;		//False if material havent texture

	texture_t	texture;		//texture on material
} material_t;

// the models
typedef struct
{
	int numVertex;     // number of verts in the model
	int numFaces;      // number of faces in the model
	int numTexFaces;   // number of textured faces in model
	int numTexVertex;  // number of texture coords
	int normals;       // do we have normal information?  
	char name[255];
	vec3_t *verts;     // model verts
	vec2_t *texVerts;  // texture coords
	vec3_t *vertNorms; // vertex normals 
	triangle_t *faces; // faces of model
	//texture_t texture; // texture information
	int material;
	animation_t anim;		// Animation of the model
	vec3_t position;
	vec3_t wireColor;
} model_t;

//lights
typedef struct
{
	int		type;			//Ommnidirectional or Spotlight
	float	position[4];
	float	tgPosition[4];
	float	falloff;
	float	color[4];
	float	intes;
	char	name[255];
	animation_t anim;		// Animation of the light
} light_t;

// the scene
typedef struct
{
	int numObjects;		// number of objects in the scene
	int numMaterials;	// number of materials in the scene
	int numLights;		// number of lights in the scene
	int numCameras;		// number of cameras in the scene
	int firstFrame;
	int lastFrame;
	int frameSpeed;
	int ticksPerFrame;
	material_t *material;	// materials in the scene
	model_t *model;		// models in the scene
	light_t *light;		// lights in the scene
	camera_t *camera;	// cameras in the scene
} scene_t;

//int aseLoad (char *name, model_t *p);
int aseLoad (char *name, scene_t *scn);
//void aseFree (model_t *p);
void aseFree (scene_t *scn);
void drawModel (model_t *p, texture_t *tex, int mode, int textureOn, int lightOn, int faceLight);
void drawScene (scene_t *scn, int mode, int textureOn, int lightOn, int faceLight, int player, int key);
//													type -> 0 = camera ;  1 = model 													
void calculateAnim (scene_t *scn, char *objName, int type);

void setCamera(camera_t *cam);

void cameraView(camera_t *cam, int player, int key);

#endif