#include <time.h>
#include <errno.h>
#include <math.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "sd_main.hpp"
#include "memfunc.hpp"
#include "types.hpp"
#include "errorh.hpp"
#include "snd.hpp"
#include "sndwavst.hpp"
#include "rsc.hpp"
#include "rscdf.hpp"

char DelString [] =
	{
		0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
		0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
		0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
		0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
		0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
		0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
		0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8,
		0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8, 0x8
	};

char FillString [] =
	{
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
	};

static FLOATING FeedbackValues [15] [15] =
	{
// --------------------------------------------------------------------------------------------------------------------------------
/* 0.1s */ 0.9630, 0.9440, 0.9100, 0.8900, 0.8650, 0.7350, 0.4700, 0.4162, 0.3625, 0.3087, 0.2550, 0.2012, 0.1475, 0.0937, 0.0400,
/* 0.2s */ 0.9800, 0.9620, 0.9200, 0.9030, 0.8900, 0.7600, 0.5500, 0.4950, 0.4400, 0.3850, 0.3300, 0.2750, 0.2200, 0.1650, 0.1100,
/* 0.3s */ 0.9880, 0.9700, 0.9400, 0.9300, 0.9220, 0.8000, 0.6500, 0.5937, 0.5375, 0.4812, 0.4250, 0.3687, 0.3125, 0.2562, 0.2000,
/* 0.5s */ 0.9920, 0.9780, 0.9600, 0.9560, 0.9440, 0.8820, 0.7600, 0.7075, 0.6550, 0.6025, 0.5500, 0.4975, 0.4450, 0.3925, 0.3400,
/* 0.7s */ 0.9940, 0.9830, 0.9700, 0.9680, 0.9550, 0.9050, 0.8200, 0.7787, 0.7375, 0.6962, 0.6550, 0.6137, 0.5752, 0.5312, 0.4900,
/* 0.8s */ 0.9950, 0.9850, 0.9770, 0.9750, 0.9640, 0.9100, 0.8400, 0.8222, 0.7785, 0.7347, 0.6910, 0.6472, 0.6035, 0.5597, 0.5160,
/* 1.0s */ 0.9960, 0.9895, 0.9800, 0.9790, 0.9710, 0.9260, 0.8660, 0.8322, 0.7985, 0.7647, 0.7310, 0.6972, 0.6635, 0.6297, 0.5960,
/* 1.5s */ 0.9973, 0.9920, 0.9870, 0.9860, 0.9780, 0.9360, 0.9200, 0.8895, 0.8604, 0.8330, 0.8040, 0.7750, 0.7490, 0.7210, 0.6910,
/* 2.0s */ 0.9979, 0.9940, 0.9913, 0.9900, 0.9845, 0.9500, 0.9400, 0.9163, 0.8942, 0.8732, 0.8510, 0.8287, 0.8065, 0.7842, 0.7620,
/* 2.5s */ 0.9983, 0.9955, 0.9925, 0.9916, 0.9880, 0.9660, 0.9550, 0.9375, 0.9206, 0.9045, 0.8880, 0.8725, 0.8560, 0.8395, 0.8230,
/* 3.0s */ 0.9986, 0.9962, 0.9936, 0.9929, 0.9900, 0.9710, 0.9630, 0.9486, 0.9350, 0.9215, 0.9090, 0.8955, 0.8820, 0.8685, 0.8550,
/* 3.5s */ 0.9988, 0.9970, 0.9948, 0.9944, 0.9918, 0.9750, 0.9705, 0.9585, 0.9486, 0.9376, 0.9270, 0.9172, 0.9066, 0.8959, 0.8853,
/* 4.0s */ 0.9989, 0.9972, 0.9957, 0.9952, 0.9928, 0.9780, 0.9735, 0.9631, 0.9535, 0.9438, 0.9336, 0.9246, 0.9156, 0.9059, 0.8963,
/* 4.5s */ 0.9990, 0.9975, 0.9964, 0.9958, 0.9935, 0.9795, 0.9750, 0.9654, 0.9560, 0.9468, 0.9380, 0.9283, 0.9195, 0.9102, 0.9010,
/* 5.0s */ 0.9991, 0.9977, 0.9966, 0.9962, 0.9941, 0.9810, 0.9766, 0.9671, 0.9591, 0.9503, 0.9416, 0.9325, 0.9241, 0.9153, 0.9066
// --------------------------------------------------------------------------------------------------------------------------------
//         0.001ms 0.003ms 0.005ms 0.007ms 0.010ms 0.029ms 0.048ms 0.067ms 0.086ms 0.105ms 0.124ms 0.143ms 0.162ms 0.181ms 0.200ms
// --------------------------------------------------------------------------------------------------------------------------------
	};

static FLOATING AttackLenValues [15] =
	{
		0.001,
		0.003,
		0.005,
		0.007,
		0.010,
		0.029,
		0.048,
		0.067,
		0.086,
		0.105,
		0.124,
		0.143,
		0.162,
		0.181,
		0.200
	};

SDWORD RevLength;
SDWORD RevAttack;
FLOATING RevVolume;
FLOATING DryVolume;
FLOATING StereoBias;
FLOATING RevEqualize;
FLOATING SilenceLength;
FLOATING PreSilenceLength;
DWORD TotalLength;
DWORD ReadLength;
BOOLEAN ProcessFinished;

char msgNoMemory [] = "Not enough memory!";

TSNDWAVST_WAVSoundStream *InSoundStream;
TSNDWAVST_WAVSoundStream *OutSoundStream;
TRSCDF_ResourceDOSFile *InFile;
TRSC_ResourceHandle *InHandle;
TRSCDF_ResourceDOSFile *OutFile;
TRSC_ResourceHandle *OutHandle;
TSND_SampleParameters SampleParameters;

/* ------------------------------------------------------------------------ */

void WAVOpen (char *FileName, char *OutFileName)
	{
		InFile = new TRSCDF_ResourceDOSFile (FileName, RSCDF_OpenModeReadOnly);

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error opening [infile]!");
			};

		RSC_ResourceInstall ("in", InFile);

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error installing inresource!");
			};

		InHandle = new TRSC_ResourceHandle ("in", RSC_flgResourceAccessModeRead);

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error creating inhandle!");
			};

		InSoundStream = new TSNDWAVST_WAVSoundStream ();

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error creating sound stream!");
			};

		InSoundStream -> ReadInitialize (InHandle, SampleParameters);

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error initializing sound stream read!");
			};

		InSoundStream -> SampleLengthGet (&ReadLength);

		OutFile = new TRSCDF_ResourceDOSFile (OutFileName, RSCDF_OpenModeCreate);

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error creating [outfile]!");
			};

		RSC_ResourceInstall ("out", OutFile);

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error installing outresource!");
			};

		OutHandle = new TRSC_ResourceHandle ("out", RSC_flgResourceAccessModeWrite);

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error creating outhandle!");
			};

		OutSoundStream = new TSNDWAVST_WAVSoundStream ();

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error creating sound stream!");
			};

		OutSoundStream -> WriteInitialize (OutHandle, SampleParameters);

		if (EH_ErrorReportResult != 0)
			{
				EH_ErrorExit ("Error initializing sound stream write!");
			};
	};

/* ------------------------------------------------------------------------ */

void WAVWrite (void)
	{
		InSoundStream -> Deinitialize ();
		OutSoundStream -> Deinitialize ();

		delete OutSoundStream;
		delete OutHandle;
		RSC_ResourceDeinstall (OutFile);
		delete OutFile;

		delete InSoundStream;
		delete InHandle;
		RSC_ResourceDeinstall (InFile);
		delete InFile;
	};

/* ------------------------------------------------------------------------ */
/* TBandwidthFilter ------------------------------------------------------- */
/* ------------------------------------------------------------------------ */

class TBandwidthFilter : public TObject
	{
		protected:
			DWORD Frequency;
			SDWORD FilterBufferSize;
			SDWORD FilterBufferHead;
			FLOATING *FilterBuffer;
			SDWORD FilterFrequencyLow;
			SDWORD FilterFrequencyHigh;
			FLOATING FilterAccumulatorLow;
			FLOATING FilterAccumulatorHigh;

			inline FLOATING FilterBufferSampleGet (DWORD Index)
				{
					DWORD RealIndex = Index;

					if (RealIndex >= FilterBufferSize)
						RealIndex -= FilterBufferSize;

					return *(FilterBuffer + RealIndex);
				};

		public:
			TBandwidthFilter (FLOATING FreqLow, FLOATING FreqHigh, DWORD aFrequency);
			~TBandwidthFilter (void);

			inline FLOATING FilterGet (FLOATING Sample)
				{
					FilterBufferHead--;

					if (FilterBufferHead < 0)
						FilterBufferHead = FilterBufferSize - 1;

					*(FilterBuffer + FilterBufferHead) = Sample;

					FilterAccumulatorLow -= FilterBufferSampleGet (FilterBufferHead + FilterFrequencyLow);
					FilterAccumulatorLow += Sample;
					FilterAccumulatorHigh -= FilterBufferSampleGet (FilterBufferHead + FilterFrequencyHigh);
					FilterAccumulatorHigh += Sample;

					return -(FilterAccumulatorLow / (FilterFrequencyLow + 1) - FilterAccumulatorHigh / (FilterFrequencyHigh + 1));
				};

			void BandwidthSet (FLOATING FreqLow, FLOATING FreqHigh);
	};

/* ------------------------------------------------------------------------ */

TBandwidthFilter::TBandwidthFilter (FLOATING FreqLow, FLOATING FreqHigh, DWORD aFrequency)
	{
		Frequency = aFrequency;
		FilterBufferSize = Frequency / 14;
		FilterBufferHead = 0;
		FilterBuffer = (FLOATING *) MF_MemoryAllocateNoCheck (FilterBufferSize * sizeof (FLOATING));

		if (EH_ErrorReportResult != 0)
			{
				return;
			};

		for (DWORD i = 0; i < FilterBufferSize; i++)
			*(FilterBuffer + i) = 0.0;

		BandwidthSet (FreqLow, FreqHigh);
	};

/* ------------------------------------------------------------------------ */

TBandwidthFilter::~TBandwidthFilter (void)
	{
		delete FilterBuffer;
	};

/* ------------------------------------------------------------------------ */

void TBandwidthFilter::BandwidthSet (FLOATING FreqLow, FLOATING FreqHigh)
	{
		FreqLow = max (16.0, FreqLow);
		FreqHigh = min (Frequency / 2, FreqHigh);

		FilterFrequencyLow = (SDWORD) ((FLOATING) Frequency / FreqLow);
		FilterFrequencyHigh = (SDWORD) ((FLOATING) Frequency / FreqHigh);
		FilterAccumulatorLow = 0.0;
		FilterAccumulatorHigh = 0.0;
	};

/* ------------------------------------------------------------------------ */
/* TReverberatorOperator -------------------------------------------------- */
/* ------------------------------------------------------------------------ */

class TReverberatorOperator : public TObject
	{
		protected:
			DWORD Frequency;
			FLOATING Volume;
			FLOATING Feedback;

			SDWORD SampleBufferSize;
			SDWORD SampleBufferHead;
			SDWORD SampleBufferTail;
			FLOATING *SampleBuffer;

		public:
			TReverberatorOperator (FLOATING Length, FLOATING aDelay, FLOATING aVolume, FLOATING aFeedback, DWORD aFrequency);
			~TReverberatorOperator (void);

			inline FLOATING ReverberationGet (FLOATING Sample)
				{
					FLOATING NewSample = *(SampleBuffer + SampleBufferTail);

					SampleBufferTail--;

					if (SampleBufferTail < 0)
						SampleBufferTail = SampleBufferSize - 1;

					*(SampleBuffer + SampleBufferHead) = Sample + NewSample * Feedback;

					SampleBufferHead--;

					if (SampleBufferHead < 0)
						SampleBufferHead = SampleBufferSize - 1;

					return NewSample * Volume;
				};

			void VolumeSet (FLOATING aVolume);
			void FeedbackSet (FLOATING aFeedback);
	};

/* ------------------------------------------------------------------------ */

TReverberatorOperator::TReverberatorOperator (FLOATING Length, FLOATING aDelay, FLOATING aVolume, FLOATING aFeedback, DWORD aFrequency) : TObject ()
	{
		Frequency = aFrequency;

		SampleBufferSize = (SDWORD) (Length * (FLOATING) Frequency);
		SampleBufferHead = 0;
		SampleBufferTail = 1 + (SDWORD) (aDelay * (FLOATING) Frequency);

		if (SampleBufferTail >= SampleBufferSize)
			SampleBufferTail = 0;
		else
			if (SampleBufferTail < 0)
				SampleBufferTail = 1;

		SampleBuffer = (FLOATING *) MF_MemoryAllocateNoCheck (SampleBufferSize * sizeof (FLOATING));

		if (EH_ErrorReportResult != 0)
			{
				return;
			};

		for (DWORD i = 0; i < SampleBufferSize; i++)
			*(SampleBuffer + i) = 0.0;

		VolumeSet (aVolume);
		FeedbackSet (aFeedback);
	};

/* ------------------------------------------------------------------------ */

TReverberatorOperator::~TReverberatorOperator (void)
	{
		delete SampleBuffer;
	};

/* ------------------------------------------------------------------------ */

void TReverberatorOperator::VolumeSet (FLOATING aVolume)
	{
		Volume = max (0.0, min (10.0, aVolume));
	};

/* ------------------------------------------------------------------------ */

void TReverberatorOperator::FeedbackSet (FLOATING aFeedback)
	{
		Feedback = max (0.0, min (0.999999, aFeedback));
	};

/* ------------------------------------------------------------------------ */
/* TReverberator ---------------------------------------------------------- */
/* ------------------------------------------------------------------------ */

const ReverberatorOperatorCount = 5;
const ReverberatorDCOffsetWindowSize = 512;

class TReverberator : public TObject
	{
		protected:
			TReverberatorOperator *Operators [ReverberatorOperatorCount * 2];
			DWORD Frequency;
			SDWORD Length;
			SDWORD Attack;
			FLOATING Volume;
			FLOATING CutOff;

			FLOATING DCOffset;
			FLOATING DCOffsetWindow [ReverberatorDCOffsetWindowSize];
			SDWORD DCOffsetWindowHead;

			TBandwidthFilter *BandFilter;

		public:
			TReverberator (SDWORD LengthValue, FLOATING aVolume, SDWORD AttackValue, FLOATING aCutOff, DWORD aFrequency);
			~TReverberator (void);

			inline FLOATING ReverberationGet (FLOATING Sample)
				{
					FLOATING Output = 0;
					FLOATING ReverbSample = BandFilter -> FilterGet (Sample);

					for (SDWORD i = 0; i < ReverberatorOperatorCount * 2; i++)
						Output += Operators [i] -> ReverberationGet (ReverbSample + Output * 0.15);

					return Output;
				};

			inline FLOATING DCOffsetProcess (FLOATING Output)
				{
					DCOffset += Output;
					DCOffsetWindow [DCOffsetWindowHead] = Output;

					DCOffsetWindowHead--;

					if (DCOffsetWindowHead < 0)
						DCOffsetWindowHead = ReverberatorDCOffsetWindowSize - 1;

					DCOffset -= DCOffsetWindow [DCOffsetWindowHead];
					Output -= DCOffset / ReverberatorDCOffsetWindowSize;

					return Output;
				};

			void DimensionSet (SDWORD LengthValue, SDWORD AttackValue);
			void VolumeSet (FLOATING aVolume);
			FLOATING VolumeGet (void);
			void CutOffSet (FLOATING CutOff);
			FLOATING CutOffGet (void);
			SDWORD LengthGet (void);
			SDWORD AttackGet (void);
	};

/* ------------------------------------------------------------------------ */

TReverberator::TReverberator (SDWORD LengthValue, FLOATING aVolume, SDWORD AttackValue, FLOATING aCutOff, DWORD aFrequency)
	{
		Frequency = max (128, min (384000, aFrequency));
		Volume = aVolume;

		for (DWORD i = 0; i < ReverberatorOperatorCount * 2; i++)
			{
				Operators [i] = NULL;
			};

		BandFilter = new TBandwidthFilter (16.0, aCutOff, aFrequency);

		if (EH_ErrorReportResult != 0)
			{
				return;
			};

		DimensionSet (LengthValue, AttackValue);

		if (EH_ErrorReportResult != 0)
			{
				return;
			};

		DCOffset = 0.0;
		DCOffsetWindowHead = 0;

		for (i = 0; i < ReverberatorDCOffsetWindowSize; i++)
			DCOffsetWindow [i] = 0.0;
	};

/* ------------------------------------------------------------------------ */

TReverberator::~TReverberator (void)
	{
		for (DWORD i = 0; i < ReverberatorOperatorCount * 2; i++)
			delete Operators [i];
	};

/* ------------------------------------------------------------------------ */

void TReverberator::VolumeSet (FLOATING aVolume)
	{
		Volume = max (0.0, min (10.0, aVolume));

		FLOATING fmod = 1.7;

		for (DWORD i = 0; i < ReverberatorOperatorCount; i++)
			{
				Operators [i] -> VolumeSet (0.35 * Volume * fmod);
				Operators [i + ReverberatorOperatorCount] -> VolumeSet (0.35 * Volume * fmod);
				fmod *= 0.92;
			};
	};

/* ------------------------------------------------------------------------ */

void TReverberator::CutOffSet (FLOATING aCutOff)
	{
		CutOff = max (16.0, min ((FLOATING) Frequency / 2, aCutOff));

		BandFilter -> BandwidthSet (16.0, CutOff);
	};

/* ------------------------------------------------------------------------ */

void TReverberator::DimensionSet (SDWORD LengthValue, SDWORD AttackValue)
	{
		Length = max (0, min (14, LengthValue));
		Attack = max (1, min (14, AttackValue));

		for (DWORD i = 0; i < ReverberatorOperatorCount * 2; i++)
			delete Operators [i];

		FLOATING CFeedback = FeedbackValues [Length] [Attack];
		FLOATING CurrentDelay = AttackLenValues [Attack] * 0.6;

		for (i = 0; i < ReverberatorOperatorCount; i++)
			{
				Operators [i] = new TReverberatorOperator (AttackLenValues [Attack], CurrentDelay, 0, CFeedback, Frequency);

				if (EH_ErrorReportResult != 0)
					{
						return;
					};

				CurrentDelay *= 1.11;
			};

		FLOATING CurrentLength = AttackLenValues [Attack];
		CurrentDelay = AttackLenValues [Attack] * 0.626;

		for (i = ReverberatorOperatorCount; i < ReverberatorOperatorCount * 2; i++)
			{
				Operators [i] = new TReverberatorOperator (CurrentLength, CurrentDelay, 0, CFeedback, Frequency);

				if (EH_ErrorReportResult != 0)
					{
						return;
					};

				CurrentLength *= 1.22;
				CurrentDelay *= 1.11;
			};

		VolumeSet (Volume);
	};

/* ------------------------------------------------------------------------ */

FLOATING TReverberator::VolumeGet (void)
	{
		return Volume;
	};

/* ------------------------------------------------------------------------ */

FLOATING TReverberator::CutOffGet (void)
	{
		return CutOff;
	};

/* ------------------------------------------------------------------------ */

SDWORD TReverberator::LengthGet (void)
	{
		return Length;
	};

/* ------------------------------------------------------------------------ */

SDWORD TReverberator::AttackGet (void)
	{
		return Attack;
	};

/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */
/* ------------------------------------------------------------------------ */

TReverberator *ReverbLeft;
TReverberator *ReverbRight;
FLOATING RevVolumeLL;
FLOATING RevVolumeLR;
FLOATING RevVolumeRL;
FLOATING RevVolumeRR;
DWORD ClipCount;

inline SWORD DoClip (FLOATING Sample)
	{
		Sample *= 32768.0;

		SDWORD OutSample = (SDWORD) Sample;

		if (OutSample > 32767)
			{
				ClipCount++;
				return (SWORD) 32767;
			}
		else
			if (OutSample < -32768)
				{
					ClipCount++;
					return (SWORD) -32768;
				}
			else
				return (SWORD) OutSample;
	};

void WAVReverberateBlock (TSND_Sample *InSample, TSND_Sample *OutSample)
	{
		FLOATING CurrentSample1;
		FLOATING CurrentSample2;
		FLOATING NewSample1;
		FLOATING NewSample2;
		FLOATING OutSample1;
		FLOATING OutSample2;
		DWORD i;

		if ((SampleParameters.SampleDepth == 16) && (SampleParameters.SampleChannelCount == 1))
			{
				for (i = 0; i < InSample -> SampleLength; i++)
					{
						CurrentSample1 = (FLOATING) (*(SWORD *) ((DWORD) InSample -> Buffer + (i << 1))) / (FLOATING) 32768.0;
						NewSample1 = ReverbLeft -> DCOffsetProcess (CurrentSample1 * DryVolume + ReverbLeft -> ReverberationGet (CurrentSample1));

						*(SWORD *) ((DWORD) OutSample -> Buffer + (i << 1)) = DoClip (NewSample1);
					};
			}
		else
			if ((SampleParameters.SampleDepth == 16) && (SampleParameters.SampleChannelCount == 2))
				{
					for (i = 0; i < InSample -> SampleLength; i++)
						{
							CurrentSample1 = (FLOATING) (*(SWORD *) ((DWORD) InSample -> Buffer + (i << 2))) / (FLOATING) 32768.0;
							NewSample1 = ReverbLeft -> ReverberationGet (CurrentSample1);

							CurrentSample2 = (FLOATING) (*(SWORD *) ((DWORD) InSample -> Buffer + (i << 2) + 2)) / (FLOATING) 32768.0;
							NewSample2 = ReverbRight -> ReverberationGet (CurrentSample2);

							OutSample1 = ReverbLeft -> DCOffsetProcess (CurrentSample1 * DryVolume + NewSample1 * RevVolumeLL + NewSample2 * RevVolumeRL);
							OutSample2 = ReverbRight -> DCOffsetProcess (CurrentSample2 * DryVolume + NewSample1 * RevVolumeLR + NewSample2 * RevVolumeRR);

							*(SWORD *) ((DWORD) OutSample -> Buffer + (i << 2)) = DoClip (OutSample1);
							*(SWORD *) ((DWORD) OutSample -> Buffer + (i << 2) + 2) = DoClip (OutSample2);
						};
				};
	};

/* ------------------------------------------------------------------------ */

void WAVReverberate (void)
	{
		ClipCount = 0;

		FLOATING CutOffL = 40.0 + RevEqualize;
		FLOATING CutOffR = CutOffL;

		SDWORD AttackL = RevAttack;
		SDWORD AttackR = RevAttack;

		if (StereoBias < 0.0)
			{
				CutOffR *= 0.8 - 0.26 * abs (StereoBias);
				AttackL += 1;
			}
		else
			{
				CutOffL *= 0.8 - 0.26 * abs (StereoBias);
				AttackR += 1;
			};

		StereoBias = abs (StereoBias);

		RevVolumeLL = 1.0 - StereoBias;
		RevVolumeLR = 0.0 + StereoBias;
		RevVolumeRL = 0.0 + StereoBias;
		RevVolumeRR = 1.0 - StereoBias;

		ReverbLeft = new TReverberator (RevLength, RevVolume, AttackL, CutOffL, SampleParameters.SampleFrequency);

		if (EH_ErrorReportResult != 0)
			EH_ErrorExit (msgNoMemory);

		ReverbRight = new TReverberator (RevLength, RevVolume, AttackR, CutOffR, SampleParameters.SampleFrequency);

		if (EH_ErrorReportResult != 0)
			EH_ErrorExit (msgNoMemory);

		DWORD PreSilence = (SDWORD) ((FLOATING) SampleParameters.SampleFrequency * PreSilenceLength);

		TotalLength = ReadLength + (SDWORD) ((FLOATING) SampleParameters.SampleFrequency * SilenceLength) + + PreSilence;

		DWORD Clk1 = clock ();

		DWORD LeftToProcess = TotalLength;
		DWORD BlockSize;
		DWORD ReadLeft;
		TSND_Sample *TempSample;

		while (LeftToProcess > 0)
			{
				if (kbhit ())
					{
						int k = getch ();

						if (k == 0)
							{
								k = getch ();
							}
						else
							if (k == 27)
								{
									printf ("%s%s%sCancelled!\n", DelString, FillString, DelString);
									EH_ErrorExit (NULL);
								};
					};

				printf ("%s%s%s%6.2f%% complete...", DelString, FillString, DelString, 100.0 - ((FLOATING) LeftToProcess / (FLOATING) TotalLength) * 100.0);
				fflush (stdout);

				if (PreSilence > 0)
					{
						BlockSize = min (0x4000, PreSilence);

						TempSample = new TSND_Sample ();

						TempSample -> Parameters = SampleParameters;
						TempSample -> SampleLength = BlockSize;
						TempSample -> Buffer = MF_MemoryAllocate (BlockSize * SampleParameters.SampleSize);
						memset (TempSample -> Buffer, 0, BlockSize * SampleParameters.SampleSize);

						PreSilence -= BlockSize;
					}
				else
					{
						InSoundStream -> SampleLengthLeftGet (&ReadLeft);

						if (ReadLeft == 0)
							{
								BlockSize = min (0x4000, LeftToProcess);

								TempSample = new TSND_Sample ();

								TempSample -> Parameters = SampleParameters;
								TempSample -> SampleLength = BlockSize;
								TempSample -> Buffer = MF_MemoryAllocate (BlockSize * SampleParameters.SampleSize);
								memset (TempSample -> Buffer, 0, BlockSize * SampleParameters.SampleSize);
							}
						else
							{
								BlockSize = min (0x4000, ReadLeft);
								TempSample = InSoundStream -> SampleBlockRead (BlockSize);

								if (EH_ErrorReportResult != 0)
									{
										EH_ErrorExit ("Error reading infile!");
									};
							};
					};

				WAVReverberateBlock (TempSample, TempSample);

				OutSoundStream -> SampleBlockWrite (TempSample);

				if (EH_ErrorReportResult != 0)
					{
						EH_ErrorExit ("Error writing infile!");
					};

				delete TempSample;
				LeftToProcess -= BlockSize;
			};

		FLOATING Clk2 = ((FLOATING) clock () - (FLOATING) Clk1) / CLOCKS_PER_SEC;
		FLOATING Speed;

		if (Clk2 != 0.0)
			{
				Speed = (FLOATING) (TotalLength * SampleParameters.SampleSize) / Clk2 / 1024;
			}
		else
			{
				Speed = 9999.99;
			};

		printf ("%s%s%sProcessed in %4.2f seconds (at %4.2f kB/sec). Samples clipped: %u\n", DelString, FillString, DelString, Clk2, Speed, ClipCount);
	};

/* ------------------------------------------------------------------------ */

void main (int argc, char *argv [])
	{
		printf ("\n\nWAV Reverberator v1.5 (c) 1998 Seaber Designs\n"
			"Written by Aleksey V. Vaneev\n"
			"Bandwidth Filter (c) Rick Murray\n\n");

		if (argc < 10)
			{
				printf ("Usage: RAWREVER.EXE <ifile> <ofile> <len> <vol> <sbias> <dvol> <eq> <sil> <atk>\n\n"
					"Where <ifile> - input 16bit wavfile\n"
					"      <ofile> - output file\n"
					"      <len> - reverb length value [0; 14]\n"
					"      <vol> - volume of reverb [0.0; 10.0]\n"
					"      <sbias> - stereobias [-1.0; 1.0]\n"
					"      <dvol> - volume of dry sound [0.0; 10.0]\n"
					"      <eq> - reverb equalization threshold in hz [16.0; 384000.0]\n"
					"      <sil> - length (in secs) of additional silence [0.0; 10.0]\n"
					"      <atk> - attack time (room size) value [0; 14]\n\n");

				return;
			};

		errno = EZERO;
		RevLength = atol (argv [3]);

		if ((RevLength > 14) || (RevLength < 0) || (errno != EZERO))
			{
				printf ("Specified <len> is invalid!\nMust be in [0; 14]\n");
				return;
			};

		errno = EZERO;
		RevVolume = atof (argv [4]);

		if ((RevVolume > 10) || (RevVolume < 0.0) || (errno != EZERO))
			{
				printf ("Specified <vol> is invalid!\nMust be in [0.0; 10.0]\n");
				return;
			};

		RevVolume *= 0.2;

		errno = EZERO;
		StereoBias = atof (argv [5]);

		if ((StereoBias > 1.0) || (StereoBias < -1.0) || (errno != EZERO))
			{
				printf ("Specified <stbias> is invalid!\nMust be in [-1.0; 1.0]\n");
				return;
			};

		errno = EZERO;
		DryVolume = atof (argv [6]);

		if ((DryVolume > 10) || (DryVolume < 0.0) || (errno != EZERO))
			{
				printf ("Specified <dryvol> is invalid!\nMust be in [0.0; 10.0]\n");
				return;
			};

		errno = EZERO;
		RevEqualize = atof (argv [7]);

		if ((RevEqualize > 384000.0) || (RevEqualize < 16.0) || (errno != EZERO))
			{
				printf ("Specified <eq> is invalid!\nMust be in [16.0; 384000.0]\n");
				return;
			};

		errno = EZERO;
		SilenceLength = atof (argv [8]);

		if ((SilenceLength > 10.0) || (SilenceLength < 0.0) || (errno != EZERO))
			{
				printf ("Specified <silence> is invalid!\nMust be in [0.0; 10.0]\n");
				return;
			};

		errno = EZERO;
		RevAttack = atol (argv [9]);

		if ((RevAttack > 14) || (RevAttack < 0) || (errno != EZERO))
			{
				printf ("Specified <atk> is invalid!\nMust be in [0; 14]\n");
				return;
			};

		PreSilenceLength = 0.0;

		if (argc > 10)
			{
				errno = EZERO;
				PreSilenceLength = atof (argv [10]);

				if ((PreSilenceLength > 10.0) || (SilenceLength < 0.0) || (errno != EZERO))
					{
						printf ("Specified <presilence> is invalid!\nMust be in [0.0; 10.0]\n");
						return;
					};
			};

		WAVOpen (argv [1], argv [2]);
		WAVReverberate ();
		WAVWrite ();
	};
