//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//
// Copyright Information:
// ======================
// 
// Some parts of the source are from the public domain and are not
// copyrighted.
// 
// Some parts of the source bear explicit copyright notices from the
// author and are subject to the conditions listed there by the author.
// 
// The remainder of the source (not already public domain, no explicit
// author's copyright notice) is Copyright 1994 by Torps Productions
// (a loosely associated and ever-growing group of fanatic programmers).
//
// The source code may be copied freely and may be used in other programs
// under the following conditions:
//  It may not be used in a commercial program without prior permission.
//  Please credit the author (in general, credit Cthugha and Torps
//  Productions) as the source of the code.
// 
// This copyright notice is grafted from the Fractint copyright notice.
//
//
// Modifying the code:
// ===================
//
// Feel free to modify this source code, HOWEVER, please send any working
// changes/fixes to me (zaph@torps.apana.org.au) for inclusion in future
// versions of the code.
//
// Distributing the code:
// ======================
//
// Feel free to distribute this code, as long as it is complete and contains
// all copyright information that was included in the original.
//
// Legal Issues:
// =============
//
// What legal issues ???
//
// Come on guys, this is for *fun*, get on with it, make it great, make us
// all famous!!!
//
//                                                zaph, 12May94

#ifndef peek

#define peek( a,b )( *( (int  far* )MK_FP( (a ),( b )) ))
#define peekb( a,b )( *( (char far* )MK_FP( (a ),( b )) ))
#define poke( a,b,c )( *( (int  far* )MK_FP( (a ),( b )) ) =( int )( c ))
#define pokeb( a,b,c )( *( (char far* )MK_FP( (a ),( b )) ) =( char )( c ))

#endif

#define TRUE 1
#define FALSE 0

#define BUFF_WIDTH  320

#define BUFF_HEIGHT 204
#define BUFF_SIZE 65280

#define BUFF_BOTTOM 200
#define Y_MAX (BUFF_HEIGHT-1)

#define NUMTABLES   10
#define NUMWAVES    23
#define NUMDISPLAYS 2
#define NUMMASSAGES 3

#define NUMMODES    8
#define NUMCOMBINATIONS 1
extern int normal_flame;
extern int normal_wave;
extern int curtable;
extern int massageStyle;
extern int curdisplay;
extern int table[NUMTABLES][256];
extern int stereo[BUFF_WIDTH][2];
extern unsigned char buff[BUFF_HEIGHT][BUFF_WIDTH];
extern int minnoise;
extern int min_time,rand_time;

#define LUTSIZE 3*256


extern int init_sbpro(void);
extern void close_sbpro(void);
extern int get_stereo(void);
extern void change_wave(int wavenum);
extern int change_flame(int flamenum);
extern void next_wave(void);


#define MASTER_VOL  0x22
#define VOC_VOL     0x04
#define LINE_VOL    0x2e
#define FM_VOL	    0x26
#define CD_VOL	    0x28

#define RECORD_SRC  0x0C

#define MIC	    0x11
#define LINE	    0x17
#define CD	    0x13


extern unsigned  tempBuff;
extern long	  buffer_size;
extern char	  far *voice_buffer ;
extern unsigned  int voice_seg;
extern int debug_mode;
extern unsigned int sample_rate;

