UNIT VTStrConst;

INTERFACE

USES Objects;




CONST
  StrPosition       = $1000;
  StrPattern        = $1001;
  StrNote           = $1002;
  StrTempo          = $1003;

  StrModule         = $1100;
  StrFilename       = $1101;
  StrMemoryLeft     = $1102;
  StrSampleRate     = $1103;
  StrVolume         = $1104;

  StrMenu1          = $1201;
  StrMenu2          = $1202;
  StrMenu3          = $1203;
  StrMenu4          = $1204;
  StrMenu5          = $1205;
  StrMenu6          = $1206;
  StrMenu7          = $1207;
  StrMenu8          = $1208;
  StrMenu9          = $1209;
  StrMenu0          = $120A;

  StrOscilloscView  = $1300;
  StrGUSOscillosc   = $1310;

  StrChannel        = $1400;

  StrCreditsTitle   = $14FF;

  StrDedicat        = $1500;
  StrCredits        = $1520;

  StrUsageTop       = $2000;
  StrUsage01        = $2001;
  StrUsageBottom    = $200D;
  StrUsageEmpty     = $200E;
  StrUsagePressAKey = $200F;

  StrUsage1Beg      = $2020;
  StrUsage2Beg      = $2040;
  StrUsage3Beg      = $2060;
  StrUsage4Beg      = $2080;

  StrInitializing   = $2200;




PROCEDURE VTAddSpanishMsg(VAR List: TStrListMaker);
PROCEDURE VTAddEnglishMsg(VAR List: TStrListMaker);




IMPLEMENTATION




PROCEDURE VTAddSpanishMsg(VAR List: TStrListMaker);
  BEGIN
    List.Put(StrPosition               , 'Posicin:  ');
    List.Put(StrPattern                , 'Patrn:    ');
    List.Put(StrNote                   , 'Nota:      ');
    List.Put(StrTempo                  , 'Tempo:     ');

    List.Put(StrModule                 , 'Mdulo:    ');
    List.Put(StrFilename               , 'Fichero:   ');
    List.Put(StrMemoryLeft             , 'Mem. libre:');
    List.Put(StrSampleRate             , 'Frecuencia:');
    List.Put(StrVolume                 , 'Volumen:');

    List.Put(StrMenu1                  , 'PAr/Ab Otro patrn     ');
    List.Put(StrMenu2                  , 'In/Fin Idem (principio)');
    List.Put(StrMenu3                  , '1-8    Apagar canal    ');
    List.Put(StrMenu4                  , 'F5-F9  Varias ventanas ');
    List.Put(StrMenu5                  , 'Iz/Dch.Desplaza canales');
    List.Put(StrMenu6                  , 'R/T    Frec. de salida ');
    List.Put(StrMenu7                  , '+/-    Volumen         ');
    List.Put(StrMenu8                  , 'D      Shell al DOS    ');
    List.Put(StrMenu9                  , 'N/S    Sig. cancin    ');
    List.Put(StrMenu0                  , 'ESC    Parar           ');

    List.Put(StrOscilloscView          , 'Osciloscopio');
    List.Put(StrGUSOscillosc           , '               El osciloscopio no est disponible cuando se usa la GUS');

    List.Put(StrChannel                , 'Canal    ');

    List.Put(StrCreditsTitle           , '                               Crditos');

    List.Put(StrCredits                , '     - Juan Carlos Arvalo    Originador de todo el tinglado.');
    List.Put(StrCredits+ 1             , '                               Cuerpo del programa. Estructura');
    List.Put(StrCredits+ 2             , '                               general. Primeras versiones.');
    List.Put(StrCredits+ 3             , '');
    List.Put(StrCredits+ 4             , '     - Luis Crespo    Antecesor del programa (JAMP).');
    List.Put(StrCredits+ 5             , '                               Rutinas de DMA. Informacin sobre');
    List.Put(StrCredits+ 6             , '                               Sound Blaster.');
    List.Put(StrCredits+ 7             , '');
    List.Put(StrCredits+ 8             , '     - Flix Sanz    Creacin de los DOCs de usuario.');
    List.Put(StrCredits+ 9             , '');
    List.Put(StrCredits+10             , '     - Alejandro Lpez    Idea original de la mezcla de');
    List.Put(StrCredits+11             , '                               canales en estreo.');
    List.Put(StrCredits+12             , '');
    List.Put(StrCredits+13             , '     - Hctor Martnez    Rutinas FFT. (no introducidas');
    List.Put(StrCredits+14             , '                               todava).');
    List.Put(StrCredits+11             , '                               Idea original del sistema de');
    List.Put(StrCredits+16             , '                               manejo de los 4 canales.');
    List.Put(StrCredits+17             , '');
    List.Put(StrCredits+18             , '     - David Lpez    Informacin sobre SB-Pro estreo.');
    List.Put(StrCredits+19             , '');
    List.Put(StrCredits+20             , '     - Angel Trigo    Informacin sobre SB-Pro estreo.');
    List.Put(StrCredits+21             , '');
    List.Put(StrCredits+22             , '     - Carlos Fernndez    Realizada una modificacin en');
    List.Put(StrCredits+23             , '                               el swapping, para que funcione');
    List.Put(StrCredits+24             , '                               con CD-ROMS.');
    List.Put(StrCredits+25             , '');
    List.Put(StrCredits+26             , '     - Nstor Matas    Traduccin del manual al Ingls.');
    List.Put(StrCredits+27             , '');
    List.Put(StrCredits+28             , 'NOTA: Esta versin de VT no soporta ninguna tarjeta aparte de la GUS.');
    List.Put(StrCredits+29             , '      Otras tarjetas sern soportadas de nuevo en futuras versiones de VT.');
    List.Put(StrCredits+30             , '');
    List.Put(StrCredits+31             , #0);

    List.Put(StrDedicat                , '         Esta versin est dedicada a Gore/FC y a John Smith.');
    List.Put(StrDedicat+1              , '           Ambos han contribudo de una forma muy especial.');
    List.Put(StrDedicat+2              , #0);

    List.Put(StrUsageTop               ,' Ŀ');
    List.Put(StrUsage01                ,'  VT  <fichero>[.MOD|.OKT|.S3M|.STM|.669| etc] [<opciones>] [@<fichero.VTO>] ');
    List.Put(StrUsageBottom            ,' ');
    List.Put(StrUsageEmpty             ,'                                                                             ');
    List.Put(StrUsagePressAKey         ,'                      ---=== Pulsa  una tecla ===---');

    List.Put(StrUsage1Beg              ,'  <fichero> acepta comodines (wildards). Se pueden especificar varios.       ');
    List.Put(StrUsage1Beg+1            ,'            Tambin se puede especificar la cancin que est dentro de una   ');
    List.Put(StrUsage1Beg+2            ,'            demo (sta sin comodines) mediante la barra "/" (ver ejemplos).  ');
    List.Put(StrUsage1Beg+3            ,'');
    List.Put(StrUsage1Beg+4            ,'  <fichero.VTO> es un fichero ASCII con lneas de parmetros. Se pueden      ');
    List.Put(StrUsage1Beg+5            ,'                especificar varios, cada uno con su arroba (@). Los ficheros ');
    List.Put(StrUsage1Beg+6            ,'                pueden llevar comentarios, precedidos por un smbolo de ";". ');
    List.Put(StrUsage1Beg+7            ,'                Tambin se pueden anidar todo lo que se quiera.              ');
    List.Put(StrUsage1Beg+8            ,#0);

    List.Put(StrUsage2Beg              ,'  <opciones> es una lista de opciones, precedidas cada una por una barra "/" ');
    List.Put(StrUsage2Beg+ 1           ,'             o por un guin "-". Las opciones deben estar separadas por, al  ');
    List.Put(StrUsage2Beg+ 2           ,'             menos, un espacio. Algunas pociones pueden llevar un parmetro, ');
    List.Put(StrUsage2Beg+ 3           ,'             que se puede especificar a continuacin, separado por un        ');
    List.Put(StrUsage2Beg+ 4           ,'             espacio o por dos puntos ":". Posibles opciones son:            ');
    List.Put(StrUsage2Beg+ 5           ,'');
    List.Put(StrUsage2Beg+ 6           ,'    /  -        interpreta lo que se haya especificado, y despus contina. ');
    List.Put(StrUsage2Beg+ 7           ,'    /v:<vol.>    volumen del sonido.                                         ');
    List.Put(StrUsage2Beg+ 8           ,'    /sh:<cmd.>   programa y parmetros que se ejecutan al hacer un shell.    ');
    List.Put(StrUsage2Beg+ 9           ,'    /ss:<pos.>   posicin de comienzo de la cancin.                         ');
    List.Put(StrUsage2Beg+10           ,'    /sr:<pos.>   posicin de comienzo del bucle de la cancin.               ');
    List.Put(StrUsage2Beg+11           ,'    /sl:<pos.>   posicin de finalizacin de la cancin.                     ');
    List.Put(StrUsage2Beg+12           ,'    /lq          "Low Quality", ocupa menos memoria, pero suena peor.        ');
    List.Put(StrUsage2Beg+13           ,'    /hq          "Hi  Quality", desactiva el anterior.                       ');
    List.Put(StrUsage2Beg+14           ,'    /flp         equivale a poner "ForceLoopMod = S" en el VT.CFG.          ');
    List.Put(StrUsage2Beg+15           ,'    /nofl        equivale a poner "ForceLoopMod = No" en el VT.CFG.          ');
    List.Put(StrUsage2Beg+16           ,'    /loop        equivale a poner "LoopMod = S" en el VT.CFG.               ');
    List.Put(StrUsage2Beg+17           ,'    /nolp        equivale a poner "LoopMod = No" en el VT.CFG.               ');
    List.Put(StrUsage2Beg+18           ,'    /off:<pos.>  posicin de comienzo de la cancin dentro del fichero.      ');
    List.Put(StrUsage2Beg+19           ,'    /port:<n>    puerto de E/S de la tarjeta de sonido.                      ');
    List.Put(StrUsage2Beg+20           ,'    /irq:<n>     IRQ de la tarjeta de sonido.                                ');
    List.Put(StrUsage2Beg+21           ,'    /frst:<file> no suena ninguna cancin hasta que no se encuentra esta.    ');

    List.Put(StrUsage2Beg+22           ,#0);

    List.Put(StrUsage3Beg              ,'  <disp.> puede ser:                                                         ');
    List.Put(StrUsage3Beg+ 1           ,'                                                                             ');
    List.Put(StrUsage3Beg+ 2           ,'      Lo siento. Esta versin de VT slo soporta GUS.                        ');
    List.Put(StrUsage3Beg+ 3           ,'                                                                             ');
    List.Put(StrUsage3Beg+ 4           ,#0);

    List.Put(StrUsage4Beg              ,'  Ejemplos: El intrprete de lnes de comando es demasiado flexible para     ');
    List.Put(StrUsage4Beg+ 1           ,'            explicarlo aqu entero, as que para hacerse una idea de cmo    ');
    List.Put(StrUsage4Beg+ 2           ,'            funciona, examine los ejemplos y los ficheros .VTO includos.    ');
    List.Put(StrUsage4Beg+ 3           ,'');
    List.Put(StrUsage4Beg+ 4           ,'    Este hace sonar la meloda "Axel F." por la GUS que est en el puerto    ');
    List.Put(StrUsage4Beg+ 5           ,'    240, IRQ 11 con un volumen de 64:                                        ');
    List.Put(StrUsage4Beg+ 6           ,'');
    List.Put(StrUsage4Beg+ 7           ,'        VT /v:64 D:\MODS\AXEL_F.MOD /port $240 /IRQ:11                       ');
    List.Put(StrUsage4Beg+ 8           ,'');
    List.Put(StrUsage4Beg+ 9           ,'    Este hace sonar la msica de la demo Unreal, de Future Crew, segn el    ');
    List.Put(StrUsage4Beg+10           ,'    fichero .VTO. Al salir al shell, edita el fichero VT.PAS en el editor:   ');
    List.Put(StrUsage4Beg+11           ,'');
    List.Put(StrUsage4Beg+12           ,'        VT @UNREAL.VTO /sh:C:\BIN\Q.EXE VT.PAS                               ');
    List.Put(StrUsage4Beg+13           ,'');
    List.Put(StrUsage4Beg+14           ,'    Este toca las canciones 1 y 2 (cualquiera que sea su formato):           ');
    List.Put(StrUsage4Beg+15           ,'');
    List.Put(StrUsage4Beg+16           ,'        VT 1 2                                                               ');
    List.Put(StrUsage4Beg+17           ,'');
    List.Put(StrUsage4Beg+18           ,'    Este toca la cancin 1 a un volumen de 64 y la cancin 2 a 128:          ');
    List.Put(StrUsage4Beg+19           ,'');
    List.Put(StrUsage4Beg+20           ,'        VT 1 /v:64 / /v 128 2                                                ');
    List.Put(StrUsage4Beg+21           ,'');
    List.Put(StrUsage4Beg+22           ,#0);

    List.Put(StrInitializing           ,'    Inicializando... ');

  END;


PROCEDURE VTAddEnglishMsg(VAR List: TStrListMaker);
  BEGIN
    List.Put(StrPosition               , 'Position:  ');
    List.Put(StrPattern                , 'Pattern:   ');
    List.Put(StrNote                   , 'Note:      ');
    List.Put(StrTempo                  , 'Tempo:     ');

    List.Put(StrModule                 , 'Module:    ');
    List.Put(StrFilename               , 'Filename:  ');
    List.Put(StrMemoryLeft             , 'Free mem.: ');
    List.Put(StrSampleRate             , 'Frequency: ');
    List.Put(StrVolume                 , 'Volume: ');

    List.Put(StrMenu1                  , 'PUp/Dn Next pattern    ');
    List.Put(StrMenu2                  , 'Bg/End Idem (from beg) ');
    List.Put(StrMenu3                  , '1-8    Turn off channel');
    List.Put(StrMenu4                  , 'F5-F9  Change windows  ');
    List.Put(StrMenu5                  , 'Lt/Rt  Shift channels  ');
    List.Put(StrMenu6                  , 'R/T    Output freq.    ');
    List.Put(StrMenu7                  , '+/-    Volume          ');
    List.Put(StrMenu8                  , 'D      DOS Shell       ');
    List.Put(StrMenu9                  , 'N/S    Next song       ');
    List.Put(StrMenu0                  , 'ESC    Quit            ');

    List.Put(StrOscilloscView          , 'Oscilloscope');
    List.Put(StrGUSOscillosc           , '                    The oscilloscope is not available with GUS sound');

    List.Put(StrChannel                , 'Channel  ');

    List.Put(StrCreditsTitle           , '                          Credits');

    List.Put(StrCredits                , '     - Juan Carlos Arvalo    Originator of all this mess.');
    List.Put(StrCredits+ 1             , '                               Program body, General structure.');
    List.Put(StrCredits+ 2             , '                               First versions.');
    List.Put(StrCredits+ 3             , '');
    List.Put(StrCredits+ 4             , '     - Luis Crespo    Programs antecesor (JAMP).');
    List.Put(StrCredits+ 5             , '                               DMA routines. Sound Blaster');
    List.Put(StrCredits+ 6             , '                               Info.');
    List.Put(StrCredits+ 7             , '');
    List.Put(StrCredits+ 8             , '     - Flix Sanz    Creation of the user DOCs.');
    List.Put(StrCredits+ 9             , '');
    List.Put(StrCredits+10             , '     - Alejandro Lpez    Original system of stereo');
    List.Put(StrCredits+11             , '                               channels mixing.');
    List.Put(StrCredits+12             , '');
    List.Put(StrCredits+13             , '     - Hctor Martnez    FFT routines. (not yet');
    List.Put(StrCredits+14             , '                               introduced).');
    List.Put(StrCredits+11             , '                               Original idea of the 4 channel');
    List.Put(StrCredits+16             , '                               handling system.');
    List.Put(StrCredits+17             , '');
    List.Put(StrCredits+18             , '     - David Lpez    SB-Pro stereo info.');
    List.Put(StrCredits+19             , '');
    List.Put(StrCredits+20             , '     - Angel Trigo    SB-Pro stereo info.');
    List.Put(StrCredits+21             , '');
    List.Put(StrCredits+22             , '     - Carlos Fernndez    Made a modification in the');
    List.Put(StrCredits+23             , '                               swapping system, to make it work');
    List.Put(StrCredits+24             , '                               on CD-ROMS.');
    List.Put(StrCredits+25             , '');
    List.Put(StrCredits+26             , '     - Nstor Matas    Translation of this manual into');
    List.Put(StrCredits+27             , '                               English.');
    List.Put(StrCredits+28             , '');
    List.Put(StrCredits+29             , '  NOTE: This version of VT currently doesn''t support other than GUS.');
    List.Put(StrCredits+30             , '        Future versions of VT will support other cards again.');
    List.Put(StrCredits+31             , #0);

    List.Put(StrDedicat                , '         This version is dedicated to Gore/FC and John Smith.');
    List.Put(StrDedicat+1              , '           They both have contributed in a very special way.');
    List.Put(StrDedicat+2              , #0);

    List.Put(StrUsageTop               ,' Ŀ');
    List.Put(StrUsage01                ,'  VT  <file.MOD|.OKT|.S3M|.STM|.669| etc] [<options>] [@<file.VTO>]          ');
    List.Put(StrUsageBottom            ,' ');
    List.Put(StrUsageEmpty             ,'                                                                             ');
    List.Put(StrUsagePressAKey         ,'                       ---=== Press any key ===---');

    List.Put(StrUsage1Beg              ,'  <file> accepts wildards. You can also specify more than one. Also, you can ');
    List.Put(StrUsage1Beg+ 1           ,'         specify the songs inside a demo (this time without wildcards)       ');
    List.Put(StrUsage1Beg+ 2           ,'         using the bar "/". (See the examples).                              ');
    List.Put(StrUsage1Beg+ 3           ,'');
    List.Put(StrUsage1Beg+ 4           ,'  <file.VTO> is an ASCII file with mor parameter lines. You can specify as   ');
    List.Put(StrUsage1Beg+ 5           ,'             many as you want, each one with it''s at-sign "@". These files   ');
    List.Put(StrUsage1Beg+ 2           ,'         using the bar "/". (See the examples).                              ');
    List.Put(StrUsage1Beg+ 3           ,'');
    List.Put(StrUsage1Beg+ 4           ,'  <file.VTO> is an ASCII file with mor parameter lines. You can specify as   ');
    List.Put(StrUsage1Beg+ 5           ,'             many as you want, each one with it''s at-sign "@". These files   ');
    List.Put(StrUsage1Beg+ 6           ,'             can have comments, beginning with a semicolon ";". They can     ');
    List.Put(StrUsage1Beg+ 7           ,'             also be nested to any level (memory permitting).                ');
    List.Put(StrUsage1Beg+ 8           ,#0);

    List.Put(StrUsage2Beg              ,'  <options> is a list of switches, preceded each one with a slash "/" or a   ');
    List.Put(StrUsage2Beg+ 1           ,'            hyphen "-". All options must be separated by, at least, a space. ');
    List.Put(StrUsage2Beg+ 2           ,'            Some options must have a parameter, which must be separated by a ');
    List.Put(StrUsage2Beg+ 3           ,'            space or a colon ":". Possible options are:                      ');
    List.Put(StrUsage2Beg+ 4           ,'');
    List.Put(StrUsage2Beg+ 5           ,'    / or -       do all the options and songs specified, and then continue.  ');
    List.Put(StrUsage2Beg+ 6           ,'    /v:<vol.>    sound volume.                                               ');
    List.Put(StrUsage2Beg+ 7           ,'    /sh:<cmd.>   program and parameters to be executed when shelling.        ');
    List.Put(StrUsage2Beg+ 8           ,'    /ss:<pos.>   song start position.                                        ');
    List.Put(StrUsage2Beg+ 9           ,'    /sr:<pos.>   song loop start position.                                   ');
    List.Put(StrUsage2Beg+10           ,'    /sl:<pos.>   song last position.                                         ');
    List.Put(StrUsage2Beg+11           ,'    /lq          "Low Quality", spends less memory, but sounds worse         ');
    List.Put(StrUsage2Beg+12           ,'    /hq          "Hi  Quality", deactivates the /lq.                         ');
    List.Put(StrUsage2Beg+13           ,'    /flp         equals to "ForceLoopMod = Yes" in the VT.CFG.               ');
    List.Put(StrUsage2Beg+14           ,'    /nofl        equals to "ForceLoopMod = No"  in the VT.CFG.               ');
    List.Put(StrUsage2Beg+15           ,'    /loop        equals to "LoopMod = Yes" in the VT.CFG.                    ');
    List.Put(StrUsage2Beg+16           ,'    /nolp        equals to "LoopMod = No"  in the VT.CFG.                    ');
    List.Put(StrUsage2Beg+17           ,'    /off:<pos.>  offset where the song begins inside the file.               ');
    List.Put(StrUsage2Beg+18           ,'    /port:<n>    I/O port of the sound card.                                 ');
    List.Put(StrUsage2Beg+19           ,'    /irq:<n>     IRQ of the sound card.                                      ');
    List.Put(StrUsage2Beg+20           ,'    /frst:<file> this is the first song that will be played.                 ');
    List.Put(StrUsage2Beg+21           ,#0);
    
    List.Put(StrUsage3Beg              ,'  <device> can be:                                                           ');
    List.Put(StrUsage3Beg+ 1           ,'                                                                             ');
    List.Put(StrUsage3Beg+ 2           ,'      Only GUS is supported in this version of VT. Sorry.                    ');
    List.Put(StrUsage3Beg+ 3           ,'                                                                             ');
    List.Put(StrUsage3Beg+ 4           ,#0);

    List.Put(StrUsage4Beg              ,'  Examples: The command line interpreter is too flexible to explain every    ');
    List.Put(StrUsage4Beg+ 1           ,'            little aspect of it, so to have an idea, just look below, and    ');
    List.Put(StrUsage4Beg+ 2           ,'            examine the example .VTO files.                                  ');
    List.Put(StrUsage4Beg+ 3           ,'');
    List.Put(StrUsage4Beg+ 4           ,'    This plays the song "Axel F." through the GUS at 240/11 with a volume of ');
    List.Put(StrUsage4Beg+ 5           ,'    64:                                                                      ');
    List.Put(StrUsage4Beg+ 6           ,'');
    List.Put(StrUsage4Beg+ 7           ,'        VT /v:64 D:\MODS\AXEL_F.MOD /port $240 /IRQ:11                       ');
    List.Put(StrUsage4Beg+ 8           ,'');
    List.Put(StrUsage4Beg+ 9           ,'    This plays the music of the Unreal demo, by Future Crew, as given in the ');
    List.Put(StrUsage4Beg+10           ,'    example .VTO file. Shells to the ASCII editor, editing the VT.PAS file:  ');
    List.Put(StrUsage4Beg+11           ,'');
    List.Put(StrUsage4Beg+12           ,'        VT @UNREAL.VTO /sh:C:\BIN\Q.EXE VT.PAS                               ');
    List.Put(StrUsage4Beg+13           ,'');
    List.Put(StrUsage4Beg+14           ,'    This plays the songs 1 and 2 (whichever format they are):                ');
    List.Put(StrUsage4Beg+15           ,'');
    List.Put(StrUsage4Beg+16           ,'        VT 1 2                                                               ');
    List.Put(StrUsage4Beg+17           ,'');
    List.Put(StrUsage4Beg+18           ,'    This plays the song 1 at 64 of volume and the song 2 at 128:             ');
    List.Put(StrUsage4Beg+19           ,'');
    List.Put(StrUsage4Beg+20           ,'        VT 1 /v:64 / /v 128 2                                                ');
    List.Put(StrUsage4Beg+21           ,'');
    List.Put(StrUsage4Beg+22           ,#0);

    List.Put(StrInitializing           ,'    Initializing... ');

  END;




END.
