/* ex1.c - example #1 */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <malloc.h>
#include <io.h>
#include <fcntl.h>
#include <i86.h>
#include "modplay.h"


/* ASM externals prototypes */

#pragma aux setgraphmode "_*" parm caller [];
#pragma aux settextmode "_*" parm caller [];
#pragma aux drawscopes "_*" parm caller [ecx];
#pragma aux putlbm "_*" parm caller [esi];

extern void setgraphmode(void);
extern void setrtextmode(void);
extern void drawscopes(int numvoices);
extern void putlbm(void *image);

/* load IFF/ILBM file */

void *loadlbm(char *path)
{
    int handle;
    void *buffer;
    int length;
    if ((handle = open(path,O_RDONLY|O_BINARY)) == -1)
        return NULL;
    length = lseek(handle,0L,SEEK_END);
    lseek(handle,0L,SEEK_SET);
    if ((buffer = malloc(length)) != NULL) {
        if (read(handle,buffer,length) != length) {
            free(buffer);
            buffer = NULL;
        }
    }
    close(handle);
    return buffer;
}

void main(void)
{
    Module *Song;
    void *Logo;
    word Port;
    byte IRQ,DRQ;

    if (MODDetectCard(&Port,&IRQ,&DRQ)) {
        printf("Sound Blaster not found.\n");
        return;
    }
    printf("Sound Blaster found at Addr:%03x IRQ:%d DMA:%d\n",Port,IRQ,DRQ);
    if ((Song = MODLoadModule("TUNE.MOD")) == NULL) {
        printf("Error loading modulefile.\n");
        return;
    }
    if (MODPlayModule(Song,Song->NumTracks,22222,Port,IRQ,DRQ,PM_TIMER)) {
        printf("Error initializing the sound system.\n");
        MODFreeModule(Song);
        return;
    }
    MODSetMusicVolume(176);
    if ((Logo = loadlbm("LOGO.LBM")) == NULL) {
        printf("Error loading the IFF/ILBM logo picture\n");
        MODStopModule();
        MODFreeModule(Song);
        return;
    }
    setgraphmode();
    putlbm(Logo);
    while (!kbhit())
        drawscopes(Song->NumTracks);
    settextmode();
    free(Logo);
    MODStopModule();
    MODFreeModule(Song);
}

