{
  Copyright (c) 1998 Erland Van Olmen (erlandvo@hotmail.com)
  Protected Mode Ready
}
Unit Shitty1;

interface

Procedure GiveDeviceInfo;

{}
{}

implementation


Uses
  Dos,       { for register stuff }
  Crt,       { some output        }
  Shitty2,   { extra output stuff }
  MODType1,  { some info          }
  GUS_DRV1,  { GUS Driver         }
  SB_DRV1;   { SB  driver         }

CONST
  StandardCursor  = $1E1F;
  NoCursor        = $201F;

{}
{}

Procedure SetCursor(Cursor: Word);
VAR
  R: REGISTERS;
BEGIN
  R.ah:=1; R.cx:=Cursor; Intr($10, R);
END;

{}

Procedure GiveDeviceInfo;
Const
     MaxX   = 80;
     MaxY   = 25;
     Width  = 65;
     Height = 17;
     BGC    = RED;
VAR
   Menu: MenuType;
   DetailedOptions: Boolean;

{}

Procedure SoundCard_Menu;
VAR
  I: Byte;
BEGIN
  TextMode(CO80); TextBackGround(BGC); ClrScr; SetCursor(NoCursor);
  InitMenu(Menu);
  Menu.X1:=(MaxX-Width ) shr 1;
  Menu.Y1:=(MaxY-Height) shr 1;
  Menu.X2:=(MaxX+Width ) shr 1;
  Menu.Y2:=(MaxY+Height) shr 1-1;

  With Menu do
  Begin
    Case PLAYDevice.ID of
      MODType1.GUSDevice  : DefaultT:=0;
      MODType1.SB100Device: DefaultT:=1;
      MODType1.SB200Device: DefaultT:=2;
      MODType1.SB201Device: DefaultT:=3;
      MODType1.SBPRODevice: DefaultT:=4;
      MODType1.SB16Device : DefaultT:=1;
    End;

    BarPos:=DefaultT;
    Title:='Select Sound Card';
    Topics[0]:='GRAVIS UltraSound (GF1 Synth)';           TAvail[0]:=True;
    Topics[1]:='SoundBlaster 1.xx or clone (DSP v1.xx )'; TAvail[1]:=True;
    Topics[2]:='SoundBlaster 1.5           (DSP v2.00 )'; TAvail[2]:=True;
    Topics[3]:='SoundBlaster 2.0           (DSP v2.01+)'; TAvail[3]:=True;
    Topics[4]:='SoundBlaster PRO           (DSP v3.xx )'; TAvail[4]:=True;
{    Topics[5]:='SoundBlaster 16            (DSP v4.xx )'; TAvail[5]:=True;}
{    Topics[6]:='SoundBlaster AWE 32 +      (DSP v?.?? )'; TAvail[6]:=True;}
  End;

  DrawNiceBox(Menu, BGC); DrawMenu(Menu);
  TextBackGround(BGC); TextColor(White); Gotoxy(1, 2);
  Writeln('              MPxx v1.0 ModPlayer, (c) 1997 by ByteRaver/TNT.');
  Writeln('                              SoundCard Setup:');
  Gotoxy(12, MaxY-2);
  Writeln('Use arrows to select, Enter to confirm or Esc to cancel');
END;

{}

Procedure BasePort_Menu;
VAR
  I: Byte;
BEGIN
  InitMenu(Menu);
  With Menu do
  Begin
    If PlayDevice.ID=NoDevice then DefaultT:=1
    Else DefaultT:=((PlayDevice.MPort-$200) shr 4)-1;
    BarPos:=DefaultT;
    Title:='Select Sound Card I/O Port Address';
    Topics[0]:='210h'; TAvail[0]:=True;
    Topics[1]:='220h'; TAvail[1]:=True;
    Topics[2]:='230h'; TAvail[2]:=True;
    Topics[3]:='240h'; TAvail[3]:=True;
    Topics[4]:='250h'; TAvail[4]:=True;
    Topics[5]:='260h'; TAvail[5]:=True;
    Topics[6]:='270h'; TAvail[6]:=True;
    Topics[7]:='280h'; TAvail[7]:=True;
  End;
  DrawMenu(Menu);
END;

{}

Procedure IRQ_Menu;
VAR
  I, IRQ: Byte;
BEGIN
  InitMenu(Menu);

  Case PLAYDevice.ID of
    MODType1.SB100Device,
    MODType1.SB200Device,
    MODType1.SB201Device,
    MODType1.SBPRODevice,
    MODType1.SB16Device : IRQ:=SB_DRV1.SBDevice.MIRQ;
    MODType1.GUSDevice  : IRQ:=GUS_DRV1.GUSDevice.MIRQ;
   Else; IRQ:=5;
  End;

  With Menu do
  Begin
    Case IRQ of
      2 : DefaultT:=0;
      3 : DefaultT:=1;
      4 : DefaultT:=2;
      5 : DefaultT:=3;
      7 : DefaultT:=4;
      9 : DefaultT:=5;
      10: DefaultT:=6;
      11: DefaultT:=7;
      12: DefaultT:=8;
      15: DefaultT:=9;
    End;
    BarPos:=DefaultT;
    Title:='Select Sound Card IRQ Number';
    Topics[0]:='IRQ  2'; TAvail[0]:=True;
    Topics[1]:='IRQ  3'; TAvail[1]:=True;
    Topics[2]:='IRQ  4'; TAvail[2]:=True;
    Topics[3]:='IRQ  5'; TAvail[3]:=True;
    Topics[4]:='IRQ  7'; TAvail[4]:=True;
{Temp. disabled: }
    Topics[5]:='IRQ  9';
    Topics[6]:='IRQ 10';
    Topics[7]:='IRQ 11';
    Topics[8]:='IRQ 12';
    Topics[9]:='IRQ 15';
  End;
  DrawMenu(Menu);
END;

{}

Procedure DMA_Menu;
VAR
  I: Byte;
BEGIN
  InitMenu(Menu);
  With Menu do
  Begin
    Case PLAYDevice.ID of
      MODType1.SB100Device,
      MODType1.SB200Device,
      MODType1.SB201Device,
      MODType1.SBPRODevice,
      MODType1.SB16Device : DefaultT:=SB_DRV1.SBDevice.MDMA;
      MODType1.GUSDevice  : DefaultT:=GUS_DRV1.GUSDevice.MDMA;
     Else; DefaultT:=1;
    End;
    BarPos:=DefaultT;
    Title:='Select Sound Card DMA Channel Number';
    Topics[0]:='0 ( 8-bit)'; TAvail[0]:=True;
    Topics[1]:='1 ( 8-bit)'; TAvail[1]:=True;
    Topics[2]:='2 ( 8-bit)'; TAvail[2]:=True;
    Topics[3]:='3 ( 8-bit)'; TAvail[3]:=True;
{Temp. disabled: }
    Topics[4]:='4 (16-bit)';
    Topics[5]:='5 (16-bit)';
    Topics[6]:='6 (16-bit)';
    Topics[7]:='7 (16-bit)';
{ // 16-bit DMA not supported yet!
    If PLAYDevice.ID >= SB16Device then For I:=4 to 7 do TAvail[I]:=True;
}
  End;
  DrawMenu(Menu);
END;

{}

Procedure MixRate_Menu;
VAR
  I: Byte;
BEGIN
  InitMenu(Menu);
  With Menu do
  Begin
    If MixRate>43000 then DefaultT:=9 Else
    If MixRate>39000 then DefaultT:=8 Else
    If MixRate>35000 then DefaultT:=7 Else
    If MixRate>31000 then DefaultT:=6 Else
    If MixRate>27000 then DefaultT:=5 Else
    If MixRate>23000 then DefaultT:=4 Else
    If MixRate>21000 then DefaultT:=3 Else
    If MixRate>17000 then DefaultT:=2 Else
    If MixRate>13000 then DefaultT:=1 Else DefaultT:=0;
    If (PLAYDevice.ID <= MODType1.SB200Device) AND (MixRate>22050) then DefaultT:=3;

    BarPos:=DefaultT;
    Title:='Select Mixing Rate';
    Topics[0]:='10000Hz'; TAvail[0]:=True;
    Topics[1]:='14000Hz'; TAvail[1]:=True;
    Topics[2]:='18000Hz'; TAvail[2]:=True;
    Topics[3]:='22000Hz'; TAvail[3]:=True;
    Topics[4]:='24000Hz';
    Topics[5]:='28000Hz';
    Topics[6]:='32000Hz';
    Topics[7]:='36000Hz';
    Topics[8]:='40000Hz';
    Topics[9]:='44000Hz';
    If (PLAYDevice.ID > MODType1.SB200Device) then For I:=4 to 9 do TAvail[I]:=True;
  End;
  DrawMenu(Menu);
END;

{}

Procedure DetailedOptions_Menu;
VAR
  I: Byte;
BEGIN
  InitMenu(Menu);
  With Menu do
  Begin
    DefaultT:=1; {temporary}
    BarPos:=DefaultT;
    Title:='Detailed Options?';
    Topics[0]:='Go playing the music right now'; TAvail[0]:=True;
    Topics[1]:='Go on for detailed options'; TAvail[1]:=True;
  End;
  DrawMenu(Menu);
END;

{}

Procedure Volume_Menu;
VAR
  I: Byte;
BEGIN
  InitMenu(Menu);
  With Menu do
  Begin
    DefaultT:=4; {temporary}
    BarPos:=DefaultT;
    Title:='Select Output Volume';
    Topics[0]:=' 20%'; TAvail[0]:=True;
    Topics[1]:=' 40%'; TAvail[1]:=True;
    Topics[2]:=' 60%'; TAvail[2]:=True;
    Topics[3]:=' 80%'; TAvail[3]:=True;
    Topics[4]:='100%'; TAvail[4]:=True;
    Topics[5]:='120% (amplify)';
    Topics[6]:='140%';
    Topics[7]:='160% (amplify, SB Volume Boost)';
    If (PLAYDevice.ID=MODType1.SB100Device) or (PLAYDevice.ID=MODType1.SB200Device) or
       (PLAYDevice.ID=MODType1.SB201Device) or (PLAYDevice.ID=MODType1.SBPRODevice) or
       (PLAYDevice.ID=MODType1.SB16Device)  then TAvail[7]:=True;
  End;
  DrawMenu(Menu);
END;

{}

Procedure SBModeMenu_Menu;
VAR
  I: Byte;
BEGIN
  InitMenu(Menu);
  With Menu do
  Begin
    Case PlayDevice.ID of
      MODType1.GUSDevice  : DefaultT:=5;
      MODType1.SB100Device,
      MODType1.SB200Device,
      MODType1.SB201Device: If Filter=SBPROHW then DefaultT:=2 Else DefaultT:=0;
      MODType1.SBPRODevice: If MixRate<22050 then
                     If Filter=SBPROHW then DefaultT:=5 Else DefaultT:=4
                   Else
                     If Filter=SBPROHW then DefaultT:=1 Else DefaultT:=0;
{      MODType1.SB16Device : DefaultT:=5;} { // Not available yet! }
      Else; DefaultT:=0;
    End;

    BarPos:=DefaultT;
    Title:='Select SB Output Type';
    Topics[0]:=' 8-bit Mono   , low  filter';          TAvail[0]:=True;
    Topics[1]:=' 8-bit Mono   , high filter';          TAvail[1]:=True;
    Topics[2]:=' 8-bit Mono   , Linear Interpolation'; TAvail[2]:=True;
    Topics[3]:='16-bit Mono   (dynamic filter)';
    Topics[4]:=' 8-bit Stereo , low  filter';          TAvail[4]:=True;
    Topics[5]:=' 8-bit Stereo , high filter';          TAvail[5]:=True;
    Topics[6]:=' 8-bit Stereo , Linear Interpolation'; TAvail[6]:=True;
    Topics[7]:='16-bit Stereo (dynamic filter)';
{
    Case PLAYDevice.ID of
      MODType1.GUSDevice  : Begin TAvail[5]:=True; TAvail[0]:=False; TAvail[2]:=False; End;
      MODType1.SBPRODevice: Begin TAvail[0]:=True; TAvail[1]:=True;  TAvail[3]:=True;  End;
; No native sb 16 support!
      MODType1.SB16Device : Begin TAvail[4]:=True; TAvail[5]:=True; End;

    End;
}
  End;
  DrawMenu(Menu);
END;

{}
{}

VAR
  Answer: Char;
  I, I2: Word;
  Choice: Byte;

  Port, IRQ, DMA: Word;
Label ExitOK;

BEGIN
  SoundCard_Menu; Choice:=GetChoice(Menu);
  Case Choice of
    0: Begin PlayDevice:=GUS_DRV1.GUSDevice; PLAYDevice.ID:=MODType1.GUSDevice;   End;
    1: Begin PlayDevice:=SB_DRV1.SBDevice;  PLAYDevice.ID:=MODType1.SB100Device; End;
    2: Begin PlayDevice:=SB_DRV1.SBDevice;  PLAYDevice.ID:=MODType1.SB200Device; End;
    3: Begin PlayDevice:=SB_DRV1.SBDevice;  PLAYDevice.ID:=MODType1.SB201Device; End;
    4: Begin PlayDevice:=SB_DRV1.SBDevice;  PLAYDevice.ID:=MODType1.SBPRODevice; End;
    5: Begin PlayDevice:=SB_DRV1.SBDevice;  PLAYDevice.ID:=MODType1.SB16Device;  End;
    else; begin PLAYDevice.ID:=NODevice; exit; end;
  end;

  BasePort_Menu; Choice:=GetChoice(Menu);
  If Choice<>NoTopic then Port:=$200+(Choice+1)*$10
  else begin PLAYDevice.ID:=NODevice; exit; end;

  If (PLAYDevice.ID=MODType1.SB100Device) or (PLAYDevice.ID=MODType1.SB200Device) or
     (PLAYDevice.ID=MODType1.SB201Device) or (PLAYDevice.ID=MODType1.SBPRODevice) or
     (PLAYDevice.ID=MODType1.SB16Device) then
  Begin
    IRQ_Menu; Choice:=GetChoice(Menu);
    Case Choice of
      0: IRQ:=2 ;
      1: IRQ:=3 ;
      2: IRQ:=4 ;
      3: IRQ:=5 ;
      4: IRQ:=7 ;
      5: IRQ:=9 ;
      6: IRQ:=10;
      7: IRQ:=11;
      8: IRQ:=12;
      9: IRQ:=15;
      else; begin PLAYDevice.ID:=NODevice; exit; end;
    End;

    DMA_Menu; Choice:=GetChoice(Menu);
    If Choice=NoTopic then begin PLAYDevice.ID:=NODevice; exit; end
    Else DMA:=Choice;

    MixRate_Menu; Choice:=GetChoice(Menu);
    Case Choice of
      0: MixRate:=10000;
      1: MixRate:=13889;
      2: MixRate:=17857;
      3: MixRate:=21739;
      4: MixRate:=23810;
      5: MixRate:=27778;
      6: MixRate:=32258;
      7: MixRate:=35714;
      8: MixRate:=40000;
      9: MixRate:=45454;
      else; begin PLAYDevice.ID:=MODType1.NODevice; exit; end;
    End;
  End;

  DetailedOptions_Menu; Choice:=GetChoice(Menu);
  If Choice <> NoTopic then DetailedOptions:=Boolean(Choice)
  Else DetailedOptions:=False;
  If NOT DetailedOptions then goto ExitOK;

  Volume_Menu; Choice:=GetChoice(Menu);
  If Choice=NoTopic then begin PLAYDevice.ID:=NODevice; exit; end;
  If Choice<=4 then GlobalVolume:=(Choice+1)*20 - 1;
  If Choice =7 then Begin SBVolumeBoost:=True; GlobalVolume:=99; End;

  If (PLAYDevice.ID=SB100Device) or (PLAYDevice.ID=SB200Device) or
     (PLAYDevice.ID=SB201Device) or (PLAYDevice.ID=SBPRODevice) or
     (PLAYDevice.ID=SB16Device) then
  Begin
    SBModeMenu_Menu; Choice:=GetChoice(Menu);
    If Choice=NoTopic then begin PLAYDevice.ID:=NODevice; exit; end;

    Case Choice of
      0: Begin Filter:=NoFilter;      StereoReplay:=False; End;
      1: Begin Filter:=SBPROHW;       StereoReplay:=False; End;
      2: Begin Filter:=Interpolative; StereoReplay:=False; End;
      4: Begin
           Filter:=NoFilter;          StereoReplay:=True;
           If (PLAYDevice.ID=SBPRODevice) AND (MixRate>22050) then MixRate:=22050;
         End;
      5: Begin
           Filter:=SBPROHW;           StereoReplay:=True;
           If (PLAYDevice.ID=SBPRODevice) AND (MixRate>22050) then MixRate:=22050;
         End;
      6: Begin
           Filter:=Interpolative;     StereoReplay:=True;
           If (PLAYDevice.ID=SBPRODevice) AND (MixRate>22050) then MixRate:=22050;
         End;
    End;
  End;

ExitOK:
  Case PlayDevice.ID of
    MODType1.GUSDevice  : With GUS_DRV1.GUSDevice do Begin MPort:=Port; MIRQ:=IRQ; MDMA:=DMA; End;
    MODType1.SB100Device,
    MODType1.SB200Device,
    MODType1.SB201Device,
    MODType1.SBPRODevice,
    MODType1.SB16Device : With SB_DRV1.SBDevice  do Begin MPort:=Port; MIRQ:=IRQ; MDMA:=DMA; End;
  End;

  TextColor(LightGray); TextBackGround(Black); Gotoxy(0, 0);
  ClrScr; SetCursor(StandardCursor);
END;

{}

END.