{
  Copyright (c) 1998 Erland Van Olmen (erlandvo@hotmail.com)
  NOT Protected Mode Ready
}

Unit HardWare;

interface

Const
{IRQ Bitfield constants (for the PIC = Interrupt controller): ---------------}
  Master_PIC = $20;       { Base Address of Master-PIC                       }
  Slave_PIC  = $A0;       { Base Address of slave-PIC                        }
  IRQ_Mask   = $01;       { Offset to Mask Port                              }

{IRQ program vectors from device-interrupts: --------------------------------}
  Master_FIRST_Vector = $08;
  Slave_FIRST_Vector  = $70;


{}

{$IFNDEF DPMI}
Function  GetDMABuffer(var DMABuffer: Pointer; Size: WORD): Boolean;
{$ENDIF}
Procedure irq_Enable  (iIRQ : Word);
Procedure irq_Disable (iIRQ : Word);
Procedure TimerSpeedup(Speed: Word);

{}

implementation

{}
{Returns true if everything went OK.}
{$IFNDEF DPMI}
Function  GetDMABuffer(var DMABuffer: Pointer; Size: WORD): Boolean;
VAR
  Page          : Byte;
  PageOffset,
  MemHoleSize   : Word;
  HeapMemory,
  RealAddress   : LongInt;
  MemHole       : Pointer;
BEGIN
  GetDMABuffer:=False; MemHole:=Nil; MemHoleSize:=0;
  HeapMemory:=MaxAvail; If HeapMemory<Size then exit; { check free mem size }
  RealAddress:=LongInt(Seg(HeapPtr^)) shl 4 + Ofs(HeapPtr^);
  Page       :=RealAddress shr 16;
  PageOffset :=RealAddress AND $FFFF;
  If ($FFFF-PageOffset)<Size Then
    Begin
      MemHoleSize:=$FFFF-PageOffset;
      GetMem(MemHole, MemHoleSize);
      HeapMemory:=MaxAvail;                           { check free mem size }
      If HeapMemory<Size then
        Begin FreeMem(MemHole, MemHoleSize); exit; End;
    End;
  GetMem(DMABuffer, Size);
  If MemHoleSize>0 then FreeMem(MemHole, MemHoleSize);
  GetDMABuffer:=True;
END;
{$ENDIF}

{}

Procedure irq_Enable(iIRQ: Word);
VAR
  iPort: Word;
BEGIN
  if iIRQ <= 7 then iPort:=MASTER_PIC Else iPort:=SLAVE_PIC;
  Inc(iPort, IRQ_MASK);             { Choose Mask port                       }
  iIRQ:=iIRQ AND $0007;             { define PIC-interrupt number (0-7)      }
  Port[iPort]:=(Port[iPort] AND ((Word(1) SHL iIRQ) XOR $FFFF));
END;

{}

Procedure irq_Disable(iIRQ: Word);
VAR
  iPort: Word;
BEGIN
  if iIRQ <= 7 then iPort:=MASTER_PIC Else iPort:=SLAVE_PIC;
  Inc(iPort, IRQ_MASK);             { Choose Mask port                       }
  iIRQ:=iIRQ AND $0007;             { define PIC-interrupt number (0-7)      }
  Port[iPort]:=Port[iPort] OR (Word(1) SHL iIRQ);
END;

{}

Procedure TimerSpeedup(Speed: Word);
Begin
  Port[$43]:=$36;
  Port[$40]:=Speed AND $FF;
  Port[$40]:=Speed SHR 8;
{
  mov    al, 036h
  out    043h, al
  mov    ax, [Speed]
  out    040h, al
  mov    al, ah
  out    040h, al
}
End;

{}

END.