;Ŀ
; Little example source of how to use SATplayer, written by Lone Ranger/AcmE 
;

P286                                    ; Uses 286 instructions
jumps                                   ; Let TASM handle out-of-range jumps

Extrn   SAT_Time:Word
Extrn   SAT_Player:Far
Extrn   SAT_Equalizer:byte
Extrn   SAT_ChannelEqu:Byte
Extrn   SAT_SongPos:byte
Extrn   SAT_PatternPos:Word

Extrn   SAT_PjumpFlag:byte
Extrn   SAT_PjumpPos:byte
Extrn   SAT_PbreakPos:Byte

Extrn   SAT_Instrument
Extrn   SAT_Note
Extrn   SAT_Volume
Extrn   SAT_Effect

_Code   segment para public 'Code'
assume  cs:_Code, ds:_Code, es:_Code, ss:_Stack

; Messages 

NoCommLineMessage:                      ; message if no command line
        db      'SATplay v1.0, written by Lone Ranger/AcmE',13,10
        db      13,10
        db      'Usage:   SATplay <filename>',13,10
        db      13,10
        db      'Keys while playing:',13,10
        db      13,10
        db      '  Cursor Left - Previous Pattern',13,10
        db      ' Cursor Right - Next Pattern',13,10
        db      '          <D> - DOS shell',13,10
        db      '        <ESC> - Exit',13,10,'$'

FileErrorMessage:                       ; message if a file error occurd
        db      'File does not exist!',13,10,'$'

MemoryErrorMessage:                     ; message if there's not enough mem
        db      'Not enough memory to load SAT file!',13,10,'$'

NoSATfileMessage:                       ; message if file is no SAT file
        db      'This is not a SAT file!',13,10,'$'

NoFMchipMessage:                        ; message if no FM chip has been found
        db      'No FM chip found!', 13, 10, '$'

Shell_Msg:                              ; message if in DosShell
        db      'Type EXIT to return to SATplay',13,10,'$'

; data 

Notes:
db '   '
db 'C-1','C#1','D-1','D#1','E-1','F-1','F#1','G-1','G#1','A-1','A#1','B-1'
db 'C-2','C#2','D-2','D#2','E-2','F-2','F#2','G-2','G#2','A-2','A#2','B-2'
db 'C-3','C#3','D-3','D#3','E-3','F-3','F#3','G-3','G#3','A-3','A#3','B-3'

Effects:
db      '             '                ; no effect, normal play
db      'ARPEGGIO     '                ; arpeggio
db      'SLIDE UP     '                ; slide up
db      'SLIDE DOWN   '                ; Slide down
db      'PORTA TO TONE'                ; Tone portamento
db      '             '                ; *** NOT SUPPORTED ***
db      'VOLUME SLIDE '                ; Volume slide
db      'VOLUME SLIDE '                ; Volume slide
db      '             '                ; *** NOT SUPPORTED ***
db      'RELEASE NOTE '                ; Release sustaining note
db      '             '                ; *** NOT SUPPORTED ***
db      'VOLUME SLIDE '                ; volume slide
db      'POSITION JUMP'                ; position jump
db      '             '                ; set volume
db      'PATTERN BREAK'                ; pattern break
db      '             '                ; *** NOT SUPPORTED ***
db      '             '                ; set speed

ChannelColor    db      122,122,122,122,122,122,122,122,122,122,122,122
                db      122,122,122,122,122,122,122,122,122,122,122,122
                db      126,126,126,126,126,126,126,126,124,124,124,124
EquColor        db      122,122,122,122,122,122,122,122,122,122,126,126
                db      126,126,124,124

PSPseg          dw      0               ; seg of pps
DTA             db      50 dup (?)      ; Disk Transfer Area
MusicSeg        dw      0               ; segment of music file
Shell_FCB1      db      26h dup (0)     ; 1st FCB for DosShell
Shell_FCB2      db      26h dup (0)     ; 2nd FCB for DosShell
Shell_ExeParm   db      16h dup (0)     ; ExeParmBlock for DosShell
Shell_CmdTail   db      80h dup (0)     ; Command tail for DosShell
Shell_FileName  db      'C:\COMMAND.COM',0

; Start of program 

ProgStart:

        mov     cs:[PspSeg], es
        mov     ax, es
        mov     bx, seg _EndSeg
        sub     bx, ax
        inc     bx                      ;Safety margin
        inc     bx
        mov     ah, 4ah                 ;Memory block resize
        int     21h

        cmp     byte ptr es:[80h], 0    ; is there a commandline?
        je      No_CommandLine          ; nope
        mov     di, 82h
        mov     al, 0dh
        mov     cx, 120
        repne   scasb                   ; scan for 'enter'
        dec     di
        xor     al, al
        stosb                           ; put a 0 there

; Get fileSize, allocate memory and load file 

        mov     ax, cs
        mov     ds, ax
        mov     dx, offset DTA
        mov     ah, 1ah
        int     21h                     ; set DTA

        mov     ax, es
        mov     ds, ax
        mov     dx, 82h
        mov     ax, 4E00h
        xor     cx, cx
        int     21h                     ; Find First File
        jc      FileError

        mov     bx, word ptr cs:[offset DTA+1ah]
        mov     dx, word ptr cs:[offset DTA+1ch]
        shr     bx, 4
        shl     dx, 12
        or      bx, dx                  ; get filesize in segments
        inc     bx
        inc     bx

        mov     ah, 48h
        int     21h                     ; allocate memory
        jc      MemoryError
        mov     cs:[MusicSeg], ax

        mov     dx, 82h
        mov     ah, 3dh
        mov     al, 0
        xor     cl, cl
        int     21h                     ; open file
        jc      FileError

        mov     bx, ax                  ; set BX to file handle
        mov     ds, cs:[MusicSeg]
LoadFileLoop:
        xor     dx, dx
        mov     cx, 64000
        mov     ah, 3fh
        int     21h                     ; load 64000 bytes of file
        cmp     ax, 64000
        jb      LoadFileDone
        mov     ax, ds
        add     ax, 64000/16
        mov     ds, ax
        jmp     LoadFileLoop
LoadFileDone:
        mov     ah, 3eh                 ; close file
        int     21h

; Check for SAT file 

        mov     ax, cs:[MusicSeg]
        mov     ds, ax

        cmp     word ptr ds:[0] ,'AS'   ; check for 'SAdT'
        jne     No_SATfile
        cmp     word ptr ds:[2], 'Td'
        jne     No_SATfile

; Setup screen 

        mov     ax, 0003h               ; set 80x25 textmode
        int     10h
        mov     ax, 1003h               ; enable background intensity
        xor     bl, bl
        int     10h

        mov     ax, 1102h               ; set 80x50 textmode
        xor     bl, bl
        int     10h

        mov     dx, 3d4h
        mov     al, 9
        out     dx, al
        inc     dx
        in      al, dx
        and     al, 0e0h
        add     al, 7
        out     dx, al

        mov     ah, 1
        mov     ch, 32
        xor     cl, cl
        int     10h                     ; delete cursor

        mov     ax, cs
        mov     ds, ax
        mov     ax, 0B800h
        mov     es, ax
        mov     si, offset SATPLAY_Screen
        xor     di, di
        mov     cx, 4000
        rep     movsw                   ; copy screen

; Draw FileName 

        mov     ax, cs
        mov     ds, ax
        mov     si, offset DTA+1eh      ; offset of filename+extension
        mov     ax, 0b800h
        mov     es, ax
        mov     di, 2*160+42*2
        mov     cx, 13
Copy_SongName:
        lodsb
        stosb
        inc     di
        loop    Copy_SongName

        mov     ax, cs:[MusicSeg]
        mov     es, ax
        mov     di, 2*160+2*13
        mov     dl, byte ptr es:[44Bh]  ; get songlen
        dec     dl
        Call    WriteDEC                ; write Songlen

        mov     ax, cs:[MusicSeg]
        mov     ds, ax
        mov     ax, 0b800h
        mov     es, ax
        mov     si, 347                 ; offset of instrument names
        mov     di, 16*160+3*2
        mov     cx, 29
Loop_Instr1:
        push    cx
        mov     cx, 16
Write_Instr1:
        lodsb
        stosb
        inc     di
        loop    Write_Instr1
        inc     si
        add     di, (80-16)*2           ; next line
        cmp     di, 32*160+3*2          ; end of column 1?
        jne     No_NextColumn           ; no
        mov     di, 16*160+24*2         ; set to column 2
No_NextColumn:
        pop     cx
        loop    Loop_Instr1


; Start playing 

        mov     bx, 0
        Call    SAT_Player              ; Check for FM chip
        jc      No_FMchip

        mov     bx, 1
        Call    SAT_Player              ; Reset FM chip

        mov     ax, cs:[MusicSeg]
        mov     es, ax
        mov     bx, 2                   ; use TIMER mode
        mov     al, 0
        Call    SAT_Player              ; Init player

        mov     bx, 3
        call    SAT_Player              ; Start playing

BigLoop:

; Draw equalizers 

        mov     ax, seg SAT_ChannelEqu
        mov     ds, ax
        mov     si, offset SAT_ChannelEqu
        mov     ax, 0b800h
        mov     es, ax
        mov     di, 5*160+43*2+1
        mov     cx, 9
chn_loop:
        push    cx
        xor     ah, ah
        lodsb
        push    di ds si
        mov     cx, ax
        push    cx
        jcxz    No_Chn
        mov     ax, cs
        mov     ds, ax
        mov     si, offset ChannelColor
Write_Col:
        lodsb
        stosb
        inc     di
        loop    Write_Col
No_Chn:
        mov     cx, 36
        pop     ax
        sub     cx, ax
        jcxz    No_ChnClear
        mov     al, 7*16+8
Del_Col:
        stosb
        inc     di
        loop    Del_Col
No_ChnClear:
        pop     si ds di cx
        add     di, 80*2
        loop    chn_loop

        mov     ax, seg SAT_Equalizer
        mov     ds, ax
        mov     si, offset SAT_Equalizer
        mov     ax, 0b800h
        mov     es, ax
        mov     di, 31*160+43*2+1
        mov     cx, 36
equ_loop:
        push    cx
        xor     ah, ah
        lodsb
        push    di ds si
        shr     ax, 1
        mov     cx, ax
        push    cx
        jcxz    No_equ
        mov     ax, cs
        mov     ds, ax
        mov     si, offset equColor
Write_equCol:
        lodsb
        stosb
        sub     di, 161
        loop    Write_equCol
No_equ:
        mov     cx, 16
        pop     ax
        sub     cx, ax
        jcxz    No_equClear
        mov     al, 7*16+8
Del_equCol:
        stosb
        sub     di, 161
        loop    Del_equCol
No_equClear:
        pop     si ds di cx
        add     di, 2
        loop    equ_loop

        mov     ax, cs
        mov     ds, ax

; Draw SongPosition 

        mov     di, 2*160+2*10
        mov     ax, seg SAT_SongPos
        mov     es, ax
        mov     dl, es:[offset SAT_SongPos]
        Call    WriteDEC

; Draw current Row 

        mov     di, 2*160+2*21
        mov     ax, seg SAT_PatternPos
        mov     es, ax
        mov     ax, es:[offset SAT_PatternPos]
        mov     cl, 9*5
        div     cl
        mov     dl, al
        Call    WriteHEX

; Draw time 

        mov     ax, seg SAT_Time
        mov     ds, ax
        mov     ax, cs:[MusicSeg]
        mov     es, ax
        mov     ax, [SAT_Time]
        div     byte ptr es:[44dh]
        xor     ah, ah
        mov     di, 2*160+2*30
        mov     cl, 60
        div     cl
        push    ax
        mov     dl, al
        call    WriteDEC
        mov     ax, 0b800h
        mov     es, ax
        pop     ax
        mov     dl, ah
        mov     di, 2*160+33*2
        call    WriteDEC

; Draw instrument 

        mov     ax, seg SAT_Instrument
        mov     ds, ax
        mov     ax, 0B800h
        mov     es, ax
        mov     si, offset SAT_Instrument
        mov     di, 5*160+1*2
        mov     cx, 9
Instr_Loop:
        push    cx di
        xor     ah, ah
        lodsb
        or      al, al
        jz      No_Instr
        dec     al
        push    si
        mov     si, ax
        shl     si, 4
        add     si, ax
        add     si, 347
        push    ds
        mov     ax, cs:[MusicSeg]
        mov     ds, ax
        mov     cx, 16
Write_Instr:
        lodsb
        stosb
        inc     di
        loop    Write_Instr
        pop     ds si
; Draw volume 
        pop     ax cx
        push    cx ax
        add     di, 7*2
        mov     bx, offset SAT_Volume+9
        sub     bx, cx
        mov     dl, 63
        sub     dl, [bx]
        Call    WriteDEC

No_Instr:
        pop     di cx
        add     di, 160
        loop    Instr_Loop

; Draw Note 

        mov     ax, seg SAT_Note
        mov     ds, ax
        mov     si, offset SAT_Note
        mov     ax, 0b800h
        mov     es, ax
        mov     di, 5*160+2*19
        mov     cx, 9
Note_Loop:
        push    cx
        xor     ah, ah
        lodsb                           ; load note
        push    ds si
        mov     si, ax
        shl     si, 1
        add     si, ax
        add     si, offset Notes
        mov     ax, cs
        mov     ds, ax
        mov     cx, 3
Write_Note:
        lodsb
        stosb
        inc     di
        loop    Write_Note
        pop     si ds cx
        add     di, (80-3)*2
        loop    Note_Loop

; Draw effect 

        mov     ax, seg SAT_Effect
        mov     ds, ax
        mov     si, offset SAT_Effect
        mov     ax, 0b800h
        mov     es, ax
        mov     di, 5*160+28*2
        mov     cx, 9
Effect_Loop:
        push    cx di
        xor     ah, ah
        lodsb
        push    si ds
        mov     cl, 13
        mul     cl
        xor     ah, ah
        add     ax, offset Effects
        mov     si, ax
        mov     ax, cs
        mov     ds, ax
        mov     cx, 13
Write_Effect:
        lodsb
        stosb
        inc     di
        loop    Write_Effect
        pop     ds si di cx
        add     di, 160
        loop    Effect_Loop

; Set instrument colors 

        mov     ax, 0b800h
        mov     es, ax
        mov     di, 16*160+3
        mov     cx, 29
        mov     bl, 1                   ; start with instr 1
InstrColLoop:
        push    cx es di
        mov     ax, seg SAT_Instrument
        mov     es, ax
        mov     al, bl
        mov     cx, 9
        mov     di, offset SAT_Instrument
        repne   scasb
        pop     di
        pop     es
        push    di
        mov     al, 16*7+8              ; set color if not played
        jne     not_played
        mov     al, 7
        dec     di
        stosb
        mov     al, 16*7+1
not_played:
        mov     cx, 19
set_col:
        stosb
        inc     di
        loop    set_col
        pop     di cx
        add     di, 160
        cmp     di, 32*160+3
        jne     No_NextColumn1
        mov     di, 16*160+22*2+1
No_NextColumn1:
        inc     bl
        loop    InstrColLoop

; Get key 

        mov     ah, 06h
        mov     dl, 0FFh
        int     21h
        jz      BigLoop                 ; no key pressed

        cmp     al, 27                  ; ESC - exit
        je      Exit_SatPlay
        cmp     al, 'd'                 ; d - dosshell
        je      DosShell
        cmp     al, 'D'                 ; D - dosshell
        je      DosShell
        cmp     al, 0
        jne     BigLoop

        int     21h

        cmp     al, 'K'                 ; cursor left
        je      Do_SongPosBack
        cmp     al, 'M'                 ; cursor right
        je      Do_SongPosFrwd
        jmp     BigLoop

; Previous pattern 

Do_SongPosBack:
        mov     ax, seg SAT_SongPos
        mov     ds, ax
        mov     al, [SAT_SongPos]
        or      al, al
        jz      BigLoop
        dec     al
        mov     [SAT_PjumpPos], al
        mov     [SAT_PbreakPos], 0
        mov     [SAT_PjumpFlag], 1
        jmp     BigLoop

; Next pattern 

Do_SongPosFrwd:
        mov     ax, seg SAT_SongPos
        mov     ds, ax
        mov     ax, cs:[MusicSeg]
        mov     es, ax
        mov     ah, es:[44BH]           ; get songlen
        mov     al, [SAT_SongPos]
        inc     al
        cmp     al, ah
        jb      NoRestart
        xor     al, al
NoRestart:
        mov     [SAT_PjumpPos], al
        mov     [SAT_PbreakPos], 0
        mov     [SAT_PjumpFlag], 1
        jmp     BigLoop

; DosShell 

DosShell:
        pusha

; store current screen 

        mov     ax, 0b800h
        mov     ds, ax
        xor     si, si
        mov     ax, cs
        mov     es, ax
        mov     di, offset TempScreen
        mov     cx, 80*50
        rep     movsw                   ; copy screen

; Setup DosScreen 

        mov     ax, 0003h
        int     10h

        mov     ax, cs
        mov     ds, ax
        mov     dx, offset Shell_Msg
        mov     ah, 9
        int     21h

        mov     ah, 2
        mov     dx, 0200h
        xor     bh, bh
        int     10h
        
; shell to dos 

        mov     ax, cs:[PSPseg]
        mov     ds, ax
        mov     ax, word ptr ds:[2ch]
        mov     word ptr cs:[Shell_ExeParm], ax
        mov     word ptr cs:[Shell_ExeParm+2], offset Shell_CmdTail
        mov     word ptr cs:[Shell_ExeParm+4], cs
        mov     word ptr cs:[Shell_ExeParm+6], offset Shell_FCB1
        mov     word ptr cs:[Shell_ExeParm+8], cs
        mov     word ptr cs:[Shell_ExeParm+6], offset Shell_FCB2
        mov     word ptr cs:[Shell_ExeParm+8], cs
        mov     ax, cs
        mov     ds, ax
        mov     es, ax
        mov     dx, offset Shell_FileName
        mov     bx, offset Shell_ExeParm
        mov     ax, 4B00h               ; shell to dos
        int     21h

; set videomode and restore screen 

        mov     ax, 0003h               ; set 80x25 textmode
        int     10h
        mov     ax, 1003h               ; enable background intensity
        xor     bl, bl
        int     10h

        mov     ax, 1102h               ; set 80x50 textmode
        xor     bl, bl
        int     10h

        mov     dx, 3d4h
        mov     al, 9
        out     dx, al
        inc     dx
        in      al, dx
        and     al, 0e0h
        add     al, 7
        out     dx, al

        mov     ah, 1
        mov     ch, 32
        xor     cl, cl
        int     10h                     ; del cursor

        mov     ax, cs
        mov     ds, ax
        mov     si, offset TempScreen
        mov     ax, 0b800h
        mov     es, ax
        xor     di, di
        mov     cx, 80*50
        rep     movsw

        popa
        jmp     BigLoop

; Exit SatPlay 

Exit_SatPlay:

        mov     bx, 5
        call    SAT_Player              ; stop player

; Restore screen and display end message 

        mov     ax, 0003h
        int     10h

        mov     ax, cs
        mov     ds, ax
        mov     ax, 0b800h
        mov     es, ax
        xor     di, di
        mov     si, offset SATPLAY_EndScrn
        mov     cx, 14*80
        rep     movsw

        mov     ah, 2
        mov     dx, 0E00h
        xor     bh, bh
        int     10h

        mov     ax, 4c00h
        int     21h                     ; Get out of here!

;
; Write DL in HEX to screen position DI 
;

WriteHEX:
        mov     ax, 0b800h
        mov     es, ax

        mov     al, dl
        shr     al, 4
        add     al, '0'                 ;
        cmp     al, ':'                 ;
        jb      No_char1                ;
        add     al, 'A'-':'             ; convert to hex
No_Char1:                               ;
        stosb
        mov     al, dl
        and     al, 15
        add     al, '0'                 ;
        cmp     al, ':'                 ;
        jb      No_Char2                ;
        add     al, 'A'-':'             ; convert to hex
No_Char2:                               ;
        inc     di
        stosb
        ret

;
; Write DL in DEC to screen position DI 
;

WriteDEC:
        pusha
        mov     ax, 0b800h
        mov     es, ax

        xor     ah, ah
        mov     al, dl
        mov     cl, 10
        div     cl
        add     al, '0'
        stosb
        inc     di
        mov     al, ah
        add     al, '0'
        stosb
        popa
        ret

; Display FileError Message 

FileError:
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset FileErrorMessage
        mov     ah, 9
        int     21h
        mov     ax, 4c01h
        int     21h

; Display MemoryError Message 
MemoryError:
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset MemoryErrorMessage
        mov     ah, 9
        int     21h
        mov     ax, 4c01h
        int     21h

; Display NoCommandLine Message 

No_CommandLine:
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset NoCommLineMessage
        mov     ah, 9
        int     21h
        mov     ax, 4c01h
        int     21h

; Display NoSatFile Message 

No_SATfile:
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset NoSATfileMessage
        mov     ah, 9
        int     21h
        mov     ax, 4c01h
        int     21h

; Display NoFMchip Message 

No_FMchip:
        mov     ax, cs
        mov     ds, ax
        mov     dx, offset NoFMchipMessage
        mov     ah, 9
        int     21h
        mov     ax, 4c01h
        int     21h

; Screen data 

Include satplay.inc                     ; main screen
Include SatEnd.Inc                      ; end screen

TempScreen      db      80*50*2 dup (?) ; tempscreen for DosShell

; The End! 

_Code   ends
_Stack  segment para stack 'stack'
        db      512 dup (?)
_Stack  ends
_EndSeg segment para public 'data'
_EndSeg ends
End     ProgStart
