;Ŀ
;          SAT Player v1.0, written by Lone Ranger/AcmE   (c) 1993          
;                                                                           
;  This file contains all the routines needed to play a .SAT file (used by  
;  Surprise! Productions Adlib Tracker, Rick Dangerous/S!P). You may use it 
;  in your own intro/demo as long as you credit the coder (Lone Ranger/AcmE)
;  and send the product it's used in to me (see ACME.NFO for contacting     
;  info). Please send all modifications or ideas to me, instead of releasing
;  a modified version. thanx..                                              
;                                                                           
;

        P286                            ; Uses 286 instuctions
        jumps                           ; Let TASM handle out-of-range jumps

; Publics 

Public  SAT_player
Public  SAT_Equalizer
Public  SAT_ChannelEqu
Public  SAT_SongPos
Public  SAT_PatternPos
Public  SAT_Time

Public  SAT_PjumpFlag
Public  SAT_PjumpPos
Public  SAT_PbreakPos

Public  SAT_Volume
Public  SAT_Note
Public  SAT_Effect
Public  SAT_Instrument

_Code   segment para public 'Code'
assume  cs:_Code, ds:_Code, es:_Code

db      'SATplayer v1.0, (c) Copyright 1993 by Lone Ranger/AcmE'

; SAT format data 

SongLen         equ     Byte ptr es:[44Bh]
RestartPosition equ     Byte ptr es:[44Ch]
CallsPerSecond  equ     Byte ptr es:[44Dh]
PatternOffset   equ     44Fh
InstrumentOffset equ    5h
PatternOrderOffset equ  842

; PROCEDURES 

;
; Write data to adlib, AH=reg, AL=data 
;

WriteFM PROC NEAR
        push    ax
        push    cx
        push    dx
        xchg    al,ah
        mov     dx,388h
        out     dx,al
        mov     cx,7
        call    FMwait
        mov     dx,389h
        mov     al,ah
        out     dx,al
        dec     dx
        mov     cx,30
        call    FMwait
        pop     dx
        pop     cx
        pop     ax
        ret
FMwait: in      al,dx
        loop    FMwait
        ret
WriteFM ENDP

OldInt08h       dd      0               ; Pointer of old timer interrupt
OldIntMask      db      0               ; Value of old interrupt mask
LSBcounter      dw      0                                                       ;

;
; Setup timer interrupt and reprogram timer chip 
;

EnableTIMER     proc    far

        cmp     cs:[PlayMode], 1
        je      Skip_EnableTIMER

        mov     es, cs:[MusicSeg]

        mov     dx, 0012h
        mov     ax, 34dch
        xor     ch, ch
        mov     cl, CallsPerSecond
        div     cx
        mov     cs:[LSBcounter], ax     ; calculate LSB counter
        xor     ah, ah
        mov     al, CallsPerSecond
        mov     cl, 18
        div     cl                      ; calc counter for OldInt08h
        mov     cs:[TimerPreset], al
        mov     cs:[TimerCounter], al

        mov     ax, 3508h
        int     21h                     ; Get old timer interrupt offset
        mov     word ptr cs:[OldInt08h], bx
        mov     word ptr cs:[OldInt08h+2], es

        in      al, 21h                 ; Get interrupt mask register
        mov     cs:[OldIntMask], al

        cli                             ; Make sure no ints occure while in
                                        ; setup!

        mov     al, 0FFh
        out     21h, al                 ; disable all maskable interrupts

        sti

        mov     dx, offset PlayerInterrupt
        push    cs
        pop     ds
        mov     ax, 2508h
        int     21h                     ; Setup new timer interrupt

        mov     al, 00110110b           ; Channel 0, Read/write LSB followed
        out     43h, al                 ; by MSB, Operation mode 2, binary
        mov     al, byte ptr cs:[LSBCounter]
        out     40h, al
        mov     al, byte ptr cs:[LSBCounter+1]
        out     40h, al                 ; Send counter MSB

        cli
        mov     al, cs:[OldIntMask]
        out     21h, al                 ; enable interrupts again
        sti
        sti

Skip_EnableTIMER:

        popa
        retf

EnableTIMER     endp

;
; Disable timer interrupt, restore timer offset and restore timer chip 
;

DisableTIMER    proc    far

        cmp     cs:[PlayMode], 1
        je      Skip_DisableTIMER

        cli
        mov     al, 0FFh                ; disable all interrupts
        out     21h, al
        sti

        mov     al, 00110100b           ; Channel 0, Read/write LSB followed
        out     43h, al                 ; by MSB, Operation mode 2, binary
        xor     ax, ax
        out     40h, al
        out     40h, al

        mov     dx, word ptr cs:[OldInt08h]
        mov     ds, word ptr cs:[OldInt08h+2]
        mov     ax, 2508h
        int     21h                     ; Restore the stored interrupt vector

        cli
        mov     al, cs:[OldIntMask]
        out     21h, al                 ; enable interrupts again
        sti
        sti

Skip_DisableTIMER:

        jmp     ResetFMchip

DisableTIMER    endp

;
; This is the actual player 
;

MusicSEG        dw      0               ; segment of sat-file
PlayMode        db      0               ; 0 = timer, 1 = poll

SAT_SongPos     db      0               ; Current Song Position
SAT_PatternPos  dw      0               ; Current Pattern Position
                                        ; (real offset!)

SAT_Volume      db      9 dup (63)      ; volumes of all 9 channels. (ex KSL)
KSL_Values      db      9 dup (0)       ; KSL values of all 9 channels.
SAT_Instrument  db      9 dup (0)       ; num of instr (0=none)
SAT_Note        db      9 dup (0)       ; note (0=none)
SAT_Effect      db      9 dup (0)       ; effect (0=none, 1=arpeggio, etc..)

Modulator_numbers       db      00h,01h,02h,08h,09h,0ah,10h,11h,12h
Carrier_numbers         db      03h,04h,05h,0bh,0ch,0dh,13h,14h,15h

f_number        dw      343,363,385,408,432,458,485,514,544,577,611,647

SAT_Speed       db      7               ; current speed
TempSpeed       db      7               ; counter for speed

SAT_Equalizer   db      36 dup (0)      ; equalizer (0-36)
SAT_ChannelEqu  db      9 dup (0)       ; channel equ (0-32)

Reg_B           db      9 dup (0)       ; register 0Bxh values

SAT_Time        dw      0               ; This, divided by TpS, is the number
                                        ; of seconds the tune has played.

SAT_PjumpFlag   db      0               ; pos jump/pbreak?
SAT_PjumpPos    db      0               ; new songpos
SAT_PbreakPos   db      0               ; new patternpos

Player  proc    far

        pusha

        mov     ax, cs
        mov     ds, ax                  ; DS = code seg (and data)
        mov     es, [MusicSeg]          ; ES = seg of sat-file

        inc     [SAT_Time]

; Update equalizers 

        mov     cx, 36
        mov     BX, offset SAT_Equalizer
EQU_Loop:
        cmp     byte ptr [bx], 0        ; already zero?
        jne     EQU_dec                 ; nope
        inc     bx
        loop    EQU_Loop
        jmp     EQU_Done
EQU_Dec:
        dec     byte ptr [bx]           ; decrease equ
        inc     bx
        loop    EQU_loop
EQU_Done:

        mov     cx, 9
        mov     BX, offset SAT_ChannelEqu
CHN_Loop:
        cmp     byte ptr [bx], 0        ; already zero?
        jne     CHN_dec                 ; nope
        inc     bx
        loop    CHN_Loop
        jmp     CHN_Done
CHN_Dec:
        dec     byte ptr [bx]           ; decrease equ
        inc     bx
        loop    CHN_loop
CHN_Done:

; Update special effects 

        xor     bp, bp                  ; current channel (0-8)
CheckEfxLoop:
        xor     bh, bh
        mov     bl, ds:[SAT_Effect+bp]  ; get current effect
        or      bl, bl                  ; no effect?
        jz      CheckEfxDone            ; yep..
        dec     bl
        shl     bx, 1
        jmp     cs:[EfxTable+bx]        ; jump to update effect
CheckEfxdone:
        inc     bp                      ; next channel
        cmp     bp, 9
        jne     CheckEfxLoop

; Check speed 

        dec     [TempSpeed]
        jnz     Exit_PLayer
        mov     al, [SAT_Speed]
        mov     [TempSpeed], al

; Update notes and instruments 

        xor     bh, bh
        xor     ah, ah
        mov     bl, [SAT_SongPos]       ; get song position and get pattern
        mov     es, [MusicSeg]
        mov     al, byte ptr es:[PatternOrderOffset+bx]
        mov     cx, 180                 ;
        mul     cx                      ;
        add     ax, 69                  ;
        add     ax, [MusicSEG]          ;
        dec     ax                      ; calc segment of pattern
        mov     es, ax

        mov     di, [SAT_PatternPos]    ; current offset in pattern
        add     di, 15

        xor     bp, bp                  ; counter channels
ChannelLoop:
        xor     ah, ah
        mov     al, es:[di+1]           ; get instr
        or      al, al                  ; is there an instr?
        jz      Skip_SetupInstr         ; nope..
        dec     al                      ; actual instr
        call    Set_Instrument          ; program FM
Skip_SetupInstr:
        cmp     byte ptr es:[di+2], 3   ; check for tone portamento
        je      Skip_SetupNote          ; if so, don't play note
        mov     al, es:[di]             ; get current note
        or      al, al                  ; is it a note?
        jz      Skip_SetupNote          ; nope, don't program FM
        call    Play_Note
Skip_SetupNote:

; Check special effects 

        mov     al, es:[di+2]           ; here we check if there is a
        or      al, al                  ; special effect, so we can set
        jnz     no_arp                  ; up SAT_Effect: 0 if no effect,
        cmp     word ptr es:[di+3], 0   ; 1 if arpeggio and so on..
        jne     no_arp
        dec     al
no_arp:
        inc     al
        mov     ds:[SAT_Effect+bp], al

        or      al, al                  ; special effect?
        jz      Check_Done              ; nope
        dec     al                      ; real effect
        xor     bh, bh
        mov     bl, al
        shl     bx, 1

        jmp     word ptr cs:[EfxInitTable+bx]

check_Done:

        inc     bp                      ; next channel
        add     di, 5                   ;
        cmp     bp, 9                   ; all channels done?
        jne     ChannelLoop             ; nope..

; Update pointers 

        cmp     [SAT_PjumpFlag], 1
        jne     No_PosJump
        mov     al, [SAT_PjumpPos]
        mov     [SAT_SongPos], al       ; set new songpos
        mov     al, [SAT_PbreakPos]
        mov     cl, 9*5
        mul     cl                      ; calc real offset
        mov     [SAT_PatternPos], ax    ; set new patternpos
        mov     [SAT_PjumpFlag], 0      ; reset SAT_PjumpFlag
        jmp     No_Set_SongPos

No_PosJump:
        add     [SAT_PatternPos], 9*5   ; next row
        cmp     [SAT_PatternPos], 64*9*5; all rows done?
        jb      No_Set_Songpos          ; nope, not yet

        mov     [SAT_PatternPos], 0     ; first row
        inc     [SAT_SongPos]           ; next songpos
        push    es
        mov     es, [MusicSeg]
        mov     al, SongLen             ; get songlen
        pop     es
        cmp     [SAT_SongPos], al       ; are we done yet?
        jb      No_Set_SongPos          ; nope
        push    es
        mov     es, [MusicSeg]
        mov     al, RestartPosition     ; get restart pos
        pop     es
        mov     [SAT_SongPos], al       ; set it

No_Set_Songpos:
Exit_Player:

        popa

        retf

Player  endp

; Effects init jumptable 

EfxInitTable    dw      offset Init_Arpeggio         ; arpeggio
                dw      offset Init_SlideUp          ; slide up
                dw      offset Init_SlideDown        ; slide down
                dw      offset Init_TonePorta        ; tone portamento
                dw      offset Check_Done            ; **
                dw      offset Init_VolumeSlide      ; vol slide
                dw      offset Init_VolumeSlide      ; vol slide
                dw      offset Check_Done            ; **
                dw      offset ReleaseNote           ; release sust. note
                dw      offset Check_Done            ; **
                dw      offset Init_VolumeSlide      ; vol slide
                dw      offset PosJump               ; position jump
                dw      offset VolumeSet             ; Volume set
                dw      offset PatternBreak          ; pattern break
                dw      offset Check_Done            ; **
                dw      offset SetSpeed              ; set speed

; Initialize special effects 

;
; Init Arpeggio 
;

Init_Arpeggio   proc    near
        mov     ah, ds:[SAT_Note+BP]    ; get current note
        dec     ah
        mov     ds:[ArpeggioN+bp], ah
        mov     ds:[ArpeggioZ+bp], ah
        mov     al, es:[di+3]
        add     al, ah
        mov     ds:[ArpeggioX+bp], al
        mov     al, es:[di+4]
        add     al, ah
        mov     ds:[ArpeggioY+bp], al
        jmp     Check_Done
Init_Arpeggio   endp

;
; Volume Set 
;

VolumeSet       proc    near
        mov     al, es:[di+3]           ; get volume
        shl     al, 4
        or      al, es:[di+4]
        cmp     al, 63
        jb      vs_no63
        mov     al, 63
vs_no63:
        mov     ah, 63
        sub     ah, al
        mov     ds:[SAT_Volume+bp], ah
        call    Set_Volume              ; reprogram FM
        jmp     Check_Done
VolumeSet       endp

;
; Set Speed 
;

SetSpeed        proc    near
        mov     al, es:[di+3]           ; get speed
        shl     al, 4
        or      al, es:[di+4]
        mov     [SAT_speed], al         ; save it
        mov     [tempspeed], al         ;
        jmp     Check_Done
SetSpeed        endp

;
; Init VolumeSlides 
;

Init_VolumeSlide proc   near
        mov     al, es:[di+3]
        mov     ds:[VolumeSlideUp+bp], al
        mov     al, es:[di+4]
        mov     ds:[VolumeSlideDown+bp], al
        jmp     Check_Done
Init_VolumeSlide endp

;
; Init Slide Up 
;

Init_SlideUp    proc    near
        mov     al, es:[di+3]
        shl     al, 4
        or      al, es:[di+4]
        mov     ds:[SlideUpFreq+bp], al
        jmp     Check_Done
Init_SlideUp    endp

;
; Init Slide Down 
;

Init_SlideDown  proc    near
        mov     al, es:[di+3]
        shl     al, 4
        or      al, es:[di+4]
        mov     ds:[SlideDownFreq+bp], al
        jmp     Check_Done
Init_SlideDown  endp

;
; Init Tone Portamento 
;

Init_TonePorta  proc    near
        mov     bh, es:[di]             ; get note in note field
        or      bh, bh
        jz      Check_Done              ; if no note do nothing..
        mov     ds:[TonePortaToNote+BP], bh
        mov     bl, ds:[SAT_Note+bp]    ; get last note played
        or      bl, bl
        jz      Check_Done              ; if zere we've got troubles..
        mov     al, es:[di+3]
        shl     al, 4
        or      al, es:[di+4]           ; get speed
        cmp     bh, bl
        jz      Check_Done              ; if equal, don't porta
        mov     ds:[TonePortaDir+bp], 0 ; set direction to 'add'
        ja      Skip_neg                ; if above don't neg
        mov     ds:[TonePortaDir+bp], 1 ; set direction to 'sub'
Skip_neg:
        mov     ds:[TonePortaSpeed+bp], al

        xor     ah, ah
        mov     al, bh                  ; get note in note field
        dec     al
        call    Calc_Freq
        shl     bp, 1
        mov     ds:[TonePortaToFreq+bp], cx
        shr     bp, 1
        mov     ds:[TonePortaToBlock+bp], dl
        mov     al, ds:[SlideBlock+bp]
        mov     ds:[TonePortaBlock+bp], al
        shl     bp, 1
        mov     ax, ds:[SlideFreq+bp]
        mov     ds:[TonePortaFreq+bp], ax
        shr     bp, 1
        jmp     Check_Done

calc_freq:
        mov     cl, 12
        div     cl                      ; Get freq and block
        mov     dx, ax
        mov     bx, ax
        shr     bx, 8
        shl     bx, 1
        mov     cx, cs:[f_number+BX]    ; get freq for output
        add     dl, 2
        ret
Init_TonePorta  endp

;
; Position Jump 
;

PosJump         proc    near
        mov     al, es:[di+3]
        shl     al, 4
        or      al, es:[di+4]           ; get new songpos
        mov     [SAT_PjumpPos], al      ; set new songpos
        mov     [SAT_PbreakPos], 0      ; set new pattern to 0
        mov     [SAT_PjumpFlag], 1      ; posjump active
        jmp     Check_Done
PosJump         endp

;
; Pattern Break 
;

PatternBreak    proc    near
        mov     al, es:[di+3]
        shl     al, 4
        or      al, es:[di+4]
        mov     [SAT_PbreakPos], al     ; set new pattern pos
        mov     al, [SAT_SongPos]       ; get current song pos
        inc     al
        push    es
        mov     es, [MusicSeg]
        mov     ah, SongLen             ; get songlen
        cmp     al, ah                  ; end of song?
        jb      NoSetSongPos            ; nope
        mov     al, RestartPosition     ; do it again..
NoSetSongPos:
        pop     es
        mov     [SAT_PjumpPos], al      ; set new songpos
        mov     [SAT_PjumpFlag], 1      ; pbreak/posjump is active
        jmp     Check_Done
PatternBreak    endp

;
; Release Sustaining Note 
;

ReleaseNote     proc    near
        mov     ax, 000B0h
        add     ax, bp
        xchg    al, ah
        mov     al, ds:[Reg_B+bp]
        and     al, 255-32
        Call    WriteFM
        jmp     Check_Done
ReleaseNote     endp

; Update Effects jumptable 

EfxTable        dw      offset Arpeggio, offset SlideUp, offset SlideDown
                dw      offset TonePorta, offset CheckEfxDone
                dw      offset VolumeSlide, offset VolumeSlide
                dw      offset CheckEfxDone, offset CheckEfxDone
                dw      offset CheckEfxDone, offset VolumeSlide
                dw      offset CheckEfxDone, offset CheckEfxDone
                dw      offset CheckEfxDone, offset CheckEfxDone
                dw      offset CheckEfxDone

; Special effects variables 

VolumeSlideUp   db      9 dup (0)       ; speed to slide up
VolumeSlideDown db      9 dup (0)       ; speed to slide down
ArpeggioN       db      9 dup (0)       ; current note
ArpeggioX       db      9 dup (0)       ; noteX
ArpeggioY       db      9 dup (0)       ; noteY
ArpeggioZ       db      9 dup (0)       ; note normal
ArpeggioC       db      9 dup (0)       ; counter
SlideFreq       dw      9 dup (0)       ; current freq
SlideBlock      db      9 dup (0)       ; current block
SlideUpFreq     db      9 dup (0)       ; speed to slide up
SlideDownFreq   db      9 dup (0)       ; speed to slide down
TonePortaSpeed  db      9 dup (0)       ; speed to slide with
TonePortaDir    db      9 dup (0)       ; direction, 0=add, 1=sub
TonePortaToFreq dw      9 dup (0)       ; freq to slide to
TonePortaToBlock db     9 dup (0)       ; block to slide to
TonePortaToNote db      9 dup (0)       ; note to slide to
TonePortaFreq   dw      9 dup (0)       ; current freq
TonePortaBlock  db      9 dup (0)       ; current block

;
; Update Arpeggio 
;

Arpeggio        proc    near
        mov     al, ds:[ArpeggioC+bp]
        cmp     al, 0
        je      Arp_X
        cmp     al, 1
        je      Arp_Y

        mov     al, ds:[ArpeggioZ+bp]
        mov     ds:[ArpeggioN+bp], al
        mov     ds:[ArpeggioC+bp], 0
        jmp     Arp_PlayNote
Arp_X:  mov     al, ds:[ArpeggioX+bp]
        mov     ds:[ArpeggioN+bp], al
        mov     ds:[ArpeggioC+bp], 1
        jmp     Arp_PlayNote
Arp_Y:  mov     al, ds:[ArpeggioY+bp]
        mov     ds:[ArpeggioN+bp], al
        mov     ds:[ArpeggioC+bp], 2
Arp_PlayNote:
        mov     al, ds:[ArpeggioN+BP]
        xor     ah, ah
        call    Play_Note1              ; call in sub Play_Note
        jmp     CheckEfxDone
Arpeggio        endp

;
; Update Slide up 
;

SlideUp         proc    near
        xor     ah, ah
        mov     al, ds:[SlideUpFreq+bp]
        mov     dl, ds:[SlideBlock+bp]
        shl     bp, 1
        mov     cx, ds:[SlideFreq+bp]
        shr     bp, 1
        add     cx, ax
        cmp     cx, 686
        jb      SlideUpDone
        sub     cx, 686-343
        inc     dl
SlideUpDone:
        mov     ds:[SlideBlock+bp], dl
        shl     bp, 1
        mov     ds:[SlideFreq+bp], cx
        shr     bp, 1
        call    Play_Note2
        jmp     CheckEfxDone
SlideUp         endp

;
; Update Slide down 
;

SlideDown       proc    near
        xor     ah, ah
        mov     al, ds:[SlideDownFreq+bp]
        mov     dl, ds:[SlideBlock+bp]
        shl     bp, 1
        mov     cx, ds:[SlideFreq+bp]
        shr     bp, 1
        sub     cx, ax
        cmp     cx, 343
        ja      SlideDownDone
        add     cx, 686-343
        dec     dl
SlideDownDone:
        mov     ds:[SlideBlock+bp], dl
        shl     bp, 1
        mov     ds:[SlideFreq+bp], cx
        shr     bp, 1
        call    Play_Note2
        jmp     CheckEfxDone
SlideDown       endp

;
; Update Tone Portamento 
;

TonePorta       proc    near
        shl     bp, 1
        mov     bx, ds:[TonePortaFreq+bp]
        mov     cx, ds:[TonePortaToFreq+bp]
        shr     bp, 1
        mov     dl, ds:[TonePortaBlock+bp]
        mov     dh, ds:[TonePortaToBlock+bp]
        xor     ah, ah
        mov     al, ds:[TonePortaSpeed+bp]
        or      al, al
        jz      CheckEfxDone
        cmp     ds:[TonePortaDir], 1
        je      Porta_Neg
        add     bx, ax
        cmp     dl, dh                  ; check if correct block
        jne     PUC
        cmp     bx, cx
        jae     PortaUpN
PUC:
        cmp     bx, 686
        jb      PortaDone
        sub     bx, 686-343
        inc     dl
        jmp     PortaDone
PortaUpN:
        mov     ds:[TonePortaSpeed+bp], 0 ; no more porta for you...
        mov     al, ds:[TonePortaToNote+bp]
        mov     ds:[SAT_Note+bp], al
        mov     dl, ds:[TonePortaToBlock+bp]
        shl     bp, 1
        mov     bx, ds:[TonePortaToFreq+bp]
        shr     bp, 1
        jmp     PortaDone
Porta_Neg:
        sub     bx, ax
        cmp     dl, dh                  ; check if correct block
        jne     PDC
        cmp     bx, cx
        jbe     PortaDownN
PDC:
        cmp     bx, 343
        ja      PortaDone
        add     bx, 686-343
        dec     dl
        jmp     PortaDone
PortaDownN:
        mov     ds:[TonePortaSpeed+bp], 0 ; no more porta for you...
        mov     al, ds:[TonePortaToNote+bp]
        mov     ds:[SAT_Note+bp], al
        mov     dl, ds:[TonePortaToBlock+bp]
        shl     bp, 1
        mov     bx, ds:[TonePortaToFreq+bp]
        shr     bp, 1
PortaDone:
        mov     ds:[TonePortaBlock+bp], dl
        shl     bp, 1
        mov     ds:[TonePortaFreq+bp], bx
        shr     bp, 1
        mov     cx, bx
        call    Play_note2
        jmp     CheckEfxDone
TonePorta       endp

;
; Update Volume Slides 
;

VolumeSlide     proc    near

        mov     al, ds:[SAT_Volume+bp]
        cmp     ds:[VolumeSlideUp+bp], 0
        je      Skip_VolUp
        sub     al, ds:[VolumeSlideUp+bp]
        jnb     Skip_VolUp
        xor     al, al
Skip_VolUp:
        cmp     ds:[VolumeSlideDown+bp], 0
        je      Skip_VolDown
        add     al, ds:[VolumeSlideDown+bp]
        cmp     al, 63
        jb      Skip_VolDown
        mov     al, 63
Skip_VolDown:
        mov     ds:[SAT_Volume+bp], al
        call    Set_Volume
        jmp     CheckEfxDone
VolumeSlide     endp

; Player/interrupt routines 

;
; This procedure is called by the timer interrupt 
;

TimerPreset     db      ?
TimerCounter    db      ?

PlayerInterrupt proc    far
        push    ax ds es
        call    Player
        dec     cs:[TimerCounter]
        jnz     Skip_TimerCall
        mov     al, cs:[TimerPreset]
        mov     cs:[TimerCounter], al
        pushf
        call    dword ptr cs:[OldInt08h]
        pop     es ds ax
        iret
Skip_TimerCall:
        mov     al, 20h                 ; interrupt finished
        out     20h, al
        pop     es ds ax
        iret
PlayerInterrupt endp

;
; This routine has to be called by the master program (intro/demo)
;
; IN:  BX = 0          Check for FM chip
;                      - returns:      CF clear: FM chip found
;                                      CF set: no FM chip found
;      BX = 1          Reset FM chip
;-      BX = 2          Init player
;-                      - in:           ES: segment of SAT file
;                                      AL = 0: timer mode (don't poll)
;                                      AL = 1: polling mode (has to be
;                                              called exactly 50 or 70 times
;                                              a second. (ie. in a vertical
;                                              retrace)
;      BX = 3          Start Playing
;      BX = 4          Poll player
;      BX = 5          Stop Playing
;

JumpTable       dw      offset TestFMchip, offset ResetFMchip, offset InitPlay
                dw      offset EnableTIMER, offset Player, offset DisableTIMER

SAT_player      proc    far
        cmp     bx, 4
        je      Skip_PushA
        pusha
Skip_Pusha:
        shl     bx, 1
        jmp     cs:[JumpTable+BX]
SAT_player      endp

;
; Initialize player (set musicseg and playmode) 
;

InitPlay        proc    far
        mov     cs:[MusicSeg], es       ; Set music segment
        mov     cs:[PlayMode], al       ; seg playing mode (timer/poll)
        popa
        retf
InitPlay        endp

;
; calc freq and write it to FM 
;

Play_Note       proc    near
        cmp     byte ptr es:[di+1], 0   ; check for instr
        jz      Skip_DelOldNote         ; if not, don't release old
                                        ; note
        mov     ax, 000A0h
        add     ax, bp
        xchg    al, ah
        Call    WriteFM
        add     ah, 010h
        Call    WriteFM
skip_deloldnote:
        mov     ds:[SAT_ChannelEqu+bp], 36 ; update Channel equalizer
        
        xor     ah, ah
        mov     al, es:[di]             ; get note

        mov     ds:[SAT_Note+BP], AL

        dec     ax
        mov     bx, ax
        mov     cs:[SAT_Equalizer+bx], 32 ; update equalizer

Play_Note1:
        mov     cl, 12
        div     cl                      ; Get freq and block
        add     al, 2
        mov     dx, ax
        mov     ds:[SlideBlock+bp], al
        mov     bx, ax
        shr     bx, 8
        shl     bx, 1
        mov     cx, cs:[f_number+BX]    ; get freq for output
        shl     bp, 1
        mov     ds:[SlideFreq+bp], cx
        shr     bp, 1
Play_Note2:

        mov     ax, 000A0h
        add     ax, bp
        xchg    al, ah
        mov     al, cl
        Call    WriteFM

        mov     ax, dx                  ; restore block
        xor     ah, ah
        shl     al, 2
        or      ch, al
        or      ch, 32

        mov     ds:[Reg_B+bp], ch       ; save reg for release note effect

        mov     ax, 000B0h
        add     ax, bp
        xchg    al, ah
        mov     al, ch
        Call    WriteFM

        ret
Play_Note       endp

;
; Program instrument 
;

Set_Instrument      proc    near
        inc     al
        mov     ds:[SAT_Instrument+bp], al
        dec     al

        xor     ah, ah
        mov     cx, 11
        mul     cx
        add     ax, 5                   ; calc offset of instr info in file
        mov     si, ax

; program instruments 

        push    es                      ; save patternseg
        mov     es, [MusicSEG]

        mov     ah, 020h
        add     ah, ds:[offset Modulator_numbers+bp]
        mov     al, es:[si+1]
        call    WriteFM

        add     ah, 020h
        mov     al, es:[si+9]
        Call    WriteFM

        add     ah, 020h
        mov     al, es:[si+3]
        Call    WriteFM

        add     ah, 020h
        mov     al, es:[si+5]
        call    WriteFM

        add     ah, 060h
        mov     al, es:[si+7]
        call    WriteFM

        mov     ah, 020h
        add     ah, ds:[offset Carrier_numbers+bp]
        mov     al, es:[si+2]
        call    WriteFM

        add     ah, 020h
        mov     al, es:[si+10]
        call    WriteFM

        add     ah, 020h
        mov     al, es:[si+4]
        call    WriteFM

        add     ah, 020h
        mov     al, es:[si+5]
        call    WriteFM

        add     ah, 060h
        mov     al, es:[si+8]
        call    WriteFM

        mov     ax, 000C0h
        add     ax, bp
        xchg    al, ah
        mov     al, es:[si]
        call    WriteFM

        mov     al, es:[si+10]
        mov     ah, al
        and     al, 00111111b
        mov     ds:[SAT_Volume+bp], al  ; update volume settings
        and     ah, 11000000b
        mov     ds:[KSL_Values+BP], ah  ; update KSL values
        pop     es

        ret
Set_Instrument      endp

;
; Programs FM volume 
;

Set_Volume      proc    near
        mov     ah, 040h
        add     ah, ds:[offset Carrier_numbers+bp]
        mov     al, ds:[SAT_Volume+bp]
        or      al, ds:[KSL_Values+bp]
        Call    WriteFM

        mov     al, ds:[SAT_Instrument+bp]

        xor     ah, ah
        mov     cx, 11
        mul     cx
        add     ax, 5                   ; calc offset of instr info in file
        mov     si, ax

        push    es                      ; save patternseg
        mov     es, [MusicSEG]

        test    byte ptr es:[si], 1     ; set modulator too?
        pop     es

        jz      Skip_SetMod             ; nope

        mov     ah, 040h
        add     ah, ds:[offset Modulator_numbers+bp]
        mov     al, ds:[SAT_Volume+bp]
        or      al, ds:[KSL_Values+bp]
        call    WriteFM

Skip_SetMod:
        ret
Set_Volume      endp

;
; Check for FM chip, returns CF = 0 if found, or CF = 1 if not 
;

TestFMchip      proc    far

        mov     ax, 00100h
        Call    WriteFM
        mov     ax, 00480h
        Call    WriteFM

        mov     dx, 388h
        in      al, dx
        mov     cl, al
        mov     ax, 002FFh
        Call    WriteFM
        mov     ax, 00421h
        Call    WriteFM

        mov     dx, 388h
        mov     cx, 100
        call    FMwait
        mov     ch, al

        mov     ax, 00460h
        Call    WriteFM
        mov     al, 80h
        Call    WriteFM

        and     cl, 0E0h
        cmp     cl, 0
        jne     No_FMchip
        and     ch, 0E0h
        cmp     ch, 0C0h
        jne     No_FMchip

        popa
        clc
        ret

No_FMchip:

        popa
        stc
        ret

TestFMchip      endp

;
; Reset FM chip 
;

ResetFMchip     proc    far

        mov     ax, 00100h
        Call    WriteFM                 ; enable writing to FM chip

        mov     ax, 0A000h              ; kill all freq
        mov     cx, 020h
@@1:
        Call    WriteFM
        inc     ah
        loop    @@1

        mov     ah, 040h                ; kill all volumes (and rythm ins)
        mov     cx, 32
@@2:
        Call    WriteFM
        inc     ah
        loop    @@2

        xor     al, al
        mov     ah, 008h
        Call    WriteFM
        mov     al, 11000000b
        mov     ah, 0BDh
        Call    WriteFM

        popa
        retf

ResetFMchip     endp

_Code ends
end
