// c_envelope.h: interface for the c_envelope class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#if !defined(AFX_C_ENVELOPE_H__2691C103_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_ENVELOPE_H__2691C103_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class c_envelope  
{
public:
	c_envelope() ;
	c_envelope(FILE *module_file, bool signed_node) ;
	c_envelope(istream &is, signed long envelope_type) ;
	virtual ~c_envelope() ;
	bool is_on();
	bool is_loop_on();
	bool is_sustain_loop_on ();
	signed long get_number_of_nodes ();
	signed long get_loop_beginning_node ();
	signed long get_loop_end_node ();
	signed long get_sustain_loop_beginning_node();
	signed long get_sustain_loop_end_node();
	signed long get_number_of_ticks();
	signed long get_loop_beginning_tick ();
	signed long get_loop_end_tick ();
	signed long get_sustain_loop_beginning_tick ();
	signed long get_sustain_loop_end_tick ();
	p_envelope_node get_node (signed long node);
	signed long get_node_tick (signed long node);
	signed long get_node_y_value (signed long node);
	double get_tick_value (signed long tick);

private:
	void init_variables();
	void init_envelope() ;
	bool m_envelope_on_off ; 	
	bool m_loop_on_off ;
	bool m_sustain_loop_on_off ;
	bool m_filter_envelope_on_off ;
	signed long m_number_of_nodes ; 
	signed long m_loop_begin ; 
	signed long m_loop_end ; 	
	signed long m_sustain_loop_begin ;
	signed long m_sustain_loop_end ;
	signed long m_last_tick ;
	signed long m_loop_begin_tick ;
	signed long m_loop_end_tick ;
	signed long m_sustain_loop_begin_tick ;
	signed long m_sustain_loop_end_tick ;
	p_envelope_node m_nodes[25] ;
	double *m_interpolation ;
};

#endif // !defined(AFX_C_ENVELOPE_H__2691C103_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
