// c_sample.h: interface for the c_sample class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_SAMPLE_H__2691C105_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_SAMPLE_H__2691C105_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class c_sample  
{
public:
	void set_output_C5_speed(double output_C5_speed);
	c_sample(FILE *module_file);
	c_sample(istream &is, bool linear_interpolation);
	virtual ~c_sample();
	const char *get_name();
	const char *get_dos_name();
	signed long get_volume();
	bool is_on();
	bool is_16_bits();
	bool is_stereo();
	bool is_loop_on();
	bool is_sustain_loop_on();
	bool is_loop_bidi();
	bool is_sustain_loop_bidi();
	bool is_signed();
	signed long get_default_volume();
	unsigned long get_length();
	unsigned long get_loop_beginning();
	unsigned long get_loop_end();
	unsigned long get_C5_speed();
	double get_output_C5_speed();
	unsigned long get_sustain_loop_beginning();
	unsigned long get_sustain_loop_end();
	signed long get_vibrato_speed();
	signed long get_vibrato_depth();
	signed long get_vibrato_rate();
	signed long get_vibrato_waveform();
	signed short *get_pointer_on_end();
	signed short *get_pointer_on_loop_beginning();
	signed short *get_pointer_on_loop_end();
	signed short *get_pointer_on_sustain_loop_beginning();
	signed short *get_pointer_on_sustain_loop_end();
	signed short get_sample_data(unsigned long position);
	const signed short *get_sample_data_pointer();
	void prepare_for_no_loop();
	void prepare_for_forward_loop();
	void prepare_for_bidi_loop();
	void prepare_for_forward_sustain_loop();
	void prepare_for_bidi_sustain_loop();
	bool use_linear_interpolation() ;
	p_coefs get_coefs() ;
	p_coefs get_coefs_end() ;
	p_coefs get_coefs_loop_b() ;
	p_coefs get_coefs_loop_e() ;
	p_coefs get_coefs_sloop_b() ;
	p_coefs get_coefs_sloop_e() ;

private:
	void init_variables();
	signed short m_end_of_sustain_loop_sample;
	signed short m_end_of_loop_sample;
	char m_name[26] ; /* name of the sample */
	
	char m_dos_file_name[12] ; /* file name of the sample */
	
	signed long m_global_volume ; 
	/* Global volume for instrument
	range from 0 to 64 */  
	
	bool m_is_on ;
	
	bool m_is_16_bits_sample ;   
	/* 1 = yes
	0 = no, 8 bits sample */
	
	bool m_is_stereo_sample ;   
	/* 1 = yes, but not supported by IT for now
	0 = no, mono sample */
	
	bool m_is_compressed ;   
	/* 1 = yes, IT 2.14 compressed sample
	   0 = no, <=IT 2.13 uncompressed sample */

	bool m_use_loop ;
	/* 1 = yes, use loop
	0 = no */
	
	bool m_use_sustain_loop ;
	/* 1 = yes, use sustain loop
	0 = no */
	
	bool m_loop_direction ;
	/* 1 = Ping Pong loop
	0 = Forward loop */
	
	bool m_sustain_loop_direction ;
	/* 1 = Ping Pong sustain_loop
	0 = Forward sustain_loop */
	
	bool m_is_signed_sample ;
	/* 1 = yes
	0 = no */
	
	bool m_big_endian_byte_order ;
	/* true  = Big Endian byte order
	   false = Little Endian byte order */

	bool m_delta_encoding ;
	/* true  = Delta encoding
	   false = PCM encoding */
	
	/* default panning */	
	signed long m_default_panning ;
	bool m_default_panning_on ;

	signed long m_default_volume ;
	/* range ??? */
	
	unsigned long m_length ; /* length of the sample */
	/* the length is not in byte but in samples */
	
	unsigned long m_loop_begin ;
	/* in samples */
	
	unsigned long m_loop_end ;
	/* no of the sample AFTER the end of loop */
	
	unsigned long m_C5_speed ; /* C-5 note speed in bytes/second */
							   /* range from 0 to 9999999
	seems strange that the speed is not in samples/second */
	
	double m_output_C5_speed ; /* C-5 note speed adjusted for output */
	
	unsigned long m_sustain_loop_begin ;
	/* in samples */
	
	unsigned long m_sustain_loop_end ;
	/* no of the sample at the end of the sustain loop */
	
	signed long m_vibrato_speed ;
	/* range from 0 to 64 */
	
	signed long m_vibrato_depth ;
	/* range from 0 to 64 */
	
	signed long m_vibrato_rate  ;
	/* range from 0 to 64 */
	
	signed long m_vibrato_waveform ;
	/* 0 = sine wave
	1 = ramp down
	2 = square Wave
	3 = random (then speed is irrelevant) */
	
	/* see ITTECH for vibrato depth processing */
	
	
	signed short *m_sample_data ; /* floating point sample data */
	
	signed short *m_pointer_on_end ;
	
	signed short *m_pointer_on_loop_beginning ;
	signed short *m_pointer_on_loop_end ;
	
	signed short *m_pointer_on_sustain_loop_beginning ;
	signed short *m_pointer_on_sustain_loop_end ;

	bool m_use_linear_interpolation ;

	coefs m_loop_beginning_coefs ;
	coefs m_loop_end_coefs ;
	coefs m_loop_end_coefs_2 ;
	coefs m_sustain_loop_beginning_coefs ;
	coefs m_sustain_loop_end_coefs ;
	coefs m_sustain_loop_end_coefs_2 ;

	coefs m_loop_beginning_coefs_save ;
	coefs m_loop_end_coefs_save ;
	coefs m_loop_end_coefs_save_2 ;
	coefs m_sustain_loop_beginning_coefs_save ;
	coefs m_sustain_loop_end_coefs_save ;
	coefs m_sustain_loop_end_coefs_save_2 ;

	p_coefs m_coefs ;
	p_coefs m_coefs_end ;
	p_coefs m_coefs_loop_b ;
	p_coefs m_coefs_loop_e ;
	p_coefs m_coefs_sloop_b ;
	p_coefs m_coefs_sloop_e ;
};


#endif // !defined(AFX_C_SAMPLE_H__2691C105_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
