/* loader.h */
/*
     PLAY_ITW.EXE v0.02b : Player for Impulse Tracker modules files
     Copyright (C) 1997  Olivier AUMAGE
     E-mail : Olivier.Aumage@ens-lyon.fr
     Web : http://www.ens-lyon.fr/~oaumage/

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* 
  *                                         *
   This file declares the functions used
   to load IT modules into memory.
  *                                         *
*/


#ifndef __loader_h__
#define __loader_h__


/* functions declarations */
/*=======================*/


int load_instrument (FILE *module_file, p_instrument pinstrument) ;
/* load a instrument form the 'module_file' file into the
   'instrument' structure pointed by 'pinstrument'.
   Code return : 0     - successful
                 other - failed */


int load_sample (FILE *module_file, p_sample psample) ;
/* load a sample form the 'module_file' file into the
   'sample' structure pointed by 'psample'.
   Code return : 0     - successful
                 other - failed */


int load_pattern (FILE *module_file, p_pattern ppattern) ;
/* load a pattern form the 'module_file' file into the
   'pattern' structure pointed by 'ppattern'.
   Code return : 0     - successful
                 other - failed */


int load_module (const char *module_file_name, p_module pmodule) ;
/* load a module from the file 'module_file_name' into the 
   'module' structure pointed by 'pmodule'.
   Code return : 0     - successful
                 other - failed */


#endif /* __loader_h__ */

/************/
/* loader.h */
/************/
