// AMF->MOD converter
// made in 1995 by Mr. P / Powersource
// mrp@fish.share.net, ac054@sfn.saskatoon.sk.ca
// This program is hereby placed in the public domain.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <conio.h>

main(int ac, char *av[])
{
	char infile[14];
	char outfile[14];
	char *inpt,*outpt;
	char *tempcptr;
	char *avptr;
	FILE *inf,*outf;
	struct ffblk find_t;
	int ch,j;
	unsigned char *workbuf;
	char orders[256];
	int workptr;
	unsigned long i,numpats,k;
	unsigned long length,repstart,replen;
	char insstruc[30];
	int numorders;
	unsigned int period,ins,effect;
	long percentile;

	int periodtable[]={6848,6464,6096,5760,5424,5120,4832,4560,4304,
			   4064,3840,3628,3424,3232,3048,2880,2712,2560,
			   2416,2280,2152,2032,1920,1814,1712,1616,1524,
			   1440,1356,1280,1208,1140,1076,1016, 960, 907,
			    856, 808, 762, 720, 678, 640, 604, 570, 538,
			    508, 480, 453, 428, 404, 381, 360, 339, 320,
			    302, 285, 269, 254, 240, 226, 214, 202, 190,
			    180, 170, 160, 151, 143, 135, 127, 120, 113,
			    107, 101,  95,  90,  85,  80,  75,  71,  67,
			     63,  60,  56,  53,  50,  47,  45,  42,  40,
			     37,  35,  33,  31,  30,  28};

	if (ac<2) {
		printf("syntax: AMF2MOD inputfile <outputfile>\n");
		exit(1);
	}

	infile[0]=0;
	outfile[0]=0;

	if (ac==2) {
		// one filename..
		avptr=av[1];
		// A) check for "." - if not, add ".AMF" to it
		// B) strip off "." and anything afterward, and add
		//    ".MOD" to end
		if ((tempcptr=strchr(avptr,'.'))!=NULL) {
			// a dot is in there - truncate anything longer
			// than 8.3
			if ((tempcptr-avptr)>8) {
				avptr[8]=0;
				strcat(infile,avptr);
			} else {
				*tempcptr=0;
				strcat(infile,avptr);
				*tempcptr='.';
			}
			// now extension
			tempcptr[4]=0;
			strcat(infile,tempcptr);
		} else {
			// no dot - truncate if longer than 8
			if (strlen(avptr)>8)
				avptr[8]=0;
			strcpy(infile,avptr);
			strcat(infile,".AMF");
		}
		// strip off dot and concatenate to OUTFILE
		tempcptr=strchr(infile,'.');
		*tempcptr=0;
		strcpy(outfile,infile);
		*tempcptr='.';
		strcat(outfile,".MOD");
	} else {
		// 2 filenames - check both for extensions & truncate
		avptr=av[1];
		if ((tempcptr=strchr(avptr,'.'))!=NULL) {
			// a dot is in there - truncate anything longer
			// than 8.3
			if ((tempcptr-avptr)>8) {
				avptr[8]=0;
				strcat(infile,avptr);
			} else {
				*tempcptr=0;
				strcat(infile,avptr);
				*tempcptr='.';
			}
			// now extension
			tempcptr[4]=0;
			strcat(infile,tempcptr);
		} else {
			// no dot - truncate if longer than 8
			if (strlen(avptr)>8)
				avptr[8]=0;
			strcpy(infile,avptr);
			strcat(infile,".AMF");
		}
		avptr=av[2];
		if ((tempcptr=strchr(avptr,'.'))!=NULL) {
			// a dot is in there - truncate anything longer
			// than 8.3
			if ((tempcptr-avptr)>8) {
				avptr[8]=0;
				strcat(outfile,avptr);
			} else {
				*tempcptr=0;
				strcat(outfile,avptr);
				*tempcptr='.';
			}
			// now extension
			tempcptr[4]=0;
			strcat(outfile,tempcptr);
		} else {
			// no dot - truncate if longer than 8
			if (strlen(avptr)>8)
				avptr[8]=0;
			strcpy(outfile,avptr);
			strcat(outfile,".MOD");
		}
	}
	// we now have input & output
	inpt = strupr(infile);
	outpt = strupr(outfile);
	if ((findfirst(inpt,&find_t,0)) != 0) {
		printf("Cannot find input file %s\n",inpt);
		exit(1);
	}

	if (!(findfirst(outpt,&find_t,0))) {
		printf("%s exists. Overwrite (y/n)? ",outpt);
		ch=0;
		while ((ch != 'y') && (ch != 'Y') && (ch != 'n') &&
			(ch != 'N')) {
			ch=getch();
		}
		putch(ch);
		printf("\n");
		if ((ch == 'N') || (ch == 'n')) {
			exit(1);
		}
		printf("\n");
	}

	inf=fopen(inpt,"rb");
	outf=fopen(outpt,"w+b");

	// AMF conversion will take place now.
	printf("Converting %s from AMF to MOD, %s as output\n\n",inpt,outpt);
	printf("Translating header:	[ ]");

	workbuf = (char *)malloc(64*37);
	// no title for MOD
	memset(workbuf,0,64*37);
	fwrite(workbuf,1,20,outf);

	// Skip past ASYLUM Music Format v1.0
	fseek(inf,32,0);

	// load valuable data
	fread(workbuf,1,6,inf);
	numorders=workbuf[4];
        numpats=workbuf[3];

	// load orders
	memset(orders,0,256);
	fread(orders,1,numorders,inf);
	fseek(inf,294,0);

	gotoxy(26,wherey());
	printf("X]\n");
	printf("Translating instruments	[ ]");

	// load instruments
	fread(workbuf,37,64,inf);

	workptr=0;

	for (i=0;i<31;i++) {
		// status report
		gotoxy(26,wherey());
		putch('|');
		// now copy name
//		strcpy(insstruc,&(workbuf[workptr]));
		asm {
			push ds
			pop es
			mov cx,22
			mov si,workbuf
			add si,workptr
			lea di,insstruc
			rep movsb
		}
		// read in instrument data
		insstruc[24]=workbuf[workptr+22];
		// copy the rest
		insstruc[25]=workbuf[workptr+23];
/*		length=((workbuf[workptr+25])     |
		       ((workbuf[workptr+26])<<8) |
		       ((workbuf[workptr+27])<<16)|
		       ((workbuf[workptr+28])<<24)); */
		asm {
			mov si,workbuf
			add si,workptr
			db 0x66
			mov ax,[si+25]
			db 0x66
			shr ax,1
			db 0x66
			mov word ptr length,ax
		}

		insstruc[22]=((length>>8)&0xff);
		insstruc[23]=(length&0xff);
		gotoxy(26,wherey());
		putch('/');
/*		repstart=((workbuf[workptr+29]&0xff)     |
			 ((workbuf[workptr+30]&0xff)<<8) |
			 ((workbuf[workptr+31]&0xff)<<16)|
			 ((workbuf[workptr+32]&0xff)<<24))/2; */
		asm {
			mov si,workbuf
			add si,workptr
			db 0x66
			mov ax,[si+29]
			db 0x66
			shr ax,1
			db 0x66
			mov word ptr repstart,ax
		}

		insstruc[26]=((repstart>>8)&0xff);
		insstruc[27]=(repstart&0xff);
		gotoxy(26,wherey());
		putch('-');

/*		replen=((workbuf[workptr+33]&0xff)     |
		       ((workbuf[workptr+34]&0xff)<<8) |
		       ((workbuf[workptr+35]&0xff)<<16)|
		       ((workbuf[workptr+36]&0xff)<<24))/2; */

		asm {
			mov si,workbuf
			add si,workptr
			db 0x66
			mov ax,[si+33]
                        db 0x66
			shr ax,1
			db 0x66
			mov word ptr replen,ax
		}

		insstruc[28]=((replen>>8)&0xff);
		insstruc[29]=(replen&0xff);
		gotoxy(26,wherey());
		putch('\\');
		workptr+=37;
		// now write
		fwrite(insstruc,1,30,outf);
	}
	gotoxy(26,wherey());
	printf("X]\n");
	printf("Translating orders	[ ]");
	// now, misc data
	insstruc[0]=numorders;
	insstruc[1]=127;
	fwrite(insstruc,1,2,outf);
	// and orders
	fwrite(orders,1,128,outf);
	// finally, 8CHN
	insstruc[0]='8';
	insstruc[1]='C';
	insstruc[2]='H';
	insstruc[3]='N';
	fwrite(insstruc,1,4,outf);
	gotoxy(26,wherey());
	printf("X]\n");
	printf("Translating patterns	 0%");

	// now tackle patterns
	for(i=0;i<numpats;i++) {
		// load a pattern
		fread(workbuf,64,32,inf);
		// conversion
		for(j=0;j<512;j++) {
			// convert period->note;
			if (workbuf[j*4] != 0) {
				// lookup
				period=periodtable[workbuf[j*4]];
			} else
				period=0;
			ins=workbuf[j*4+1];
			// asm is the only way
//			effect=(workbuf[j*4+2] * 256)|workbuf[j*4+3];
			asm {
				lea si,workbuf
				mov cx,j
				shl cx,2
				mov bx,cx
				add bx,[si]
				mov ax,[bx+2]
				xchg ah,al
				mov effect,ax
			}
			// encode it
			insstruc[0]=(ins&0xf0)|((period&0xf00)>>8);
			insstruc[1]=(period&0xff);
			insstruc[2]=((ins&0xf)<<4)|((effect&0xf00)>>8);
			insstruc[3]=(effect&0xff);
			// write it
			fwrite(insstruc,1,4,outf);
		}
		// status display
		gotoxy(25,wherey());
		percentile=((100*(i*2048))/(2048*numpats));
		printf("%2ld%%",percentile);
	}
	gotoxy(25,wherey());
	printf("[X]\n");
	printf("Copying sample data	 0%");
	i=2662+(2048*numpats);
	// first, find our limit
	fseek(inf,0,2);
	k=ftell(inf);
	fseek(inf,i,0);
	// read 4096-byte blocks until there is no more room
	free(workbuf);
	workbuf=(char *)malloc(31*1024);
	while((k-i)>=31*1024) {
		fread(workbuf,31*1024,1,inf);
		fwrite(workbuf,31*1024,1,outf);
		i+=31*1024;
		gotoxy(25,wherey());
		percentile=((100*i)/k);
		printf("%2ld%%",percentile);
	}
	// finish it off
	if ((k-i) != 0) {
		fread(workbuf,k-i,1,inf);
		fwrite(workbuf,k-i,1,outf);
	}

	free(workbuf);
	gotoxy(25,wherey());
	printf("[X]\n");

	fclose(inf);
	fclose(outf);
	printf("\nConversion successful.\n");
	return 0;
}

