; ASYLUM v1.0 loader/player routine.
; (C) 1995 Power Source

.386P
include         dos32.inc

Sample          struc
Length          dd      0
S3MFinetune     dd      0
Volume          dd      0
RepeatStart     dd      0
RepeatEnd       dd      0
Repeating       dd      0
MemoryLocation  dd      0
                dd      0
                ends

FX              struc
C2Spd           dd      0
TonePortPeriod  dd      0
PlayingPeriod   dd      0
PlayingVolume   dd      0
TonePortSpd     dd      0
VibratoSpd      dd      0
TonePortDir     dd      0                       ;0=up,1=down
ArpNoteLocation dd      0
PatLoopCount    db      0
PatLoopPos      db      0
NoteDelayPer    dw      0
NoteDelayIns    db      0
VibratoPos      db      0
VibratoCmd      db      0
TremoloPos      db      0
EffectNumber    db      0
EffectValue     db      0
TremoloCmd      db      0
LastCmdFX       db      0
WavCtrl         db      0
InsNum          db      0
TonePortActive  db      0
                db      0
                dd      0
                dd      0
                dd      0
                dd      0
                ends

code32                  segment para public 'code' use32
assume                  cs:code32,ds:code32

; Speed of module (ticks/beat)
SpeedCounter    dd      0
SpeedMaster     dd      0

Samples         Sample  64 dup (<>)
PatternLoc      dd      128 dup (0)
PatternTable    dd      256 dup (0)
AMFHandle       dd      0
SongLength      dd      0
HighestPattern  dd      0
PeriodConst     dd      3579264         ;3546894 for PAL
                                        ;3579545 for NTSC
ChannelFX       FX      32 dup (<>)

CurrentRow      dd      0
CurrentSequence dd      0
CurrentPattOfs  dd      0
DCurrentSequence dd     0
DCurrentRow     dd      0

DispChan        dd      0

EffectSequence  dd      0
EffectRow       dd      0
EffectFlag      dd      0                       ;1=setpattern

PatDelayTime    dd      0
PatDelayFlag    dd      0

	; sine table for vibrato:
vibratoTable    DD      0,24,49,74,97,120,141,161
                DD      180,197,212,224,235,244,250,253
                DD      255,253,250,244,235,224,212,197
                DD      180,161,141,120,97,74,49,24

NoteFXTable     dd      offset SetArpeggio
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset SetPanning
                dd      offset SampleOfs
                dd      offset _ret
                dd      offset PatternJump
                dd      offset SetVolume
                dd      offset PatternSkip
                dd      offset ENoteFX
                dd      offset SetSpeed

TickFXTable     dd      offset DoArpeggio
                dd      offset PortaUp
                dd      offset PortaDown
                dd      offset PortaToNote
                dd      offset Vibrato
                dd      offset PTNVolSlide
                dd      offset VIBVolSlide
                dd      offset Tremolo
                dd      offset _ret
                dd      offset _ret
                dd      offset VolumeSlide
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset ETickFX
                dd      offset _ret

ENFXTable       dd      offset _ret
                dd      offset FineSlideUp
                dd      offset FineSlideDown
                dd      offset _ret
                dd      offset SetVibWaveform
                dd      offset _ret
                dd      offset PatternLoop
                dd      offset SetTrmWaveform
                dd      offset SetMajPan
                dd      offset _ret
                dd      offset FineVSlUp
                dd      offset FineVSlDn
                dd      offset _ret
                dd      offset _ret
                dd      offset PatDelay
                dd      offset _ret

ETFXTable       dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset _ret
                dd      offset Retrig
                dd      offset _ret
                dd      offset _ret
                dd      offset NoteCut
                dd      offset NoteDelay
                dd      offset _ret
                dd      offset _ret

SampleTableBuf  db      2662-294 dup (0)

FinetuneTable   dd      8363,8413,8463,8529,8581,8651,8723,8757
                dd      7895,7941,7985,8046,8107,8169,8232,8280

PeriodTable     dd      6848,6464,6096,5760,5424,5120,4832,4560,4304,4064,3840,3628
                dd      3424,3232,3048,2880,2712,2560,2416,2280,2152,2032,1920,1814
                dd      1712,1616,1524,1440,1356,1280,1208,1140,1076,1016, 960, 907
                dd       856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453
                dd       428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226
                dd       214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113
                dd       107, 101,  95,  90,  85,  80,  75,  71,  67,  63,  60,  56
                dd        53,  50,  47,  45,  42,  40,  37,  35,  33,  31,  30,  28

AMFScreenText   db      "Pattern: 000 / 000   Powersource protected mode ASYLUM v1.0 player v1.0         "
                db      "Row:      00 /  00   (C) 1995 Mr. P / Power Source                              "
                db      "Offset     RepStart   RepEnd     Per.  SRate ActRt Vl Efx                       "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
                db      "                                                                                "
AMFScreenLength =       $-AMFScreenText

extrn           SSInit:near,SSDeInit:near,SSSetGlobalVol:near
extrn           SSSetSample:near,SSSetOffset:near,SSSetPanning:near
extrn           SSSetFrequency:near,SSSetVolume:near
extrn           SSSetTickRout:near,SSSetBPM:near
extrn           SSGetChannelInf:near,SSIsChannelOn:near
extrn           SSGetChannelRt:near,SSShutOffChn:near

extrn           ModuleDone:dword

public          AMFLoad,AMFScreen

AMFLoad                 proc    near            ; Works 100%
; EDX=pointer to module (as always).
; NO DETECTION IS PERFORMED, but this is not a general module player.
; always must succeed.
; open module
        mov     eax,3d00h
        int     21h
        mov     AMFHandle,eax
; load certain variables.
        mov     ebx,eax
        mov     eax,4200h
        mov     edx,32
        int     21h
        mov     eax,3f00h
        mov     ebx,AMFHandle
        mov     ecx,294-32
        mov     edx,offset SampleTableBuf
        int     21h

        movzx   eax,byte ptr SampleTableBuf
        mov     SpeedCounter,eax
        mov     SpeedMaster,eax
        movzx   eax,byte ptr SampleTableBuf[1]
        call    SSSetBPM
        movzx   eax,byte ptr SampleTableBuf[3]
        mov     HighestPattern,eax
        movzx   eax,byte ptr SampleTableBuf[4]
        mov     SongLength,eax

; and now.. after this interesting and instructive prologue, we are privileged
; to present... this great historic epic drama
; "ASTERIX AND CLEOPATRA" :P
        mov     ecx,eax
        mov     esi,offset SampleTableBuf+6
        mov     edi,offset PatternTable
AMFPatXferLoop:
        movzx   eax,byte ptr [esi]
        mov     [edi],eax
        inc     esi
        add     edi,4
        dec     ecx
        jnz     AMFPatXferLoop

; NOW... sample-xfer time!!!
        mov     eax,3f00h
        mov     ebx,AMFHandle
        mov     ecx,2662-294
        mov     edx,offset SampleTableBuf
        int     21h

        mov     esi,offset SampleTableBuf
        mov     edi,offset Samples
        mov     ecx,64
AMFSampInfoXferLoop:
; Skip the name - who CARES!? this ain't no pretty visual music player!
; Xfer finetune
        movzx   eax,byte ptr [esi+22]
        and     eax,0fh
        mov     eax,[eax*4+offset Finetunetable]
        mov     [edi+S3MFinetune],eax
; Volume
        movzx   eax,byte ptr [esi+23]
        mov     [edi+Volume],eax
; Sample length
        mov     eax,[esi+25]
        mov     [edi+Length],eax
; Sample repeat/end
        mov     eax,[esi+29]
        mov     edx,[esi+33]
        mov     [edi+RepeatStart],eax
        cmp     edx,2
        jnz     AMFSampInfoXferRepLenOK
        xor     edx,edx
AMFSampInfoXferRepLenOK:
        add     eax,edx
        mov     [edi+RepeatEnd],eax
        or      edx,edx
        setnz   al
        movzx   eax,al
        mov     [edi+Repeating],eax
; Allocate memory for the sample
        mov     edx,[edi+Length]
        or      edx,edx
        jz      AMFSampInfoXferNothing2Allocate
        and     edx,NOT 4095
        add     edx,4096
        call    Allocate_Memory
        mov     [edi+MemoryLocation],edx
AMFSampInfoXferNothing2Allocate:
; And back.
        add     esi,37
        add     edi,size Sample
        dec     ecx
        jnz     AMFSampInfoXferLoop

; Now, loadez patterns.
; Seek to proper spot.
        mov     eax,4200h
        mov     ebx,AMFHandle
        mov     edx,2662
        int     21h

        mov     ecx,HighestPattern
        mov     edi,offset PatternLoc
AMFLoadPatternLoop:
; Allocate memory for a pattern. [2k each, but DOS32 is so cheap it only
; allocates in 4k blocks. Must convert to WATCOM!!!]
        mov     edx,4096
        call    Allocate_Memory
        mov     [edi],edx
; Load the pattern.
        push    ecx
        mov     eax,3f00h
        mov     ebx,AMFHandle
        mov     ecx,2048
        int     21h
        pop     ecx
; Load all patterns
        add     edi,4
        dec     ecx
        jnz     AMFLoadPatternLoop
; Sample-load time.
        mov     ecx,64
        mov     esi,offset Samples
AMFLoadSampleLoop:
; Is there a sample?
        cmp     [esi+Length],0
        jz      AMFLoadSampleSkipSample
; Yup-load it.
        push    ecx
        mov     ecx,[esi+Length]
        mov     edx,[esi+MemoryLocation]
        mov     ebx,AMFHandle
        mov     eax,3f00h
        int     21h
        pop     ecx
; copy last sample from LoopStart to LoopEnd..
        mov     ebx,[esi+RepeatStart]
        mov     edx,[esi+RepeatEnd]
        add     ebx,[esi+MemoryLocation]
        add     edx,[esi+MemoryLocation]
        mov     al,[ebx]
        mov     [edx],al
        mov     edx,[esi+Length]
        add     edx,[esi+MemoryLocation]
        mov     [edx],al
AMFLoadSampleSkipSample:
; Next.
        add     esi,size Sample
        dec     ecx
        jnz     AMFLoadSampleLoop
; Module is loaded.
        mov     SpeedCounter,1
        mov     CurrentRow,0
        mov     CurrentSequence,0
        mov     eax,[PatternTable]
        mov     eax,[eax*4+PatternLoc]
        mov     CurrentPattOfs,eax

        mov     eax,offset AMFTick
        call    SSSetTickRout
; Now: calculate total volume.
        mov     eax,128
        call    SSSetGlobalVol
; Set panning for channels
        mov     ecx,4
        xor     edx,edx
SetPanLoop:
        xor     eax,eax
        call    SSSetPanning
        inc     edx
        mov     eax,100h
        call    SSSetPanning
        inc     edx
        call    SSSetPanning
        inc     edx
        xor     eax,eax
        call    SSSetPanning
        inc     edx
        dec     ecx
        jnz     SetPanLoop
;        mov     ecx,16
;        xor     edx,edx
;        mov     eax,80h
;SetPanLoop:
;        call    SSSetPanning
;        inc     edx
;        dec     ecx
;        jnz     SetPanLoop
        ret
AMFLoad         endp

AMFScreen       proc    near
; save-all-registers-?
        pushad
; calculate real playing numbers
        mov     eax,CurrentSequence
        mov     ebx,CurrentRow
        dec     ebx
        jns     AMFScreencalcok
        mov     ebx,3fh
        dec     eax
AMFScreencalcok:
        mov     DCurrentSequence,eax
        mov     DCurrentRow,ebx

; NOW: display pattern numbers.
        mov     edi,offset AMFScreenText
        mov     eax,DCurrentSequence
        mov     ebx,10
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        add     dl,30h
        mov     [edi+9],dl
        pop     edx
        add     dl,30h
        mov     [edi+10],dl
        pop     edx
        add     dl,30h
        mov     [edi+11],dl

        mov     eax,SongLength
        mov     ebx,10
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        add     dl,30h
        mov     [edi+15],dl
        pop     edx
        add     dl,30h
        mov     [edi+16],dl
        pop     edx
        add     dl,30h
        mov     [edi+17],dl

; now row numbers
        mov     eax,DCurrentRow
        mov     edx,eax
        shr     edx,4
        add     edx,30h
        cmp     edx,39h
        jbe     AMFScreenRow1Low
        add     edx,7
AMFScreenRow1Low:
        mov     [edi+90],dl
        mov     edx,eax
        and     edx,0fh
        add     edx,30h
        cmp     edx,39h
        jbe     AMFScreenRow2Low
        add     edx,7
AMFScreenRow2Low:
        mov     [edi+91],dl
        mov     word ptr [edi+96],3034h

        add     edi,240
; NOW: stuff we can get locally.
; Period, samplerate, volume.
        mov     ecx,8
        mov     edx,offset ChannelFX
AMFScreenDoChannelFX:
        push    ecx
        push    edx
        mov     DispChan,ecx
;----------------------------Is it on?-----------------------------------------
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSIsChannelOn
        pop     edx
        or      eax,eax
        jz      AMFScreenNotPlaying
;------------------------------------Offset------------------------------------
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSGetChannelInf

        push    eax
        mov     eax,ecx
        xor     edx,edx
        mov     ecx,10
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx

        add     edx,30h
        mov     [edi],dl
        pop     edx
        add     edx,30h
        mov     [edi+1],dl
        pop     edx
        add     edx,30h
        mov     [edi+2],dl
        pop     edx
        add     edx,30h
        mov     [edi+3],dl
        pop     edx
        add     edx,30h
        mov     [edi+4],dl
        pop     edx
        add     edx,30h
        mov     [edi+5],dl
        pop     edx
        add     edx,30h
        mov     [edi+6],dl
        pop     edx
        add     edx,30h
        mov     [edi+7],dl
        pop     edx
        add     edx,30h
        mov     [edi+8],dl
        pop     edx
        add     edx,30h
        mov     [edi+9],dl
        pop     eax
;---------------------------------loopstart------------------------------------
        xor     edx,edx
        mov     ecx,10
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx

        add     edx,30h
        mov     [edi+11],dl
        pop     edx
        add     edx,30h
        mov     [edi+12],dl
        pop     edx
        add     edx,30h
        mov     [edi+13],dl
        pop     edx
        add     edx,30h
        mov     [edi+14],dl
        pop     edx
        add     edx,30h
        mov     [edi+15],dl
        pop     edx
        add     edx,30h
        mov     [edi+16],dl
        pop     edx
        add     edx,30h
        mov     [edi+17],dl
        pop     edx
        add     edx,30h
        mov     [edi+18],dl
        pop     edx
        add     edx,30h
        mov     [edi+19],dl
        pop     edx
        add     edx,30h
        mov     [edi+20],dl
;---------------------------loopend-------------------------------------------
        mov     eax,ebx
        xor     edx,edx
        mov     ecx,10
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx
        push    edx
        xor     edx,edx
        div     ecx

        add     edx,30h
        mov     [edi+22],dl
        pop     edx
        add     edx,30h
        mov     [edi+23],dl
        pop     edx
        add     edx,30h
        mov     [edi+24],dl
        pop     edx
        add     edx,30h
        mov     [edi+25],dl
        pop     edx
        add     edx,30h
        mov     [edi+26],dl
        pop     edx
        add     edx,30h
        mov     [edi+27],dl
        pop     edx
        add     edx,30h
        mov     [edi+28],dl
        pop     edx
        add     edx,30h
        mov     [edi+29],dl
        pop     edx
        add     edx,30h
        mov     [edi+30],dl
        pop     edx
        add     edx,30h
        mov     [edi+31],dl
        pop     edx
;----------------------------Period------------------------
        mov     eax,[edx+PlayingPeriod]
        or      eax,eax
        jz      AMFScreenNotPlaying

        push    edx
        mov     ebx,10
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx

        add     edx,30h
        mov     [edi+33],dl
        pop     edx
        add     edx,30h
        mov     [edi+34],dl
        pop     edx
        add     edx,30h
        mov     [edi+35],dl
        pop     edx
        add     edx,30h
        mov     [edi+36],dl
        pop     edx
        add     edx,30h
        mov     [edi+37],dl
        pop     edx
; ---------------------------------samplerate---------------------------------
        mov     eax,[edx+PlayingPeriod]
        push    edx
        mov     ebx,eax
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx

        mov     ebx,10
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx

        add     edx,30h
        mov     [edi+39],dl
        pop     edx
        add     edx,30h
        mov     [edi+40],dl
        pop     edx
        add     edx,30h
        mov     [edi+41],dl
        pop     edx
        add     edx,30h
        mov     [edi+42],dl
        pop     edx
        add     edx,30h
        mov     [edi+43],dl
        pop     edx

        push    edx
        mov     edx,8
        sub     edx,DispChan
        call    SSGetChannelRt

        mov     ebx,10
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx

        add     edx,30h
        mov     [edi+45],dl
        pop     edx
        add     edx,30h
        mov     [edi+46],dl
        pop     edx
        add     edx,30h
        mov     [edi+47],dl
        pop     edx
        add     edx,30h
        mov     [edi+48],dl
        pop     edx
        add     edx,30h
        mov     [edi+49],dl
        pop     edx
;---------------------------------volume--------------------------------------
        mov     eax,[edx+PlayingVolume]
        push    edx

        mov     ebx,10
        xor     edx,edx
        div     ebx
        push    edx
        xor     edx,edx
        div     ebx

        add     edx,30h
        mov     [edi+51],dl
        pop     edx
        add     edx,30h
        mov     [edi+52],dl
        pop     edx

;FX
        mov     al,[edx+EffectNumber]
        mov     ah,al
        shr     al,4
        and     ah,0fh
        add     ax,3030h
        cmp     ah,3Ah
        jb      AMFScreenFX1NO
        add     ah,7
AMFScreenFX1NO:
        cmp     al,3AH
        jb      AMFScreenFX2NO
        add     al,7
AMFScreenFX2NO:
        mov     [edi+54],ax

        mov     al,[edx+EffectValue]
        mov     ah,al
        shr     al,4
        and     ah,0fh
        add     ax,3030h
        cmp     ah,3Ah
        jb      AMFScreenFX3NO
        add     ah,7
AMFScreenFX3NO:
        cmp     al,3AH
        jb      AMFScreenFX4NO
        add     al,7
AMFScreenFX4NO:
        mov     [edi+56],ax

        jmp     AMFScreenDoneChannel

AMFScreenNotPlaying:
; fill column with -s
        mov     dword ptr [edi],'----'
        mov     dword ptr [edi+4],'----'
        mov     word ptr [edi+8],'--'
        mov     dword ptr [edi+11],'----'
        mov     dword ptr [edi+15],'----'
        mov     word ptr [edi+19],'--'

        mov     dword ptr [edi+22],'----'
        mov     dword ptr [edi+26],'----'
        mov     word ptr [edi+30],'--'
        mov     dword ptr [edi+54],'----'

AMFScreenNoNote:
        mov     dword ptr [edi+33],'----'
        mov     byte ptr [edi+37],'-'

        mov     dword ptr [edi+39],'----'
        mov     byte ptr [edi+43],'-'

        mov     dword ptr [edi+45],'----'
        mov     byte ptr [edi+49],'-'

        mov     word ptr [edi+51],'--'
AMFScreenDoneChannel:
        pop     edx
        pop     ecx
        add     edi,80
        add     edx,size FX
        dec     ecx
        jnz     AMFScreenDoChannelFX

AMFScreenskipitall:
; Load EDI with screen offset.
        mov     edi,_0b8000h
; Display screen.
        mov     ecx,AMFScreenLength
        mov     esi,offset AMFScreenText
        mov     ah,7
AMFScreenShowLoop:
        lodsb
        stosw
        dec     ecx
        jnz     AMFScreenShowLoop
        popad
        ret
AMFScreen       endp

AMFTick         proc    near
        cmp     ModuleDone,1
        jnz     AMFNotDone
        ret
AMFNotDone:
        dec     SpeedCounter
        jz      AMFDoNextLine
; FX go here
        mov     ecx,8
        mov     edx,offset ChannelFX
AMFDoFX:
        xor     eax,eax
        mov     al,[edx+EffectNumber]
        mov     bl,[edx+EffectValue]
        or      bl,al
        jz      AMFDoFXSkip
        push    ecx
        push    edx
        call    dword ptr [eax*4+offset TickFXTable]
        pop     edx
        pop     ecx
AMFDoFXSkip:
        add     edx,size FX
        dec     ecx
        jnz     AMFDoFX
        call    AMFScreen
        ret
AMFDoNextLine:
; esi needs saving: its the DMA buffer pointer.
        push    esi
        mov     EffectFlag,0
        mov     eax,SpeedMaster
        mov     SpeedCounter,eax
; Check for PATTERN DELAY.
        cmp     PatDelayTime,0
        jnz     AMFDoPatDelay
; No pattern delay.
        mov     PatDelayFlag,0
        mov     ecx,8
        mov     esi,CurrentPattOfs
AMFDoChannelLoop:
        call    AMFDoChannel
        dec     ecx
        jnz     AMFDoChannelLoop
; Check for pattern-location-changing effect
        cmp     EffectFlag,0
        jnz     AMFLocationChange
        inc     CurrentRow
        cmp     CurrentRow,64
        jz      AMFNextPattern
AMFDoneLocationChange:
        mov     CurrentPattOfs,esi
        pop     esi
        call    AMFScreen
        ret
AMFLocationChange:
; location change code here
        mov     eax,EffectSequence
        mov     ebx,EffectRow
        mov     CurrentRow,ebx
        mov     CurrentSequence,eax
        mov     eax,[eax*4+PatternTable]
        mov     eax,[eax*4+PatternLoc]
        imul    ebx,32
        add     eax,ebx
        mov     esi,eax
        jmp     AMFFinishLocationChange
AMFNextPattern:
; get next pattern.
        mov     CurrentRow,0
        mov     eax,CurrentSequence
        inc     eax
        cmp     eax,SongLength
        jae     AMFEndofSong
        mov     CurrentSequence,eax
        mov     eax,[eax*4+PatternTable]
        mov     eax,[eax*4+PatternLoc]
        mov     esi,eax
AMFFinishLocationChange:
; clear ALL pattern loop indicators.
        pushad
        mov     ecx,8
        mov     edx,offset ChannelFX
AMFNPClearPL:
        mov     byte ptr [edx+PatLoopPos],0
        add     edx,size FX
        dec     ecx
        jnz     AMFNPClearPL
        popad
        jmp     AMFDoneLocationChange
AMFEndOfSong:
        mov     ModuleDone,1
        jmp     AMFDoneLocationChange
AMFDoPatDelay:
; Pattern delay EFFECT. Effects ONLY.
        dec     PatDelayTime
; Now do MOD effects.
        mov     ecx,8
        mov     edx,offset ChannelFX
AMFDoPDFX:
        xor     eax,eax
        mov     al,[edx+EffectNumber]
        mov     bl,[edx+EffectValue]
        or      bl,al
        jz      AMFDoPDFXSkip
        push    ecx
        push    edx
        call    dword ptr [eax*4+offset NoteFXTable]
        pop     edx
        pop     ecx
AMFDoPDFXSkip:
        add     edx,size FX
        dec     ecx
        jnz     AMFDoPDFX
        pop     esi
        call    AMFScreen
        ret
AMFTick         endp

AMFDoChannel    proc    near
; Each channel takes 4 bytes.
        push    ebp
; AMF: byte 1=note, byte2=ins, byte3,4=effect
; translate note to PERIOD, and blast the rest
        movzx   ebx,byte ptr [esi+1]
        movzx   edx,word ptr [esi+2]
        xchg    dh,dl
        movzx   eax,byte ptr [esi]
        add     esi,4
        or      eax,eax
        jz      AMFDCXLNoNote
        cmp     eax,96
        jb      AMFDCNoteBelow
        mov     eax,95
AMFDCNoteBelow:
        mov     eax,[eax*4+offset PeriodTable]
AMFDCXLNoNote:
; Set EBP to FX-structure.
        mov     ebp,8
        sub     ebp,ecx
        shl     ebp,6                           ; REPLACE #3
        add     ebp,offset ChannelFX

; Clear out effects structure.
; Reset period.
        cmp     byte ptr [ebp+EffectNumber],4
        jz      AMFDoChannelResetPer
        cmp     byte ptr [ebp+EffectNumber],7
        jz      AMFDoChannelResetVol
        cmp     byte ptr [ebp+EffectNumber],0
        jnz     AMFDoChannelSkipReset
        cmp     byte ptr [ebp+EffectValue],0
        jz      AMFDoChannelSkipReset
AMFDoChannelResetPer:
        cmp     dword ptr [ebp+PlayingPeriod],0
        jz      AMFDoChannelSkipReset
        pushad
        mov     ebx,[ebp+PlayingPeriod]
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        mov     edx,8
        sub     edx,ecx
        call    SSSetFrequency
AMFDoChannelResetAbort:
        popad
        jmp     AMFDoChannelSkipReset
AMFDoChannelResetVol:
        pushad
        mov     eax,[ebp+PlayingVolume]
        mov     edx,8
        sub     edx,ecx
        call    SSSetVolume
        popad
AMFDoChannelSkipReset:
; Check for effect ED (Note Delay), if so then special handle.
        push    edx
        and     edx,0ff0h
        cmp     edx,0ed0h
        jz      AMFDoChannelFXED
AMFDoChannelFXED0:
        pop     edx
; Check for new -sample-.
        or      ebx,ebx
        jz      AMFDoChannelNoNewIns
        pushad
        mov     edx,8
        sub     edx,ecx
        push    edx
; Load sample info into memory.
        dec     ebx
        shl     ebx,5
        mov     edx,ebx
        mov     eax,[edx+Volume+offset Samples]
        mov     [ebp+PlayingVolume],eax
        mov     ecx,[edx+Length+offset Samples]
        mov     ebx,[edx+MemoryLocation+offset Samples]
        mov     esi,[edx+RepeatStart+offset Samples]
        mov     edi,[edx+RepeatEnd+offset Samples]
        mov     ebp,[edx+Repeating+offset Samples]
        pop     edx
        call    SSSetSample
        popad
        push    eax
        push    ebx
        push    edx
        mov     edx,ebx
        dec     ebx
        shl     ebx,5
        mov     eax,[ebx+S3MFinetune+offset Samples]
        mov     [ebp+C2Spd],eax
; ADDITIONAL FIX to accomodate ST3-created AMFs...?
        cmp     [ebp+InsNum],dl
        jz      AMFDoChannelReVolIns
        mov     [ebp+InsNum],dl
        mov     edx,8
        sub     edx,ecx
        xor     eax,eax
        call    SSSetOffset
AMFDoChannelReVolIns:
        pop     edx
        pop     ebx
        pop     eax
AMFDoChannelNoNewIns:
; WRONGOID.
; Next: check for effect THREE, if so then skip right to the FX.
        cmp     dh,3
        jz      AMFDoChannelFX3
; If not, check for effect FIVE (PortaToNote+VolumeSlide), since note may
; change.
        cmp     dh,5
        jz      AMFDoChannelFX5
; Check for new period.
        or      eax,eax
        jz      AMFDoChannelNoNewPeriod
; New period. Set respective channel.
        pushad
        mov     edx,8
        sub     edx,ecx
        push    edx
; since SSSetFreq doesn't reset pointer to 0 for us, reset it ourselves.
        push    eax
        push    edx
        xor     eax,eax
        call    SSSetOffset
        pop     edx
        pop     eax
; First: calculate finetuned period.
        mov     ebx,8363
        mul     ebx
        mov     ebx,[ebp+C2Spd]
        or      ebx,ebx
        jz      AMFDoChannelNoteAbort
        div     ebx

        shr     ebx,1
        sub     ebx,edx
        adc     eax,0

        mov     ebx,eax
        mov     [ebp+PlayingPeriod],eax
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        pop     edx
        push    edx
        call    SSSetFrequency
AMFDoChannelNoteAbort:
        pop     edx
        popad
; RESET VIBRATO/TREMOLO (if needed).
        pushad
        mov     al,[ebp+WavCtrl]
        test    al,100b
        jnz     AMFDoChannelNoResetVib
        mov     byte ptr [ebp+VibratoPos],0
AMFDoChannelNoResetVib:
        test    al,100000b
        jnz     AMFDoChannelNoResetTrem
        mov     byte ptr [ebp+TremoloPos],0
AMFDoChannelNoResetTrem:
        popad
        jmp     AMFDoChannelNoNewPeriod
; eh.
AMFDoChannelFX3:
; Effect 3-porta to note. SO...
        pushad
; New note?
        or      eax,eax
        jz      AMFDoChannelPTNNoNewNote

        mov     ebx,8363
        mul     ebx
        mov     ebx,[ebp+C2Spd]
        or      ebx,ebx
        jz      AMFDoChannelPTNNoPP2
        div     ebx
        shr     ebx,1
        sub     ebx,edx
        adc     eax,0
        mov     [ebp+TonePortPeriod],eax
        cmp     eax,[ebp+PlayingPeriod]
        seta    al
        movzx   eax,al
        mov     [ebp+TonePortDir],eax
        popad
        push    ebx
        movzx   ebx,dl
        or      ebx,ebx
        jz      AMFDoChannelPTNNoSpd
        mov     [ebp+TonePortSpd],ebx
AMFDoChannelPTNNoSpd:
        cmp     [ebp+PlayingPeriod],0
        jz      AMFDoChannelPTNNoPP
        mov     [ebp+TonePortActive],1
        pop     ebx
        jmp     AMFDoChannelNoNewPeriod
AMFDoChannelPTNNoPP:
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSShutOffChn
        pop     edx
        pop     ebx
        jmp     AMFDoChannelNoNewPeriod

AMFDoChannelPTNNoPP2:
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSShutOffChn
        pop     edx
        popad
        jmp     AMFDoChannelNoNewPeriod

AMFDoChannelPTNNoNewNote:
        mov     eax,[ebp+TonePortPeriod]
        cmp     eax,[ebp+PlayingPeriod]
        seta    al
        movzx   eax,al
        mov     [ebp+TonePortDir],eax
        popad
        push    ebx
        movzx   ebx,dl
        or      ebx,ebx
        jz      AMFDoChannelPTNNoSpd2
        mov     [ebp+TonePortSpd],ebx
AMFDoChannelPTNNoSpd2:
        pop     ebx
        jmp     AMFDoChannelNoNewPeriod

AMFDoChannelFXED:
; Effect ED-note delay. Store relative info in parm. block.
        pop     edx
        push    edx
        and     edx,0fh
        or      edx,edx
        jz      AMFDoChannelFXED0
        pop     edx
        pushad
        mov     [ebp+NoteDelayIns],bl
; retrieve C2SPD
        movzx   ebx,bl
        or      ebx,ebx
        jnz     AMFDoChannelFXEDNewIns
AMFDoChannelFXEDDoneHandlingIns:
        mov     ebx,8363
        mul     ebx
        mov     ebx,[ebp+C2Spd]
        div     ebx
        mov     [ebp+NoteDelayPer],ax
AMFDoChannelFXEDSkipSpd:
        popad
        jmp     AMFDoChannelNoNewPeriod

AMFDoChannelFXEDNewIns:
; retrieve new finetune
        push    eax
        push    ebx
        dec     ebx
        shl     ebx,5
        mov     eax,[ebx+S3MFineTune+offset Samples]
        mov     [ebp+C2Spd],eax
        pop     ebx
        pop     eax
        jmp     AMFDoChannelFXEDDoneHandlingIns

AMFDoChannelFX5:
; Effect 3-porta to note. SO...
        pushad
; New note?
        or      eax,eax
        jz      AMFDoChannelFX5NoNewNote

        mov     ebx,8363
        mul     ebx
        mov     ebx,[ebp+C2Spd]
        or      ebx,ebx
        jz      AMFDoChannelFX5NoPP2
        div     ebx
        shr     ebx,1
        sub     ebx,edx
        adc     eax,0
        mov     [ebp+TonePortPeriod],eax
        cmp     eax,[ebp+PlayingPeriod]
        seta    al
        movzx   eax,al
        mov     [ebp+TonePortDir],eax
        popad
        cmp     [ebp+PlayingPeriod],0
        jz      AMFDoChannelFX5NoPP
        mov     [ebp+TonePortActive],1
        jmp     AMFDoChannelNoNewPeriod

AMFDoChannelFX5NoPP:
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSShutOffChn
        pop     edx
        pop     ebx
        jmp     AMFDoChannelNoNewPeriod

AMFDoChannelFX5NoPP2:
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSShutOffChn
        pop     edx
        popad
        jmp     AMFDoChannelNoNewPeriod

AMFDoChannelFX5NoNewNote:
        mov     eax,[ebp+TonePortPeriod]
        cmp     eax,[ebp+PlayingPeriod]
        seta    al
        movzx   eax,al
        mov     [ebp+TonePortDir],eax
        popad

AMFDoChannelNoNewPeriod:
; Effectoid time.
        pushad
        movzx   eax,dh
        movzx   ebx,dl
        mov     [ebp+EffectNumber],al
        mov     dl,[ebp+EffectValue]
        mov     [ebp+EffectValue],bl
        or      ebx,eax
        jz      AMFDoChannelNoEffect

        or      ebx,ebx
        jnz     AMFDoChannelDiffEffect
        mov     [ebp+EffectValue],dl

AMFDoChannelDiffEffect:
        mov     [ebp+LastCmdFX],dl
        mov     edx,ebp
        call    dword ptr [eax*4+offset NoteFXTable]
AMFDoChannelNoEffect:
        popad
        pop     ebp
        ret
AMFDoChannel    endp

;---------------------------EFFECTS FOR AMF PLAYING---------------------------
; notes for effect-playing:
; ECX/EDX _NOT_ TO BE CHANGED.
; ECX=8-current channel
; EDX=pointer to the FX structure
align   16
_ret:
        ret

align   16
SetArpeggio     proc    near
; All we need to do is figure out regular period from the real period.
; Reverse the formula.
        push    edx
        mov     eax,[edx+PlayingPeriod]
        mov     ebx,[edx+C2Spd]
        mul     ebx
        mov     ebx,8363
        div     ebx
        shr     ebx,1
        sub     ebx,edx
        adc     eax,0
; NOW: find period in table.
        mov     ebx,offset PeriodTable
SetArpFindPerLoop:
        cmp     eax,[ebx]
        jae     SetArpFound
        add     ebx,4
        jmp     SetArpFindPerLoop
align   16
SetArpFound:
        sub     ebx,offset PeriodTable
        shr     ebx,2
        pop     edx
        mov     [edx+ArpNoteLocation],ebx
        ret
SetArpeggio     endp

align   16
SetPanning      proc    near
; set panning of a channel.
        push    edx
        xor     eax,eax
        mov     al,[edx+EffectValue]
        mov     edx,8
        sub     edx,ecx
        call    SSSetPanning
        pop     edx
        ret
SetPanning      endp

align   16
SampleOfs       proc    near
; set "sample offset" of channel.
; ALWAYS 8-bit.
        push    edx
        xor     eax,eax
        mov     al,[edx+EffectValue]
        mov     edx,8
        shl     eax,8
        sub     edx,ecx
        call    SSSetOffset
        pop     edx
        ret
SampleOfs       endp

align   16
PatternJump     proc    near
; set current pattern.
        xor     eax,eax
        mov     al,[edx+EffectValue]
        mov     EffectSequence,eax
        mov     EffectRow,0
        mov     EffectFlag,1
        ret
PatternJump     endp

align   16
SetVolume       proc    near
; set the volume of channel.
        xor     eax,eax
        mov     al,[edx+EffectValue]
        cmp     eax,40h
        jbe     SetVolumeInLimits
        mov     eax,40h
SetVolumeInLimits:
        mov     [edx+PlayingVolume],eax
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSSetVolume
        pop     edx
        ret
SetVolume       endp

align   16
PatternSkip     proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
; decimal! ack!
        mov     ebx,eax
        shr     eax,4
        and     ebx,0fh
        imul    eax,10
        add     eax,ebx
        mov     EffectRow,eax
; next pattern
        mov     eax,CurrentSequence
        inc     eax
        cmp     eax,SongLength
        jb      PatternSkipNotEOS
        mov     ModuleDone,1
PatternSkipNotEOS:
        mov     EffectSequence,eax
        mov     EffectFlag,1
        ret
PatternSkip     endp

align   16
SetSpeed        proc    near
; command<20h: set ticks
; command>=20h: set BPM
        xor     eax,eax
        mov     al,[edx+EffectValue]
        cmp     eax,20h
        jae     SetSpeedBPM
        mov     SpeedMaster,eax
        mov     SpeedCounter,eax
        ret
align   16
SetSpeedBPM:
        call    SSSetBPM
        ret
SetSpeed        endp

;---------------------------------Tick FX.-------------------------------------
align   16
DoArpeggio      proc    near
; Determine tick bits..
        push    edx
        push    edi
        mov     eax,SpeedCounter
        sub     eax,SpeedMaster
        neg     eax
        mov     bl,3
        div     bl
        cmp     ah,2
        jz      ArpTick2
        cmp     ah,1
        jz      ArpTick1
; tick 0 - normal note.
        mov     eax,[edx+ArpNoteLocation]
        jmp     ArpSetNote
ArpTick2:
        mov     ebx,[edx+ArpNoteLocation]
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        add     eax,ebx
        jmp     ArpSetNote
ArpTick1:
        mov     ebx,[edx+ArpNoteLocation]
        xor     eax,eax
        mov     al,[edx+EffectValue]
        shr     eax,4
        add     eax,ebx
ArpSetNote:
        mov     eax,[offset PeriodTable+eax*4]
        cmp     dword ptr [edx+C2Spd],0
        jz      ArpAbort
; compensate for finetune
        mov     edi,edx
        mov     ebx,8363
        mul     ebx
        mov     ebx,[edi+C2Spd]
        div     ebx
        shr     ebx,1
        sub     ebx,edx
        adc     eax,0
; do freq. bit
        mov     ebx,eax
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        mov     edx,8
        sub     edx,ecx
        call    SSSetFrequency
ArpAbort:
        pop     edi
        pop     edx
        ret
DoArpeggio      endp

align   16
PortaUp         proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        or      eax,eax
        jnz     PUNoCmd
        mov     al,[edx+LastCmdFX]
PUNoCmd:
        mov     ebx,[edx+PlayingPeriod]
        sub     ebx,eax
        cmp     ebx,28
        jge     PUWithinLimits                  ; make DAMN sure of negatives
        mov     ebx,28
PUWithinLimits:
        mov     [edx+PlayingPeriod],ebx
        push    edx
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        mov     edx,8
        sub     edx,ecx
        call    SSSetFrequency
        pop     edx
        ret
PortaUp         endp

align   16
PortaDown       proc    near
        xor     ebx,ebx
        mov     bl,[edx+EffectValue]
        or      ebx,ebx
        jnz     PDNoCmd
        mov     bl,[edx+LastCmdFX]
PDNoCmd:
        add     ebx,[edx+PlayingPeriod]
        cmp     ebx,1712
        jle     PDWithinLimits                  ; make DAMN sure of negatives
        mov     ebx,1712
PDWithinLimits:
        mov     [edx+PlayingPeriod],ebx
        push    edx
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        mov     edx,8
        sub     edx,ecx
        call    SSSetFrequency
        pop     edx
        ret
PortaDown       endp

align   16
PortaToNote     proc    near
; Check to see if we are SUPPOSED to be moving.
        cmp     [edx+TonePortActive],1
        jz      PTNOn
        ret
PTNOn:
; Check to see if we are sitting on note.
        mov     eax,[edx+PlayingPeriod]
        cmp     eax,[edx+TonePortPeriod]
        jnz     PTNNotOnNote
        mov     [edx+TonePortActive],0
        ret
align   16
PTNNotOnNote:
; OK, check direction.
        cmp     [edx+TonePortDir],0
        jnz     PTNDown
; Up.
        mov     ebx,[edx+PlayingPeriod]
        sub     ebx,[edx+TonePortSpd]
        cmp     ebx,[edx+TonePortPeriod]
        jge     PTNUpBounds
        mov     ebx,[edx+TonePortPeriod]
PTNUpBounds:
        mov     [edx+PlayingPeriod],ebx
        push    edx
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        mov     edx,8
        sub     edx,ecx
        call    SSSetFrequency
        pop     edx
        ret
align   16
PTNDown:
        mov     ebx,[edx+PlayingPeriod]
        add     ebx,[edx+TonePortSpd]
        cmp     ebx,[edx+TonePortPeriod]
        jbe     PTNDnBounds
        mov     ebx,[edx+TonePortPeriod]
PTNDnBounds:
        mov     [edx+PlayingPeriod],ebx
        push    edx
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        mov     edx,8
        sub     edx,ecx
        call    SSSetFrequency
        pop     edx
        ret
PortaToNote     endp

align   16
Vibrato         proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        test    al,0fh                  ; depth?
        jnz     VibDepth
        mov     bl,[edx+VibratoCmd]
        and     bl,0fh
        or      al,bl
VibDepth:
        test    al,0f0h                 ; speed?
        jnz     VibSpeed
        mov     bl,[edx+VibratoCmd]
        and     bl,0f0h
        or      al,bl
VibSpeed:
        mov     [edx+VibratoCmd],al
VibIgnoreParm:
        push    edx
        push    ecx
        mov     al,[edx+VibratoCmd]
        mov     bl,[edx+VibratoPos]
        and     ebx,1Fh
        mov     eax,[vibratoTable+ebx*4]
VibCalculatedDiff:
        mov     cl,[edx+VibratoCmd]
	and	cl,0Fh			; multiply with depth
	mul	cl
        shr     eax,7                   ; divide with 128

        mov     ebx,[edx+PlayingPeriod]

        test    byte ptr [edx+VibratoPos],32
        jnz     VibNeg

	; vibrato position < 32 - positive
	add	ebx,eax
        jmp     VibSetPeriod

VibNeg:
	; vibrato position >= 32 - negative
	sub	ebx,eax

VibSetPeriod:
        mov     al,[edx+VibratoCmd]
	shr	al,4
        add     [edx+VibratoPos],al       ; vibrato position

; find FREQUENCY
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx

        pop     ecx
        mov     edx,8
        sub     edx,ecx
        call    SSSetFrequency

        pop     edx
        ret
Vibrato         endp

align   16
PTNVolSlide     proc    near
        call    PortaToNote
        call    VolumeSlide
        ret
PTNVolSlide     endp

align   16
VIBVolSlide     proc    near
        call    VibIgnoreParm
        call    VolumeSlide
        ret
VIBVolSlide     endp

Tremolo         proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        test    al,0fh                  ; depth?
        jnz     TrmDepth
        mov     bl,[edx+TremoloCmd]
        and     bl,0fh
        or      al,bl
TrmDepth:
        test    al,0f0h                 ; speed?
        jnz     TrmSpeed
        mov     bl,[edx+TremoloCmd]
        and     bl,0f0h
        or      al,bl
TrmSpeed:
        mov     [edx+TremoloCmd],al
TrmIgnoreParm:
        push    edx
        push    ecx
        mov     al,[edx+TremoloCmd]
        mov     bl,[edx+TremoloPos]
        and     ebx,1Fh
        mov     eax,[vibratoTable+ebx*4]
TrmCalculatedDiff:
        mov     cl,[edx+TremoloCmd]
	and	cl,0Fh			; multiply with depth
	mul	cl
        shr     eax,7                   ; divide with 128

        mov     ebx,[edx+PlayingVolume]

        test    byte ptr [edx+TremoloPos],32
        jnz     TrmNeg

	; vibrato position < 32 - positive
	add	ebx,eax
        jmp     TrmSetPeriod

TrmNeg:
	; vibrato position >= 32 - negative
	sub	ebx,eax

TrmSetPeriod:
        mov     al,[edx+TremoloCmd]
	shr	al,4
        add     [edx+TremoloPos],al       ; vibrato position

; check volume to see if its in LIMITS
        or      ebx,ebx
        jge     TrmAbove0
        xor     ebx,ebx
TrmAbove0:
        cmp     ebx,64
        jle     TrmBelow64
        mov     ebx,64
TrmBelow64:
; set the volume
        pop     ecx
        mov     edx,8
        sub     edx,ecx
        mov     eax,ebx
        call    SSSetVolume

        pop     edx
        ret
Tremolo         endp

align   16
VolumeSlide     proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        or      eax,eax
        jz      VolSlideUp
        mov     ebx,[edx+PlayingVolume]
        sub     ebx,eax
        jns     VSDNoWrap
        xor     ebx,ebx
VSDNoWrap:
        mov     [edx+PlayingVolume],ebx
        mov     eax,ebx
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSSetVolume
        pop     edx
        ret
align   16
VolSlideUp:
        xor     eax,eax
        mov     al,[edx+EffectValue]
        shr     eax,4
        add     eax,[edx+PlayingVolume]
        cmp     eax,40h
        jbe     VSUNoWrap
        mov     eax,40h
VSUNoWrap:
        mov     [edx+PlayingVolume],eax
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSSetVolume
        pop     edx
        ret
VolumeSlide     endp

align   16
ENoteFX         proc    near
; translate E effect
        xor     eax,eax
        mov     al,[edx+EffectValue]
        shr     eax,4
        call    dword ptr [eax*4+offset ENFXTable]
        ret
ENoteFX         endp

align   16
ETickFX         proc    near
; translate E effect
        xor     eax,eax
        mov     al,[edx+EffectValue]
        shr     eax,4
        call    dword ptr [eax*4+offset ETFXTable]
        ret
ETickFX         endp

align   16
FineSlideUp     proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        mov     ebx,[edx+PlayingPeriod]
        sub     ebx,eax
        cmp     ebx,28
        jge     FSUWithinLimits                  ; make DAMN sure of negatives
        mov     ebx,28
FSUWithinLimits:
        mov     [edx+PlayingPeriod],ebx
        push    ecx
        push    edx
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        mov     edx,8
        sub     edx,ecx
        call    SSSetFrequency
        pop     edx
        pop     ecx
        ret
FineSlideUp     endp

align   16
FineSlideDown   proc    near
        xor     ebx,ebx
        mov     bl,[edx+EffectValue]
        and     ebx,0fh
        add     ebx,[edx+PlayingPeriod]
        cmp     ebx,1712
        jle     FSDWithinLimits                  ; make DAMN sure of negatives
        mov     ebx,1712
FSDWithinLimits:
        mov     [edx+PlayingPeriod],ebx
        push    ecx
        push    edx
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        mov     edx,8
        sub     edx,ecx
        call    SSSetFrequency
        pop     edx
        pop     ecx
        ret
FineSlideDown   endp

align   16
SetVibWaveform  proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,07h
; 0=sine,1=rampdown,2=square,3=random (we'll make it SINE)
        mov     ebx,eax
        and     ebx,3
        cmp     ebx,3
        jnz     SetVibWFNotRandom
        and     eax,4
SetVibWFNotRandom:
        mov     bl,[edx+WavCtrl]
        and     bl,00111000b
        or      bl,al
        mov     [edx+WavCtrl],bl
        ret
SetVibWaveform  endp

align   16
PatternLoop     proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        or      eax,eax
        jz      PatternLoopSetPos
; if its NONZERO:
; A) check origcnt to see if it is ZERO, if its not, then decrement cnt.
; B) if origcnt = 0, then set origcnt and cnt, decrement cnt.
; C) if cnt reaches 0, set origcnt to 0.
        cmp     byte ptr [edx+PatLoopCount],0
        jz      PatternLoopSetCnt

PatternLoopDoIt:
        dec     byte ptr [edx+PatLoopCount]
        jz      PatternLoopZero

        xor     eax,eax
        mov     al,[edx+PatLoopPos]
        mov     EffectRow,eax
        mov     eax,CurrentSequence
        mov     EffectSequence,eax
        mov     EffectFlag,1
        ret
align   16
PatternLoopSetCnt:
        inc     eax
        mov     [edx+PatLoopCount],al
        jmp     PatternLoopDoIt

PatternLoopZero:
        ret

align   16
PatternLoopSetPos:
        mov     eax,CurrentRow
        mov     [edx+PatLoopPos],al
        ret
PatternLoop     endp

align   16
SetTrmWaveform  proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,07h
; 0=sine,1=rampdown,2=square,3=random (we'll make it SINE)
        mov     ebx,eax
        and     ebx,3
        cmp     ebx,3
        jnz     SetTrmWFNotRandom
        and     eax,4
SetTrmWFNotRandom:
        mov     bl,[edx+WavCtrl]
        and     bl,00000111b
        shl     eax,3
        or      bl,al
        mov     [edx+WavCtrl],bl
        ret
SetTrmWaveform  endp

align   16
SetMajPan       proc    near
; set panning of a channel.
        push    edx
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        shl     eax,4
        mov     edx,8
        sub     edx,ecx
        call    SSSetPanning
        pop     edx
        ret
SetMajPan       endp

align   16
Retrig          proc    near
        push    edx
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        mov     ebx,eax
        mov     eax,SpeedMaster
        sub     eax,SpeedCounter
        xor     edx,edx
        div     ebx
        or      edx,edx
        jnz     RetrigNo
        mov     edx,ecx
        sub     edx,8
        neg     edx
        xor     eax,eax
        call    SSSetOffset
RetrigNo:
        pop     edx
        ret
Retrig          endp

align   16
FineVSlUp       proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        add     eax,[edx+PlayingVolume]
        cmp     eax,40h
        jbe     FVSUNoWrap
        mov     eax,40h
FVSUNoWrap:
        mov     [edx+PlayingVolume],eax
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSSetVolume
        pop     edx
        ret
FineVSlUp       endp

align   16
FineVSlDn       proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        mov     ebx,[edx+PlayingVolume]
        sub     ebx,eax
        jns     FVSDNoWrap
        xor     ebx,ebx
FVSDNoWrap:
        mov     [edx+PlayingVolume],ebx
        mov     eax,ebx
        push    edx
        mov     edx,8
        sub     edx,ecx
        call    SSSetVolume
        pop     edx
        ret
FineVSlDn       endp

align   16
NoteCut         proc    near
        push    edx
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        mov     ebx,SpeedMaster
        sub     ebx,SpeedCounter
        cmp     eax,ebx
        jnz     NoteCutNotNow
        mov     [edx+PlayingVolume],0
        mov     edx,8
        sub     edx,ecx
        xor     eax,eax
        call    SSSetVolume
NoteCutNotNow:
        pop     edx
        ret
NoteCut         endp

align   16
NoteDelay       proc    near
        push    edx
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        mov     ebx,SpeedMaster
        sub     ebx,SpeedCounter
        cmp     eax,ebx
        jnz     NoteDelayNotNow
; trigger the note..NOW!
        xor     eax,eax
        xor     ebx,ebx
        mov     ax,[edx+NoteDelayPer]
        mov     bl,[edx+NoteDelayIns]
; Check for new -sample-.
        or      ebx,ebx
        jz      NoteDelayNoNewIns
        pushad
        mov     edx,8
        sub     edx,ecx
        push    edx
; Load sample info into memory.
        dec     ebx
        shl     ebx,5
        mov     edx,ebx
        mov     eax,[edx+Volume+offset Samples]
        mov     [ebp+PlayingVolume],eax
        mov     ecx,[edx+Length+offset Samples]
        mov     ebx,[edx+MemoryLocation+offset Samples]
        mov     esi,[edx+RepeatStart+offset Samples]
        mov     edi,[edx+RepeatEnd+offset Samples]
        mov     ebp,[edx+Repeating+offset Samples]
        pop     edx
        call    SSSetSample
        popad
        push    eax
        dec     ebx
        shl     ebx,5
        mov     eax,[ebx+S3MFinetune+offset Samples]
        mov     [edx+C2Spd],eax
        pop     eax
NoteDelayNoNewIns:
; WRONGOID.
; Check for new period.
        or      eax,eax
        jz      NoteDelayNotNow
; New period. Set respective channel.
        pushad
        mov     ebp,edx
        mov     edx,8
        sub     edx,ecx
        push    edx
; since SSSetFreq doesn't reset pointer to 0 for us, reset it ourselves.
        push    eax
        push    edx
        xor     eax,eax
        call    SSSetOffset
        pop     edx
        pop     eax
; First: calculate finetuned period.
        mov     ebx,8363
        mul     ebx
        mov     ebx,[ebp+C2Spd]
        or      ebx,ebx
        jz      NoteDelayNoteAbort
        div     ebx

        mov     ebx,eax
        mov     [ebp+PlayingPeriod],eax
        mov     eax,PeriodConst
        xor     edx,edx
        div     ebx
        pop     edx
        push    edx
        call    SSSetFrequency
NoteDelayNoteAbort:
        pop     edx
        popad
NoteDelayNotNow:
        pop     edx
        ret
NoteDelay       endp

align   16
PatDelay        proc    near
        xor     eax,eax
        mov     al,[edx+EffectValue]
        and     eax,0fh
        cmp     PatDelayFlag,0
        jnz     PatDelaySkipSet
        mov     PatDelayTime,eax
        mov     PatDelayFlag,1
PatDelaySkipSet:
        ret
PatDelay        endp

code32          ends
end

